/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.am.console.base.model;

import com.iplanet.am.console.base.model.AMAdminMenuModelImpl;
import com.iplanet.am.console.base.model.AMCommonNameGenerator;
import com.iplanet.am.console.base.model.AMFormatUtils;
import com.iplanet.am.console.base.model.AMHeaderViewModel;
import com.iplanet.am.console.base.model.AMModelBase;
import com.iplanet.am.console.base.model.AMSystemConfig;
import com.iplanet.am.sdk.AMException;
import com.iplanet.am.sdk.AMRole;
import com.iplanet.am.sdk.AMUser;
import com.iplanet.sso.SSOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import netscape.ldap.util.DN;

public class AMHeaderViewModelImpl
extends AMAdminMenuModelImpl
implements AMHeaderViewModel {
    private HttpServletRequest req;

    public AMHeaderViewModelImpl(HttpServletRequest httpServletRequest, Map map) {
        super(httpServletRequest, map);
        this.req = httpServletRequest;
    }

    public String getDocLabel() {
        return this.getLocalizedString("help.label");
    }

    public String getLogoutURL() {
        StringBuffer stringBuffer = new StringBuffer(30);
        stringBuffer.append(AMSystemConfig.serverDeploymentURI).append("/UI/Logout");
        if (AMSystemConfig.isConsoleRemote) {
            stringBuffer.insert(0, AMSystemConfig.serverURL);
        }
        return stringBuffer.toString();
    }

    public String getLogoutLabel() {
        return this.getLocalizedString("logout.label");
    }

    public String getUserLabel() {
        return this.getLocalizedString("welcome.label");
    }

    public String getCurrentUserName() {
        String string = "";
        String string2 = this.getLoggedInUserDN();
        if (this.isEntityObject(string2)) {
            string = AMFormatUtils.DNToName(this, string2);
        } else if (this.dpUser != null) {
            AMCommonNameGenerator aMCommonNameGenerator = AMCommonNameGenerator.getInstance();
            string = aMCommonNameGenerator.generateCommonName(this.getUserAttrValues(), string2, this);
        }
        return string;
    }

    public String getCurrentUserOrgDN() {
        String string = "";
        if (this.dpUser != null) {
            try {
                string = this.dpUser.getOrganizationDN();
            }
            catch (AMException aMException) {
                AMModelBase.debug.error("AMHeaderViewModelImpl.getCurrentUserOrgDN", (Throwable)aMException);
            }
            catch (SSOException sSOException) {
                AMModelBase.debug.error("AMHeaderViewModelImpl.getCurrentUserOrgDN", (Throwable)sSOException);
            }
        }
        return string;
    }

    public String getSunLabel() {
        return this.getLocalizedString("SUN.label");
    }

    public String getProductLabel() {
        return this.getLocalizedString("product.label");
    }

    public String getQuickSearchLabel() {
        return this.getLocalizedString("quickSearch.label");
    }

    public List getSearchTypes() {
        List list = Collections.EMPTY_LIST;
        int n = this.getStartLocType();
        if (n != -1) {
            switch (n) {
                case 2: 
                case 3: {
                    list = this.getOrgSearchTypes();
                    break;
                }
                case 4: 
                case 9: 
                case 10: 
                case 11: 
                case 12: {
                    list = this.getGroupSearchTypes();
                    break;
                }
                case 5: {
                    list = this.getUserSearchTypes();
                    break;
                }
                case 6: 
                case 8: {
                    list = this.getRoleSearchTypes();
                }
            }
        }
        return list;
    }

    private List getOrgSearchTypes() {
        ArrayList<String> arrayList = new ArrayList<String>(6);
        if (this.isUserMgtEnabled()) {
            arrayList.add(Integer.toString(2));
            if (this.showOrgUnits()) {
                arrayList.add(Integer.toString(3));
            }
            if (this.showGroupContainers()) {
                arrayList.add(Integer.toString(4));
            }
            arrayList.add(Integer.toString(9));
            if (this.showPeopleContainers()) {
                arrayList.add(Integer.toString(5));
            }
            if (!this.isServiceDenied("iPlanetAMUserService")) {
                arrayList.add(Integer.toString(1));
            }
            arrayList.add(Integer.toString(6));
        }
        return arrayList;
    }

    private List getGroupSearchTypes() {
        ArrayList<String> arrayList = new ArrayList<String>(3);
        if (this.isUserMgtEnabled()) {
            if (this.showGroupContainers()) {
                arrayList.add(Integer.toString(4));
            }
            arrayList.add(Integer.toString(9));
            if (!this.isServiceDenied("iPlanetAMUserService")) {
                arrayList.add(Integer.toString(1));
            }
        }
        return arrayList;
    }

    private List getUserSearchTypes() {
        ArrayList<String> arrayList = new ArrayList<String>(2);
        if (this.isUserMgtEnabled()) {
            if (this.showPeopleContainers()) {
                arrayList.add(Integer.toString(5));
            }
            if (!this.isServiceDenied("iPlanetAMUserService")) {
                arrayList.add(Integer.toString(1));
            }
        }
        return arrayList;
    }

    private List getRoleSearchTypes() {
        ArrayList<String> arrayList = new ArrayList<String>(1);
        if (this.isUserMgtEnabled()) {
            arrayList.add(Integer.toString(1));
        }
        return arrayList;
    }

    private int getStartLocType() {
        int n = -1;
        try {
            n = this.getObjectType(this.startDN);
        }
        catch (SSOException sSOException) {
            AMModelBase.debug.warning("AMHeaderViewModelImpl.getStartLocType", (Throwable)sSOException);
        }
        catch (AMException aMException) {
            AMModelBase.debug.error("AMHeaderViewModelImpl.getStartLocType", (Throwable)aMException);
        }
        return n;
    }

    public String getContainerDN(String string) {
        String string2 = string;
        try {
            int n = this.getObjectType(string);
            if (!this.isContainerType(n)) {
                switch (n) {
                    case 1: {
                        AMUser aMUser = this.dpStoreConn.getUser(string);
                        if (this.showPeopleContainers()) {
                            string2 = aMUser.getParentDN();
                            break;
                        }
                        string2 = aMUser.getOrganizationDN();
                        break;
                    }
                    case 6: 
                    case 8: {
                        AMRole aMRole = (AMRole)this.getAMObject(string);
                        string2 = aMRole.getOrganizationDN();
                        break;
                    }
                    default: {
                        AMModelBase.debug.error("AMHeaderViewModelImpl.getContainerDN invalid object " + string);
                    }
                }
            }
        }
        catch (SSOException sSOException) {
            AMModelBase.debug.warning("AMHeaderViewModelImpl.getContainerDN", (Throwable)sSOException);
        }
        catch (AMException aMException) {
            AMModelBase.debug.warning("AMHeaderViewModelImpl.getContainerDN", (Throwable)aMException);
        }
        return string2;
    }

    public boolean isDescendantOfStartDN(String string) {
        DN dN = new DN(string);
        DN dN2 = new DN(this.startDN);
        return dN.isDescendantOf(dN2);
    }

    private boolean isContainerType(int n) {
        return n == 2 || n == 3 || n == 5 || n == 9 || n == 10 || n == 11 || n == 12;
    }

    public String getOptionMenu(String string) {
        String string2 = null;
        int n = this.getLocationObjectType(string);
        switch (n) {
            case 2: {
                string2 = "organizations";
                break;
            }
            case 3: {
                string2 = "organizationalunits";
                break;
            }
            case 4: {
                string2 = "groupcontainers";
                break;
            }
            case 5: {
                string2 = "peoplecontainers";
                break;
            }
            case 6: 
            case 7: 
            case 8: {
                string2 = "roles";
                break;
            }
            case 9: 
            case 10: 
            case 11: 
            case 12: {
                string2 = "groups";
                break;
            }
            case 1: {
                string2 = "users";
                break;
            }
            default: {
                string2 = "";
                AMModelBase.debug.error("AMHeaderViewModelImpl.getOptionMenu, unknown location type.");
            }
        }
        return string2;
    }

    private int getLocationObjectType(String string) {
        int n = 2;
        try {
            n = this.getObjectType(string);
        }
        catch (SSOException sSOException) {
            AMModelBase.debug.warning("AMHeaderViewModelImpl.getLocationObjectType", (Throwable)sSOException);
        }
        catch (AMException aMException) {
            AMModelBase.debug.warning("AMHeaderViewModelImpl.getLocationObjectType", (Throwable)aMException);
        }
        return n;
    }

    private Map getUserAttrValues() {
        Map map = Collections.EMPTY_MAP;
        try {
            map = this.dpUser.getAttributes(this.getUserAttributeNames());
        }
        catch (SSOException sSOException) {
            AMModelBase.debug.warning("AMHeaderViewModelImpl.getUserAttrValues", (Throwable)sSOException);
        }
        catch (AMException aMException) {
            AMModelBase.debug.warning("AMHeaderViewModelImpl.getUserAttrValues", (Throwable)aMException);
        }
        return map;
    }

    public String getHelpDocURL() {
        return "";
    }

    public String getHelpAnchorTag() {
        return "";
    }
}

