/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.am.console.base.model;

import com.sun.identity.policy.ActionSchema;
import com.sun.identity.policy.Syntax;
import com.sun.identity.sm.AttributeSchema;

public class AMDisplayTypeConverter {
    public static int DEFAULT_TYPE = 0;
    public static int DEFAULT_SYNTAX = 1;
    public static int UNDEFINED_TYPE = -1;
    public static int UNDEFINED_SYNTAX = -1;

    public static int getDisplayType(AttributeSchema attributeSchema) {
        int n = DEFAULT_TYPE;
        AttributeSchema.Type type = attributeSchema.getType();
        if (type.equals((Object)AttributeSchema.Type.LIST)) {
            n = 3;
        } else if (type.equals((Object)AttributeSchema.Type.SINGLE_CHOICE)) {
            n = 1;
        } else if (type.equals((Object)AttributeSchema.Type.MULTIPLE_CHOICE)) {
            n = 2;
        }
        return n;
    }

    public static int getDisplayType(ActionSchema actionSchema) {
        int n = DEFAULT_TYPE;
        AttributeSchema.Type type = actionSchema.getType();
        if (type.equals((Object)AttributeSchema.Type.LIST)) {
            n = 3;
        } else if (type.equals((Object)AttributeSchema.Type.SINGLE_CHOICE)) {
            n = 1;
        } else if (type.equals((Object)AttributeSchema.Type.MULTIPLE_CHOICE)) {
            n = 2;
        }
        return n;
    }

    public static int getDisplaySyntax(AttributeSchema attributeSchema) {
        int n = AMDisplayTypeConverter.getDisplaySyntaxFromUIType(attributeSchema);
        if (n == UNDEFINED_SYNTAX) {
            n = DEFAULT_SYNTAX;
            AttributeSchema.Syntax syntax = attributeSchema.getSyntax();
            if (syntax.equals((Object)AttributeSchema.Syntax.BOOLEAN)) {
                n = 0;
            } else if (syntax.equals((Object)AttributeSchema.Syntax.PASSWORD)) {
                n = 2;
            } else if (syntax.equals((Object)AttributeSchema.Syntax.ENCRYPTED_PASSWORD)) {
                n = 9;
            } else if (syntax.equals((Object)AttributeSchema.Syntax.XML)) {
                n = 3;
            } else if (syntax.equals((Object)AttributeSchema.Syntax.PARAGRAPH)) {
                n = 3;
            } else if (syntax.equals((Object)AttributeSchema.Syntax.DATE)) {
                n = 4;
            }
        }
        return n;
    }

    private static int getDisplaySyntaxFromUIType(AttributeSchema attributeSchema) {
        int n = UNDEFINED_SYNTAX;
        AttributeSchema.UIType uIType = attributeSchema.getUIType();
        if (uIType != null) {
            if (uIType.equals((Object)AttributeSchema.UIType.RADIO)) {
                n = 5;
            } else if (uIType.equals((Object)AttributeSchema.UIType.LINK)) {
                n = 6;
            } else if (uIType.equals((Object)AttributeSchema.UIType.BUTTON)) {
                n = 7;
            } else if (uIType.equals((Object)AttributeSchema.UIType.NAME_VALUE_LIST)) {
                n = 8;
            }
        }
        return n;
    }

    public static int getDisplaySyntax(ActionSchema actionSchema) {
        int n = AMDisplayTypeConverter.getDisplaySyntaxFromUIType(actionSchema);
        if (n == UNDEFINED_SYNTAX) {
            n = DEFAULT_SYNTAX;
            AttributeSchema.Syntax syntax = actionSchema.getSyntax();
            if (syntax == AttributeSchema.Syntax.BOOLEAN) {
                n = 0;
            } else if (syntax == AttributeSchema.Syntax.PASSWORD) {
                n = 2;
            } else if (syntax == AttributeSchema.Syntax.ENCRYPTED_PASSWORD) {
                n = 9;
            } else if (syntax == AttributeSchema.Syntax.PARAGRAPH || syntax == AttributeSchema.Syntax.XML) {
                n = 3;
            }
        }
        return n;
    }

    private static int getDisplaySyntaxFromUIType(ActionSchema actionSchema) {
        int n = UNDEFINED_SYNTAX;
        AttributeSchema.UIType uIType = actionSchema.getUIType();
        if (uIType != null) {
            if (uIType == AttributeSchema.UIType.RADIO) {
                n = 5;
            } else if (uIType == AttributeSchema.UIType.LINK) {
                n = 6;
            } else if (uIType == AttributeSchema.UIType.BUTTON) {
                n = 7;
            } else if (uIType == AttributeSchema.UIType.NAME_VALUE_LIST) {
                n = 8;
            }
        }
        return n;
    }

    public static int getDisplayType(Syntax syntax) {
        int n = 0;
        if (syntax != null) {
            if (syntax.equals((Object)Syntax.CONSTANT)) {
                n = 5;
            } else if (syntax.equals((Object)Syntax.SINGLE_CHOICE)) {
                n = 1;
            } else if (syntax.equals((Object)Syntax.MULTIPLE_CHOICE)) {
                n = 2;
            }
        }
        return n;
    }
}

