/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.am.console.base.model;

import com.iplanet.am.console.base.model.AMAdminConstants;
import com.iplanet.am.console.base.model.AMAdminUtils;
import com.iplanet.am.console.base.model.AMFormatUtils;
import com.iplanet.am.console.base.model.AMModel;
import com.iplanet.am.sdk.AMException;
import com.iplanet.am.sdk.AMOrganization;
import com.iplanet.am.sdk.AMOrganizationalUnit;
import com.iplanet.am.sdk.AMStoreConnection;
import com.iplanet.am.sdk.AMTemplate;
import com.iplanet.am.util.Debug;
import com.iplanet.sso.SSOException;
import com.iplanet.sso.SSOToken;
import com.sun.identity.security.AdminTokenAction;
import com.sun.identity.sm.SMSException;
import com.sun.identity.sm.SchemaType;
import com.sun.identity.sm.ServiceConfigManager;
import com.sun.identity.sm.ServiceListener;
import com.sun.identity.sm.ServiceSchemaManager;
import java.security.AccessController;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;

public class AMCommonNameGenerator
implements AMAdminConstants,
ServiceListener {
    private static final String DEFAULT_FORMAT = "{givenname} {initials} {sn}";
    private static Debug debug = Debug.getInstance((String)"amConsole");
    private static AMCommonNameGenerator instance = new AMCommonNameGenerator();
    private static ServiceSchemaManager serviceSchemaManager;
    private static ServiceConfigManager serviceConfigManager;
    private static AMStoreConnection storeConnection;
    private Map mapOrgDNToFormat = new HashMap();
    private static final String ROOT = "root_suffix";

    private AMCommonNameGenerator() {
        this.initialize();
    }

    private void initialize() {
        try {
            SSOToken sSOToken = (SSOToken)AccessController.doPrivileged(AdminTokenAction.getInstance());
            if (sSOToken != null) {
                serviceSchemaManager = new ServiceSchemaManager("iPlanetG11NSettings", sSOToken);
                serviceConfigManager = new ServiceConfigManager("iPlanetG11NSettings", sSOToken);
                serviceConfigManager.addListener((ServiceListener)this);
                serviceSchemaManager.addListener((ServiceListener)this);
                storeConnection = new AMStoreConnection(sSOToken);
            } else {
                debug.error("AMCommonNameGenerator.initialize:cannot get application sso token");
            }
        }
        catch (SMSException sMSException) {
            debug.error("AMCommonNameGenerator.initManager", (Throwable)sMSException);
        }
        catch (SSOException sSOException) {
            debug.error("AMCommonNameGenerator.initManager", (Throwable)sSOException);
        }
    }

    public static AMCommonNameGenerator getInstance() {
        return instance;
    }

    public String generateCommonName(Map map, String string, AMModel aMModel) {
        String string2 = "";
        if (map != null && !map.isEmpty()) {
            String string3;
            Object object;
            String string4 = AMAdminUtils.getFirstElement((Set)map.get("preferredlocale"));
            if (string4 == null || string4.trim().length() == 0) {
                string4 = aMModel.getUserLocale().toString();
            }
            String string5 = this.getCommonNameFormat(string4, string);
            Set set = this.getTokens(string5);
            Map map2 = this.getAttributeValues(map, set);
            string2 = string5;
            Iterator iterator = map2.keySet().iterator();
            while (iterator.hasNext()) {
                object = (String)iterator.next();
                string3 = (String)map2.get(object);
                if (!string5.equals(DEFAULT_FORMAT)) {
                    string3 = string3 + " ";
                }
                string2 = AMFormatUtils.replaceString(string2, (String)object, string3);
            }
            set.removeAll(map2.keySet());
            object = set.iterator();
            while (object.hasNext()) {
                string3 = (String)object.next();
                int n = string2.indexOf(string3 + " ");
                if (n != -1) {
                    string2 = string2.substring(0, n) + string2.substring(n + string3.length() + 1);
                    continue;
                }
                n = string2.indexOf(string3);
                if (n == -1) continue;
                string2 = string2.substring(0, n) + string2.substring(n + string3.length());
            }
        }
        return string2;
    }

    private Map getAttributeValues(Map map, Set set) {
        HashMap<String, String> hashMap = new HashMap<String, String>(set.size() * 2);
        Iterator iterator = set.iterator();
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            String string2 = string.substring(1, string.length() - 1);
            String string3 = AMAdminUtils.getFirstElement((Set)map.get(string2));
            if (string3 == null || string3.length() <= 0) continue;
            hashMap.put(string, string3);
        }
        return hashMap;
    }

    private Set getTokens(String string) {
        HashSet<String> hashSet = new HashSet<String>();
        int n = string.indexOf(123);
        while (n != -1) {
            int n2 = string.indexOf(125, n + 1);
            if (n2 == 1) break;
            hashSet.add(string.substring(n, n2 + 1));
            string = string.substring(n2 + 1);
            n = string.indexOf(123);
        }
        return hashSet;
    }

    private String getCommonNameFormat(String string, String string2) {
        int n;
        String string3 = null;
        Map map = this.getFormats(this.getOrganizationDN(string2));
        if (map != null && !map.isEmpty() && (string3 = (String)map.get(string.toLowerCase())) == null && (n = string.indexOf(95)) != -1) {
            string = string.substring(0, n);
            string3 = (String)map.get(string.toLowerCase());
        }
        return string3 != null ? string3 : DEFAULT_FORMAT;
    }

    private Map addFormats(String string, AMTemplate aMTemplate) {
        Set set = null;
        try {
            if (aMTemplate != null) {
                set = aMTemplate.getAttribute("sun-identity-g11n-settings-common-name-format");
            } else if (serviceSchemaManager != null) {
                set = AMAdminUtils.getAttribute(serviceSchemaManager, SchemaType.ORGANIZATION, "sun-identity-g11n-settings-common-name-format");
            } else {
                debug.error("AMCommonNameGenerator.addFormats: formats are not added because Console cannot get an instance of service schema manager.");
            }
        }
        catch (SMSException sMSException) {
            debug.warning("AMCommonNameGenerator.addFormats", (Throwable)sMSException);
        }
        catch (SSOException sSOException) {
            debug.warning("AMCommonNameGenerator.addFormats", (Throwable)sSOException);
        }
        catch (AMException aMException) {
            debug.warning("AMCommonNameGenerator.addFormats", (Throwable)aMException);
        }
        Map map = this.getFormatMap(set);
        Map map2 = this.mapOrgDNToFormat;
        synchronized (map2) {
            this.mapOrgDNToFormat.put(string, map);
        }
        return map;
    }

    private Map getFormatMap(Set set) {
        HashMap<String, String> hashMap = new HashMap<String, String>(set.size());
        Iterator iterator = set.iterator();
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            StringTokenizer stringTokenizer = new StringTokenizer(string, "=");
            if (stringTokenizer.countTokens() == 2) {
                String string2 = stringTokenizer.nextToken().trim();
                String string3 = stringTokenizer.nextToken().trim();
                hashMap.put(string2.toLowerCase(), string3);
                continue;
            }
            debug.error("Incorrect common name format, " + string + " in Globalization Service");
        }
        return hashMap;
    }

    private String getOrganizationDN(String string) {
        int n = this.getLocationType(string);
        while (n != 2 && n != 3) {
            string = AMAdminUtils.getParent(string);
            n = this.getLocationType(string);
        }
        return string;
    }

    private AMTemplate getOrgTemplate(String string) {
        AMTemplate aMTemplate = null;
        if (storeConnection != null) {
            int n = this.getLocationType(string);
            try {
                if (n == 2) {
                    AMOrganization aMOrganization = storeConnection.getOrganization(string);
                    if (aMOrganization.orgTemplateExists("iPlanetG11NSettings")) {
                        aMTemplate = aMOrganization.getTemplate("iPlanetG11NSettings", 302);
                    }
                } else if (n == 3) {
                    AMOrganizationalUnit aMOrganizationalUnit = storeConnection.getOrganizationalUnit(string);
                    if (aMOrganizationalUnit.orgTemplateExists("iPlanetG11NSettings")) {
                        aMTemplate = aMOrganizationalUnit.getTemplate("iPlanetG11NSettings", 302);
                    }
                } else {
                    debug.error("AMCommonNameGenerator.getOrgTemplate: invalid DN type " + string);
                }
            }
            catch (SSOException sSOException) {
                debug.error("AMCommonNameGenerator.getOrgTemplate", (Throwable)sSOException);
            }
            catch (AMException aMException) {
                debug.error("AMCommonNameGenerator.getOrgTemplate", (Throwable)aMException);
            }
        }
        return aMTemplate;
    }

    public Map getFormats(String string) {
        Map map = null;
        if (string.equals(ROOT)) {
            map = (Map)this.mapOrgDNToFormat.get(ROOT);
            if (map == null) {
                map = this.addFormats(string, null);
            }
        } else {
            String string2 = this.getOrganizationDN(string);
            map = (Map)this.mapOrgDNToFormat.get(string2);
            if (map == null) {
                AMTemplate aMTemplate = this.getOrgTemplate(string2);
                map = aMTemplate != null ? this.addFormats(string2, aMTemplate) : this.getFormats(ROOT);
            }
        }
        return map;
    }

    public void schemaChanged(String string, String string2) {
        Map map = this.mapOrgDNToFormat;
        synchronized (map) {
            this.mapOrgDNToFormat.remove(ROOT);
        }
    }

    public void globalConfigChanged(String string, String string2, String string3, String string4, int n) {
    }

    public void organizationConfigChanged(String string, String string2, String string3, String string4, String string5, int n) {
        Map map = this.mapOrgDNToFormat;
        synchronized (map) {
            this.mapOrgDNToFormat.remove(string3);
        }
    }

    private int getLocationType(String string) {
        block3: {
            try {
                return storeConnection.getAMObjectType(string);
            }
            catch (SSOException sSOException) {
                debug.error("AMCommonNameGenerator.getLocationType", (Throwable)sSOException);
            }
            catch (AMException aMException) {
                if (!debug.messageEnabled()) break block3;
                debug.message("AMCommonNameGenerator.getLocationType: couldn't get the type of object for " + string + ". It could be a service");
            }
        }
        return -1;
    }
}

