/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.am.console.base.model;

import com.iplanet.am.console.base.model.AMAdminConstants;
import com.iplanet.am.console.base.model.AMAdminUtils;
import com.iplanet.am.console.base.model.AMAttributeDisplay;
import com.iplanet.am.console.base.model.AMModelBase;
import com.iplanet.am.console.base.model.AMServiceDisplayModelImpl;
import com.iplanet.am.sdk.AMException;
import com.iplanet.am.sdk.AMRole;
import com.iplanet.am.sdk.AMStoreConnection;
import com.iplanet.am.sdk.AMUser;
import com.iplanet.sso.SSOException;
import com.iplanet.sso.SSOToken;
import com.sun.identity.sm.AttributeSchema;
import com.sun.identity.sm.SMSException;
import com.sun.identity.sm.SchemaType;
import com.sun.identity.sm.ServiceSchema;
import com.sun.identity.sm.ServiceSchemaManager;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;

public class AMAttributeDisplayImpl
implements AMAdminConstants,
AMAttributeDisplay {
    private AMStoreConnection amStoreConn = null;
    private SSOToken ssoToken = null;
    private static final String SERVICE_ATTR_NAME_SEPARATOR = "#";
    private static final String ATTR_NAME_ANY_OPTION_SEPARATOR = ",";
    private static final String ANY_OPTION_SEPARATOR = "|";

    public AMAttributeDisplayImpl(AMStoreConnection aMStoreConnection, SSOToken sSOToken) {
        this.amStoreConn = aMStoreConnection;
        this.ssoToken = sSOToken;
    }

    public Map getRoleOptions(AMModelBase aMModelBase, AMRole aMRole, Set set) throws AMException, SSOException, SMSException {
        Map map = null;
        AMServiceDisplayModelImpl aMServiceDisplayModelImpl = new AMServiceDisplayModelImpl(this.amStoreConn);
        Set set2 = aMServiceDisplayModelImpl.getDeniedServices(aMRole);
        set.removeAll(set2);
        Set set3 = aMRole.getAttribute("iplanet-am-role-any-options");
        map = set3 == null || set3.isEmpty() ? this.getDefaultRoleOptions(aMModelBase, set) : this.getOptionsFromRoleAttribute(set3, set);
        if (AMModelBase.debug.messageEnabled()) {
            AMModelBase.debug.message("getRoleOptions:anyOptions " + map);
        }
        return map;
    }

    public void setRoleOptions(AMRole aMRole, Map map) throws AMException, SSOException {
        Set set = this.mapOptionsToSet(map);
        HashMap<String, Set> hashMap = new HashMap<String, Set>(1);
        hashMap.put("iplanet-am-role-any-options", set);
        aMRole.setAttributes(hashMap);
        aMRole.store();
    }

    public Set getAttributeOptions(ServiceSchemaManager serviceSchemaManager, SchemaType schemaType, String string) throws SMSException {
        ServiceSchema serviceSchema = serviceSchemaManager.getSchema(schemaType);
        AttributeSchema attributeSchema = serviceSchema.getAttributeSchema(string);
        return this.getAllOptions(attributeSchema);
    }

    public Set getAttributeDisplayOptions(ServiceSchemaManager serviceSchemaManager, SchemaType schemaType, String string) throws SMSException {
        ServiceSchema serviceSchema = serviceSchemaManager.getSchema(schemaType);
        AttributeSchema attributeSchema = serviceSchema.getAttributeSchema(string);
        return this.getDisplayOptions(attributeSchema);
    }

    public boolean isFilterAttribute(ServiceSchemaManager serviceSchemaManager, SchemaType schemaType, String string) throws SMSException {
        ServiceSchema serviceSchema = serviceSchemaManager.getSchema(schemaType);
        AttributeSchema attributeSchema = serviceSchema.getAttributeSchema(string);
        Set set = this.getAllOptions(attributeSchema);
        return set.contains("filter");
    }

    public boolean isRequiredAttribute(ServiceSchemaManager serviceSchemaManager, SchemaType schemaType, String string) throws SMSException {
        ServiceSchema serviceSchema = serviceSchemaManager.getSchema(schemaType);
        AttributeSchema attributeSchema = serviceSchema.getAttributeSchema(string);
        Set set = this.getAllOptions(attributeSchema);
        return set.contains("required");
    }

    public boolean isOptionalAttribute(ServiceSchemaManager serviceSchemaManager, SchemaType schemaType, String string) throws SMSException {
        ServiceSchema serviceSchema = serviceSchemaManager.getSchema(schemaType);
        AttributeSchema attributeSchema = serviceSchema.getAttributeSchema(string);
        Set set = this.getAllOptions(attributeSchema);
        return set.contains("optional");
    }

    public Map getServiceDisplayOptions(ServiceSchemaManager serviceSchemaManager) throws SMSException {
        Set set = this.getDisplaySchemaTypes(serviceSchemaManager);
        if (set == null || set.isEmpty()) {
            return new HashMap(1);
        }
        HashMap hashMap = new HashMap();
        Iterator iterator = set.iterator();
        while (iterator.hasNext()) {
            SchemaType schemaType = (SchemaType)iterator.next();
            hashMap.putAll(this.getServiceDisplayOptions(serviceSchemaManager, schemaType, hashMap));
        }
        if (AMModelBase.debug.messageEnabled()) {
            AMModelBase.debug.message("getServiceDisplayOptions:displayOptions " + hashMap);
        }
        return hashMap;
    }

    public Map getServiceDisplayOptions(ServiceSchemaManager serviceSchemaManager, SchemaType schemaType, Map map) throws SMSException {
        ServiceSchema serviceSchema = serviceSchemaManager.getSchema(schemaType);
        Set set = serviceSchema.getAttributeSchemaNames();
        Iterator iterator = set.iterator();
        while (iterator.hasNext()) {
            Set set2;
            String string = (String)iterator.next();
            AttributeSchema attributeSchema = serviceSchema.getAttributeSchema(string);
            if (attributeSchema == null || (set2 = this.getDisplayOptions(attributeSchema, schemaType)).isEmpty()) continue;
            HashSet hashSet = (HashSet)map.get(string);
            if (hashSet == null) {
                hashSet = new HashSet(set2.size());
            }
            hashSet.addAll(set2);
            map.put(string, hashSet);
        }
        return map;
    }

    public Map getUserDisplayOptions(AMModelBase aMModelBase, Set set, ServiceSchemaManager serviceSchemaManager, AMUser aMUser) throws AMException, SSOException, SMSException {
        HashMap<String, Map> hashMap = new HashMap<String, Map>();
        Set set2 = aMUser.getRoleDNs();
        if (set2.isEmpty()) {
            Iterator iterator = set.iterator();
            while (iterator.hasNext()) {
                String string = (String)iterator.next();
                Map map = this.getServiceDisplayOptions(serviceSchemaManager);
                if (map == null || map.isEmpty()) continue;
                hashMap.put(string, map);
            }
        } else {
            AMStoreConnection aMStoreConnection;
            AMServiceDisplayModelImpl aMServiceDisplayModelImpl = new AMServiceDisplayModelImpl(this.amStoreConn);
            Set set3 = aMServiceDisplayModelImpl.getDeniedServices(aMUser);
            if (AMModelBase.debug.messageEnabled()) {
                AMModelBase.debug.message("getUserDisplayOptions:deniedServices " + set3);
            }
            set.removeAll(set3);
            if (AMModelBase.debug.messageEnabled()) {
                AMModelBase.debug.message("getUserDisplayOptions:assignedSvcs " + set);
            }
            if ((aMStoreConnection = (AMStoreConnection)AccessController.doPrivileged(new PrivilegedAction(){

                public Object run() {
                    try {
                        return AMAdminUtils.getStoreConnAsAdmin();
                    }
                    catch (SecurityException securityException) {
                        AMModelBase.debug.error("AMAttributeDisplayImpl.getUserDisplayOptions", (Throwable)securityException);
                        return null;
                    }
                }
            })) != null) {
                Iterator iterator = set2.iterator();
                while (iterator.hasNext()) {
                    Map map = null;
                    String string = (String)iterator.next();
                    AMRole aMRole = aMStoreConnection.getRole(string);
                    Set set4 = aMRole.getAttribute("iplanet-am-role-any-options");
                    map = set4 == null || set4.isEmpty() ? this.getDefaultRoleOptions(aMModelBase, set) : this.getOptionsFromRoleAttribute(set4, set);
                    if (hashMap.isEmpty()) {
                        hashMap.putAll(this.getUserOptions(map));
                        continue;
                    }
                    hashMap.putAll(this.getAggregatedUserOptions(hashMap, map));
                }
            }
            if (AMModelBase.debug.messageEnabled()) {
                AMModelBase.debug.message("getUserDisplayOptions:aggregatedOptions " + hashMap);
            }
        }
        return hashMap;
    }

    public Map getServiceDisplayOptions(String string, ServiceSchemaManager serviceSchemaManager, AMUser aMUser) throws AMException, SSOException, SMSException {
        HashMap hashMap = new HashMap();
        Set set = aMUser.getRoleDNs();
        if (set.isEmpty()) {
            hashMap.putAll(this.getServiceDisplayOptions(serviceSchemaManager));
        } else {
            AMServiceDisplayModelImpl aMServiceDisplayModelImpl = new AMServiceDisplayModelImpl(this.amStoreConn);
            Set set2 = Collections.EMPTY_SET;
            AMStoreConnection aMStoreConnection = (AMStoreConnection)AccessController.doPrivileged(new PrivilegedAction(){

                public Object run() {
                    try {
                        return AMAdminUtils.getStoreConnAsAdmin();
                    }
                    catch (SecurityException securityException) {
                        AMModelBase.debug.error("AMAttributeDisplayImpl.getServiceDisplayOptions", (Throwable)securityException);
                        return null;
                    }
                }
            });
            if (aMStoreConnection != null) {
                Iterator iterator = set.iterator();
                while (iterator.hasNext()) {
                    Map map = null;
                    String string2 = (String)iterator.next();
                    AMRole aMRole = aMStoreConnection.getRole(string2);
                    set2 = aMServiceDisplayModelImpl.getDeniedServices(aMRole);
                    if (set2.contains(string)) continue;
                    Set set3 = aMRole.getAttribute("iplanet-am-role-any-options");
                    map = set3 == null || set3.isEmpty() ? this.getServiceDisplayOptions(serviceSchemaManager) : this.getOptionsFromRoleAttribute(set3, string);
                    if (hashMap.isEmpty()) {
                        hashMap.putAll(map);
                        continue;
                    }
                    hashMap.putAll(this.getAggregatedServiceOptions(hashMap, map));
                }
            }
            if (AMModelBase.debug.messageEnabled()) {
                AMModelBase.debug.message("getServiceDisplayOptions: " + hashMap);
            }
        }
        return hashMap;
    }

    private Set mapOptionsToSet(Map map) {
        if (map == null || map.isEmpty()) {
            return Collections.EMPTY_SET;
        }
        HashSet<String> hashSet = new HashSet<String>();
        Iterator iterator = map.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry entry = iterator.next();
            String string = (String)entry.getKey();
            Map map2 = (Map)entry.getValue();
            if (map2 == null || map2.isEmpty()) continue;
            Iterator iterator2 = map2.entrySet().iterator();
            while (iterator2.hasNext()) {
                StringBuffer stringBuffer = new StringBuffer(100);
                Map.Entry entry2 = iterator2.next();
                String string2 = (String)entry2.getKey();
                Set set = (Set)entry2.getValue();
                stringBuffer.append(string).append(SERVICE_ATTR_NAME_SEPARATOR).append(string2);
                if (set == null || set.isEmpty()) {
                    hashSet.add(stringBuffer.toString());
                    continue;
                }
                stringBuffer.append(ATTR_NAME_ANY_OPTION_SEPARATOR);
                Iterator iterator3 = set.iterator();
                StringBuffer stringBuffer2 = new StringBuffer(25);
                while (iterator3.hasNext()) {
                    if (stringBuffer2.length() != 0) {
                        stringBuffer2.append(ANY_OPTION_SEPARATOR);
                    }
                    stringBuffer2.append((String)iterator3.next());
                }
                stringBuffer.append((Object)stringBuffer2);
                hashSet.add(stringBuffer.toString());
            }
        }
        if (AMModelBase.debug.messageEnabled()) {
            AMModelBase.debug.message("mapOptionsToSet attrVal : " + hashSet);
        }
        return hashSet;
    }

    private Map getDefaultRoleOptions(AMModelBase aMModelBase, Set set) throws AMException, SSOException, SMSException {
        HashMap<String, Map> hashMap = new HashMap<String, Map>(set.size());
        Iterator iterator = set.iterator();
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            ServiceSchemaManager serviceSchemaManager = aMModelBase.getServiceSchemaManager(string);
            Map map = this.getServiceDisplayOptions(serviceSchemaManager);
            if (map == null || map.isEmpty()) continue;
            hashMap.put(string, map);
        }
        if (AMModelBase.debug.messageEnabled()) {
            AMModelBase.debug.message("getDefaultRoleOptions:displayOptions " + hashMap);
        }
        return hashMap;
    }

    private Set getDisplaySchemaTypes(ServiceSchemaManager serviceSchemaManager) throws SMSException {
        Set set = serviceSchemaManager.getSchemaTypes();
        if (set != null) {
            set.remove(SchemaType.GLOBAL);
            set.remove(SchemaType.POLICY);
        } else {
            set = Collections.EMPTY_SET;
        }
        return set;
    }

    private Map getUserOptions(Map map) {
        HashMap hashMap = new HashMap(map.size());
        Iterator iterator = map.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry entry = iterator.next();
            String string = (String)entry.getKey();
            Map map2 = (Map)entry.getValue();
            HashMap hashMap2 = new HashMap(map2.size());
            Iterator iterator2 = map2.entrySet().iterator();
            while (iterator2.hasNext()) {
                Map.Entry entry2 = iterator2.next();
                String string2 = (String)entry2.getKey();
                String string3 = this.getHighestDisplayOption((Set)entry2.getValue());
                HashSet<String> hashSet = new HashSet<String>(1);
                hashSet.add(string3);
                hashMap2.put(string2, hashSet);
            }
            hashMap.put(string, hashMap2);
        }
        return hashMap;
    }

    private Map getAggregatedUserOptions(Map map, Map map2) {
        HashMap<String, Map> hashMap = new HashMap<String, Map>();
        Iterator iterator = map.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry entry = iterator.next();
            String string = (String)entry.getKey();
            Map map3 = (Map)entry.getValue();
            Map map4 = (Map)map2.get(string);
            if (map4 == null) {
                hashMap.put(string, map3);
                continue;
            }
            HashMap<String, Set> hashMap2 = new HashMap<String, Set>(map3.size());
            Iterator iterator2 = map3.entrySet().iterator();
            while (iterator2.hasNext()) {
                Map.Entry entry2 = iterator2.next();
                String string2 = (String)entry2.getKey();
                Set set = (Set)entry2.getValue();
                Set set2 = (Set)map4.get(string2);
                if ((set == null || set.isEmpty()) && (set2 == null || set2.isEmpty())) {
                    hashMap2.put(string2, Collections.EMPTY_SET);
                    continue;
                }
                if (set == null || set.isEmpty()) {
                    hashMap2.put(string2, set2);
                    continue;
                }
                if (set2 == null || set2.isEmpty()) {
                    hashMap2.put(string2, set);
                    continue;
                }
                set.addAll(set2);
                hashMap2.put(string2, set);
            }
            hashMap.put(string, hashMap2);
        }
        if (AMModelBase.debug.messageEnabled()) {
            AMModelBase.debug.message("getAggregatedUserOptions: " + hashMap);
        }
        return hashMap;
    }

    private Map getAggregatedServiceOptions(Map map, Map map2) {
        HashMap<String, Set> hashMap = new HashMap<String, Set>(map.size());
        Iterator iterator = map.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry entry = iterator.next();
            String string = (String)entry.getKey();
            if (string == null || string.length() < 1) continue;
            Set set = (Set)entry.getValue();
            Set set2 = (Set)map2.get(string);
            if ((set == null || set.isEmpty()) && (set2 == null || set2.isEmpty())) {
                hashMap.put(string, Collections.EMPTY_SET);
                continue;
            }
            if (set == null || set.isEmpty()) {
                hashMap.put(string, set2);
                continue;
            }
            if (set2 == null || set2.isEmpty()) {
                hashMap.put(string, set);
                continue;
            }
            set.addAll(set2);
            hashMap.put(string, set);
        }
        if (AMModelBase.debug.messageEnabled()) {
            AMModelBase.debug.message("getAggregatedServiceOptions: " + hashMap);
        }
        return hashMap;
    }

    private String getHighestDisplayOption(Set set) {
        String string = "";
        if (set.contains("display")) {
            string = "display";
        } else if (set.contains("adminDisplay")) {
            string = "adminDisplay";
        } else if (set.contains("userReadOnly")) {
            string = "userReadOnly";
        } else if (set.contains("readOnly")) {
            string = "readOnly";
        }
        return string;
    }

    private Map getOptionsFromRoleAttribute(Set set, String string) {
        HashSet<String> hashSet = new HashSet<String>(1);
        hashSet.add(string);
        Map map = this.getOptionsFromRoleAttribute(set, hashSet);
        HashMap hashMap = (HashMap)map.get(string);
        if (hashMap == null) {
            hashMap = new HashMap(1);
        }
        return hashMap;
    }

    private Map getOptionsFromRoleAttribute(Set set, Set set2) {
        if (AMModelBase.debug.messageEnabled()) {
            AMModelBase.debug.message("getOptionsFromRoleAttribute:attrValue " + set);
            AMModelBase.debug.message("getOptionsFromRoleAttribute:availSvcs " + set2);
        }
        HashMap<String, HashMap<String, Set>> hashMap = new HashMap<String, HashMap<String, Set>>();
        Map map = this.parseAttributeValue(set);
        Iterator iterator = map.entrySet().iterator();
        while (iterator.hasNext()) {
            String string;
            Map.Entry entry = iterator.next();
            Set set3 = (Set)entry.getValue();
            String string2 = (String)entry.getKey();
            StringTokenizer stringTokenizer = new StringTokenizer(string2, SERVICE_ATTR_NAME_SEPARATOR);
            if (stringTokenizer.countTokens() != 2 || !set2.contains(string = stringTokenizer.nextToken())) continue;
            String string3 = stringTokenizer.nextToken();
            HashMap<String, Set> hashMap2 = (HashMap<String, Set>)hashMap.get(string);
            if (hashMap2 == null) {
                hashMap2 = new HashMap<String, Set>(set.size());
            }
            hashMap2.put(string3, set3);
            hashMap.put(string, hashMap2);
        }
        return hashMap;
    }

    private Map parseAttributeValue(Set set) {
        HashMap<String, Set> hashMap = new HashMap<String, Set>(set.size());
        Iterator iterator = set.iterator();
        while (iterator.hasNext()) {
            String string;
            StringTokenizer stringTokenizer = new StringTokenizer((String)iterator.next(), ATTR_NAME_ANY_OPTION_SEPARATOR);
            int n = stringTokenizer.countTokens();
            if (n == 1) {
                string = stringTokenizer.nextToken();
                hashMap.put(string, Collections.EMPTY_SET);
                continue;
            }
            if (n <= 1) continue;
            string = stringTokenizer.nextToken();
            Set set2 = this.getDisplayOptions(stringTokenizer.nextToken());
            hashMap.put(string, set2);
        }
        return hashMap;
    }

    private Set getAllOptions(String string) {
        if (string == null || string.length() == 0) {
            return Collections.EMPTY_SET;
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string, ANY_OPTION_SEPARATOR);
        HashSet<String> hashSet = new HashSet<String>(stringTokenizer.countTokens());
        while (stringTokenizer.hasMoreTokens()) {
            hashSet.add(stringTokenizer.nextToken());
        }
        return hashSet;
    }

    private Set getAllOptions(AttributeSchema attributeSchema) {
        String string;
        if (attributeSchema == null) {
            return Collections.EMPTY_SET;
        }
        HashSet<String> hashSet = new HashSet<String>(6);
        String string2 = attributeSchema.getI18NKey();
        if (string2 != null && string2.length() != 0 && (string = attributeSchema.getAny()) != null && string.length() != 0) {
            StringTokenizer stringTokenizer = new StringTokenizer(string, ANY_OPTION_SEPARATOR);
            while (stringTokenizer.hasMoreTokens()) {
                hashSet.add(stringTokenizer.nextToken());
            }
        }
        return hashSet;
    }

    private Set getDisplayOptions(String string) {
        if (string == null || string.length() == 0) {
            return Collections.EMPTY_SET;
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string, ANY_OPTION_SEPARATOR);
        HashSet<String> hashSet = new HashSet<String>(stringTokenizer.countTokens());
        while (stringTokenizer.hasMoreTokens()) {
            hashSet.add(stringTokenizer.nextToken());
        }
        return hashSet;
    }

    private Set getDisplayOptions(AttributeSchema attributeSchema) {
        Set set = Collections.EMPTY_SET;
        if (attributeSchema == null) {
            return set;
        }
        String string = attributeSchema.getI18NKey();
        if (string == null || string.length() == 0) {
            return set;
        }
        String string2 = attributeSchema.getAny();
        if (string2 != null && string2.length() != 0) {
            set = this.getDisplayOptions(string2);
        }
        return set;
    }

    private Set getDisplayOptions(AttributeSchema attributeSchema, SchemaType schemaType) {
        HashSet<String> hashSet = Collections.EMPTY_SET;
        if (attributeSchema == null) {
            return hashSet;
        }
        String string = attributeSchema.getI18NKey();
        if (string == null || string.length() == 0) {
            return hashSet;
        }
        String string2 = attributeSchema.getAny();
        if (string2 == null) {
            if (!schemaType.equals((Object)SchemaType.USER)) {
                hashSet = new HashSet<String>(1);
                hashSet.add("display");
            }
        } else {
            hashSet = this.getDisplayOptions(string2);
        }
        return hashSet;
    }
}

