/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.am.console.base.model;

import com.iplanet.am.console.StringConstants;
import com.iplanet.am.console.base.model.AMAdminConstants;
import com.iplanet.am.console.base.model.AMModel;
import com.iplanet.am.console.base.model.AMModelBase;
import com.iplanet.am.console.base.model.AMResBundleCacher;
import com.iplanet.am.sdk.AMException;
import com.iplanet.am.sdk.AMObject;
import com.iplanet.am.sdk.AMOrganization;
import com.iplanet.am.sdk.AMSearchResults;
import com.iplanet.am.sdk.AMStoreConnection;
import com.iplanet.am.sdk.AMTemplate;
import com.iplanet.am.sdk.AMUser;
import com.iplanet.am.util.Debug;
import com.iplanet.services.util.Crypt;
import com.iplanet.sso.SSOException;
import com.iplanet.sso.SSOToken;
import com.sun.identity.security.AdminTokenAction;
import com.sun.identity.security.ISSecurityPermission;
import com.sun.identity.sm.AttributeSchema;
import com.sun.identity.sm.SMSException;
import com.sun.identity.sm.SchemaType;
import com.sun.identity.sm.ServiceSchema;
import com.sun.identity.sm.ServiceSchemaManager;
import java.security.AccessController;
import java.security.Permission;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.Set;
import netscape.ldap.util.DN;

public class AMAdminUtils
implements AMAdminConstants,
StringConstants {
    private static Debug debug = Debug.getInstance((String)"amConsole");
    private static SSOToken adminSSOToken = (SSOToken)AccessController.doPrivileged(AdminTokenAction.getInstance());
    private static AMStoreConnection adminStoreConn = AMAdminUtils.getAdminStoreConnection();
    static /* synthetic */ Class class$com$iplanet$am$console$user$UMOrgProfileViewBean;
    static /* synthetic */ Class class$com$iplanet$am$console$user$UMOrgUnitProfileViewBean;
    static /* synthetic */ Class class$com$iplanet$am$console$user$UMUserDataViewBean;
    static /* synthetic */ Class class$com$iplanet$am$console$user$UMServiceDataViewBean;
    static /* synthetic */ Class class$com$iplanet$am$console$user$UMFilteredRoleProfileViewBean;
    static /* synthetic */ Class class$com$iplanet$am$console$user$UMRoleProfileViewBean;
    static /* synthetic */ Class class$com$iplanet$am$console$user$UMFilteredGroupProfileViewBean;
    static /* synthetic */ Class class$com$iplanet$am$console$user$UMStaticGroupProfileViewBean;
    static /* synthetic */ Class class$com$iplanet$am$console$user$UMOrgDisplayOptionsViewBean;
    static /* synthetic */ Class class$com$iplanet$am$console$user$UMOrgUnitDisplayOptionsViewBean;
    static /* synthetic */ Class class$com$iplanet$am$console$user$UMRoleDisplayOptionsViewBean;
    static /* synthetic */ Class class$com$iplanet$am$console$user$UMOrgPermissionsViewBean;
    static /* synthetic */ Class class$com$iplanet$am$console$user$UMOrgUnitPermissionsViewBean;
    static /* synthetic */ Class class$com$iplanet$am$console$user$UMRolePermissionsViewBean;
    static /* synthetic */ Class class$com$iplanet$am$console$user$UMGroupMembersViewBean;

    public static Set getAttrValues(AMObject aMObject, String string) throws SSOException {
        Set set;
        block2: {
            set = Collections.EMPTY_SET;
            try {
                set = aMObject.getAttribute(string);
            }
            catch (AMException aMException) {
                if (!debug.warningEnabled()) break block2;
                debug.warning("AMAdminUtils.getAttrValues, ", (Throwable)aMException);
            }
        }
        return set;
    }

    public static Set getAttribute(ServiceSchemaManager serviceSchemaManager, SchemaType schemaType, String string) throws SMSException {
        AttributeSchema attributeSchema;
        Set set = Collections.EMPTY_SET;
        ServiceSchema serviceSchema = serviceSchemaManager.getSchema(schemaType);
        if (serviceSchema != null && (attributeSchema = serviceSchema.getAttributeSchema(string)) != null) {
            set = attributeSchema.getDefaultValues();
        }
        if (set == null) {
            set = Collections.EMPTY_SET;
        }
        return set;
    }

    public static Set getAttribute(AMTemplate aMTemplate, String string) throws AMException, SSOException {
        Set set = Collections.EMPTY_SET;
        if (aMTemplate != null) {
            set = aMTemplate.getAttribute(string);
        }
        if (set == null) {
            set = Collections.EMPTY_SET;
        }
        return set;
    }

    public static boolean getBooleanAttribute(ServiceSchemaManager serviceSchemaManager, SchemaType schemaType, String string) throws SMSException {
        Iterator iterator;
        boolean bl = true;
        Set set = AMAdminUtils.getAttribute(serviceSchemaManager, schemaType, string);
        if (set != null && !set.isEmpty() && (iterator = set.iterator()).hasNext()) {
            bl = Boolean.valueOf((String)iterator.next());
        }
        return bl;
    }

    public static boolean getBooleanAttribute(AMTemplate aMTemplate, String string) throws AMException, SSOException {
        Iterator iterator;
        boolean bl = false;
        Set set = AMAdminUtils.getAttribute(aMTemplate, string);
        if (set != null && !set.isEmpty() && (iterator = set.iterator()).hasNext()) {
            bl = Boolean.valueOf((String)iterator.next());
        }
        return bl;
    }

    public static int getIntegerAttribute(ServiceSchemaManager serviceSchemaManager, SchemaType schemaType, String string) throws NumberFormatException, SMSException {
        String string2;
        Iterator iterator;
        int n = -1;
        Set set = AMAdminUtils.getAttribute(serviceSchemaManager, schemaType, string);
        if (set != null && !set.isEmpty() && (iterator = set.iterator()).hasNext() && (string2 = (String)iterator.next()) != null && string2.length() > 0) {
            n = Integer.parseInt(string2);
        }
        return n;
    }

    public static int getIntegerAttribute(AMTemplate aMTemplate, String string) throws NumberFormatException, AMException, SSOException {
        String string2;
        Iterator iterator;
        int n = -1;
        Set set = AMAdminUtils.getAttribute(aMTemplate, string);
        if (set != null && !set.isEmpty() && (iterator = set.iterator()).hasNext() && (string2 = (String)iterator.next()) != null && string2.length() > 0) {
            n = Integer.parseInt(string2);
        }
        return n;
    }

    public static String getStringAttribute(ServiceSchemaManager serviceSchemaManager, SchemaType schemaType, String string) throws SMSException {
        Iterator iterator;
        String string2 = "";
        Set set = AMAdminUtils.getAttribute(serviceSchemaManager, schemaType, string);
        if (set != null && !set.isEmpty() && (iterator = set.iterator()).hasNext()) {
            string2 = (String)iterator.next();
        }
        return string2;
    }

    public static String geti18nKey(ServiceSchemaManager serviceSchemaManager, SchemaType schemaType, String string) throws SMSException {
        String string2 = null;
        ServiceSchema serviceSchema = serviceSchemaManager.getSchema(schemaType);
        AttributeSchema attributeSchema = serviceSchema.getAttributeSchema(string);
        if (attributeSchema != null) {
            string2 = attributeSchema.getI18NKey();
        }
        return string2;
    }

    public static String getStringAttribute(AMTemplate aMTemplate, String string) throws AMException, SSOException {
        Iterator iterator;
        String string2 = "";
        Set set = AMAdminUtils.getAttribute(aMTemplate, string);
        if (set != null && !set.isEmpty() && (iterator = set.iterator()).hasNext()) {
            string2 = (String)iterator.next();
        }
        return string2;
    }

    public static boolean isAttributeEditableByUser(int n, AttributeSchema attributeSchema, SchemaType schemaType) {
        if (schemaType.equals((Object)SchemaType.DYNAMIC)) {
            return false;
        }
        if (n != 3) {
            return true;
        }
        boolean bl = true;
        String string = attributeSchema.getAny();
        if (string != null) {
            if (string.indexOf("userReadOnly") != -1) {
                bl = false;
            } else if (string.indexOf("display") == -1) {
                bl = false;
            }
        }
        return bl;
    }

    public static boolean isUserAttrEditable(int n, AttributeSchema attributeSchema, SchemaType schemaType) {
        return AMAdminUtils.isAttributeEditableByUser(n, attributeSchema, schemaType);
    }

    public static boolean isAttributeDisplayable(int n, AttributeSchema attributeSchema) {
        boolean bl;
        if (attributeSchema == null) {
            return false;
        }
        String string = attributeSchema.getI18NKey();
        if (string == null || string.length() == 0) {
            return false;
        }
        String string2 = attributeSchema.getAny();
        if (string2 == null) {
            return false;
        }
        boolean bl2 = string2.indexOf("display") != -1;
        boolean bl3 = string2.indexOf("userReadOnly") != -1;
        boolean bl4 = bl = string2.indexOf("adminDisplay") != -1;
        if (bl2 || bl3) {
            return true;
        }
        return n != 3 && bl;
    }

    public static boolean isAttrDisplayable(int n, AttributeSchema attributeSchema) {
        return AMAdminUtils.isAttributeDisplayable(n, attributeSchema);
    }

    public static AMObject getAMObject(AMModelBase aMModelBase, String string, AMStoreConnection aMStoreConnection) throws AMException, SSOException {
        AMOrganization aMOrganization = null;
        int n = aMModelBase.getObjectType(string);
        switch (n) {
            case 2: {
                aMOrganization = aMStoreConnection.getOrganization(string);
                break;
            }
            case 3: {
                aMOrganization = aMStoreConnection.getOrganizationalUnit(string);
                break;
            }
            case 9: 
            case 10: {
                aMOrganization = aMStoreConnection.getStaticGroup(string);
                break;
            }
            case 11: {
                aMOrganization = aMStoreConnection.getDynamicGroup(string);
                break;
            }
            case 12: {
                aMOrganization = aMStoreConnection.getAssignableDynamicGroup(string);
                break;
            }
            case 6: {
                aMOrganization = aMStoreConnection.getRole(string);
                break;
            }
            case 8: {
                aMOrganization = aMStoreConnection.getFilteredRole(string);
                break;
            }
            case 1: {
                aMOrganization = aMStoreConnection.getUser(string);
                break;
            }
            case 5: {
                aMOrganization = aMStoreConnection.getPeopleContainer(string);
                break;
            }
            case 4: {
                aMOrganization = aMStoreConnection.getGroupContainer(string);
                break;
            }
            default: {
                if (!debug.warningEnabled()) break;
                debug.warning("AMAdminUtils.getAMObject: Cannot create AMObject for:" + string);
            }
        }
        return aMOrganization;
    }

    public static String getParent(String string) {
        if (string != null) {
            return new DN(string).getParent().toString();
        }
        return "";
    }

    public static ResourceBundle getSchemaResourceBundle(AMStoreConnection aMStoreConnection, Locale locale, String string) {
        ResourceBundle resourceBundle = null;
        String string2 = null;
        try {
            string2 = aMStoreConnection.getI18NPropertiesFileName(string);
        }
        catch (AMException aMException) {
            debug.warning("AMModelBase.getSchemaResourceBundle", (Throwable)aMException);
        }
        if (string2 != null && string2.length() != 0) {
            resourceBundle = AMResBundleCacher.getBundle(string2, locale);
        }
        return resourceBundle;
    }

    public static String getUserOrganization(AMUser aMUser) {
        String string = "";
        if (aMUser != null) {
            try {
                string = aMUser.getOrganizationDN();
            }
            catch (AMException aMException) {
                if (debug.warningEnabled()) {
                    debug.warning("AMAdminUtils.getUserOrganization", (Throwable)aMException);
                }
            }
            catch (SSOException sSOException) {
                debug.error("AMAdminUtils.getUserOrganization", (Throwable)sSOException);
            }
        }
        return string;
    }

    public static Map getAttributeRadioValue(AttributeSchema attributeSchema, ResourceBundle resourceBundle) {
        Map map = new HashMap(0);
        AttributeSchema.UIType uIType = attributeSchema.getUIType();
        AttributeSchema.Syntax syntax = attributeSchema.getSyntax();
        if (uIType != null && uIType == AttributeSchema.UIType.RADIO) {
            map = syntax == AttributeSchema.Syntax.BOOLEAN ? AMAdminUtils.getAttributeRadioBooleanValue(attributeSchema, resourceBundle) : AMAdminUtils.getAttributeRadioOptionValue(attributeSchema, resourceBundle);
        }
        return map;
    }

    private static Map getAttributeRadioBooleanValue(AttributeSchema attributeSchema, ResourceBundle resourceBundle) {
        String string;
        HashMap<String, String> hashMap = new HashMap<String, String>(2);
        String string2 = attributeSchema.getTrueValue();
        String string3 = attributeSchema.getFalseValue();
        if (string2 == null) {
            string2 = "true";
        }
        if (string3 == null) {
            string3 = "false";
        }
        String string4 = attributeSchema.getTrueValueI18NKey();
        String string5 = attributeSchema.getFalseValueI18NKey();
        if (string4 != null) {
            string = com.iplanet.am.util.Locale.getString((ResourceBundle)resourceBundle, (String)string4, (Debug)debug);
            if (string == null || string.length() == 0) {
                hashMap.put(string2, string2);
            } else {
                hashMap.put(string, string2);
            }
        } else {
            hashMap.put(string2, string2);
        }
        if (string5 != null) {
            string = com.iplanet.am.util.Locale.getString((ResourceBundle)resourceBundle, (String)string5, (Debug)debug);
            if (string == null || string.length() == 0) {
                hashMap.put(string3, string3);
            } else {
                hashMap.put(string, string3);
            }
        } else {
            hashMap.put(string3, string3);
        }
        return hashMap;
    }

    private static Map getAttributeRadioOptionValue(AttributeSchema attributeSchema, ResourceBundle resourceBundle) {
        HashMap<String, String> hashMap = null;
        String[] stringArray = attributeSchema.getChoiceValues();
        if (stringArray != null && stringArray.length > 0) {
            int n = stringArray.length;
            hashMap = new HashMap(n);
            int n2 = 0;
            while (n2 < n) {
                String string = stringArray[n2];
                String string2 = attributeSchema.getChoiceValueI18NKey(string);
                if (string2 != null && string2.length() > 0) {
                    hashMap.put(com.iplanet.am.util.Locale.getString((ResourceBundle)resourceBundle, (String)string2, (Debug)debug), string);
                } else {
                    hashMap.put(string, string);
                }
                ++n2;
            }
        } else {
            hashMap = new HashMap<String, String>(0);
        }
        return hashMap;
    }

    public static Set getUserManagementSchemaTypes(ServiceSchemaManager serviceSchemaManager, int n) {
        HashSet<SchemaType> hashSet;
        block4: {
            hashSet = Collections.EMPTY_SET;
            try {
                Set set = serviceSchemaManager.getSchemaTypes();
                hashSet = new HashSet<SchemaType>(set.size());
                Iterator iterator = set.iterator();
                while (iterator.hasNext()) {
                    SchemaType schemaType = (SchemaType)iterator.next();
                    if (schemaType.equals((Object)SchemaType.ORGANIZATION)) {
                        if (n != 2 && n != 3) continue;
                        hashSet.add(schemaType);
                        continue;
                    }
                    if (!schemaType.equals((Object)SchemaType.DYNAMIC) || n != 2 && n != 3 && n != 6 && n != 8 && n != 7) continue;
                    hashSet.add(schemaType);
                }
            }
            catch (SMSException sMSException) {
                if (!debug.warningEnabled()) break block4;
                debug.warning("AMAdminUtils.getUserManagementSchemaTypes", (Throwable)sMSException);
            }
        }
        return hashSet;
    }

    public static AMStoreConnection getStoreConnAsAdmin() throws SecurityException {
        SecurityManager securityManager;
        if (Crypt.checkCaller() && (securityManager = System.getSecurityManager()) != null) {
            securityManager.checkPermission((Permission)new ISSecurityPermission("access", "adminPassword"));
        }
        return adminStoreConn;
    }

    private static AMStoreConnection getAdminStoreConnection() {
        AMStoreConnection aMStoreConnection = null;
        if (adminSSOToken != null) {
            try {
                aMStoreConnection = new AMStoreConnection(adminSSOToken);
            }
            catch (SSOException sSOException) {
                debug.warning("AMAdminUtils.getAdminStoreConnection", (Throwable)sSOException);
            }
        }
        return aMStoreConnection;
    }

    public static final SSOToken getSuperAdminSSOToken() throws SecurityException {
        SecurityManager securityManager;
        if (Crypt.checkCaller() && (securityManager = System.getSecurityManager()) != null) {
            securityManager.checkPermission((Permission)new ISSecurityPermission("access", "adminPassword"));
        }
        return adminSSOToken;
    }

    public static final boolean containsSchemaType(Set set, SchemaType schemaType) {
        boolean bl = false;
        Iterator iterator = set.iterator();
        while (iterator.hasNext() && !bl) {
            bl = schemaType.equals((Object)((SchemaType)iterator.next()));
        }
        return bl;
    }

    public static final Class getProfileViewBeanClass(AMModelBase aMModelBase, String string, String string2) {
        int n;
        Class clazz = null;
        if (string2.equals("general")) {
            n = AMAdminUtils.getObjectType(aMModelBase, string);
            switch (n) {
                case 2: {
                    string2 = "organizations";
                    break;
                }
                case 3: {
                    string2 = "organizationalunits";
                    break;
                }
                case 6: 
                case 7: 
                case 8: {
                    string2 = "roles";
                    break;
                }
                case 9: 
                case 10: 
                case 11: 
                case 12: {
                    string2 = "groups";
                }
            }
        }
        if (string2.equals("organizations")) {
            clazz = class$com$iplanet$am$console$user$UMOrgProfileViewBean == null ? (class$com$iplanet$am$console$user$UMOrgProfileViewBean = AMAdminUtils.class$("com.iplanet.am.console.user.UMOrgProfileViewBean")) : class$com$iplanet$am$console$user$UMOrgProfileViewBean;
        } else if (string2.equals("organizationalunits")) {
            clazz = class$com$iplanet$am$console$user$UMOrgUnitProfileViewBean == null ? (class$com$iplanet$am$console$user$UMOrgUnitProfileViewBean = AMAdminUtils.class$("com.iplanet.am.console.user.UMOrgUnitProfileViewBean")) : class$com$iplanet$am$console$user$UMOrgUnitProfileViewBean;
        } else if (string2.equals("users")) {
            clazz = class$com$iplanet$am$console$user$UMUserDataViewBean == null ? (class$com$iplanet$am$console$user$UMUserDataViewBean = AMAdminUtils.class$("com.iplanet.am.console.user.UMUserDataViewBean")) : class$com$iplanet$am$console$user$UMUserDataViewBean;
        } else if (string2.equals("services")) {
            clazz = class$com$iplanet$am$console$user$UMServiceDataViewBean == null ? (class$com$iplanet$am$console$user$UMServiceDataViewBean = AMAdminUtils.class$("com.iplanet.am.console.user.UMServiceDataViewBean")) : class$com$iplanet$am$console$user$UMServiceDataViewBean;
        } else if (string2.equals("roles")) {
            n = AMAdminUtils.getRoleType(aMModelBase, string);
            clazz = n == 8 ? (class$com$iplanet$am$console$user$UMFilteredRoleProfileViewBean == null ? (class$com$iplanet$am$console$user$UMFilteredRoleProfileViewBean = AMAdminUtils.class$("com.iplanet.am.console.user.UMFilteredRoleProfileViewBean")) : class$com$iplanet$am$console$user$UMFilteredRoleProfileViewBean) : (class$com$iplanet$am$console$user$UMRoleProfileViewBean == null ? (class$com$iplanet$am$console$user$UMRoleProfileViewBean = AMAdminUtils.class$("com.iplanet.am.console.user.UMRoleProfileViewBean")) : class$com$iplanet$am$console$user$UMRoleProfileViewBean);
        } else if (string2.equals("groups")) {
            n = AMAdminUtils.getObjectType(aMModelBase, string);
            if (n != -1) {
                clazz = n == 11 ? (class$com$iplanet$am$console$user$UMFilteredGroupProfileViewBean == null ? (class$com$iplanet$am$console$user$UMFilteredGroupProfileViewBean = AMAdminUtils.class$("com.iplanet.am.console.user.UMFilteredGroupProfileViewBean")) : class$com$iplanet$am$console$user$UMFilteredGroupProfileViewBean) : (class$com$iplanet$am$console$user$UMStaticGroupProfileViewBean == null ? (class$com$iplanet$am$console$user$UMStaticGroupProfileViewBean = AMAdminUtils.class$("com.iplanet.am.console.user.UMStaticGroupProfileViewBean")) : class$com$iplanet$am$console$user$UMStaticGroupProfileViewBean);
            }
        } else if (string2.equals("displayoptions")) {
            n = AMAdminUtils.getObjectType(aMModelBase, string);
            switch (n) {
                case 2: {
                    clazz = class$com$iplanet$am$console$user$UMOrgDisplayOptionsViewBean == null ? (class$com$iplanet$am$console$user$UMOrgDisplayOptionsViewBean = AMAdminUtils.class$("com.iplanet.am.console.user.UMOrgDisplayOptionsViewBean")) : class$com$iplanet$am$console$user$UMOrgDisplayOptionsViewBean;
                    break;
                }
                case 3: {
                    clazz = class$com$iplanet$am$console$user$UMOrgUnitDisplayOptionsViewBean == null ? (class$com$iplanet$am$console$user$UMOrgUnitDisplayOptionsViewBean = AMAdminUtils.class$("com.iplanet.am.console.user.UMOrgUnitDisplayOptionsViewBean")) : class$com$iplanet$am$console$user$UMOrgUnitDisplayOptionsViewBean;
                    break;
                }
                case 6: 
                case 7: 
                case 8: {
                    clazz = class$com$iplanet$am$console$user$UMRoleDisplayOptionsViewBean == null ? (class$com$iplanet$am$console$user$UMRoleDisplayOptionsViewBean = AMAdminUtils.class$("com.iplanet.am.console.user.UMRoleDisplayOptionsViewBean")) : class$com$iplanet$am$console$user$UMRoleDisplayOptionsViewBean;
                }
            }
        } else if (string2.equals("permissions")) {
            n = AMAdminUtils.getObjectType(aMModelBase, string);
            switch (n) {
                case 2: {
                    clazz = class$com$iplanet$am$console$user$UMOrgPermissionsViewBean == null ? (class$com$iplanet$am$console$user$UMOrgPermissionsViewBean = AMAdminUtils.class$("com.iplanet.am.console.user.UMOrgPermissionsViewBean")) : class$com$iplanet$am$console$user$UMOrgPermissionsViewBean;
                    break;
                }
                case 3: {
                    clazz = class$com$iplanet$am$console$user$UMOrgUnitPermissionsViewBean == null ? (class$com$iplanet$am$console$user$UMOrgUnitPermissionsViewBean = AMAdminUtils.class$("com.iplanet.am.console.user.UMOrgUnitPermissionsViewBean")) : class$com$iplanet$am$console$user$UMOrgUnitPermissionsViewBean;
                    break;
                }
                case 6: 
                case 7: 
                case 8: {
                    clazz = class$com$iplanet$am$console$user$UMRolePermissionsViewBean == null ? (class$com$iplanet$am$console$user$UMRolePermissionsViewBean = AMAdminUtils.class$("com.iplanet.am.console.user.UMRolePermissionsViewBean")) : class$com$iplanet$am$console$user$UMRolePermissionsViewBean;
                }
            }
        } else if (string2.equals("members")) {
            clazz = class$com$iplanet$am$console$user$UMGroupMembersViewBean == null ? (class$com$iplanet$am$console$user$UMGroupMembersViewBean = AMAdminUtils.class$("com.iplanet.am.console.user.UMGroupMembersViewBean")) : class$com$iplanet$am$console$user$UMGroupMembersViewBean;
        }
        return clazz;
    }

    private static int getObjectType(AMModelBase aMModelBase, String string) {
        int n = -1;
        try {
            n = aMModelBase.getObjectType(string);
        }
        catch (AMException aMException) {
            aMModelBase.debugWarning("AMAdminUtils.getObjectType", (Exception)((Object)aMException));
        }
        catch (SSOException sSOException) {
            aMModelBase.debugWarning("AMAdminUtils.getObjectType", (Exception)((Object)sSOException));
        }
        return n;
    }

    public static String getFirstElement(Set set) {
        return set != null && !set.isEmpty() ? (String)set.iterator().next() : "";
    }

    private static int getRoleType(AMModelBase aMModelBase, String string) {
        int n = 6;
        try {
            n = aMModelBase.getObjectType(string);
        }
        catch (AMException aMException) {
            debug.warning("AMAdminUtils.getRoleType", (Throwable)aMException);
        }
        catch (SSOException sSOException) {
            debug.warning("AMAdminUtils.getRoleType", (Throwable)sSOException);
        }
        return n;
    }

    public static void excludeAttributeSchemas(Collection collection, Set set) {
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            AttributeSchema attributeSchema = (AttributeSchema)iterator.next();
            if (set.contains(attributeSchema.getName())) continue;
            iterator.remove();
        }
    }

    public static List chunkEntries(Set set, int n, int n2) {
        ArrayList arrayList = Collections.EMPTY_LIST;
        if (set != null && !set.isEmpty()) {
            arrayList = new ArrayList(n);
            int n3 = 0;
            Iterator iterator = set.iterator();
            while (--n2 >= 0 && iterator.hasNext()) {
                iterator.next();
            }
            while (n3 < n && iterator.hasNext()) {
                arrayList.add(iterator.next());
                ++n3;
            }
        }
        return arrayList;
    }

    public static String getSearchResultWarningTitle(AMSearchResults aMSearchResults, AMModel aMModel) {
        String string = null;
        if (aMSearchResults != null) {
            int n = aMSearchResults.getErrorCode();
            if (n == 1) {
                string = aMModel.getLocalizedString("sizeLimitExceeded.title");
            } else if (n == 2) {
                string = aMModel.getLocalizedString("timeLimitExceeded.title");
            }
        }
        return string != null ? string : "";
    }

    public static String getSearchResultWarningMessage(AMSearchResults aMSearchResults, AMModel aMModel) {
        String string = null;
        if (aMSearchResults != null) {
            int n = aMSearchResults.getErrorCode();
            if (n == 1) {
                string = aMModel.getLocalizedString("sizeLimitExceeded.message");
            } else if (n == 2) {
                string = aMModel.getLocalizedString("timeLimitExceeded.message");
            }
        }
        return string != null ? string : "";
    }

    public static boolean compareDNs(String string, String string2) {
        DN dN = new DN(string);
        DN dN2 = new DN(string2);
        return dN.equals(dN2);
    }

    public static void removeDNFromSet(Set set, String string) {
        boolean bl = false;
        DN dN = new DN(string);
        Iterator iterator = set.iterator();
        while (iterator.hasNext() && !bl) {
            DN dN2 = new DN((String)iterator.next());
            if (!dN2.equals(dN)) continue;
            iterator.remove();
            bl = true;
        }
    }

    public static String getElementIgnoreCase(Collection collection, String string) {
        String string2 = null;
        String string3 = string.toLowerCase();
        Iterator iterator = collection.iterator();
        while (iterator.hasNext() && string2 == null) {
            String string4 = (String)iterator.next();
            if (!string3.equals(string4.toLowerCase())) continue;
            string2 = string4;
        }
        return string2;
    }

    public static String getSubSchemaI18NKey(ServiceSchemaManager serviceSchemaManager, SchemaType schemaType, String string, String string2) throws SMSException {
        AttributeSchema attributeSchema;
        ServiceSchema serviceSchema;
        String string3 = null;
        ServiceSchema serviceSchema2 = serviceSchemaManager.getSchema(schemaType);
        if (serviceSchema2 != null && (serviceSchema = serviceSchema2.getSubSchema(string)) != null && (attributeSchema = serviceSchema.getAttributeSchema(string2)) != null) {
            string3 = attributeSchema.getI18NKey();
        }
        return string3;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

