/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.am.console.base.model;

import com.iplanet.am.console.base.model.AMAdminMenuModel;
import com.iplanet.am.console.base.model.AMAdminUtils;
import com.iplanet.am.console.base.model.AMModelBase;
import com.iplanet.am.console.base.model.AMSystemConfig;
import com.iplanet.am.sdk.AMException;
import com.iplanet.am.sdk.AMOrganization;
import com.iplanet.am.sdk.AMTemplate;
import com.iplanet.sso.SSOException;
import com.iplanet.sso.SSOToken;
import com.sun.identity.sm.AttributeSchema;
import com.sun.identity.sm.SMSException;
import com.sun.identity.sm.SchemaType;
import com.sun.identity.sm.ServiceSchema;
import com.sun.identity.sm.ServiceSchemaManager;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.text.Collator;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import javax.servlet.http.HttpServletRequest;

public class AMAdminMenuModelImpl
extends AMModelBase
implements AMAdminMenuModel {
    private Map menuMap = null;
    private Map subMenuMap = null;
    private static Map mapPatchViewMenus = new HashMap();

    public AMAdminMenuModelImpl(HttpServletRequest httpServletRequest, Map map) {
        super(httpServletRequest, map);
    }

    public String getLocalizedModuleName(String string) {
        return this.getLocalizedString(string);
    }

    public List getRegisteredModuleNames() {
        ArrayList<Object> arrayList = Collections.EMPTY_LIST;
        Map map = this.getMenuMap();
        if (map != null) {
            Object object;
            Set set = map.keySet();
            arrayList = new ArrayList<Object>(set.size());
            Iterator iterator = set.iterator();
            while (iterator.hasNext()) {
                object = (String)iterator.next();
                if (!this.fireBeforeDisplayModuleTabEvent((String)object)) continue;
                arrayList.add(object);
            }
            if (!arrayList.isEmpty()) {
                object = Collator.getInstance(this.getUserLocale());
                Collections.sort(arrayList, object);
            }
        }
        return arrayList;
    }

    public List getSubEntries(String string) {
        ArrayList arrayList = Collections.EMPTY_LIST;
        Map map = (Map)this.subMenuMap.get(string);
        if (map != null && !map.isEmpty()) {
            arrayList = new ArrayList(map.keySet());
            Collator collator = Collator.getInstance(this.getUserLocale());
            Collections.sort(arrayList, collator);
        }
        return arrayList;
    }

    public String getNavigationURL(String string, String string2) {
        String string3 = null;
        if (this.fireBeforeDisplayModuleTabEvent(string)) {
            Map map = this.getMenuMap();
            if (string != null && string.length() > 0) {
                if (string2 != null && string2.length() > 0) {
                    Map map2 = (Map)this.subMenuMap.get(string);
                    if (map2 != null && !map2.isEmpty()) {
                        string3 = (String)map2.get(string2);
                    }
                } else {
                    string3 = (String)map.get(string);
                }
            }
        }
        return string3;
    }

    public String getViewNotFoundTitle() {
        return this.getLocalizedString("viewNotFound.title");
    }

    public String getViewNotFoundMessage() {
        return this.getLocalizedString("viewNotFound.message");
    }

    protected Map getMenuMap() {
        if (this.menuMap == null) {
            this.menuMap = new HashMap();
            this.subMenuMap = new HashMap();
            Set set = null;
            if (this.getAuthenticatedOrgDN() != null) {
                set = this.getMenuEntriesFromTemplate();
            }
            if (set == null || set.isEmpty()) {
                set = this.getMenuEntriesFromSchema();
            }
            this.createMenuList(set);
        }
        return this.menuMap;
    }

    private int createMenuList(Set set) {
        Iterator iterator = set.iterator();
        this.menuMap = new HashMap(set.size());
        while (iterator.hasNext()) {
            String string;
            String string2;
            String string3 = (String)iterator.next();
            StringTokenizer stringTokenizer = new StringTokenizer(string3, "|");
            if (stringTokenizer.countTokens() == 2) {
                string2 = stringTokenizer.nextToken();
                string = stringTokenizer.nextToken();
                this.menuMap.put(string2, string);
                continue;
            }
            if (stringTokenizer.countTokens() == 3) {
                string2 = stringTokenizer.nextToken();
                string = stringTokenizer.nextToken();
                String string4 = stringTokenizer.nextToken();
                this.addMenuItem(string2, string, string4);
                continue;
            }
            if (!AMModelBase.debug.warningEnabled()) continue;
            AMModelBase.debug.warning("AMAdminMenuModelImpl.createMenuListview entry, " + string3 + " is invalid");
        }
        return this.menuMap.size();
    }

    private void addMenuItem(String string, String string2, String string3) {
        HashMap<String, String> hashMap = (HashMap<String, String>)this.subMenuMap.get(string);
        if (hashMap == null) {
            hashMap = new HashMap<String, String>(5);
            this.subMenuMap.put(string, hashMap);
        }
        hashMap.put(string2, string3);
        this.menuMap.put(string, null);
    }

    private Set getMenuEntriesFromTemplate() {
        Set set = null;
        try {
            AMOrganization aMOrganization = this.dpStoreConn.getOrganization(this.getAuthenticatedOrgDN());
            AMTemplate aMTemplate = this.getOrgTemplate(aMOrganization);
            if (aMTemplate != null) {
                set = AMAdminMenuModelImpl.patchViewMenuData(aMTemplate.getAttribute("iplanet-am-admin-console-view-menu"));
            }
        }
        catch (AMException aMException) {
            AMModelBase.debug.warning("AMAdminMenuModelImpl.getMenuEntriesFromTemplate", (Throwable)aMException);
        }
        catch (SSOException sSOException) {
            AMModelBase.debug.warning("AMAdminMenuModelImpl.getMenuEntriesFromTemplate", (Throwable)sSOException);
        }
        if (set == null) {
            set = Collections.EMPTY_SET;
        }
        return set;
    }

    private Set getMenuEntriesFromSchema() {
        AMModelBase.debug.message("getting menu entries from schema");
        Set set = null;
        try {
            SSOToken sSOToken = (SSOToken)AccessController.doPrivileged(new PrivilegedAction(){

                public Object run() {
                    try {
                        return AMAdminUtils.getSuperAdminSSOToken();
                    }
                    catch (SecurityException securityException) {
                        AMModelBase.debug.error("AMAdminMenuModelImpl.getMenuEntriesFromSchema", (Throwable)securityException);
                        return null;
                    }
                }
            });
            if (sSOToken != null) {
                ServiceSchemaManager serviceSchemaManager = new ServiceSchemaManager("iPlanetAMAdminConsoleService", sSOToken);
                ServiceSchema serviceSchema = serviceSchemaManager.getSchema(SchemaType.ORGANIZATION);
                if (serviceSchema != null) {
                    AttributeSchema attributeSchema = serviceSchema.getAttributeSchema("iplanet-am-admin-console-view-menu");
                    set = this.patchViewMenuData(attributeSchema.getDefaultValues(), attributeSchema);
                }
            } else {
                AMModelBase.debug.warning("getMenuEntriesFromSchema, no admin token");
            }
        }
        catch (SSOException sSOException) {
            AMModelBase.debug.warning("AMAdminMenuModelImpl.getMenuEntriesFromSchema", (Throwable)sSOException);
        }
        catch (SMSException sMSException) {
            AMModelBase.debug.error("AMAdminMenuModelImpl.getMenuEntriesFromSchema", (Throwable)sMSException);
        }
        if (set == null) {
            set = Collections.EMPTY_SET;
        }
        return set;
    }

    private Set patchViewMenuData(Set set, AMTemplate aMTemplate) {
        if (set != null && !set.isEmpty()) {
            Set set2 = AMAdminMenuModelImpl.patchViewMenuData(set);
            if (!set2.isEmpty()) {
                try {
                    AMModelBase.debug.message("AMAdminMenuModelImpl.patchViewMenuData: patching");
                    HashMap<String, Set> hashMap = new HashMap<String, Set>(2);
                    hashMap.put("iplanet-am-admin-console-view-menu", set2);
                    aMTemplate.setAttributes(hashMap);
                    aMTemplate.store();
                    AMModelBase.debug.message("AMAdminMenuModelImpl.patchViewMenuData: succeed");
                }
                catch (AMException aMException) {
                    AMModelBase.debug.error("AMAdminMenuModelImpl.patchViewMenuData", (Throwable)aMException);
                }
                catch (SSOException sSOException) {
                    AMModelBase.debug.error("AMAdminMenuModelImpl.patchViewMenuData", (Throwable)sSOException);
                }
                return set2;
            }
            return set;
        }
        return set;
    }

    private Set patchViewMenuData(Set set, AttributeSchema attributeSchema) {
        if (set != null && !set.isEmpty()) {
            Set set2 = AMAdminMenuModelImpl.patchViewMenuData(set);
            if (!set2.isEmpty()) {
                try {
                    AMModelBase.debug.message("AMAdminMenuModelImpl.patchViewMenuData: patching");
                    attributeSchema.setDefaultValues(set2);
                    AMModelBase.debug.message("AMAdminMenuModelImpl.patchViewMenuData: succeed");
                }
                catch (SMSException sMSException) {
                    AMModelBase.debug.error("AMAdminMenuModelImpl.patchViewMenuData", (Throwable)sMSException);
                }
                catch (SSOException sSOException) {
                    AMModelBase.debug.error("AMAdminMenuModelImpl.patchViewMenuData", (Throwable)sSOException);
                }
                return set2;
            }
            return set;
        }
        return set;
    }

    private static Set patchViewMenuData(Set set) {
        boolean bl = false;
        HashSet<String> hashSet = new HashSet<String>(set.size());
        Iterator iterator = set.iterator();
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            int n = string.indexOf(124);
            if (n != -1) {
                String string2 = string.substring(0, n);
                String string3 = string.substring(n + 1);
                String string4 = (String)mapPatchViewMenus.get(string3);
                if (string4 != null) {
                    string = string2 + "|" + string4;
                    bl = true;
                }
            }
            hashSet.add(string);
        }
        return bl ? hashSet : Collections.EMPTY_SET;
    }

    static {
        mapPatchViewMenus.put("com.iplanet.am.console.user.UMHomeViewBean", AMSystemConfig.deploymentURI + "/user/UMHome");
        mapPatchViewMenus.put("com.iplanet.am.console.service.SMHomeViewBean", AMSystemConfig.deploymentURI + "/service/SMHome");
        mapPatchViewMenus.put("com.iplanet.am.console.session.SMHomeViewBean", AMSystemConfig.deploymentURI + "/session/SMHome");
        mapPatchViewMenus.put("com.iplanet.am.console.federation.FSHomeViewBean", AMSystemConfig.deploymentURI + "/federation/FSHome");
    }
}

