/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.am.console.base;

import com.iplanet.am.console.StringConstants;
import com.iplanet.am.console.base.AMLoginViewBean;
import com.iplanet.am.console.base.AMUncaughtExceptionViewBean;
import com.iplanet.am.console.base.model.AMAdminConstants;
import com.iplanet.am.console.base.model.AMAdminUtils;
import com.iplanet.am.sdk.AMException;
import com.iplanet.am.sdk.AMStoreConnection;
import com.iplanet.am.util.BrowserEncoding;
import com.iplanet.am.util.Debug;
import com.iplanet.am.util.Locale;
import com.iplanet.am.util.SystemProperties;
import com.iplanet.jato.ApplicationServletBase;
import com.iplanet.jato.CompleteRequestException;
import com.iplanet.jato.RequestContext;
import com.iplanet.jato.ViewBeanManager;
import com.iplanet.jato.view.ViewBean;
import com.iplanet.sso.SSOException;
import com.iplanet.sso.SSOToken;
import com.iplanet.sso.SSOTokenManager;
import com.sun.identity.common.Constants;
import com.sun.identity.common.FQDNUtils;
import com.sun.identity.common.ISLocaleContext;
import com.sun.identity.common.RequestUtils;
import com.sun.identity.sm.ServiceManager;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.security.AccessController;
import java.security.PrivilegedAction;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;

public abstract class ConsoleServletBase
extends ApplicationServletBase
implements AMAdminConstants,
StringConstants,
Constants {
    private static FQDNUtils fqdnUtils = new FQDNUtils();
    static final String PARAM_REDIRECT = "amconsoleRedirect";
    static final String URL_ADMIN_FRAME = "/base/AMAdminFrame";
    static final String LOGIN_PARAM = "?service=adminconsoleservice&goto=";
    private static final String AUTH_ORG_PARAM = "&org=";
    private static final String AUTH_DOMAIN_PARAM = "&domain=";
    private static final String GX_CHARSET = "gx_charset=";
    private static final String GX_CHARSET_PARAM = "&gx_charset=";
    protected static String serverURI = SystemProperties.get((String)"com.iplanet.am.services.deploymentDescriptor");
    protected static String serverProtocol = SystemProperties.get((String)"com.iplanet.am.server.protocol");
    protected static String serverPort = SystemProperties.get((String)"com.iplanet.am.server.port");
    protected static String serverHost = SystemProperties.get((String)"com.iplanet.am.server.host");
    protected static String consoleProtocol = SystemProperties.get((String)"com.iplanet.am.console.protocol");
    protected static String consolePort = SystemProperties.get((String)"com.iplanet.am.console.port");
    protected static String consoleHost = SystemProperties.get((String)"com.iplanet.am.console.host");
    protected static String serverURL = serverProtocol + "://" + serverHost + ":" + serverPort;
    protected static String consoleURI = SystemProperties.get((String)"com.iplanet.am.console.deploymentDescriptor");
    protected static String consoleURL = consoleProtocol + "://" + consoleHost + ":" + consolePort;
    protected static Debug debug = Debug.getInstance((String)"amConsole");
    protected static boolean isConsoleRemote = Boolean.valueOf(SystemProperties.get((String)"com.iplanet.am.console.remote"));
    private static boolean setRequestEncoding = false;
    static /* synthetic */ Class class$com$iplanet$am$console$base$AMLoginViewBean;
    static /* synthetic */ Class class$com$iplanet$am$console$base$AMInvalidURLViewBean;
    static /* synthetic */ Class class$com$iplanet$am$console$base$AMUncaughtExceptionViewBean;

    protected void onBeforeRequest(RequestContext requestContext) throws ServletException {
        String string;
        HttpServletRequest httpServletRequest = requestContext.getRequest();
        String string2 = httpServletRequest.getHeader("Host");
        if (string2 != null && (string = this.validateHost(string2)) != null) {
            try {
                requestContext.getResponse().sendRedirect(this.replaceHostNameInUrl(httpServletRequest, string));
            }
            catch (IOException iOException) {
                debug.error("ConsoleServletBase.onBeforeRequest, failed to redirect to fully qualified host");
            }
            throw new CompleteRequestException();
        }
        this.validateSSOToken(requestContext);
        this.forwardToNewConsoleIfRealmMode(requestContext);
    }

    private void forwardToNewConsoleIfRealmMode(RequestContext requestContext) {
        if (ServiceManager.isRealmEnabled()) {
            String string = isConsoleRemote ? serverURL + serverURI : serverURI;
            string = string + URL_ADMIN_FRAME;
            try {
                requestContext.getResponse().sendRedirect(string);
            }
            catch (IOException iOException) {
                debug.error("ConsoleServletBase.forwardToNewConsoleIfRealmMode", (Throwable)iOException);
            }
            throw new CompleteRequestException();
        }
    }

    private String replaceHostNameInUrl(HttpServletRequest httpServletRequest, String string) {
        StringBuffer stringBuffer = new StringBuffer(1024);
        String string2 = RequestUtils.getRedirectProtocol((String)httpServletRequest.getScheme(), (String)string);
        stringBuffer.append(string2).append("://").append(string).append(httpServletRequest.getRequestURI());
        String string3 = httpServletRequest.getQueryString();
        if (string3 != null) {
            stringBuffer.append("?").append(string3);
        }
        return stringBuffer.toString();
    }

    private void validateSSOToken(RequestContext requestContext) throws ServletException {
        try {
            HttpServletRequest httpServletRequest = requestContext.getRequest();
            SSOToken sSOToken = this.checkAuthentication(httpServletRequest);
            if (setRequestEncoding) {
                String string = sSOToken.getProperty("CharSet");
                try {
                    String string2 = BrowserEncoding.mapHttp2JavaCharset((String)string);
                    if (debug.messageEnabled()) {
                        debug.message("request charset = " + string);
                    }
                    httpServletRequest.setCharacterEncoding(string2);
                }
                catch (UnsupportedEncodingException unsupportedEncodingException) {
                    debug.error("unsupported encoding", (Throwable)unsupportedEncodingException);
                }
            }
        }
        catch (SSOException sSOException) {
            this.browserRedirect(requestContext, this.formGotoUrl(requestContext.getRequest()));
            throw new CompleteRequestException();
        }
    }

    private void browserRedirect(RequestContext requestContext, String string) {
        ViewBeanManager viewBeanManager = requestContext.getViewBeanManager();
        AMLoginViewBean aMLoginViewBean = (AMLoginViewBean)viewBeanManager.getViewBean(class$com$iplanet$am$console$base$AMLoginViewBean == null ? (class$com$iplanet$am$console$base$AMLoginViewBean = ConsoleServletBase.class$("com.iplanet.am.console.base.AMLoginViewBean")) : class$com$iplanet$am$console$base$AMLoginViewBean);
        if (debug.messageEnabled()) {
            debug.message("ConsoleServletBase.browserRedirect: redirecting unauthenticated user to " + string);
        }
        aMLoginViewBean.setLoginURL(string);
        aMLoginViewBean.forwardTo(requestContext);
    }

    protected void onSessionTimeout(RequestContext requestContext) throws ServletException {
    }

    protected void onRequestHandlerNotFound(RequestContext requestContext, String string) throws ServletException {
        ViewBeanManager viewBeanManager = requestContext.getViewBeanManager();
        ViewBean viewBean = viewBeanManager.getViewBean(class$com$iplanet$am$console$base$AMInvalidURLViewBean == null ? (class$com$iplanet$am$console$base$AMInvalidURLViewBean = ConsoleServletBase.class$("com.iplanet.am.console.base.AMInvalidURLViewBean")) : class$com$iplanet$am$console$base$AMInvalidURLViewBean);
        viewBean.forwardTo(requestContext);
        throw new CompleteRequestException();
    }

    protected void onRequestHandlerNotSpecified(RequestContext requestContext) throws ServletException {
        ViewBeanManager viewBeanManager = requestContext.getViewBeanManager();
        ViewBean viewBean = viewBeanManager.getViewBean(class$com$iplanet$am$console$base$AMInvalidURLViewBean == null ? (class$com$iplanet$am$console$base$AMInvalidURLViewBean = ConsoleServletBase.class$("com.iplanet.am.console.base.AMInvalidURLViewBean")) : class$com$iplanet$am$console$base$AMInvalidURLViewBean);
        viewBean.forwardTo(requestContext);
        throw new CompleteRequestException();
    }

    protected void onUncaughtException(RequestContext requestContext, Exception exception) throws ServletException, IOException {
        debug.error("ConsoleServletBase.onUncaughtException", (Throwable)exception);
        ViewBeanManager viewBeanManager = requestContext.getViewBeanManager();
        AMUncaughtExceptionViewBean aMUncaughtExceptionViewBean = (AMUncaughtExceptionViewBean)viewBeanManager.getViewBean(class$com$iplanet$am$console$base$AMUncaughtExceptionViewBean == null ? (class$com$iplanet$am$console$base$AMUncaughtExceptionViewBean = ConsoleServletBase.class$("com.iplanet.am.console.base.AMUncaughtExceptionViewBean")) : class$com$iplanet$am$console$base$AMUncaughtExceptionViewBean);
        aMUncaughtExceptionViewBean.forwardTo(requestContext);
        throw new CompleteRequestException();
    }

    private SSOToken checkAuthentication(HttpServletRequest httpServletRequest) throws SSOException {
        SSOTokenManager sSOTokenManager = SSOTokenManager.getInstance();
        SSOToken sSOToken = sSOTokenManager.createSSOToken(httpServletRequest);
        sSOTokenManager.validateToken(sSOToken);
        return sSOToken;
    }

    private String formGotoUrl(HttpServletRequest httpServletRequest) {
        StringBuffer stringBuffer = new StringBuffer(2048);
        String string = SystemProperties.get((String)"com.sun.identity.loginurl");
        if (string != null && string.trim().length() > 0) {
            stringBuffer.append(string);
        } else if (isConsoleRemote) {
            stringBuffer.append(serverURL).append(serverURI).append("/UI/Login");
        } else {
            stringBuffer.append(serverURI).append("/UI/Login");
        }
        stringBuffer.append(LOGIN_PARAM);
        if (isConsoleRemote) {
            stringBuffer.append(consoleURL);
        }
        stringBuffer.append(consoleURI).append(URL_ADMIN_FRAME);
        String string2 = httpServletRequest.getParameter(PARAM_REDIRECT);
        if (string2 != null && string2.equals("1")) {
            String string3 = this.getQueryParameters(httpServletRequest);
            stringBuffer.append(string3);
            if (!this.containOrgDomainParam(string3)) {
                String string4;
                String string5 = httpServletRequest.getHeader("Host");
                if (string5 == null) {
                    debug.message("Host header is null:");
                    string5 = consoleHost;
                }
                if ((string4 = this.getOrganizationQueryParam(httpServletRequest, string5)) != null) {
                    stringBuffer.append(string4);
                }
            }
        }
        return stringBuffer.toString();
    }

    private String validateHost(String string) {
        String string2 = null;
        String string3 = null;
        String string4 = null;
        int n = string.indexOf(58);
        if (n != -1) {
            string4 = string.substring(n + 1);
            string3 = string.substring(0, n);
        } else {
            string3 = string;
        }
        if (!string3.equalsIgnoreCase(consoleHost) && (string3 = fqdnUtils.getFullyQualifiedHostName(string3)) != null) {
            if (isConsoleRemote && string3.equals(serverHost)) {
                string3 = consoleHost;
            }
            string2 = string4 != null ? string3 + ":" + string4 : string3;
        }
        return string2;
    }

    private String getQueryParameters(HttpServletRequest httpServletRequest) {
        String string = httpServletRequest.getQueryString();
        if (string != null && string.length() > 0) {
            int n = string.indexOf(PARAM_REDIRECT);
            if (n != -1) {
                String string2 = string.substring(0, n);
                if (string.length() > n + PARAM_REDIRECT.length() + 3) {
                    string2 = string2 + string.substring(n + PARAM_REDIRECT.length() + 3);
                }
                string = string2;
            }
            if ((n = string.indexOf(GX_CHARSET)) != -1) {
                int n2 = string.indexOf("&", n + 1);
                String string3 = string.substring(0, n);
                if (n2 != -1) {
                    String string4 = string.substring(n2);
                    string = string3 + string4;
                } else {
                    string = string3;
                }
            }
            return "&" + string;
        }
        return string != null ? string : "";
    }

    private boolean containOrgDomainParam(String string) {
        boolean bl = false;
        if (string.length() > 0) {
            bl = string.indexOf(AUTH_ORG_PARAM) != -1 || string.indexOf(AUTH_DOMAIN_PARAM) != -1;
        }
        return bl;
    }

    private String getOrganizationQueryParam(HttpServletRequest httpServletRequest, String string) {
        String string2 = null;
        AMStoreConnection aMStoreConnection = (AMStoreConnection)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                try {
                    return AMAdminUtils.getStoreConnAsAdmin();
                }
                catch (SecurityException securityException) {
                    debug.error("ConsoleServletBase.getOrganizationQueryParam", (Throwable)securityException);
                    return null;
                }
            }
        });
        if (aMStoreConnection != null) {
            int n = string.indexOf(58);
            if (n != -1) {
                string = string.substring(0, n);
            }
            try {
                String string3 = aMStoreConnection.getOrganizationDN(string, null);
                if (setRequestEncoding) {
                    ISLocaleContext iSLocaleContext = new ISLocaleContext();
                    iSLocaleContext.setLocale(httpServletRequest);
                    iSLocaleContext.setOrgLocale(string3);
                    String string4 = iSLocaleContext.getJavaCharset();
                    string2 = AUTH_ORG_PARAM + Locale.URLEncodeField((String)string3, (String)string4);
                } else if (string3 != null) {
                    string2 = AUTH_ORG_PARAM + Locale.URLEncodeField((String)string3, (String)"UTF-8") + GX_CHARSET_PARAM + "UTF-8";
                }
            }
            catch (AMException aMException) {
                debug.error("ConsoleServletBase.getOrganizationQueryParam", (Throwable)aMException);
            }
            catch (SSOException sSOException) {
                debug.error("ConsoleServletBase.getOrganizationQueryParam", (Throwable)sSOException);
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                debug.error("ConsoleServletBase.getOrganizationQueryParam", (Throwable)unsupportedEncodingException);
            }
        }
        return string2;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static {
        String string = SystemProperties.get((String)"com.sun.identity.webcontainer");
        if (string != null) {
            boolean bl = setRequestEncoding = string.indexOf("BEA") == 0 || string.indexOf("IBM") == 0 || string.indexOf("IAS8.1") == 0;
        }
        if (debug.messageEnabled()) {
            debug.message("Webcontainer=[" + string + "]setRequestEncoding=" + setRequestEncoding);
        }
    }
}

