/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.am.console.auth.model;

import com.iplanet.am.console.auth.model.ACServiceInstanceListModel;
import com.iplanet.am.console.base.model.AMConsoleException;
import com.iplanet.am.console.base.model.AMModelBase;
import com.iplanet.sso.SSOException;
import com.iplanet.sso.SSOToken;
import com.sun.identity.authentication.config.AMAuthConfigUtils;
import com.sun.identity.authentication.config.AMConfigurationException;
import com.sun.identity.sm.SMSException;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;

public class ACServiceInstanceListModelImpl
extends AMModelBase
implements ACServiceInstanceListModel {
    private String location = null;

    public ACServiceInstanceListModelImpl(HttpServletRequest httpServletRequest, Map map) {
        super(httpServletRequest, "amAdminModuleMsgs", map);
    }

    public String getServiceInstanceListTitle() {
        return this.getLocalizedString("serviceInstanceListTitle.label");
    }

    public String getServiceInstanceLabel() {
        return this.getLocalizedString("serviceInstance.label");
    }

    public String getNewLabel() {
        return this.getLocalizedString("new.button");
    }

    public String getDeleteSelectedLabel() {
        return this.getLocalizedString("deleteSelected.button");
    }

    public String getErrorTitle() {
        return this.getLocalizedString("error.title");
    }

    public Set getServiceInstanceList(String string) {
        Set set = null;
        String string2 = string;
        try {
            set = AMAuthConfigUtils.getAllNamedConfig((String)string2, (SSOToken)this.ssoToken);
        }
        catch (SSOException sSOException) {
            AMModelBase.debug.warning("ACServiceInstanceListModelImpl.getServiceInstanceList:Can't get Named Config - invalid sso token", (Throwable)sSOException);
        }
        catch (SMSException sMSException) {
            AMModelBase.debug.warning("ACServiceInstanceListModelImpl.getServiceInstanceList: couldn't get named config " + string2, (Throwable)sMSException);
        }
        return set == null ? Collections.EMPTY_SET : set;
    }

    public void deleteServiceInstance(String string) throws AMConsoleException {
        try {
            AMAuthConfigUtils.removeNamedConfig((String)string, (String)this.location, (SSOToken)this.ssoToken);
            this.writeFormatLog("authConfigDeleted.message", string, this.location);
        }
        catch (SSOException sSOException) {
            AMModelBase.debug.error("ACServiceInstanceListModelImpl.deleteServiceInstance", (Throwable)sSOException);
            throw new AMConsoleException(this.getErrorString((Exception)((Object)sSOException)));
        }
        catch (SMSException sMSException) {
            AMModelBase.debug.error("ACServiceInstanceListModelImpl.deleteServiceInstance", (Throwable)sMSException);
            throw new AMConsoleException(this.getErrorString((Exception)((Object)sMSException)));
        }
        catch (AMConfigurationException aMConfigurationException) {
            AMModelBase.debug.error("ACServiceInstanceListModelImpl.deleteServiceInstance", (Throwable)aMConfigurationException);
            throw new AMConsoleException(this.getErrorString((Exception)((Object)aMConfigurationException)));
        }
    }

    public boolean hasInstances(String string) {
        Set set = this.getServiceInstanceList(string);
        return !set.isEmpty();
    }

    public String getNoEntriesMsg() {
        return this.getLocalizedString("noEntries.message");
    }

    public void setLoc(String string) {
        this.location = string;
    }

    public String getLoc() {
        return this.location;
    }

    public String getNoInstanceSelectedForDeletionTitle() {
        return this.getLocalizedString("noInstanceSelectedForDeletion.title");
    }

    public String getNoInstanceSelectedForDeletionMessage() {
        return this.getLocalizedString("noInstanceSelectedForDeletion.message");
    }

    public String getHelpAnchorTag() {
        String string = this.getLocalizedString("authServiceInstanceList.help");
        if (string.equals("authServiceInstanceList.help")) {
            string = "contents.html";
        }
        return this.getHelpURL(string);
    }
}

