/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.am.console.auth.model;

import com.iplanet.am.console.auth.model.ACModelBaseImpl;
import com.iplanet.am.console.auth.model.ACModuleListModel;
import com.iplanet.am.console.base.model.AMConsoleException;
import com.iplanet.am.console.base.model.AMModelBase;
import com.iplanet.am.sdk.AMException;
import com.iplanet.am.sdk.AMRole;
import com.iplanet.am.sdk.AMTemplate;
import com.iplanet.am.sdk.AMUser;
import com.iplanet.sso.SSOException;
import com.sun.identity.authentication.config.AMConfigurationException;
import com.sun.identity.authentication.config.AuthConfigurationEntry;
import com.sun.identity.sm.AttributeSchema;
import com.sun.identity.sm.SMSException;
import com.sun.identity.sm.SchemaType;
import com.sun.identity.sm.ServiceConfig;
import com.sun.identity.sm.ServiceConfigManager;
import com.sun.identity.sm.ServiceSchema;
import com.sun.identity.sm.ServiceSchemaManager;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import javax.servlet.http.HttpServletRequest;
import netscape.ldap.LDAPDN;

public class ACModuleListModelImpl
extends ACModelBaseImpl
implements ACModuleListModel {
    public ACModuleListModelImpl(HttpServletRequest httpServletRequest, Map map) {
        super(httpServletRequest, map);
    }

    public String getReorderModulesTitle() {
        return this.getLocalizedString("reorderModulesTitle.label");
    }

    public String getTitle() {
        return this.getLocalizedString("authConfigPopup.title");
    }

    public String getSelectLabel() {
        return this.getLocalizedString("select.label");
    }

    public String getModuleLabel() {
        return this.getLocalizedString("module.label");
    }

    public String getFlagLabel() {
        return this.getLocalizedString("flag.label");
    }

    public String getOptionLabel() {
        return this.getLocalizedString("option.label");
    }

    public String getReorderButtonLabel() {
        return this.getLocalizedString("reorder.button");
    }

    public String getDeleteSelectedLabel() {
        return this.getLocalizedString("deleteSelected.button");
    }

    public String getModulesLabel() {
        return this.getLocalizedString("modules.label");
    }

    public String getUpButtonLabel() {
        return this.getLocalizedString("up.button");
    }

    public String getDownButtonLabel() {
        return this.getLocalizedString("down.button");
    }

    public String loadUserModules(String string, String string2) throws AMConsoleException {
        String string3 = null;
        try {
            AMUser aMUser = this.dpStoreConn.getUser(string);
            if (aMUser != null) {
                Set set = aMUser.getAttribute(string2);
                string3 = this.getValue(set);
            }
        }
        catch (SSOException sSOException) {
            if (AMModelBase.debug.warningEnabled()) {
                AMModelBase.debug.warning("ACModuleListModelImpl.loadUserModules: cannot load user module from user object", (Throwable)sSOException);
            }
            throw new AMConsoleException(this.getErrorString((Exception)((Object)sSOException)));
        }
        catch (AMException aMException) {
            if (AMModelBase.debug.warningEnabled()) {
                AMModelBase.debug.warning("ACModuleListModelImpl.loadUserModules: cannot load user module from user object", (Throwable)aMException);
            }
            throw new AMConsoleException(this.getErrorString((Exception)((Object)aMException)));
        }
        return string3;
    }

    public String loadRoleModules(String string, String string2, String string3) throws AMConsoleException {
        String string4 = null;
        try {
            AMTemplate aMTemplate;
            AMRole aMRole = this.dpStoreConn.getRole(string);
            if (aMRole != null && (aMTemplate = aMRole.getTemplate(string2, 301)) != null) {
                Set set = aMTemplate.getAttribute(string3);
                string4 = this.getValue(set);
            }
        }
        catch (SSOException sSOException) {
            if (AMModelBase.debug.warningEnabled()) {
                AMModelBase.debug.warning("ACModuleListModelImpl.loadRoleModules: cannot get authentication configuration information from role", (Throwable)sSOException);
            }
            throw new AMConsoleException(this.getErrorString((Exception)((Object)sSOException)));
        }
        catch (AMException aMException) {
            if (AMModelBase.debug.warningEnabled()) {
                AMModelBase.debug.warning("ACModuleListModelImpl.loadRoleModules: cannot get authentication configuration information from role", (Throwable)aMException);
            }
            throw new AMConsoleException(this.getErrorString((Exception)((Object)aMException)));
        }
        return string4;
    }

    public String loadOrgSvcModules(String string, String string2, String string3) throws AMConsoleException {
        String string4 = null;
        try {
            Map map;
            ServiceConfigManager serviceConfigManager = new ServiceConfigManager(this.ssoToken, string, "1.0");
            ServiceConfig serviceConfig = serviceConfigManager.getOrganizationConfig(string2, null);
            if (serviceConfig != null && (map = serviceConfig.getAttributes()) != null) {
                Set set = (Set)map.get(string3);
                string4 = this.getValue(set);
            }
        }
        catch (SSOException sSOException) {
            if (AMModelBase.debug.warningEnabled()) {
                AMModelBase.debug.warning("ACModuleListModelImpl.loadOrgSvcModules: cannot get registered service modules", (Throwable)sSOException);
            }
            throw new AMConsoleException(this.getErrorString((Exception)((Object)sSOException)));
        }
        catch (SMSException sMSException) {
            if (AMModelBase.debug.warningEnabled()) {
                AMModelBase.debug.warning("ACModuleListModelImpl.loadOrgSvcModules: cannot get registered service modules", (Throwable)sMSException);
            }
            throw new AMConsoleException(this.getErrorString((Exception)((Object)sMSException)));
        }
        return string4;
    }

    public String loadOrgSubSvcModules(String string, String string2, String string3, String string4) throws AMConsoleException {
        String string5 = null;
        try {
            Map map;
            ServiceConfig serviceConfig;
            if (string2 == null) {
                if (AMModelBase.debug.warningEnabled()) {
                    AMModelBase.debug.warning("ACModuleListModelImpl.loadOrgSvcModules:  Failed to get authconfig for: " + string2);
                }
                throw new AMConsoleException(this.getLocalizedString("invalidServiceInstanceName.message"));
            }
            ServiceConfigManager serviceConfigManager = new ServiceConfigManager(this.ssoToken, string, "1.0");
            ServiceConfig serviceConfig2 = serviceConfigManager.getOrganizationConfig(string3, null);
            if (serviceConfig2 == null) {
                throw new AMConsoleException(this.getLocalizedString("serviceNotRegistered.message"));
            }
            ServiceConfig serviceConfig3 = serviceConfig2.getSubConfig("Configurations");
            if (serviceConfig3 != null && (serviceConfig = serviceConfig3.getSubConfig(string2)) != null && (map = serviceConfig.getAttributes()) != null) {
                Set set = (Set)map.get(string4);
                string5 = this.getValue(set);
            }
        }
        catch (SSOException sSOException) {
            if (AMModelBase.debug.warningEnabled()) {
                AMModelBase.debug.warning("ACModuleListModelImpl.loadOrgSubSvcModules: unable to get registered sub modules", (Throwable)sSOException);
            }
            throw new AMConsoleException(this.getErrorString((Exception)((Object)sSOException)));
        }
        catch (SMSException sMSException) {
            if (AMModelBase.debug.warningEnabled()) {
                AMModelBase.debug.warning("ACModuleListModelImpl.loadOrgSubSvcModules: unable to get registered sub modules", (Throwable)sMSException);
            }
            throw new AMConsoleException(this.getErrorString((Exception)((Object)sMSException)));
        }
        return string5;
    }

    public String loadSubSvcModules(String string, int n, String string2) throws AMConsoleException {
        Set set;
        block10: {
            set = new HashSet();
            try {
                ServiceSchemaManager serviceSchemaManager = this.getServiceSchemaManager(string);
                if (n == 2) {
                    AttributeSchema attributeSchema;
                    ServiceSchema serviceSchema = serviceSchemaManager.getSchema(SchemaType.DYNAMIC);
                    if (serviceSchema != null && (attributeSchema = serviceSchema.getAttributeSchema(string2)) != null) {
                        set = attributeSchema.getDefaultValues();
                    }
                    break block10;
                }
                if (n == 1) {
                    AttributeSchema attributeSchema;
                    ServiceSchema serviceSchema;
                    ServiceSchema serviceSchema2;
                    ServiceSchema serviceSchema3 = serviceSchemaManager.getSchema(SchemaType.ORGANIZATION);
                    if (serviceSchema3 != null && (serviceSchema2 = serviceSchema3.getSubSchema("Configurations")) != null && (serviceSchema = serviceSchema2.getSubSchema("NamedConfiguration")) != null && (attributeSchema = serviceSchema.getAttributeSchema(string2)) != null) {
                        set = attributeSchema.getDefaultValues();
                    }
                    break block10;
                }
                if (AMModelBase.debug.warningEnabled()) {
                    AMModelBase.debug.warning("ACModuleListModelImpl.loadSubSvcModules: Invalid Service Type " + n);
                }
                throw new AMConsoleException(this.getLocalizedString("invalidServiceType.label"));
            }
            catch (SSOException sSOException) {
                if (AMModelBase.debug.warningEnabled()) {
                    AMModelBase.debug.warning("ACModuleListModelImpl.loadSubSvcModules: unable to get list of service modules under LDAP", (Throwable)sSOException);
                }
                throw new AMConsoleException(this.getErrorString((Exception)((Object)sSOException)));
            }
            catch (SMSException sMSException) {
                if (AMModelBase.debug.warningEnabled()) {
                    AMModelBase.debug.warning("ACModuleListModelImpl.loadSubSvcModules: unable to get list of service modules under LDAP", (Throwable)sMSException);
                }
                throw new AMConsoleException(this.getErrorString((Exception)((Object)sMSException)));
            }
        }
        return this.getValue(set);
    }

    public String loadSvcModules(String string, int n, String string2) throws AMConsoleException {
        Set set;
        block8: {
            set = new HashSet();
            try {
                ServiceSchemaManager serviceSchemaManager = this.getServiceSchemaManager(string);
                if (n == 1) {
                    AttributeSchema attributeSchema;
                    ServiceSchema serviceSchema = serviceSchemaManager.getSchema(SchemaType.ORGANIZATION);
                    if (serviceSchema != null && (attributeSchema = serviceSchema.getAttributeSchema(string2)) != null) {
                        set = attributeSchema.getDefaultValues();
                    }
                    break block8;
                }
                if (AMModelBase.debug.warningEnabled()) {
                    AMModelBase.debug.warning("ACModuleListModelImpl.loadSvcModules: Invalid Service Type " + n);
                }
                throw new AMConsoleException(this.getLocalizedString("invalidServiceType.label"));
            }
            catch (SSOException sSOException) {
                if (AMModelBase.debug.warningEnabled()) {
                    AMModelBase.debug.warning("ACModuleListModelImpl.loadSvcModules: unable to get list of service modules under LDAP", (Throwable)sSOException);
                }
            }
            catch (SMSException sMSException) {
                if (AMModelBase.debug.warningEnabled()) {
                    AMModelBase.debug.warning("ACModuleListModelImpl.loadSvcModules: unable to get list of service modules under LDAP", (Throwable)sMSException);
                }
                throw new AMConsoleException(this.getErrorString((Exception)((Object)sMSException)));
            }
        }
        return this.getValue(set);
    }

    public void saveUserModules(String string, String string2, String string3, String string4) throws AMConsoleException {
        try {
            AMUser aMUser = this.dpStoreConn.getUser(string);
            HashSet<String> hashSet = new HashSet<String>();
            hashSet.add(string2);
            HashMap<String, HashSet<String>> hashMap = new HashMap<String, HashSet<String>>();
            hashMap.put(string3, hashSet);
            if (aMUser != null) {
                aMUser.setAttributes(hashMap);
                aMUser.store();
            }
            this.writeFormatLog("authConfigModuleListChanged.message", string4, string);
        }
        catch (SSOException sSOException) {
            if (AMModelBase.debug.warningEnabled()) {
                AMModelBase.debug.warning("ACModuleListModelImpl.saveUserModules: unable to save user based authentication configuration", (Throwable)sSOException);
            }
            throw new AMConsoleException(this.getErrorString((Exception)((Object)sSOException)));
        }
        catch (AMException aMException) {
            if (AMModelBase.debug.warningEnabled()) {
                AMModelBase.debug.warning("ACModuleListModelImpl.saveUserModules: unable to save user based authentication configuration", (Throwable)aMException);
            }
            throw new AMConsoleException(this.getErrorString((Exception)((Object)aMException)));
        }
    }

    public void saveRoleModules(String string, String string2, String string3, String string4) throws AMConsoleException {
        try {
            AMTemplate aMTemplate = null;
            AMRole aMRole = this.dpStoreConn.getRole(string);
            if (aMRole != null) {
                aMTemplate = aMRole.getTemplate(string2, 301);
            }
            HashSet<String> hashSet = new HashSet<String>();
            hashSet.add(string3);
            HashMap<String, HashSet<String>> hashMap = new HashMap<String, HashSet<String>>();
            hashMap.put(string4, hashSet);
            if (aMTemplate != null) {
                aMTemplate.setAttributes(hashMap);
                aMTemplate.store();
            }
            this.writeFormatLog("authConfigModuleListChanged.message", string2, string);
        }
        catch (SSOException sSOException) {
            if (AMModelBase.debug.warningEnabled()) {
                AMModelBase.debug.warning("ACModuleListModelImpl.saveRoleModules: unable to save role based authentication configuration", (Throwable)sSOException);
            }
            throw new AMConsoleException(this.getErrorString((Exception)((Object)sSOException)));
        }
        catch (AMException aMException) {
            if (AMModelBase.debug.warningEnabled()) {
                AMModelBase.debug.warning("ACModuleListModelImpl.saveRoleModules: unable to save role based authentication configuration", (Throwable)aMException);
            }
            throw new AMConsoleException(this.getErrorString((Exception)((Object)aMException)));
        }
    }

    public void saveOrgSvcModules(String string, String string2, String string3, String string4) throws AMConsoleException {
        try {
            ServiceConfigManager serviceConfigManager = new ServiceConfigManager(this.ssoToken, string, "1.0");
            HashSet<String> hashSet = new HashSet<String>();
            hashSet.add(string3);
            ServiceConfig serviceConfig = serviceConfigManager.getOrganizationConfig(string2, null);
            HashMap<String, HashSet<String>> hashMap = new HashMap<String, HashSet<String>>(1);
            hashMap.put(string4, hashSet);
            serviceConfig.setAttributes(hashMap);
            this.writeFormatLog("authConfigModuleListChanged.message", string, string2);
        }
        catch (SSOException sSOException) {
            if (AMModelBase.debug.warningEnabled()) {
                AMModelBase.debug.warning("ACModuleListModelImpl.saveOrgSvcModules: unable to save organizational based authentication configuration", (Throwable)sSOException);
            }
            throw new AMConsoleException(this.getErrorString((Exception)((Object)sSOException)));
        }
        catch (SMSException sMSException) {
            if (AMModelBase.debug.warningEnabled()) {
                AMModelBase.debug.warning("ACModuleListModelImpl.saveOrgSvcModules: unable to save organizational based authentication configuration", (Throwable)sMSException);
            }
            throw new AMConsoleException(this.getErrorString((Exception)((Object)sMSException)));
        }
    }

    public void saveOrgSubSvcModules(String string, String string2, String string3, String string4, String string5) throws AMConsoleException {
        try {
            HashMap hashMap;
            ServiceConfig serviceConfig;
            ServiceConfig serviceConfig2;
            ServiceConfigManager serviceConfigManager = new ServiceConfigManager(this.ssoToken, string, "1.0");
            HashSet<String> hashSet = new HashSet<String>();
            hashSet.add(string4);
            ServiceConfig serviceConfig3 = serviceConfigManager.getOrganizationConfig(string2, null);
            if (serviceConfig3 == null) {
                serviceConfig3 = serviceConfigManager.createOrganizationConfig(string2, null);
            }
            if ((serviceConfig2 = serviceConfig3.getSubConfig("Configurations")) == null) {
                serviceConfig3.addSubConfig("Configurations", null, 0, null);
                serviceConfig2 = serviceConfig3.getSubConfig("Configurations");
            }
            if ((serviceConfig = serviceConfig2.getSubConfig(string3)) == null) {
                serviceConfig2.addSubConfig(string3, "NamedConfiguration", 0, null);
                serviceConfig = serviceConfig2.getSubConfig(string3);
            }
            if ((hashMap = serviceConfig.getAttributes()) == null) {
                hashMap = new HashMap(1);
            }
            hashMap.put(string5, hashSet);
            serviceConfig.setAttributes(hashMap);
            this.writeFormatLog("authConfigModuleListChanged.message", string + "." + string3, string2);
        }
        catch (SSOException sSOException) {
            if (AMModelBase.debug.warningEnabled()) {
                AMModelBase.debug.warning("ACModuleListModelImpl.saveOrgSubSvcModules: unable to save organizational based sub authentication configuration", (Throwable)sSOException);
            }
            throw new AMConsoleException(this.getErrorString((Exception)((Object)sSOException)));
        }
        catch (SMSException sMSException) {
            if (AMModelBase.debug.warningEnabled()) {
                AMModelBase.debug.warning("ACModuleListModelImpl.saveOrgSubSvcModules: unable to save organizational based sub authentication configuration", (Throwable)sMSException);
            }
            throw new AMConsoleException(this.getErrorString((Exception)((Object)sMSException)));
        }
    }

    public void saveSubSvcModules(String string, int n, String string2, String string3) throws AMConsoleException {
        HashSet<String> hashSet = new HashSet<String>();
        hashSet.add(string2);
        try {
            ServiceSchemaManager serviceSchemaManager = this.getServiceSchemaManager(string);
            if (n == 2) {
                ServiceSchema serviceSchema = serviceSchemaManager.getSchema(SchemaType.DYNAMIC);
                if (serviceSchema != null) {
                    serviceSchema.setAttributeDefaults(string3, hashSet);
                }
            } else if (n == 1) {
                ServiceSchema serviceSchema;
                ServiceSchema serviceSchema2;
                ServiceSchema serviceSchema3 = serviceSchemaManager.getSchema(SchemaType.ORGANIZATION);
                if (serviceSchema3 != null && (serviceSchema2 = serviceSchema3.getSubSchema("Configurations")) != null && (serviceSchema = serviceSchema2.getSubSchema("NamedConfiguration")) != null) {
                    serviceSchema.setAttributeDefaults(string3, hashSet);
                }
            } else {
                if (AMModelBase.debug.warningEnabled()) {
                    AMModelBase.debug.warning("ACModuleListModelImpl.saveSubSvcModules: Invalid Service Type " + n);
                }
                throw new AMConsoleException(this.getLocalizedString("invalidServiceType.label"));
            }
            this.writeFormatLog("authConfigModuleListChanged.message", string, this.locationDN);
        }
        catch (SSOException sSOException) {
            if (AMModelBase.debug.warningEnabled()) {
                AMModelBase.debug.warning("ACModuleListModelImpl.saveSubSvcModules: unable to save global based sub authentication configuration", (Throwable)sSOException);
            }
            throw new AMConsoleException(this.getErrorString((Exception)((Object)sSOException)));
        }
        catch (SMSException sMSException) {
            if (AMModelBase.debug.warningEnabled()) {
                AMModelBase.debug.warning("ACModuleListModelImpl.saveSubSvcModules: unable to save global based sub authentication configuration", (Throwable)sMSException);
            }
            throw new AMConsoleException(this.getErrorString((Exception)((Object)sMSException)));
        }
    }

    public void saveSvcModules(String string, int n, String string2, String string3) throws AMConsoleException {
        HashSet<String> hashSet = new HashSet<String>();
        hashSet.add(string2);
        try {
            ServiceSchemaManager serviceSchemaManager = this.getServiceSchemaManager(string);
            if (n == 1) {
                ServiceSchema serviceSchema = serviceSchemaManager.getSchema(SchemaType.ORGANIZATION);
                if (serviceSchema != null) {
                    serviceSchema.setAttributeDefaults(string3, hashSet);
                }
            } else {
                if (AMModelBase.debug.warningEnabled()) {
                    AMModelBase.debug.warning("ACModuleListModelImpl.saveSvcModules: Invalid Service Type " + n);
                }
                throw new AMConsoleException(this.getLocalizedString("invalidServiceType.label"));
            }
            this.writeFormatLog("authConfigModuleListChanged.message", string, this.locationDN);
        }
        catch (SSOException sSOException) {
            if (AMModelBase.debug.warningEnabled()) {
                AMModelBase.debug.warning("ACModuleListModelImpl.saveSvcModules: unable to save global based authentication configuration", (Throwable)sSOException);
            }
            throw new AMConsoleException(this.getErrorString((Exception)((Object)sSOException)));
        }
        catch (SMSException sMSException) {
            if (AMModelBase.debug.warningEnabled()) {
                AMModelBase.debug.warning("ACModuleListModelImpl.saveSvcModules: unable to save global based authentication configuration", (Throwable)sMSException);
            }
            throw new AMConsoleException(this.getErrorString((Exception)((Object)sMSException)));
        }
    }

    public List getModuleList() {
        return this.getAttrs().getModuleList();
    }

    public void setModuleList(List list) {
        this.getAttrs().setModuleList(list);
    }

    public String[] getModuleOptions() {
        int n = 0;
        ArrayList arrayList = (ArrayList)this.getModuleList();
        if (arrayList != null) {
            n = arrayList.size();
        }
        AuthConfigurationEntry[] authConfigurationEntryArray = new AuthConfigurationEntry[n];
        arrayList.toArray(authConfigurationEntryArray);
        String[] stringArray = new String[n];
        int n2 = 0;
        while (n2 < n) {
            stringArray[n2] = authConfigurationEntryArray[n2].toString();
            ++n2;
        }
        return stringArray;
    }

    public String[] getModuleOptionLabels() {
        List list = this.getAttrs().getModuleList();
        int n = 0;
        String[] stringArray = new String[list.size()];
        if (list != null && !list.isEmpty()) {
            Iterator iterator = list.iterator();
            while (iterator.hasNext()) {
                AuthConfigurationEntry authConfigurationEntry = (AuthConfigurationEntry)iterator.next();
                StringBuffer stringBuffer = new StringBuffer(list.size());
                stringBuffer.append(authConfigurationEntry.getLoginModuleName());
                stringBuffer.append(", ");
                stringBuffer.append(this.getFlagLabel(authConfigurationEntry.getControlFlag()));
                String string = authConfigurationEntry.getOptions();
                if (string != null && string.length() > 0) {
                    stringBuffer.append(", ");
                    stringBuffer.append(string);
                }
                stringArray[n] = stringBuffer.toString();
                ++n;
            }
        }
        return stringArray;
    }

    public void deleteModule(int n) {
        ArrayList arrayList = (ArrayList)this.getModuleList();
        arrayList.remove(n);
        this.setModuleList(arrayList);
    }

    public boolean hasModules() {
        List list = this.getModuleList();
        return list != null && !list.isEmpty();
    }

    public AuthConfigurationEntry toEntry(String string) {
        String string2 = null;
        String string3 = null;
        String string4 = null;
        AuthConfigurationEntry authConfigurationEntry = null;
        StringTokenizer stringTokenizer = new StringTokenizer(string, " ");
        if (stringTokenizer.countTokens() >= 2) {
            if (stringTokenizer.hasMoreTokens()) {
                string2 = stringTokenizer.nextToken();
            }
            if (stringTokenizer.hasMoreTokens()) {
                string3 = stringTokenizer.nextToken();
            }
            int n = stringTokenizer.countTokens();
            StringBuffer stringBuffer = new StringBuffer();
            int n2 = 0;
            while (n2 < n - 1) {
                stringBuffer.append(stringTokenizer.nextToken());
                stringBuffer.append(" ");
                ++n2;
            }
            if (stringTokenizer.hasMoreTokens()) {
                stringBuffer.append(stringTokenizer.nextToken());
            }
            string4 = stringBuffer.toString();
        }
        try {
            authConfigurationEntry = new AuthConfigurationEntry(string2, string3, string4);
        }
        catch (AMConfigurationException aMConfigurationException) {
            AMModelBase.debug.error("ACModuleListModelImpl.toEntry: Failed to convert module entries to AuthConfigurationEntry[]", (Throwable)aMConfigurationException);
        }
        return authConfigurationEntry;
    }

    public String getModuleName(int n) {
        String string = null;
        AuthConfigurationEntry authConfigurationEntry = (AuthConfigurationEntry)this.getModuleList().get(n);
        if (authConfigurationEntry != null) {
            string = authConfigurationEntry.getLoginModuleName();
        }
        return string;
    }

    public String getModuleFlag(int n) {
        String string = null;
        AuthConfigurationEntry authConfigurationEntry = (AuthConfigurationEntry)this.getModuleList().get(n);
        if (authConfigurationEntry != null) {
            string = authConfigurationEntry.getControlFlag();
        }
        return string;
    }

    public String getModuleOptions(int n) {
        String string = null;
        AuthConfigurationEntry authConfigurationEntry = (AuthConfigurationEntry)this.getModuleList().get(n);
        if (authConfigurationEntry != null) {
            string = authConfigurationEntry.getOptions();
        }
        return string;
    }

    public boolean isUserType() {
        boolean bl = false;
        String string = this.acAttrs.getTemplate();
        int n = 0;
        try {
            n = Integer.parseInt(this.acAttrs.getServiceType());
            if (!(string != null && string.equals("true") || n != 3)) {
                bl = true;
            }
        }
        catch (NumberFormatException numberFormatException) {
            AMModelBase.debug.error("ACModuleListModelImpl.isUserType: Invalid Service Type " + this.acAttrs.getServiceType(), (Throwable)numberFormatException);
        }
        return bl;
    }

    public String filter(String string) {
        return LDAPDN.explodeDN((String)string, (boolean)true)[0];
    }

    public String getNoEntriesMsg() {
        return this.getLocalizedString("noEntries.message");
    }

    public String getNoModuleSelectedForDeletionTitle() {
        return this.getLocalizedString("noModuleSelectedForDeletion.title");
    }

    public String getNoModuleSelectedForDeletionMessage() {
        return this.getLocalizedString("noModuleSelectedForDeletion.message");
    }

    public String getSuccessMessage() {
        return this.getLocalizedString("updateModuleList.message");
    }

    public String getTableHeader() {
        Object[] objectArray = new String[]{"" + this.getModuleList().size()};
        return MessageFormat.format(this.getLocalizedString("authConfigTableHeader.label"), objectArray);
    }
}

