/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.am.console.auth.model;

import com.iplanet.am.console.auth.model.ACAttrs;
import com.iplanet.am.console.auth.model.ACModelBase;
import com.iplanet.am.console.base.model.AMModelBase;
import com.iplanet.am.console.base.model.AMProfileModelBase;
import com.iplanet.am.console.base.model.AMResBundleCacher;
import com.iplanet.am.sdk.AMAssignableDynamicGroup;
import com.iplanet.am.sdk.AMDynamicGroup;
import com.iplanet.am.sdk.AMException;
import com.iplanet.am.sdk.AMGroupContainer;
import com.iplanet.am.sdk.AMObject;
import com.iplanet.am.sdk.AMStaticGroup;
import com.iplanet.am.util.Debug;
import com.iplanet.am.util.Locale;
import com.iplanet.sso.SSOException;
import com.iplanet.sso.SSOToken;
import com.sun.identity.authentication.config.AMAuthConfigUtils;
import com.sun.identity.authentication.config.AMAuthenticationManager;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;

public abstract class ACModelBaseImpl
extends AMProfileModelBase
implements ACModelBase {
    private static final String AUTH_PROPERTIES = "amAuth";
    private String[] flagOptions = new String[]{"REQUIRED", "REQUISITE", "SUFFICIENT", "OPTIONAL"};
    protected ACAttrs acAttrs = null;

    public ACModelBaseImpl(HttpServletRequest httpServletRequest, Map map) {
        super(httpServletRequest, "amAdminModuleMsgs", map);
    }

    public String getSearchLocationDN() {
        String string;
        block12: {
            string = this.getLocationDN();
            int n = this.getLocationType();
            try {
                switch (n) {
                    case 2: 
                    case 3: {
                        break;
                    }
                    case 4: {
                        AMGroupContainer aMGroupContainer = this.dpStoreConn.getGroupContainer(string);
                        string = aMGroupContainer.getOrganizationDN();
                        break;
                    }
                    case 9: 
                    case 10: {
                        AMStaticGroup aMStaticGroup = this.dpStoreConn.getStaticGroup(string);
                        string = aMStaticGroup.getOrganizationDN();
                        break;
                    }
                    case 12: {
                        AMAssignableDynamicGroup aMAssignableDynamicGroup = this.dpStoreConn.getAssignableDynamicGroup(string);
                        string = aMAssignableDynamicGroup.getOrganizationDN();
                        break;
                    }
                    case 11: {
                        AMDynamicGroup aMDynamicGroup = this.dpStoreConn.getDynamicGroup(string);
                        string = aMDynamicGroup.getOrganizationDN();
                        break;
                    }
                    default: {
                        AMModelBase.debug.error("ACServiceInstanceListModelImpl.getSearchLocationDN: Cannot get Organization for:" + string);
                        break;
                    }
                }
            }
            catch (SSOException sSOException) {
                if (AMModelBase.debug.warningEnabled()) {
                    AMModelBase.debug.warning("ACServiceInstanceListModelImpl.getSearchLocationDN: unable to get search location DN", (Throwable)sSOException);
                }
            }
            catch (AMException aMException) {
                if (!AMModelBase.debug.warningEnabled()) break block12;
                AMModelBase.debug.warning("ACServiceInstanceListModelImpl.getSearchLocationDN: unable to get search location DN", (Throwable)aMException);
            }
        }
        if (AMModelBase.debug.messageEnabled()) {
            AMModelBase.debug.message("ACServiceInstanceListModelImpl:getSearchLocationDN " + string);
        }
        return string;
    }

    public String getValue(Set set) {
        Iterator iterator;
        String string = "";
        if (set != null && !set.isEmpty() && (iterator = set.iterator()).hasNext()) {
            string = iterator.next().toString();
        }
        return string;
    }

    public Map getRegisteredModules() {
        Map map = null;
        ACAttrs aCAttrs = this.getAttrs();
        String string = aCAttrs.getLocation();
        int n = this.getLocationType(string);
        AMAuthenticationManager aMAuthenticationManager = null;
        switch (n) {
            case 2: {
                try {
                    aMAuthenticationManager = new AMAuthenticationManager(this.ssoToken, string);
                    Set set = aMAuthenticationManager.getAllowedModuleNames();
                    map = ACModelBaseImpl.getMapFromSet(set);
                }
                catch (Exception exception) {
                    AMModelBase.debug.error("ACModelBaseImpl.getRegisteredModules: getAllowedModuleNames ", (Throwable)exception);
                }
                break;
            }
            case 1: 
            case 3: 
            case 6: 
            case 7: 
            case 8: {
                try {
                    AMObject aMObject = this.getAMObject(string);
                    map = AMAuthConfigUtils.getAllAuthModules((String)aMObject.getOrganizationDN(), (SSOToken)this.ssoToken);
                }
                catch (SSOException sSOException) {
                    AMModelBase.debug.error("ACModelBaseImpl.getRegisteredModules: invalid object type", (Throwable)sSOException);
                }
                catch (AMException aMException) {
                    AMModelBase.debug.error("ACModelBaseImpl.getRegisteredModules: invalid object type", (Throwable)aMException);
                }
                break;
            }
            default: {
                try {
                    aMAuthenticationManager = new AMAuthenticationManager(this.ssoToken, "/");
                    Set set = aMAuthenticationManager.getAllowedModuleNames();
                    map = ACModelBaseImpl.getMapFromSet(set);
                    break;
                }
                catch (Exception exception) {
                    AMModelBase.debug.error("ACModelBaseImpl.getRegisteredModules: getAllowedModuleNames ", (Throwable)exception);
                }
            }
        }
        if (map == null) {
            map = Collections.EMPTY_MAP;
        }
        return map;
    }

    public String getModuleLocalizedName(String string) {
        ResourceBundle resourceBundle = AMResBundleCacher.getBundle(AUTH_PROPERTIES, this.getUserLocale());
        return Locale.getString((ResourceBundle)resourceBundle, (String)string, (Debug)AMModelBase.debug);
    }

    public void setAttrs(ACAttrs aCAttrs) {
        this.acAttrs = aCAttrs;
    }

    public ACAttrs getAttrs() {
        if (this.acAttrs == null) {
            this.acAttrs = new ACAttrs();
        }
        return this.acAttrs;
    }

    public String getErrorTitle() {
        return this.getLocalizedString("error.title");
    }

    public String[] getFlagOptions() {
        return this.flagOptions;
    }

    public String[] getFlagLabels() {
        int n = this.flagOptions.length;
        String[] stringArray = new String[n];
        int n2 = 0;
        while (n2 < n) {
            stringArray[n2] = this.getLocalizedString(this.flagOptions[n2] + ".label");
            ++n2;
        }
        return stringArray;
    }

    public String getFlagLabel(String string) {
        String[] stringArray = this.getFlagLabels();
        int n = 0;
        while (!string.equals(this.flagOptions[n])) {
            ++n;
        }
        return stringArray[n];
    }

    private static Map getMapFromSet(Set set) {
        if (AMModelBase.debug.messageEnabled()) {
            AMModelBase.debug.message("getMapFromSet : allowedModules : " + set);
        }
        HashMap<String, String> hashMap = null;
        if (set != null && !set.isEmpty()) {
            Iterator iterator = set.iterator();
            hashMap = new HashMap<String, String>();
            while (iterator.hasNext()) {
                String string = (String)iterator.next();
                hashMap.put(string, string);
            }
        }
        return hashMap;
    }
}

