/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.xmlenc;

import com.iplanet.am.util.SystemProperties;
import com.sun.identity.saml.common.SAMLUtilsCommon;
import com.sun.identity.saml.xmlsig.KeyProvider;
import com.sun.identity.xmlenc.EncryptionException;
import com.sun.identity.xmlenc.EncryptionProvider;
import com.sun.identity.xmlenc.EncryptionUtils;
import java.security.Key;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class XMLEncryptionManager {
    private EncryptionProvider ep = null;
    private static XMLEncryptionManager instance = new XMLEncryptionManager();

    protected XMLEncryptionManager() {
        try {
            String string = SystemProperties.get((String)"com.sun.identity.xmlenc.EncryptionProviderImpl", (String)"com.sun.identity.xmlenc.AMEncryptionProvider");
            this.ep = (EncryptionProvider)Class.forName(string).newInstance();
            this.ep.initialize((KeyProvider)Class.forName(SAMLUtilsCommon.bundle.getString("keyproviderimplclass")).newInstance());
        }
        catch (Exception exception) {
            EncryptionUtils.debug.error("XMLEncryptionManager:constructor Exception in constructing xml encryption manager", (Throwable)exception);
        }
    }

    protected XMLEncryptionManager(EncryptionProvider encryptionProvider, KeyProvider keyProvider) {
        try {
            encryptionProvider.initialize(keyProvider);
            this.ep = encryptionProvider;
        }
        catch (Exception exception) {
            EncryptionUtils.debug.error("XMLEncryptionManager:constructor Exception in constructing xml encryption manager", (Throwable)exception);
        }
    }

    public static XMLEncryptionManager getInstance() {
        return instance;
    }

    public static XMLEncryptionManager getInstance(EncryptionProvider encryptionProvider, KeyProvider keyProvider) {
        return new XMLEncryptionManager(encryptionProvider, keyProvider);
    }

    public Document encryptAndReplace(Document document, Element element, String string, int n, String string2) throws EncryptionException {
        return this.ep.encryptAndReplace(document, element, string, n, string2, 0);
    }

    public Document encryptAndReplace(Document document, Element element, String string, int n, String string2, String string3) throws EncryptionException {
        return this.ep.encryptAndReplace(document, element, string, n, string2, 0, string3);
    }

    public Document encryptAndReplaceResourceID(Document document, Element element, String string, int n, String string2, String string3) throws EncryptionException {
        return this.ep.encryptAndReplaceResourceID(document, element, string, n, string2, 0, string3);
    }

    public Document encryptAndReplace(Document document, Element element, String string, int n, String string2, int n2) throws EncryptionException {
        return this.ep.encryptAndReplace(document, element, string, n, string2, n2);
    }

    public Document encryptAndReplace(Document document, Element element, String string, int n, Key key, int n2) throws EncryptionException {
        return this.ep.encryptAndReplace(document, element, string, n, key, n2, null);
    }

    public Document decryptAndReplace(Document document, String string) throws EncryptionException {
        return this.ep.decryptAndReplace(document, string);
    }

    public Document decryptAndReplace(Document document, Key key) throws EncryptionException {
        return this.ep.decryptAndReplace(document, key);
    }
}

