/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.sm.ldap;

import com.iplanet.am.util.Debug;
import com.iplanet.services.ldap.DSConfigMgr;
import com.iplanet.services.ldap.LDAPServiceException;
import com.iplanet.services.ldap.LDAPUser;
import com.iplanet.services.ldap.ServerGroup;
import com.iplanet.services.ldap.ServerInstance;
import netscape.ldap.LDAPBind;
import netscape.ldap.LDAPConnection;
import netscape.ldap.LDAPException;
import netscape.ldap.LDAPSearchConstraints;
import netscape.ldap.util.ConnectionPool;

class SMDataLayer {
    private static Debug debug;
    static final int MAX_CONN = 20;
    static final int MAX_BACKLOG = 100;
    static final String LDAP_MAXBACKLOG = "maxbacklog";
    static final String LDAP_RELEASECONNBEFORESEARCH = "releaseconnectionbeforesearchcompletes";
    static final String LDAP_REFERRAL = "referral";
    private static ConnectionPool _ldapPool;
    private static LDAPConnection _trialConn;
    private static LDAPSearchConstraints _defaultSearchConstraints;
    private static SMDataLayer m_instance;
    private boolean m_releaseConnectionBeforeSearchCompletes = false;

    private SMDataLayer() {
        this.initLdapPool();
    }

    protected static synchronized SMDataLayer getInstance() {
        debug = Debug.getInstance((String)"amSMSLdap");
        if (m_instance == null) {
            m_instance = new SMDataLayer();
        }
        return m_instance;
    }

    protected LDAPConnection getConnection() {
        if (_ldapPool == null) {
            return null;
        }
        if (debug.messageEnabled()) {
            debug.message("SMDataLayer:getConnection()-Invoking _ldapPool.getConnection()");
        }
        LDAPConnection lDAPConnection = _ldapPool.getConnection();
        if (debug.messageEnabled()) {
            debug.message("SMDataLayer:getConnection()-Got Connection : " + lDAPConnection);
        }
        return lDAPConnection;
    }

    protected void releaseConnection(LDAPConnection lDAPConnection) {
        if (_ldapPool == null || lDAPConnection == null) {
            return;
        }
        lDAPConnection.setSearchConstraints(_defaultSearchConstraints);
        if (debug.messageEnabled()) {
            debug.message("SMDataLayer:releaseConnection()-Invoking _ldapPool.close(conn) : " + lDAPConnection);
        }
        _ldapPool.close(lDAPConnection);
        if (debug.messageEnabled()) {
            debug.message("SMDataLayer:releaseConnection()-Released Connection : " + lDAPConnection);
        }
    }

    private synchronized void initLdapPool() {
        if (_ldapPool != null) {
            return;
        }
        ServerInstance serverInstance = null;
        try {
            DSConfigMgr dSConfigMgr = DSConfigMgr.getDSConfigMgr();
            ServerGroup serverGroup = dSConfigMgr.getServerGroup("sms");
            if (serverGroup != null) {
                _trialConn = dSConfigMgr.getNewConnection("sms", LDAPUser.Type.AUTH_ADMIN);
                serverInstance = serverGroup.getServerInstance(LDAPUser.Type.AUTH_ADMIN);
            } else {
                _trialConn = dSConfigMgr.getNewAdminConnection();
                serverInstance = dSConfigMgr.getServerInstance(LDAPUser.Type.AUTH_ADMIN);
            }
            if (serverInstance == null) {
                debug.error("SMDataLayer:initLdapPool()-Error getting server config.");
            }
        }
        catch (LDAPServiceException lDAPServiceException) {
            debug.error("SMDataLayer:initLdapPool()-Error initializing connection pool " + lDAPServiceException.getMessage());
            lDAPServiceException.printStackTrace();
        }
        int n = serverInstance.getMinConnections();
        int n2 = serverInstance.getMaxConnections();
        int n3 = serverInstance.getIntValue(LDAP_MAXBACKLOG, 100);
        this.m_releaseConnectionBeforeSearchCompletes = serverInstance.getBooleanValue(LDAP_RELEASECONNBEFORESEARCH, false);
        boolean bl = serverInstance.getBooleanValue(LDAP_REFERRAL, true);
        if (debug.messageEnabled()) {
            debug.message("SMDataLayer:initLdapPool()-Creating ldap connection pool with :");
            debug.message("SMDataLayer:initLdapPool()-poolMin : " + n);
            debug.message("SMDataLayer:initLdapPool()-poolMax : " + n2);
            debug.message("SMDataLayer:getConnection()-maxBackLog : " + n3);
        }
        try {
            _trialConn.setOption(30, (Object)new Integer(n3));
            _trialConn.setOption(8, (Object)new Boolean(bl));
            LDAPBind lDAPBind = new LDAPBind(){

                public void bind(LDAPConnection lDAPConnection) throws LDAPException {
                    String string = _trialConn.getAuthenticationDN();
                    String string2 = _trialConn.getAuthenticationPassword();
                    String string3 = lDAPConnection.getHost();
                    int n = lDAPConnection.getPort();
                    lDAPConnection.connect(3, string3, n, string, string2);
                }
            };
            _trialConn.setOption(13, (Object)lDAPBind);
            _defaultSearchConstraints = _trialConn.getSearchConstraints();
            _ldapPool = new ConnectionPool(n, n2, _trialConn);
        }
        catch (LDAPException lDAPException) {
            debug.error("SMDataLayer:initLdapPool()-Exception in SMDataLayer.initLdapPool:", (Throwable)lDAPException);
            lDAPException.printStackTrace();
        }
    }

    static {
        _ldapPool = null;
        _trialConn = null;
        _defaultSearchConstraints = null;
        m_instance = null;
    }
}

