/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.sm.ldap;

import com.iplanet.am.util.Debug;
import com.iplanet.services.ldap.DSConfigMgr;
import com.iplanet.services.ldap.LDAPUser;
import com.iplanet.services.ldap.ServerInstance;
import com.iplanet.services.ldap.event.DSEvent;
import com.iplanet.services.ldap.event.IDSEventListener;
import com.iplanet.sso.SSOException;
import com.iplanet.sso.SSOToken;
import com.iplanet.sso.providers.dpro.SSOProviderBundle;
import com.sun.identity.authentication.internal.AuthContext;
import com.sun.identity.authentication.internal.AuthPrincipal;
import com.sun.identity.security.AdminDNAction;
import com.sun.identity.security.AdminPasswordAction;
import com.sun.identity.sm.SMSEntry;
import com.sun.identity.sm.SMSObjectListener;
import com.sun.identity.sm.SMSUtils;
import java.security.AccessController;
import java.security.Principal;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

public class LDAPEventManager
implements IDSEventListener {
    protected static String listenerID;
    protected static ServerInstance serInstance;
    protected static Map changeListeners;
    protected static Debug eventDebug;
    Map listeners = null;
    protected static final int OPERATIONS = 15;
    protected static final String OC_SERVICE = "sunService";
    protected static final String OC_SERVICE_COMP = "sunServiceComponent";
    protected static final String SEARCH_FILTER = "(|(objectclass=sunService)(objectclass=sunServiceComponent))";
    protected static Principal adminPrincipal;
    protected static boolean initialized;

    static void initialize() {
        try {
            serInstance = DSConfigMgr.getDSConfigMgr().getServerInstance(LDAPUser.Type.AUTH_ADMIN);
            if (eventDebug.messageEnabled()) {
                eventDebug.message("LDAPEventManager:initialize Initialized LDAPEvent listener");
            }
            initialized = true;
        }
        catch (Exception exception) {
            eventDebug.error("LDAPEventManager:initialize Unable to init LDAP listener", (Throwable)exception);
        }
    }

    public LDAPEventManager() {
        if (!initialized) {
            LDAPEventManager.initialize();
        }
    }

    static synchronized String addObjectChangeListener(SMSObjectListener sMSObjectListener) {
        String string = SMSUtils.getUniqueID();
        if (!initialized) {
            LDAPEventManager.initialize();
        }
        changeListeners.put(string, sMSObjectListener);
        return string;
    }

    static synchronized void removeObjectChangeListener(String string) {
        changeListeners.remove(string);
    }

    public synchronized void entryChanged(DSEvent dSEvent) {
        int n = dSEvent.getEventType();
        String string = dSEvent.getID();
        switch (n) {
            case 1: {
                n = 0;
                break;
            }
            case 2: 
            case 8: {
                n = 1;
                break;
            }
            case 4: {
                n = 3;
            }
        }
        if (eventDebug.messageEnabled()) {
            eventDebug.message("SMSEventListener::entry changed for: " + string + " sending object changed notifications");
        }
        SMSEntry.objectChanged(string, n);
    }

    public void eventError(String string) {
        eventDebug.error("SMSEventListener.eventError(): " + string);
    }

    public void allEntriesChanged() {
        eventDebug.error("LDAPEventManager: received all entries changed event from EventService");
        Iterator iterator = changeListeners.values().iterator();
        while (iterator.hasNext()) {
            SMSObjectListener sMSObjectListener = (SMSObjectListener)iterator.next();
            sMSObjectListener.allObjectsChanged();
        }
    }

    private static SSOToken getSSOToken() throws SSOException {
        try {
            String string = (String)AccessController.doPrivileged(new AdminPasswordAction());
            AuthContext authContext = new AuthContext(adminPrincipal, string.toCharArray());
            return authContext.getSSOToken();
        }
        catch (Exception exception) {
            throw new SSOException(SSOProviderBundle.rbName, "invalidadmin", null);
        }
    }

    public String getBase() {
        return serInstance.getBaseDN();
    }

    public String getFilter() {
        return SEARCH_FILTER;
    }

    public int getOperations() {
        return 15;
    }

    public int getScope() {
        return 2;
    }

    public void setListeners(Map map) {
        this.listeners = map;
    }

    static {
        changeListeners = new HashMap();
        eventDebug = Debug.getInstance((String)"amSMSEvent");
        adminPrincipal = new AuthPrincipal((String)AccessController.doPrivileged(new AdminDNAction()));
    }
}

