/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.sm.jaxrpc;

import com.iplanet.am.util.Debug;
import com.iplanet.am.util.SystemProperties;
import com.iplanet.am.util.XMLUtils;
import com.iplanet.services.comm.server.PLLServer;
import com.iplanet.services.comm.server.SendNotificationException;
import com.iplanet.services.comm.share.Notification;
import com.iplanet.services.comm.share.NotificationSet;
import com.iplanet.sso.SSOException;
import com.iplanet.sso.SSOToken;
import com.iplanet.sso.SSOTokenManager;
import com.sun.identity.sm.CachedSMSEntry;
import com.sun.identity.sm.SMSEntry;
import com.sun.identity.sm.SMSException;
import com.sun.identity.sm.SMSObject;
import com.sun.identity.sm.SMSObjectListener;
import com.sun.identity.sm.SMSUtils;
import com.sun.identity.sm.jaxrpc.SMSJAXRPCObject;
import com.sun.identity.sm.jaxrpc.SMSObjectIF;
import java.net.MalformedURLException;
import java.net.URL;
import java.rmi.RemoteException;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;
import javax.naming.directory.BasicAttribute;
import javax.naming.directory.ModificationItem;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class SMSJAXRPCObjectImpl
implements SMSObjectIF,
SMSObjectListener {
    static Debug debug = SMSEntry.debug;
    static SMSObject smsObject = SMSEntry.getSMSObject();
    static Map notificationURLs = new HashMap();
    static SSOTokenManager tokenMgr;
    static SSOException initializationError;
    static String baseDN;
    static boolean initialized;
    static String serverURL;
    static int cacheSize;
    static LinkedList cacheIndices;
    static HashMap cache;

    public SMSJAXRPCObjectImpl() {
        this.initialize();
    }

    private void initialize() {
        if (!initialized) {
            try {
                tokenMgr = SSOTokenManager.getInstance();
            }
            catch (SSOException sSOException) {
                debug.error("SMSJAXRPCObject: Unable to get SSO Token Manager");
                initializationError = sSOException;
            }
            SMSObject sMSObject = smsObject;
            synchronized (sMSObject) {
                if (!initialized) {
                    try {
                        SMSEntry.registerCallbackHandler(null, this);
                    }
                    catch (Exception exception) {
                        debug.warning("SMSJAXRPCObjectImpl(): unable to register for callback handler", (Throwable)exception);
                    }
                }
            }
            serverURL = SystemProperties.get((String)"com.iplanet.am.server.protocol") + "://" + SystemProperties.get((String)"com.iplanet.am.server.host") + ":" + SystemProperties.get((String)"com.iplanet.am.server.port");
            initialized = true;
        }
    }

    public void checkForLocal() {
        SMSJAXRPCObject.isLocal = true;
    }

    public Map read(String string, String string2) throws SMSException, SSOException, RemoteException {
        if (debug.messageEnabled()) {
            debug.message("SMSJAXRPCObjectImpl::read dn: " + string2);
        }
        CachedSMSEntry cachedSMSEntry = CachedSMSEntry.getInstance(SMSJAXRPCObjectImpl.getToken(string), string2, null);
        HashMap hashMap = new HashMap();
        Map map = cachedSMSEntry.getSMSEntry().getAttributes();
        if (map != null) {
            Iterator iterator = map.keySet().iterator();
            while (iterator.hasNext()) {
                String string3 = iterator.next().toString();
                Object v = map.get(string3);
                hashMap.put(string3, v);
            }
        }
        return hashMap;
    }

    public void create(String string, String string2, Map map) throws SMSException, SSOException, RemoteException {
        if (debug.messageEnabled()) {
            debug.message("SMSJAXRPCObjectImpl::create dn: " + string2);
        }
        smsObject.create(SMSJAXRPCObjectImpl.getToken(string), string2, map);
        SMSEntry.notifyObjectChanged(string2, 0);
    }

    public void modify(String string, String string2, String string3) throws SMSException, SSOException, RemoteException {
        if (debug.messageEnabled()) {
            debug.message("SMSJAXRPCObjectImpl::modify dn: " + string2);
        }
        smsObject.modify(SMSJAXRPCObjectImpl.getToken(string), string2, SMSJAXRPCObjectImpl.getModItems(string3));
        SMSEntry.notifyObjectChanged(string2, 3);
    }

    public void delete(String string, String string2) throws SMSException, SSOException, RemoteException {
        if (debug.messageEnabled()) {
            debug.message("SMSJAXRPCObjectImpl::delete dn: " + string2);
        }
        smsObject.delete(SMSJAXRPCObjectImpl.getToken(string), string2);
        SMSEntry.notifyObjectChanged(string2, 1);
    }

    public Set searchSubOrgNames(String string, String string2, String string3, int n, boolean bl, boolean bl2, boolean bl3) throws SMSException, SSOException {
        if (debug.messageEnabled()) {
            debug.message("SMSJAXRPCObjectImpl::searchSubOrgNames dn: " + string2);
        }
        return smsObject.searchSubOrgNames(SMSJAXRPCObjectImpl.getToken(string), string2, string3, n, bl, bl2, bl3);
    }

    public Set searchOrganizationNames(String string, String string2, int n, boolean bl, boolean bl2, String string3, String string4, Set set) throws SMSException, SSOException {
        if (debug.messageEnabled()) {
            debug.message("SMSJAXRPCObjectImpl::searchOrganizationNames dn: " + string2);
        }
        return smsObject.searchOrganizationNames(SMSJAXRPCObjectImpl.getToken(string), string2, n, bl, bl2, string3, string4, set);
    }

    public Set subEntries(String string, String string2, String string3, int n, boolean bl, boolean bl2) throws SMSException, SSOException {
        if (debug.messageEnabled()) {
            debug.message("SMSJAXRPCObjectImpl::subentries dn: " + string2);
        }
        return smsObject.subEntries(SMSJAXRPCObjectImpl.getToken(string), string2, string3, n, bl, bl2);
    }

    public Set schemaSubEntries(String string, String string2, String string3, String string4, int n, boolean bl, boolean bl2) throws SMSException, SSOException {
        if (debug.messageEnabled()) {
            debug.message("SMSJAXRPCObjectImpl::subentries dn: " + string2);
        }
        return smsObject.schemaSubEntries(SMSJAXRPCObjectImpl.getToken(string), string2, string3, string4, n, bl, bl2);
    }

    public Set search(String string, String string2, String string3) throws SMSException, SSOException, RemoteException {
        if (debug.messageEnabled()) {
            debug.message("SMSJAXRPCObjectImpl::search dn: " + string2 + " filter: " + string3);
        }
        return smsObject.search(SMSJAXRPCObjectImpl.getToken(string), string2, string3);
    }

    public boolean entryExists(String string, String string2) throws SSOException, RemoteException {
        if (debug.messageEnabled()) {
            debug.message("SMSJAXRPCObjectImpl::exists dn: " + string2);
        }
        return smsObject.entryExists(SMSJAXRPCObjectImpl.getToken(string), string2);
    }

    public String getRootSuffix() throws RemoteException {
        if (baseDN == null) {
            baseDN = smsObject.getRootSuffix();
        }
        return baseDN;
    }

    public synchronized Set objectsChanged(int n) throws RemoteException {
        HashSet hashSet = new HashSet();
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(new Date());
        calendar.add(12, 1);
        int n2 = 0;
        while (n2 < n + 3) {
            calendar.add(12, -1);
            String string = SMSJAXRPCObjectImpl.calendarToString(calendar);
            Set set = (Set)cache.get(string);
            if (set != null) {
                hashSet.addAll(set);
            }
            ++n2;
        }
        return hashSet;
    }

    public synchronized void objectChanged(String string, int n) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(new Date());
        String string2 = SMSJAXRPCObjectImpl.calendarToString(calendar);
        HashSet<String> hashSet = (HashSet<String>)cache.get(string2);
        if (hashSet == null) {
            hashSet = new HashSet<String>();
            cache.put(string2, hashSet);
            cacheIndices.addFirst(string2);
            if (cacheIndices.size() > cacheSize) {
                cacheIndices.removeLast();
            }
        }
        String string3 = null;
        switch (n) {
            case 0: {
                string3 = "ADD:" + string;
                break;
            }
            case 1: {
                string3 = "DEL:" + string;
                break;
            }
            default: {
                string3 = "MOD:" + string;
            }
        }
        hashSet.add(string3);
        HashMap hashMap = new HashMap(notificationURLs);
        Iterator iterator = notificationURLs.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry entry = iterator.next();
            String string4 = (String)entry.getKey();
            URL uRL = (URL)entry.getValue();
            Notification notification = new Notification(string3);
            NotificationSet notificationSet = new NotificationSet("SMSObjectIF");
            notificationSet.addNotification(notification);
            try {
                PLLServer.send(uRL, notificationSet);
                if (!debug.messageEnabled()) continue;
                debug.message("SMSJAXRPCObjectImpl:sentNotification URL: " + uRL + " Data: " + notificationSet);
            }
            catch (SendNotificationException sendNotificationException) {
                if (debug.warningEnabled()) {
                    debug.warning("SMSJAXRPCObject: failed sending notification to: " + uRL + "\nRemoving " + "URL from notification list.", (Throwable)sendNotificationException);
                }
                notificationURLs.remove(string4);
            }
        }
    }

    public void allObjectsChanged() {
    }

    public synchronized String registerNotificationURL(String string) throws RemoteException {
        String string2;
        block5: {
            string2 = SMSUtils.getUniqueID();
            try {
                if (!string.startsWith(serverURL)) {
                    notificationURLs.put(string2, new URL(string));
                    if (debug.messageEnabled()) {
                        debug.message("SMSJAXRPCObjectImpl:register for notification URL: " + string);
                    }
                    break block5;
                }
                if (debug.warningEnabled()) {
                    debug.warning("SMSJAXRPCObjectImpl:registerURL cannot add local server: " + string);
                }
                throw new RemoteException("invalid-notification-URL");
            }
            catch (MalformedURLException malformedURLException) {
                if (!debug.warningEnabled()) break block5;
                debug.warning("SMSJAXRPCObjectImpl:registerNotificationURL  invalid URL: " + string, (Throwable)malformedURLException);
            }
        }
        return string2;
    }

    public synchronized void deRegisterNotificationURL(String string) throws RemoteException {
        notificationURLs.remove(string);
    }

    public void notifyObjectChanged(String string, int n) throws RemoteException {
        SMSEntry.objectChanged(string, n);
    }

    private static String calendarToString(Calendar calendar) {
        int n = calendar.get(1);
        int n2 = calendar.get(2);
        int n3 = calendar.get(5);
        int n4 = calendar.get(10);
        int n5 = calendar.get(12);
        calendar.clear();
        calendar.set(n, n2, n3, n4, n5);
        return serverURL + calendar.toString();
    }

    private static SSOToken getToken(String string) throws SSOException {
        if (initializationError != null) {
            throw initializationError;
        }
        return tokenMgr.createSSOToken(string);
    }

    static ModificationItem[] getModItems(String string) throws SMSException {
        if (debug.messageEnabled()) {
            debug.message("SMSJAXRPCObject::StringToMods: " + string);
        }
        ModificationItem[] modificationItemArray = null;
        try {
            if (string != null) {
                string = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n" + string;
                Document document = XMLUtils.toDOMDocument((String)string, (Debug)debug);
                Node node = XMLUtils.getRootNode((Document)document, (String)"Modifications");
                int n = Integer.parseInt(XMLUtils.getNodeAttributeValue((Node)node, (String)"size"));
                modificationItemArray = new ModificationItem[n];
                NodeList nodeList = node.getChildNodes();
                int n2 = 0;
                while (n2 < n) {
                    Node node2 = nodeList.item(n2);
                    if (node2.getNodeName().equals("AttributeValuePair")) {
                        String string2 = XMLUtils.getNodeAttributeValue((Node)node2, (String)"event");
                        int n3 = 1;
                        if (string2.equals("REPLACE")) {
                            n3 = 2;
                        } else if (string2.equals("DELETE")) {
                            n3 = 3;
                        }
                        Node node3 = XMLUtils.getChildNode((Node)node2, (String)"Attribute");
                        String string3 = XMLUtils.getNodeAttributeValue((Node)node3, (String)"name");
                        Set set = XMLUtils.getAttributeValuePair((Node)node2);
                        BasicAttribute basicAttribute = new BasicAttribute(string3);
                        Iterator iterator = set.iterator();
                        while (iterator.hasNext()) {
                            basicAttribute.add(iterator.next());
                        }
                        modificationItemArray[n2] = new ModificationItem(n3, basicAttribute);
                    }
                    ++n2;
                }
            }
        }
        catch (Exception exception) {
            throw new SMSException(exception, "sms-JAXRPC-cannot-copy-fromModStringToModItem");
        }
        return modificationItemArray;
    }

    static {
        cacheSize = 30;
        cacheIndices = new LinkedList();
        cache = new HashMap(cacheSize);
    }
}

