/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.sm.flatfile;

import com.iplanet.am.util.Debug;
import com.iplanet.am.util.SystemProperties;
import com.iplanet.sso.SSOException;
import com.iplanet.sso.SSOToken;
import com.sun.identity.common.CaseInsensitiveHashMap;
import com.sun.identity.common.CaseInsensitiveHashSet;
import com.sun.identity.common.CaseInsensitiveProperties;
import com.sun.identity.common.CaseInsensitiveTreeSet;
import com.sun.identity.common.ReaderWriterLock;
import com.sun.identity.sm.SMSEntry;
import com.sun.identity.sm.SMSException;
import com.sun.identity.sm.SMSObject;
import com.sun.identity.sm.SMSObjectListener;
import com.sun.identity.sm.SchemaException;
import com.sun.identity.sm.ServiceAlreadyExistsException;
import com.sun.identity.sm.ServiceNotFoundException;
import com.sun.identity.sm.flatfile.FileNameDecoder;
import com.sun.identity.sm.flatfile.FileNameEncoder;
import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.text.MessageFormat;
import java.text.ParseException;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.directory.Attribute;
import javax.naming.directory.ModificationItem;

public class SMSFlatFileObject
extends SMSObject {
    private String mRootDir = null;
    private File mRootDirHandle = null;
    private String mRootDN = null;
    private boolean mInitialized = false;
    private Debug mDebug = null;
    private Properties mNameMap = null;
    private File mNameMapHandle = null;
    private ReaderWriterLock mRWLock = new ReaderWriterLock();
    static final String SMS_FLATFILE_ROOTDIR_PROPERTY = "com.sun.identity.sm.flatfile.root_dir";
    static final String DEFAULT_ATTRIBUTE_FILENAME = "Attributes.properties";
    static final String DEFAULT_NAMEMAP_FILENAME = "NameMap.properties";
    static final String DEFAULT_ROOT_DIR = "/var/opt/SUNWam/sms";
    static final String DEFAULT_ORG_DN = "dc=sun,dc=com";

    private void deleteDir(File file) throws SMSException {
        File[] fileArray = file.listFiles();
        if (fileArray != null && fileArray.length > 0) {
            int n = 0;
            while (n < fileArray.length) {
                if (fileArray[n].isDirectory()) {
                    this.deleteDir(fileArray[n]);
                } else if (!fileArray[n].delete()) {
                    String string = "SMSFlatFileObject.delete: File " + fileArray[n].getPath() + " could not be removed!";
                    this.mDebug.error(string);
                    throw new SMSException(string);
                }
                ++n;
            }
        }
        file.delete();
    }

    private void init() throws SMSException {
        block21: {
            String string = null;
            this.mRootDir = SystemProperties.get((String)SMS_FLATFILE_ROOTDIR_PROPERTY, (String)DEFAULT_ROOT_DIR);
            this.mRootDN = SystemProperties.get((String)"com.iplanet.am.defaultOrg", (String)DEFAULT_ORG_DN);
            this.mRootDirHandle = new File(this.mRootDir);
            if (this.mRootDirHandle.isDirectory()) {
                if (!this.mRootDirHandle.canRead() || !this.mRootDirHandle.canWrite()) {
                    string = "SMSFlatFileObject.initialize: cannot read or write to the root directory." + this.mRootDir;
                    this.mDebug.error(string);
                    throw new SMSException(string);
                }
                if (this.mDebug.messageEnabled()) {
                    this.mDebug.message("SMSFlatFileObject: Root Directory: " + this.mRootDir);
                }
            } else {
                if (!this.mRootDirHandle.mkdir()) {
                    string = "SMSFlatFileObject.initialize: Cannot create the root directory." + this.mRootDir;
                    this.mDebug.error(string);
                    throw new SMSException(string);
                }
                if (this.mDebug.messageEnabled()) {
                    this.mDebug.message("SMSFlatFileObject: Created root directory: " + this.mRootDir);
                }
            }
            StringBuffer stringBuffer = new StringBuffer(this.mRootDir);
            stringBuffer.append(File.separatorChar);
            stringBuffer.append(DEFAULT_NAMEMAP_FILENAME);
            this.mNameMapHandle = new File(stringBuffer.toString());
            if (this.mNameMapHandle.isFile()) {
                if (!this.mNameMapHandle.canRead()) {
                    string = "SMSFlatFileObject.initialize: cannot read file " + this.mNameMapHandle.getPath();
                    this.mDebug.error(string);
                    throw new SMSException(string);
                }
                this.mNameMap = this.loadProperties(this.mNameMapHandle, null);
            } else {
                block20: {
                    try {
                        this.mNameMapHandle.createNewFile();
                    }
                    catch (IOException iOException) {
                        string = "SMSFlatFileObject.initialize: cannot create file " + stringBuffer + ". Exception " + iOException.getMessage();
                        this.mDebug.error(string);
                        throw new SMSException(string);
                    }
                    catch (SecurityException securityException) {
                        string = "SMSFlatFileObject.initialize: cannot create file " + stringBuffer + ". Exception " + securityException.getMessage();
                        this.mDebug.error(string);
                        throw new SMSException(string);
                    }
                    this.mNameMap = new CaseInsensitiveProperties();
                    try {
                        this.create(null, this.mRootDN, new HashMap());
                        if (this.mDebug.messageEnabled()) {
                            this.mDebug.message("SMSFlatFileObject.initialize: created SMS object for " + this.mRootDN);
                        }
                    }
                    catch (SSOException sSOException) {
                    }
                    catch (ServiceAlreadyExistsException serviceAlreadyExistsException) {
                        if (!this.mDebug.messageEnabled()) break block20;
                        this.mDebug.message("SMSFlatFileObject.initialize: " + this.mRootDN + " already exists");
                    }
                }
                try {
                    this.create(null, "ou=services," + this.mRootDN, new HashMap());
                    if (this.mDebug.messageEnabled()) {
                        this.mDebug.message("SMSFlatFileObject.initialize: created SMS object for ou=services," + this.mRootDN);
                    }
                }
                catch (SSOException sSOException) {
                }
                catch (ServiceAlreadyExistsException serviceAlreadyExistsException) {
                    if (!this.mDebug.messageEnabled()) break block21;
                    this.mDebug.message("SMSFlatFileObject.initialize: ou=services," + this.mRootDN + " already exists");
                }
            }
        }
    }

    protected String getAttrFile(String string) {
        String string2;
        String string3;
        int n;
        String string4 = null;
        StringBuffer stringBuffer = new StringBuffer(this.mRootDir.length() + string.length() + 20);
        stringBuffer.append(this.mRootDir);
        stringBuffer.append(File.separatorChar);
        char[] cArray = string.toCharArray();
        int n2 = n = cArray.length - 1;
        while (n2 >= 0) {
            if (cArray[n2] == ',') {
                if (n2 == n) {
                    --n;
                } else {
                    string3 = new String(cArray, n2 + 1, n - n2).trim();
                    string2 = FileNameEncoder.encode(string3);
                    stringBuffer.append(string2);
                    stringBuffer.append(File.separatorChar);
                    n = n2 - 1;
                }
            }
            --n2;
        }
        if (n2 != n) {
            string3 = new String(cArray, 0, n - n2);
            string2 = FileNameEncoder.encode(string3);
            stringBuffer.append(string2);
            stringBuffer.append(File.separatorChar);
        }
        stringBuffer.append(DEFAULT_ATTRIBUTE_FILENAME);
        string4 = stringBuffer.toString();
        return string4;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    Properties loadProperties(File file, String string) throws SMSException {
        FileInputStream fileInputStream = null;
        CaseInsensitiveProperties caseInsensitiveProperties = new CaseInsensitiveProperties();
        String string2 = null;
        try {
            try {
                fileInputStream = new FileInputStream(file);
                caseInsensitiveProperties.load(fileInputStream);
                CaseInsensitiveProperties caseInsensitiveProperties2 = caseInsensitiveProperties;
                Object var10_8 = null;
                if (fileInputStream == null) return caseInsensitiveProperties2;
                try {
                    fileInputStream.close();
                    return caseInsensitiveProperties2;
                }
                catch (IOException iOException) {
                    if (!this.mDebug.messageEnabled()) return caseInsensitiveProperties2;
                    this.mDebug.message("SMSFileFileObject: IO Exception encountered while closing properties file " + file.getPath());
                }
                return caseInsensitiveProperties2;
            }
            catch (FileNotFoundException fileNotFoundException) {
                string2 = "SMSFlatFileObject.loadProperties: " + (string == null ? "" : string + ": ") + "File not found: " + file.getPath();
                this.mDebug.error(string2);
                throw new ServiceNotFoundException(string2);
            }
            catch (IOException iOException) {
                string2 = "SMSFlatFileObject.loadProperties: " + (string == null ? "" : string + ": ") + "IO Exception encountered: " + iOException.getMessage();
                this.mDebug.error(string2);
                throw new SMSException(string2);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                string2 = "SMSFlatFileObject.loadProperties: " + (string == null ? "" : string + ": ") + "Incorrect syntax found in file " + file.getPath() + ". Exception: " + illegalArgumentException.getMessage();
                this.mDebug.error(string2);
                throw new SchemaException(string2);
            }
        }
        catch (Throwable throwable) {
            Object var10_9 = null;
            if (fileInputStream == null) throw throwable;
            try {}
            catch (IOException iOException) {
                if (!this.mDebug.messageEnabled()) throw throwable;
                this.mDebug.message("SMSFileFileObject: IO Exception encountered while closing properties file " + file.getPath());
                throw throwable;
            }
            fileInputStream.close();
            throw throwable;
        }
    }

    /*
     * Loose catch block
     */
    void saveProperties(Properties properties, File file, String string) throws SMSException {
        block10: {
            FileOutputStream fileOutputStream = null;
            String string2 = null;
            try {
                fileOutputStream = new FileOutputStream(file);
            }
            catch (FileNotFoundException fileNotFoundException) {
                string2 = "SMSFlatFileObject.saveProperties: " + (string == null ? "" : string + ": ") + "FileNotFoundException encountered while creating an " + "output stream to file " + file.getPath() + ". Exception: " + fileNotFoundException.getMessage();
                this.mDebug.error(string2);
                throw new ServiceNotFoundException(string2);
            }
            properties.store(fileOutputStream, string);
            Object var8_8 = null;
            try {
                fileOutputStream.close();
            }
            catch (IOException iOException) {
                if (this.mDebug.messageEnabled()) {
                    this.mDebug.message("SMSFileFileObject: IO Exception encountered while closing properties file " + file.getPath());
                }
                break block10;
            }
            {
                catch (IOException iOException) {
                    string2 = "SMSFlatFileObject.saveProperties: " + (string == null ? "" : string + ": ") + "IO Exception encountered writing attributes to file " + file.getPath() + ". Exception: " + iOException.getMessage();
                    this.mDebug.error(string2);
                    throw new SMSException(string2);
                }
            }
            catch (Throwable throwable) {
                block11: {
                    Object var8_9 = null;
                    try {
                        fileOutputStream.close();
                    }
                    catch (IOException iOException) {
                        if (!this.mDebug.messageEnabled()) break block11;
                        this.mDebug.message("SMSFileFileObject: IO Exception encountered while closing properties file " + file.getPath());
                    }
                }
                throw throwable;
            }
        }
    }

    String toValString(Set set) {
        Iterator iterator = set.iterator();
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = true;
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            string = this.encodeVal(string);
            if (bl) {
                bl = false;
            } else {
                stringBuffer.append(',');
            }
            stringBuffer.append(string);
        }
        return stringBuffer.toString();
    }

    String toValString(Enumeration enumeration) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = true;
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            string = this.encodeVal(string);
            if (bl) {
                bl = false;
            } else {
                stringBuffer.append(',');
            }
            stringBuffer.append(string);
        }
        return stringBuffer.toString();
    }

    String encodeVal(String string) {
        char[] cArray = string.toCharArray();
        StringBuffer stringBuffer = new StringBuffer(cArray.length + 20);
        int n = 0;
        int n2 = 0;
        n = 0;
        while (n < cArray.length) {
            if (cArray[n] == '%') {
                if (n2 != n) {
                    stringBuffer.append(cArray, n2, n - n2);
                }
                stringBuffer.append("%25");
                n2 = n + 1;
            } else if (cArray[n] == ',') {
                if (n2 != n) {
                    stringBuffer.append(cArray, n2, n - n2);
                }
                stringBuffer.append("%2C");
                n2 = n + 1;
            }
            ++n;
        }
        if (n2 != n) {
            stringBuffer.append(cArray, n2, n - n2);
        }
        return stringBuffer.toString();
    }

    protected Set toValSet(String string, String string2) {
        CaseInsensitiveHashSet caseInsensitiveHashSet = null;
        caseInsensitiveHashSet = SMSEntry.isAttributeCaseSensitive(string) ? new HashSet() : new CaseInsensitiveHashSet();
        char[] cArray = string2.toCharArray();
        int n = 0;
        int n2 = 0;
        while (n2 < cArray.length) {
            char c = cArray[n2];
            if (c == ',') {
                if (n == n2) {
                    n = n2 + 1;
                } else {
                    String string3 = new String(cArray, n, n2 - n).trim();
                    if (string3.length() > 0) {
                        string3 = this.decodeVal(string3);
                    }
                    caseInsensitiveHashSet.add(string3);
                    n = n2 + 1;
                }
            }
            ++n2;
        }
        if (n2 == cArray.length && n < n2) {
            String string4 = new String(cArray, n, n2 - n).trim();
            if (string4.length() > 0) {
                string4 = this.decodeVal(string4);
            }
            caseInsensitiveHashSet.add(string4);
        }
        return caseInsensitiveHashSet;
    }

    String decodeVal(String string) {
        char[] cArray = string.toCharArray();
        StringBuffer stringBuffer = new StringBuffer(cArray.length);
        int n = 0;
        int n2 = 0;
        n = 0;
        while (n < cArray.length) {
            if (cArray[n] == '%' && n + 2 < cArray.length && cArray[n + 1] == '2') {
                if (n2 != n) {
                    stringBuffer.append(cArray, n2, n - n2);
                }
                if (cArray[n + 2] == 'C') {
                    stringBuffer.append(',');
                } else if (cArray[n + 2] == '5') {
                    stringBuffer.append('%');
                } else {
                    stringBuffer.append(cArray, n, 3);
                }
                n2 = (n += 2) + 1;
            }
            ++n;
        }
        if (n2 != n) {
            stringBuffer.append(cArray, n2, n - n2);
        }
        return stringBuffer.toString();
    }

    void createSunServiceIdFiles(File file, Set set) throws SMSException {
        StringBuffer stringBuffer = new StringBuffer(file.getPath());
        stringBuffer.append(File.separatorChar);
        stringBuffer.append("sunserviceID");
        stringBuffer.append('=');
        String string = stringBuffer.toString();
        Iterator iterator = set.iterator();
        while (iterator.hasNext()) {
            String string2 = (String)iterator.next();
            File file2 = new File(string + string2);
            try {
                file2.createNewFile();
            }
            catch (IOException iOException) {
                String string3 = "SMSFlatFileObject.createSunServiceIdFiles : IO Exception encountered for file " + file2.getPath() + ". Msg: " + iOException.getMessage();
                this.mDebug.error(string3);
                throw new SMSException(string3);
            }
        }
    }

    Set getSubEntries(String string, String string2, String string3, int n, boolean bl, boolean bl2) throws SMSException {
        Object object;
        CharSequence charSequence;
        String string4 = string.toLowerCase();
        String string5 = null;
        Object object2 = null;
        this.mRWLock.readRequest();
        try {
            String string6;
            charSequence = this.mNameMap.getProperty(string4);
            if (charSequence == null) {
                string5 = "SMSFlatFileObject.getSubEntries: " + string + ": not found in objects map.";
                this.mDebug.warning(string5);
                throw new ServiceNotFoundException(string5);
            }
            object = new File((String)charSequence);
            File file = ((File)object).getParentFile();
            if (!file.isDirectory()) {
                string5 = "SMSFlatFileObject.getSubEntries: " + string + ": " + ((File)object).getPath() + " does not exist or is not a directory.";
                this.mDebug.error(string5);
                throw new ServiceNotFoundException(string5);
            }
            FilenameFilter filenameFilter = new FilenameFilter("ou=" + string2);
            FilenameFilter filenameFilter2 = null;
            if (string3 != null && string3.length() > 0) {
                filenameFilter2 = new FilenameFilter("sunserviceID=" + string3);
            }
            object2 = bl ? new CaseInsensitiveTreeSet(bl2) : new CaseInsensitiveHashSet();
            File[] fileArray = file.listFiles(filenameFilter);
            int n2 = 0;
            int n3 = 0;
            while (n3 < fileArray.length) {
                File[] fileArray2 = null;
                if (filenameFilter2 == null || (fileArray2 = fileArray[n3].listFiles(filenameFilter2)) != null && fileArray2.length > 0) {
                    string6 = fileArray[n3].getName();
                    int n4 = string6.indexOf(61);
                    if (n4 < 0 || n4 == string6.length() - 1) {
                        string5 = "SMSFlatFileObject.getSubEntries: Invalid sub entry name found: " + string6;
                        this.mDebug.error(string5);
                        throw new SchemaException(string5);
                    }
                    String string7 = FileNameDecoder.decode(string6.substring(n4 + 1));
                    object2.add(string7);
                    if (!bl && n > 0 && ++n2 == n) {
                        if (!this.mDebug.messageEnabled()) break;
                        this.mDebug.message("SMSFlatFileObject.getSubEntries: sub entries maximum number " + n + "reached out of " + fileArray.length + "found.");
                        break;
                    }
                }
                ++n3;
            }
            if (bl && n > 0 && n2 > n) {
                int n5 = n2 - n;
                while (n5 > 0) {
                    string6 = ((CaseInsensitiveTreeSet)object2).last();
                    object2.remove(string6);
                    --n5;
                }
            }
            Object var23_24 = null;
        }
        catch (Throwable throwable) {
            Object var23_25 = null;
            this.mRWLock.readDone();
            throw throwable;
        }
        this.mRWLock.readDone();
        if (this.mDebug.messageEnabled()) {
            charSequence = new StringBuffer("SMSFlatFileObject(");
            ((StringBuffer)charSequence).append(string);
            ((StringBuffer)charSequence).append("): \n");
            ((StringBuffer)charSequence).append("Returning sub entries: ");
            if (object2 == null) {
                ((StringBuffer)charSequence).append("null");
            } else {
                object = object2.iterator();
                while (object.hasNext()) {
                    ((StringBuffer)charSequence).append('\t');
                    ((StringBuffer)charSequence).append((String)object.next());
                }
            }
            this.mDebug.message(((StringBuffer)charSequence).toString());
        }
        return object2;
    }

    public SMSFlatFileObject() throws SMSException {
        if (!this.mInitialized) {
            this.initialize();
        }
    }

    public synchronized void initialize() throws SMSException {
        if (this.mInitialized) {
            return;
        }
        this.mDebug = super.debug();
        this.init();
        this.mInitialized = true;
    }

    public Map read(SSOToken sSOToken, String string) throws SMSException, SSOException {
        if (string == null || string.length() == 0) {
            throw new IllegalArgumentException("SMSFlatFileObject.read: object name is null or empty.");
        }
        String string2 = string.toLowerCase();
        String string3 = null;
        CaseInsensitiveHashMap caseInsensitiveHashMap = null;
        this.mRWLock.readRequest();
        try {
            String string4 = this.mNameMap.getProperty(string2);
            if (string4 == null) {
                if (this.mDebug.messageEnabled()) {
                    string3 = "SMSFlatFileObject.read: object " + string + " not found.";
                    this.mDebug.message(string3);
                }
            } else {
                File file = new File(string4);
                Properties properties = null;
                try {
                    properties = this.loadProperties(file, string);
                }
                catch (ServiceNotFoundException serviceNotFoundException) {
                    // empty catch block
                }
                if (properties != null) {
                    caseInsensitiveHashMap = new CaseInsensitiveHashMap();
                    Enumeration<?> enumeration = properties.propertyNames();
                    while (enumeration.hasMoreElements()) {
                        String string5 = (String)enumeration.nextElement();
                        String string6 = properties.getProperty(string5);
                        Set set = null;
                        if (string6 == null || string6.length() <= 0) continue;
                        set = this.toValSet(string5, string6);
                        caseInsensitiveHashMap.put(string5, set);
                    }
                }
            }
            Object var14_14 = null;
        }
        catch (Throwable throwable) {
            Object var14_15 = null;
            this.mRWLock.readDone();
            throw throwable;
        }
        this.mRWLock.readDone();
        if (this.mDebug.messageEnabled()) {
            if (caseInsensitiveHashMap != null) {
                this.mDebug.message("SMSFlatFileObject: read " + string + " success");
            } else {
                this.mDebug.message("SMSFlatFileObject: read " + string + " returns null.");
            }
        }
        return caseInsensitiveHashMap;
    }

    public void create(SSOToken sSOToken, String string, Map map) throws SMSException, SSOException {
        File file;
        if (string == null || string.length() == 0 || map == null) {
            throw new IllegalArgumentException("SMSFlatFileObject.create: One or more arguments is null or empty");
        }
        String string2 = string.toLowerCase();
        String string3 = null;
        String string4 = null;
        this.mRWLock.readRequest();
        try {
            string3 = this.mNameMap.getProperty(string2);
            if (string3 != null) {
                string4 = "SMSFlatFileObject.create: object " + string + " already exists in " + string3;
                this.mDebug.error(string4);
                throw new ServiceAlreadyExistsException(string4);
            }
            file = null;
        }
        catch (Throwable throwable) {
            Object var8_8 = null;
            this.mRWLock.readDone();
            throw throwable;
        }
        this.mRWLock.readDone();
        this.mRWLock.writeRequest();
        try {
            string3 = this.mNameMap.getProperty(string2);
            if (string3 != null) {
                string4 = "SMSFlatFileObject.create: object " + string + " already exists in " + string3;
                this.mDebug.error(string4);
                throw new ServiceAlreadyExistsException(string4);
            }
            string3 = this.getAttrFile(string);
            File file2 = new File(string3);
            file = file2.getParentFile();
            if (file.isDirectory()) {
                string4 = "SMSFlatFileObject.create: object " + string + " directory " + file.getPath() + "exists before create!";
                this.mDebug.error(string4);
                throw new ServiceAlreadyExistsException(string4);
            }
            Set set = null;
            Properties properties = new Properties();
            Set set2 = map.keySet();
            if (set2 != null) {
                Iterator iterator = set2.iterator();
                while (iterator.hasNext()) {
                    String string5 = (String)iterator.next();
                    Set set3 = (Set)map.get(string5);
                    if (string5.equalsIgnoreCase("sunserviceID")) {
                        set = set3;
                    }
                    String string6 = this.toValString(set3);
                    ((Hashtable)properties).put(string5, string6);
                }
            }
            try {
                if (!file.mkdirs()) {
                    string4 = "SMSFlatFileObject.create: object " + string + ": Could not create directory " + file.getPath();
                    this.mDebug.error(string4);
                    throw new SMSException(string4);
                }
                try {
                    if (!file2.createNewFile()) {
                        string4 = "SMSFlatFileObject.create: object " + string + ": Could not create file " + string3;
                        this.mDebug.error(string4);
                        throw new SMSException(string4);
                    }
                }
                catch (IOException iOException) {
                    string4 = "SMSFlatFileObject: object " + string + ": IOException encountered when creating file " + file2.getPath() + ". Msg: " + iOException.getMessage();
                    this.mDebug.error(string4);
                    throw new SMSException(string4);
                }
                this.saveProperties(properties, file2, string);
                if (set != null && !set.isEmpty()) {
                    this.createSunServiceIdFiles(file, set);
                }
                this.mNameMap.setProperty(string2, string3);
                this.saveProperties(this.mNameMap, this.mNameMapHandle, null);
            }
            catch (SMSException sMSException) {
                this.deleteDir(file);
                ((Hashtable)this.mNameMap).remove(string2);
                throw sMSException;
            }
            Object var17_20 = null;
        }
        catch (Throwable throwable) {
            Object var17_21 = null;
            this.mRWLock.writeDone();
            throw throwable;
        }
        this.mRWLock.writeDone();
        if (this.mDebug.messageEnabled()) {
            this.mDebug.message("SMSFlatFileObject.create: Created " + string + " in file " + string3);
        }
    }

    public void modify(SSOToken sSOToken, String string, ModificationItem[] modificationItemArray) throws SMSException, SSOException {
        Properties properties;
        if (string == null || string.length() == 0 || modificationItemArray == null || modificationItemArray.length == 0) {
            throw new IllegalArgumentException("SMSFlatFileObject.modify: One or more arguments is null or empty");
        }
        String string2 = string.toLowerCase();
        String string3 = null;
        String string4 = null;
        this.mRWLock.readRequest();
        try {
            string3 = this.mNameMap.getProperty(string2);
            if (string3 == null) {
                string4 = "SMSFlatFileObject.modify: object " + string + " not found.";
                this.mDebug.error(string4);
                throw new ServiceNotFoundException(string4);
            }
            properties = null;
        }
        catch (Throwable throwable) {
            Object var8_8 = null;
            this.mRWLock.readDone();
            throw throwable;
        }
        this.mRWLock.readDone();
        this.mRWLock.writeRequest();
        try {
            string3 = this.mNameMap.getProperty(string2);
            if (string3 == null) {
                string4 = "SMSFlatFileObject.modify: object " + string + " not found.";
                this.mDebug.error(string4);
                throw new ServiceNotFoundException(string4);
            }
            File file = new File(string3);
            if (!file.isFile()) {
                string4 = "SMSFlatFileObject.modify: Attributes file for object " + string + " not found.";
                this.mDebug.error(string4);
                throw new ServiceNotFoundException(string4);
            }
            properties = this.loadProperties(file, string);
            int n = 0;
            while (n < modificationItemArray.length) {
                Attribute attribute = modificationItemArray[n].getAttribute();
                String string5 = attribute.getID();
                NamingEnumeration<?> namingEnumeration = null;
                try {
                    namingEnumeration = attribute.getAll();
                }
                catch (NamingException namingException) {
                    string4 = "SMSFlatFileObject.modify: " + string + ": Error getting attributes: " + namingException.getMessage();
                    this.mDebug.error(string4);
                    throw new IllegalArgumentException(string4);
                }
                String string6 = this.toValString(namingEnumeration);
                ((Hashtable)properties).put(string5, string6);
                ++n;
            }
            this.saveProperties(properties, file, string);
            if (this.mDebug.messageEnabled()) {
                this.mDebug.message("SMSFlatFileObject: Successfully modified " + modificationItemArray.length + " attributes for " + string);
            }
            Object var15_17 = null;
        }
        catch (Throwable throwable) {
            Object var15_18 = null;
            this.mRWLock.writeDone();
            throw throwable;
        }
        this.mRWLock.writeDone();
    }

    public void delete(SSOToken sSOToken, String string) throws SMSException, SSOException {
        File file;
        if (string == null || string.length() == 0) {
            throw new IllegalArgumentException("SMSFlatFileObject.delete: object name is null or empty.");
        }
        String string2 = string.toLowerCase();
        String string3 = null;
        String string4 = null;
        this.mRWLock.readRequest();
        try {
            string3 = this.mNameMap.getProperty(string2);
            if (string3 == null && this.mDebug.messageEnabled()) {
                string4 = "SMSFlatFileObject.delete: " + string + ": object not found.";
                this.mDebug.message(string4);
            }
            file = null;
        }
        catch (Throwable throwable) {
            Object var7_7 = null;
            this.mRWLock.readDone();
            throw throwable;
        }
        this.mRWLock.readDone();
        if (string3 != null) {
            this.mRWLock.writeRequest();
            try {
                string3 = this.mNameMap.getProperty(string2);
                if (string3 == null) {
                    if (this.mDebug.messageEnabled()) {
                        string4 = "SMSFlatFileObject.delete: " + string + ": object not found.";
                        this.mDebug.message(string4);
                    }
                } else {
                    File file2 = new File(string3);
                    file = file2.getParentFile();
                    this.deleteDir(file);
                    string = string.toLowerCase();
                    Enumeration enumeration = ((Hashtable)this.mNameMap).keys();
                    while (enumeration.hasMoreElements()) {
                        String string5 = (String)enumeration.nextElement();
                        if (!string5.endsWith(string)) continue;
                        ((Hashtable)this.mNameMap).remove(string5);
                        if (!this.mDebug.messageEnabled()) continue;
                        this.mDebug.message("SMSFlatFileObject.delete: deleted " + string + " from map");
                    }
                    this.saveProperties(this.mNameMap, this.mNameMapHandle, null);
                    if (this.mDebug.messageEnabled()) {
                        this.mDebug.message("SMSFlatFileObject.delete: Successfully deleted " + string + " in path " + string3);
                    }
                }
                Object var11_12 = null;
            }
            catch (Throwable throwable) {
                Object var11_13 = null;
                this.mRWLock.writeDone();
                throw throwable;
            }
            this.mRWLock.writeDone();
            {
            }
        }
    }

    public Set subEntries(SSOToken sSOToken, String string, String string2, int n, boolean bl, boolean bl2) throws SMSException, SSOException {
        if (string == null || string.length() == 0 || string2 == null || string2.length() == 0 || n < 0) {
            throw new IllegalArgumentException("SMSFlatFileObject.subEntries(): One or more arguments is null or empty: objName [" + string == null ? "null" : (string + "] filter ]" + string2 == null ? "null" : string2 + "]"));
        }
        Object object = null;
        try {
            object = this.getSubEntries(string, string2, null, n, bl, bl2);
        }
        catch (ServiceNotFoundException serviceNotFoundException) {
            object = new CaseInsensitiveHashSet();
        }
        if (this.mDebug.messageEnabled()) {
            this.mDebug.message("SMSFlatFileObject: SubEntries search " + string2 + " for " + string + " returned " + object.size() + " items");
        }
        return object;
    }

    public Set schemaSubEntries(SSOToken sSOToken, String string, String string2, String string3, int n, boolean bl, boolean bl2) throws SMSException, SSOException {
        if (string == null || string.length() == 0 || string2 == null || string2.length() == 0 || string3 == null || string3.length() == 0) {
            throw new IllegalArgumentException("SMSFlatFileObject.schemaSubEntries: One or more arguments is null or empty.");
        }
        Object object = null;
        try {
            object = this.getSubEntries(string, string2, string3, n, bl, bl2);
        }
        catch (ServiceNotFoundException serviceNotFoundException) {
            object = new CaseInsensitiveHashSet();
        }
        if (this.mDebug.messageEnabled()) {
            this.mDebug.message("SMSFlatFileObject: SchemaSubEntries search " + string2 + " for " + string + " returned " + object.size() + " items");
        }
        return object;
    }

    public boolean entryExists(SSOToken sSOToken, String string) {
        boolean bl = false;
        if (string == null || string.length() == 0) {
            throw new IllegalArgumentException("SMSFlatFileObject.entryExists: One or more arguments is null or empty.");
        }
        this.mRWLock.readRequest();
        try {
            String string2 = this.mNameMap.getProperty(string.toLowerCase());
            if (string2 != null) {
                bl = true;
            }
            Object var6_5 = null;
        }
        catch (Throwable throwable) {
            Object var6_6 = null;
            this.mRWLock.readDone();
            throw throwable;
        }
        this.mRWLock.readDone();
        if (this.mDebug.messageEnabled()) {
            this.mDebug.message("SMSFlatFileObject.exists: config object " + string + " exists: " + bl);
        }
        return bl;
    }

    public Set search(SSOToken sSOToken, String string, String string2) throws SSOException, SMSException {
        if (string == null || string.length() == 0 || string2 == null || string2.length() == 0) {
            throw new IllegalArgumentException("SMSFlatFileObject.search: One or more arguments is null or empty.");
        }
        try {
            String string3 = SMSEntry.getFilterPatternService();
            MessageFormat messageFormat = new MessageFormat(string3);
            Object[] objectArray = messageFormat.parse(string2);
            if (objectArray.length != 2 || !(objectArray[0] instanceof String) || !(objectArray[1] instanceof String)) {
                throw new IllegalArgumentException("SMSFlatFile.search: Error parsing filter pattern " + string2);
            }
            String string4 = (String)objectArray[0];
            String string5 = (String)objectArray[1];
            String string6 = "ou=" + string4 + ",ou=services," + this.mRootDN;
            Set set = null;
            set = this.getSubEntries(string6, "*", "ou=" + string5, 0, false, false);
            return set;
        }
        catch (ParseException parseException) {
            throw new IllegalArgumentException("SMSFlatFileObject.search: Unexpected filter pattern " + string2);
        }
    }

    public Set searchSubOrgNames(SSOToken sSOToken, String string, String string2, int n, boolean bl, boolean bl2, boolean bl3) throws SMSException, SSOException {
        return null;
    }

    public Set searchOrganizationNames(SSOToken sSOToken, String string, int n, boolean bl, boolean bl2, String string2, String string3, Set set) throws SMSException, SSOException {
        return null;
    }

    public String registerCallbackHandler(SSOToken sSOToken, SMSObjectListener sMSObjectListener) throws SMSException, SSOException {
        return null;
    }

    public void deregisterCallbackHandler(String string) {
    }

    public String getRootSuffix() {
        return this.mRootDN;
    }

    public String toString() {
        return "SMSFlatFileObject";
    }

    private class FilenameFilter
    implements FileFilter {
        private String mFilter = null;
        private String mBegin = null;
        private int mBeginLen = 0;
        private String mEnd = null;
        private int mEndLen = 0;
        private int mWildcard = -1;

        public FilenameFilter(String string) {
            this.mFilter = string;
            this.mWildcard = this.mFilter.indexOf(42);
            if (this.mWildcard >= 0) {
                if (this.mWildcard > 0) {
                    this.mBegin = FileNameEncoder.encode(this.mFilter.substring(0, this.mWildcard));
                    this.mBeginLen = this.mBegin.length();
                }
                if (this.mWildcard < string.length() - 1) {
                    this.mEnd = FileNameEncoder.encode(this.mFilter.substring(this.mWildcard + 1));
                    this.mEndLen = this.mEnd.length();
                }
            }
        }

        public boolean accept(File file) {
            String string = file.getName();
            boolean bl = false;
            bl = this.mWildcard >= 0 ? !(this.mBegin != null && !string.regionMatches(true, 0, this.mBegin, 0, this.mBeginLen) || this.mEnd != null && !string.regionMatches(true, string.length() - this.mEndLen, this.mEnd, 0, this.mEndLen)) : string.equalsIgnoreCase(this.mFilter);
            if (SMSFlatFileObject.this.mDebug.messageEnabled()) {
                SMSFlatFileObject.this.mDebug.message("SMSFlatFileObject: subentry file " + string + " matched " + this.mFilter + ": " + bl);
            }
            return bl;
        }
    }
}

