/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.sm;

import com.iplanet.am.util.Debug;
import com.iplanet.am.util.XMLUtils;
import com.iplanet.sso.SSOException;
import com.iplanet.sso.SSOToken;
import com.sun.identity.sm.CachedSMSEntry;
import com.sun.identity.sm.PluginInterface;
import com.sun.identity.sm.SMSEntry;
import com.sun.identity.sm.SMSException;
import com.sun.identity.sm.SMSSchema;
import com.sun.identity.sm.SMSUtils;
import com.sun.identity.sm.SchemaType;
import com.sun.identity.sm.ServiceListener;
import com.sun.identity.sm.ServiceManager;
import com.sun.identity.sm.ServiceSchemaImpl;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

class ServiceSchemaManagerImpl {
    private String serviceName;
    private String version;
    private int instanceID;
    private String i18nKey;
    private String i18nFileName;
    private String i18nJarURL;
    private String serviceHierarchy;
    private String viewBeanURL;
    private int revisionNumber;
    private ServiceManager sm;
    private CachedSMSEntry smsEntry;
    private HashMap listenerObjects;
    private String xmlSchema;
    private Document document;
    private Node schemaRoot;
    private Map subSchemas;
    private Map pluginInterfaces;
    private static Debug debug = SMSEntry.debug;
    private static Map schemaManagers = new HashMap();
    private static final String schemaMgrMutex = "SchemaManagerMutext";
    private static final int DEFAULT_REVISION = 10;
    private static final int REVISION_ERROR = -1;

    private ServiceSchemaManagerImpl(SSOToken sSOToken, String string, String string2) throws SMSException, SSOException {
        ServiceManager.checkServiceNameAndVersion(sSOToken, string, string2);
        this.serviceName = string;
        this.version = string2;
        this.instanceID = SMSUtils.getInstanceID();
        this.listenerObjects = new HashMap();
        this.subSchemas = new HashMap();
        this.pluginInterfaces = new HashMap();
        this.smsEntry = CachedSMSEntry.getInstance(sSOToken, this, string, string2);
        this.update();
    }

    public String getName() {
        return this.serviceName;
    }

    public String getVersion() {
        return this.version;
    }

    String getI18NKey() {
        return this.i18nKey;
    }

    void setI18NKey(String string) throws SMSException, SSOException {
        this.i18nKey = string;
        Node node = XMLUtils.getRootNode((Document)this.getDocument(), (String)"Schema");
        ((Element)node).setAttribute("i18nKey", string);
    }

    int getRevisionNumber() {
        return this.revisionNumber;
    }

    void setRevisionNumber(int n) throws SMSException, SSOException {
        this.revisionNumber = n;
        Node node = XMLUtils.getRootNode((Document)this.getDocument(), (String)"Schema");
        ((Element)node).setAttribute("revisionNumber", Integer.toString(n));
    }

    String getI18NFileName() {
        return this.i18nFileName;
    }

    void setI18NFileName(String string) throws SMSException, SSOException {
        this.i18nFileName = string;
        Node node = XMLUtils.getRootNode((Document)this.getDocument(), (String)"Schema");
        ((Element)node).setAttribute("i18nFileName", string);
    }

    String getI18NJarURL() {
        return this.i18nJarURL;
    }

    void setI18NJarURL(String string) throws SMSException, SSOException {
        this.i18nJarURL = string;
        Node node = XMLUtils.getRootNode((Document)this.getDocument(), (String)"Schema");
        ((Element)node).setAttribute("i18nJarURL", string);
    }

    String getServiceHierarchy() {
        return this.serviceHierarchy;
    }

    void setServiceHierarchy(String string) throws SMSException, SSOException {
        this.serviceHierarchy = string;
        Node node = XMLUtils.getRootNode((Document)this.getDocument(), (String)"Schema");
        ((Element)node).setAttribute("serviceHierarchy", string);
    }

    String getPropertiesViewBeanURL() {
        return this.viewBeanURL;
    }

    void setPropertiesViewBeanURL(String string) throws SMSException, SSOException {
        this.viewBeanURL = string;
        Node node = XMLUtils.getRootNode((Document)this.getDocument(), (String)"Schema");
        ((Element)node).setAttribute("propertiesViewBeanURL", string);
    }

    Set getSchemaTypes() throws SMSException {
        return new HashSet(this.subSchemas.keySet());
    }

    ServiceSchemaImpl getSchema(SchemaType schemaType) {
        ServiceSchemaImpl serviceSchemaImpl = (ServiceSchemaImpl)this.subSchemas.get(schemaType);
        return serviceSchemaImpl;
    }

    InputStream getSchema() {
        return new ByteArrayInputStream(this.xmlSchema.getBytes());
    }

    CachedSMSEntry getCachedSMSEntry() {
        return this.smsEntry;
    }

    public boolean equals(Object object) {
        if (object instanceof ServiceSchemaManagerImpl) {
            ServiceSchemaManagerImpl serviceSchemaManagerImpl = (ServiceSchemaManagerImpl)object;
            if (this.serviceName.equals(serviceSchemaManagerImpl.serviceName) && this.version.equals(serviceSchemaManagerImpl.version) && this.instanceID == serviceSchemaManagerImpl.instanceID) {
                return true;
            }
        }
        return false;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer(100);
        stringBuffer.append("\nService Schema Manager: ").append(this.serviceName).append("\n\tVersion: ").append(this.version);
        stringBuffer.append("\nI18n file name: " + this.getI18NFileName());
        stringBuffer.append("\nI18n Jar URL: " + this.getI18NJarURL());
        stringBuffer.append("\nService hierarchy: " + this.getServiceHierarchy());
        stringBuffer.append("\nProperty View Bean: " + this.getPropertiesViewBeanURL());
        ServiceSchemaImpl serviceSchemaImpl = this.getSchema(SchemaType.GLOBAL);
        if (serviceSchemaImpl != null) {
            stringBuffer.append("\nGlobal Schema:\n").append(serviceSchemaImpl.toString());
        }
        if ((serviceSchemaImpl = this.getSchema(SchemaType.ORGANIZATION)) != null) {
            stringBuffer.append("Organization Schema:\n").append(serviceSchemaImpl.toString());
        }
        if ((serviceSchemaImpl = this.getSchema(SchemaType.DYNAMIC)) != null) {
            stringBuffer.append("Dynamic Schema:\n").append(serviceSchemaImpl.toString());
        }
        if ((serviceSchemaImpl = this.getSchema(SchemaType.USER)) != null) {
            stringBuffer.append("User Schema:\n").append(serviceSchemaImpl.toString());
        }
        if ((serviceSchemaImpl = this.getSchema(SchemaType.POLICY)) != null) {
            stringBuffer.append("Policy Schema:\n").append(serviceSchemaImpl.toString());
        }
        return stringBuffer.toString();
    }

    synchronized String addListener(ServiceListener serviceListener) {
        String string = SMSUtils.getUniqueID();
        this.listenerObjects.put(string, serviceListener);
        return string;
    }

    synchronized void removeListener(String string) {
        this.listenerObjects.remove(string);
    }

    Set getPluginInterfaceNames() {
        return new HashSet(this.pluginInterfaces.keySet());
    }

    PluginInterface getPluginInterface(String string) {
        return (PluginInterface)this.pluginInterfaces.get(string);
    }

    void setServiceManager(ServiceManager serviceManager) {
        this.sm = serviceManager;
    }

    Document getDocument() {
        return this.document;
    }

    Document getDocumentCopy() throws SMSException {
        String string = this.xmlSchema;
        if (string == null || string.length() == 0) {
            string = SMSSchema.getDummyXML(this.serviceName, this.version);
        }
        return SMSSchema.getXMLDocument(string, false);
    }

    protected void finalize() throws Throwable {
        this.smsEntry.removeServiceListener(this);
    }

    synchronized void updateAndNotifyListeners() {
        this.update();
        HashMap hashMap = (HashMap)this.listenerObjects.clone();
        Iterator iterator = hashMap.values().iterator();
        while (iterator.hasNext()) {
            ServiceListener serviceListener = (ServiceListener)iterator.next();
            serviceListener.schemaChanged(this.serviceName, this.version);
        }
    }

    synchronized void update() {
        this.xmlSchema = this.smsEntry.getXMLSchema();
        if (this.xmlSchema == null) {
            if (debug.warningEnabled()) {
                debug.warning("ServiceSchemaManagerImpl:: schema is null " + this.serviceName + "(" + this.version + ")");
            }
            return;
        }
        try {
            this.document = SMSSchema.getXMLDocument(SMSSchema.getServiceSchemaInputStream(this.xmlSchema), false);
            this.schemaRoot = XMLUtils.getRootNode((Document)this.document, (String)"Schema");
        }
        catch (Exception exception) {
            debug.error("ServiceSchemaManagerImpl: XML parser error: " + this.serviceName + "(" + this.version + ")", (Throwable)exception);
            return;
        }
        if (this.schemaRoot == null) {
            debug.warning("ServiceSchemaManagerImpl: " + this.serviceName + "no schema found");
            return;
        }
        this.i18nKey = XMLUtils.getNodeAttributeValue((Node)this.schemaRoot, (String)"i18nKey");
        this.i18nFileName = XMLUtils.getNodeAttributeValue((Node)this.schemaRoot, (String)"i18nFileName");
        this.i18nJarURL = XMLUtils.getNodeAttributeValue((Node)this.schemaRoot, (String)"i18nJarURL");
        this.serviceHierarchy = XMLUtils.getNodeAttributeValue((Node)this.schemaRoot, (String)"serviceHierarchy");
        this.viewBeanURL = XMLUtils.getNodeAttributeValue((Node)this.schemaRoot, (String)"propertiesViewBeanURL");
        String string = XMLUtils.getNodeAttributeValue((Node)this.schemaRoot, (String)"revisionNumber");
        try {
            this.revisionNumber = string != null ? Integer.parseInt(string) : 10;
        }
        catch (Exception exception) {
            if (debug.warningEnabled()) {
                debug.warning("ServiceSchemaManagerImpl ==> " + this.serviceName + ": Invalid revision revision number: " + string, (Throwable)exception);
            }
            this.revisionNumber = -1;
        }
        this.updateSchema(SchemaType.GLOBAL, "Global");
        this.updateSchema(SchemaType.ORGANIZATION, "Organization");
        this.updateSchema(SchemaType.DYNAMIC, "Dynamic");
        this.updateSchema(SchemaType.USER, "User");
        this.updateSchema(SchemaType.POLICY, "Policy");
        this.updateSchema(SchemaType.GROUP, "Group");
        this.updateSchema(SchemaType.DOMAIN, "Domain");
        this.updateGenericSchema("Generic");
        Iterator iterator = XMLUtils.getChildNodes((Node)this.schemaRoot, (String)"PluginInterface").iterator();
        while (iterator.hasNext()) {
            PluginInterface pluginInterface = new PluginInterface(this, (Node)iterator.next());
            this.pluginInterfaces.put(pluginInterface.getName(), pluginInterface);
        }
    }

    void updateGenericSchema(String string) {
        Iterator iterator = XMLUtils.getChildNodes((Node)this.schemaRoot, (String)string).iterator();
        while (iterator.hasNext()) {
            Node node = (Node)iterator.next();
            String string2 = XMLUtils.getNodeAttributeValue((Node)node, (String)"type");
            if (string2 == null) continue;
            SchemaType schemaType = new SchemaType(string2.toUpperCase());
            ServiceSchemaImpl serviceSchemaImpl = (ServiceSchemaImpl)this.subSchemas.get(schemaType);
            if (serviceSchemaImpl != null) {
                serviceSchemaImpl.update(node);
                continue;
            }
            this.subSchemas.put(schemaType, new ServiceSchemaImpl(this, node));
        }
    }

    void updateSchema(SchemaType schemaType, String string) {
        Node node = XMLUtils.getChildNode((Node)this.schemaRoot, (String)string);
        if (node == null) {
            this.subSchemas.remove(schemaType);
        } else {
            ServiceSchemaImpl serviceSchemaImpl = (ServiceSchemaImpl)this.subSchemas.get(schemaType);
            if (serviceSchemaImpl != null) {
                serviceSchemaImpl.update(node);
            } else {
                this.subSchemas.put(schemaType, new ServiceSchemaImpl(this, node));
            }
        }
    }

    static ServiceSchemaManagerImpl getInstance(SSOToken sSOToken, String string, String string2) throws SMSException, SSOException {
        String string3 = ServiceManager.getCacheIndex(string, string2);
        ServiceSchemaManagerImpl serviceSchemaManagerImpl = (ServiceSchemaManagerImpl)schemaManagers.get(string3);
        if (serviceSchemaManagerImpl != null && !serviceSchemaManagerImpl.smsEntry.isValid()) {
            serviceSchemaManagerImpl = null;
        }
        if (serviceSchemaManagerImpl != null) {
            if (!SMSEntry.cacheSMSEntries) {
                serviceSchemaManagerImpl.update();
            }
            return serviceSchemaManagerImpl;
        }
        String string4 = schemaMgrMutex;
        synchronized (string4) {
            serviceSchemaManagerImpl = (ServiceSchemaManagerImpl)schemaManagers.get(string3);
            if (serviceSchemaManagerImpl == null || !serviceSchemaManagerImpl.smsEntry.isValid()) {
                serviceSchemaManagerImpl = new ServiceSchemaManagerImpl(sSOToken, string, string2);
                HashMap<String, ServiceSchemaManagerImpl> hashMap = new HashMap<String, ServiceSchemaManagerImpl>(schemaManagers);
                hashMap.put(string3, serviceSchemaManagerImpl);
                schemaManagers = hashMap;
            }
        }
        return serviceSchemaManagerImpl;
    }

    static void clearCache() {
        schemaManagers = new HashMap();
    }
}

