/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.sm;

import com.iplanet.am.util.Debug;
import com.iplanet.am.util.XMLUtils;
import com.iplanet.sso.SSOException;
import com.iplanet.sso.SSOToken;
import com.sun.identity.sm.CachedSMSEntry;
import com.sun.identity.sm.CachedSubEntries;
import com.sun.identity.sm.DNMapper;
import com.sun.identity.sm.PluginInterface;
import com.sun.identity.sm.PluginSchema;
import com.sun.identity.sm.SMSEntry;
import com.sun.identity.sm.SMSException;
import com.sun.identity.sm.SMSSchema;
import com.sun.identity.sm.SchemaType;
import com.sun.identity.sm.ServiceListener;
import com.sun.identity.sm.ServiceManager;
import com.sun.identity.sm.ServiceSchema;
import com.sun.identity.sm.ServiceSchemaImpl;
import com.sun.identity.sm.ServiceSchemaManagerImpl;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collections;
import java.util.Set;
import org.w3c.dom.Document;
import org.w3c.dom.Node;

public class ServiceSchemaManager {
    private SSOToken token;
    private String serviceName;
    private String version;
    private ServiceSchemaManagerImpl ssm;
    private static Debug debug = SMSEntry.debug;

    public ServiceSchemaManager(String string, SSOToken sSOToken) throws SMSException, SSOException {
        this(sSOToken, string, ServiceManager.serviceDefaultVersion(sSOToken, string));
    }

    public ServiceSchemaManager(SSOToken sSOToken, String string, String string2) throws SMSException, SSOException {
        if (sSOToken == null || string == null || string2 == null) {
            throw new IllegalArgumentException(SMSEntry.bundle.getString("sms-INVALID_PARAMETERS"));
        }
        SMSEntry.validateToken(sSOToken);
        this.token = sSOToken;
        this.serviceName = string;
        this.version = string2;
        this.ssm = ServiceSchemaManagerImpl.getInstance(sSOToken, string, string2);
    }

    public String getName() {
        return this.serviceName;
    }

    public String getVersion() {
        return this.version;
    }

    public String getI18NFileName() {
        return this.ssm.getI18NFileName();
    }

    public void setI18NFileName(String string) throws SMSException, SSOException {
        SMSEntry.validateToken(this.token);
        String string2 = this.ssm.getI18NFileName();
        this.ssm.setI18NFileName(string);
        try {
            this.replaceSchema(this.ssm.getDocument());
        }
        catch (SMSException sMSException) {
            this.ssm.setI18NFileName(string2);
            throw sMSException;
        }
    }

    public String getI18NJarURL() {
        return this.ssm.getI18NJarURL();
    }

    public void setI18NJarURL(String string) throws SMSException, SSOException {
        SMSEntry.validateToken(this.token);
        String string2 = this.ssm.getI18NJarURL();
        this.ssm.setI18NJarURL(string);
        try {
            this.replaceSchema(this.ssm.getDocument());
        }
        catch (SMSException sMSException) {
            this.ssm.setI18NJarURL(string2);
            throw sMSException;
        }
    }

    public String getServiceHierarchy() {
        return this.ssm.getServiceHierarchy();
    }

    public void setServiceHierarchy(String string) throws SMSException, SSOException {
        SMSEntry.validateToken(this.token);
        String string2 = this.getServiceHierarchy();
        this.ssm.setServiceHierarchy(string);
        try {
            this.replaceSchema(this.ssm.getDocument());
        }
        catch (SMSException sMSException) {
            this.ssm.setServiceHierarchy(string2);
            throw sMSException;
        }
    }

    public String getI18NKey() {
        return this.ssm.getI18NKey();
    }

    public void setI18NKey(String string) throws SMSException, SSOException {
        SMSEntry.validateToken(this.token);
        String string2 = this.ssm.getI18NKey();
        this.ssm.setI18NKey(string);
        try {
            this.replaceSchema(this.ssm.getDocument());
        }
        catch (SMSException sMSException) {
            this.ssm.setI18NKey(string2);
            throw sMSException;
        }
    }

    public String getPropertiesViewBeanURL() {
        return this.ssm.getPropertiesViewBeanURL();
    }

    public void setPropertiesViewBeanURL(String string) throws SMSException, SSOException {
        SMSEntry.validateToken(this.token);
        String string2 = this.ssm.getPropertiesViewBeanURL();
        this.ssm.setPropertiesViewBeanURL(string);
        try {
            this.replaceSchema(this.ssm.getDocument());
        }
        catch (SMSException sMSException) {
            this.ssm.setPropertiesViewBeanURL(string2);
            throw sMSException;
        }
    }

    public int getRevisionNumber() {
        return this.ssm.getRevisionNumber();
    }

    public void setRevisionNumber(int n) throws SMSException, SSOException {
        SMSEntry.validateToken(this.token);
        int n2 = this.ssm.getRevisionNumber();
        this.ssm.setRevisionNumber(n);
        try {
            this.replaceSchema(this.ssm.getDocument());
        }
        catch (SMSException sMSException) {
            this.ssm.setRevisionNumber(n2);
            throw sMSException;
        }
    }

    public Set getSchemaTypes() throws SMSException {
        SMSEntry.validateToken(this.token);
        return this.ssm.getSchemaTypes();
    }

    public ServiceSchema getSchema(String string) throws SMSException {
        SchemaType schemaType = null;
        schemaType = string.equalsIgnoreCase("role") || string.equalsIgnoreCase("filteredrole") || string.equalsIgnoreCase("realm") ? SchemaType.DYNAMIC : (string.equalsIgnoreCase("user") ? SchemaType.USER : new SchemaType(string));
        return this.getSchema(schemaType);
    }

    public ServiceSchema getSchema(SchemaType schemaType) throws SMSException {
        SMSEntry.validateToken(this.token);
        ServiceSchemaImpl serviceSchemaImpl = this.ssm.getSchema(schemaType);
        if (serviceSchemaImpl == null && schemaType.equals(SchemaType.USER)) {
            schemaType = SchemaType.DYNAMIC;
            serviceSchemaImpl = this.ssm.getSchema(schemaType);
        }
        if (serviceSchemaImpl != null) {
            return new ServiceSchema(serviceSchemaImpl, "", schemaType, this);
        }
        return null;
    }

    public ServiceSchema getOrganizationCreationSchema() throws SMSException {
        ServiceSchemaImpl serviceSchemaImpl;
        SMSEntry.validateToken(this.token);
        ServiceSchemaImpl serviceSchemaImpl2 = this.ssm.getSchema(SchemaType.ORGANIZATION);
        if (serviceSchemaImpl2 != null && (serviceSchemaImpl = serviceSchemaImpl2.getOrgAttrSchema()) != null) {
            return new ServiceSchema(serviceSchemaImpl, "", SchemaType.ORGANIZATION, this, true);
        }
        return null;
    }

    public Set getServiceAttributeNames(SchemaType schemaType) throws SMSException {
        SMSEntry.validateToken(this.token);
        ServiceSchema serviceSchema = this.getSchema(schemaType);
        return serviceSchema.getServiceAttributeNames();
    }

    public ServiceSchema getGlobalSchema() throws SMSException {
        SMSEntry.validateToken(this.token);
        return this.getSchema(SchemaType.GLOBAL);
    }

    public ServiceSchema getOrganizationSchema() throws SMSException {
        SMSEntry.validateToken(this.token);
        return this.getSchema(SchemaType.ORGANIZATION);
    }

    public ServiceSchema getDynamicSchema() throws SMSException {
        SMSEntry.validateToken(this.token);
        return this.getSchema(SchemaType.DYNAMIC);
    }

    public ServiceSchema getUserSchema() throws SMSException {
        SMSEntry.validateToken(this.token);
        return this.getSchema(SchemaType.USER);
    }

    public ServiceSchema getPolicySchema() throws SMSException {
        SMSEntry.validateToken(this.token);
        return this.getSchema(SchemaType.POLICY);
    }

    public InputStream getSchema() throws SMSException {
        SMSEntry.validateToken(this.token);
        return this.ssm.getSchema();
    }

    public void replaceSchema(InputStream inputStream) throws SSOException, SMSException, IOException {
        SMSEntry.validateToken(this.token);
        CachedSMSEntry cachedSMSEntry = this.ssm.getCachedSMSEntry();
        cachedSMSEntry.writeXMLSchema(this.token, inputStream);
    }

    public boolean equals(Object object) {
        if (object instanceof ServiceSchemaManager) {
            ServiceSchemaManager serviceSchemaManager = (ServiceSchemaManager)object;
            if (this.serviceName.equals(serviceSchemaManager.serviceName) && this.version.equals(serviceSchemaManager.version)) {
                return true;
            }
        }
        return false;
    }

    public String toString() {
        return this.ssm.toString();
    }

    public String addListener(ServiceListener serviceListener) {
        return this.ssm.addListener(serviceListener);
    }

    public void removeListener(String string) {
        this.ssm.removeListener(string);
    }

    public String getLastModifiedTime() throws SMSException, SSOException {
        CachedSMSEntry cachedSMSEntry = this.ssm.getCachedSMSEntry();
        SMSEntry sMSEntry = cachedSMSEntry.getSMSEntry();
        String[] stringArray = sMSEntry.getAttributeValues("modifytimestamp", true);
        String string = null;
        if (stringArray != null) {
            string = stringArray[0];
        }
        return string;
    }

    public Set getPluginInterfaceNames() {
        return this.ssm.getPluginInterfaceNames();
    }

    public PluginInterface getPluginInterface(String string) {
        return this.ssm.getPluginInterface(string);
    }

    public void addPluginInterface(String string, String string2, String string3) throws SMSException, SSOException {
        SMSEntry.validateToken(this.token);
        if (string == null || string2 == null) {
            throw new IllegalArgumentException();
        }
        StringBuffer stringBuffer = new StringBuffer(100);
        stringBuffer.append("<").append("PluginInterface").append(" ").append("name").append("=\"").append(string).append("\" ").append("interface").append("=\"").append(string2).append("\"");
        if (string3 != null) {
            stringBuffer.append(" ").append("i18nKey").append("=\"").append(string3).append("\"");
        }
        stringBuffer.append("></").append("PluginInterface").append(">");
        Document document = SMSSchema.getXMLDocument(stringBuffer.toString(), false);
        Node node = XMLUtils.getRootNode((Document)document, (String)"PluginInterface");
        Document document2 = this.ssm.getDocumentCopy();
        Node node2 = document2.importNode(node, true);
        Node node3 = XMLUtils.getRootNode((Document)document2, (String)"Schema");
        node3.appendChild(node2);
        this.replaceSchema(document2);
    }

    public void removePluginInterface(String string) throws SMSException, SSOException {
        SMSEntry.validateToken(this.token);
        Document document = this.ssm.getDocumentCopy();
        Node node = XMLUtils.getRootNode((Document)document, (String)"Schema");
        Node node2 = XMLUtils.getNamedChildNode((Node)node, (String)"PluginInterface", (String)"name", (String)string);
        if (node2 != null) {
            node.removeChild(node2);
            this.replaceSchema(document);
        }
    }

    public Set getPluginSchemaNames(String string, String string2) throws SMSException {
        SMSEntry.validateToken(this.token);
        StringBuffer stringBuffer = new StringBuffer(100);
        stringBuffer.append("ou=").append(string).append(",").append("ou=PluginConfig,").append("ou=").append(this.version).append(",").append("ou=").append(this.serviceName).append(",").append("ou=services").append(",").append(DNMapper.orgNameToDN(string2));
        CachedSubEntries cachedSubEntries = CachedSubEntries.getInstance(this.token, stringBuffer.toString());
        try {
            return cachedSubEntries.getSubEntries(this.token);
        }
        catch (SSOException sSOException) {
            debug.error("ServiceSchemaManager: Unable to get Plugin Schema Names", (Throwable)sSOException);
            return Collections.EMPTY_SET;
        }
    }

    public PluginSchema getPluginSchema(String string, String string2, String string3) throws SMSException {
        SMSEntry.validateToken(this.token);
        return new PluginSchema(this.token, this.serviceName, this.version, string, string2, string3);
    }

    SSOToken getSSOToken() {
        return this.token;
    }

    protected Document getDocumentCopy() throws SMSException {
        return this.ssm.getDocumentCopy();
    }

    protected synchronized void replaceSchema(Document document) throws SSOException, SMSException {
        CachedSMSEntry cachedSMSEntry = this.ssm.getCachedSMSEntry();
        SMSSchema sMSSchema = new SMSSchema(document);
        cachedSMSEntry.writeXMLSchema(this.token, sMSSchema.getSchema());
    }

    static void createService(SSOToken sSOToken, SMSSchema sMSSchema) throws SMSException, SSOException {
        SMSEntry sMSEntry = new SMSEntry(sSOToken, ServiceManager.getServiceNameDN(sMSSchema.getServiceName()));
        if (sMSEntry.isNewEntry()) {
            sMSEntry.addAttribute("objectclass", "top");
            sMSEntry.addAttribute("objectclass", "sunService");
            sMSEntry.save();
        }
        CachedSMSEntry cachedSMSEntry = CachedSMSEntry.getInstance(sSOToken, ServiceManager.getServiceNameDN(sMSSchema.getServiceName(), sMSSchema.getServiceVersion()), null);
        sMSEntry = cachedSMSEntry.getSMSEntry();
        String[] stringArray = new String[1];
        if (sMSEntry.getAttributeValues("sunServiceSchema") != null && !sMSEntry.getAttributeValues("sunServiceSchema")[0].equalsIgnoreCase(SMSSchema.getDummyXML(sMSSchema.getServiceName(), sMSSchema.getServiceVersion()))) {
            Object[] objectArray = new Object[]{sMSSchema.getServiceName(), sMSSchema.getServiceVersion()};
            throw new SMSException("amSDK", "sms-service_already_exists", objectArray);
        }
        stringArray[0] = sMSSchema.getSchema();
        sMSEntry.setAttribute("sunServiceSchema", stringArray);
        if (sMSEntry.isNewEntry()) {
            sMSEntry.addAttribute("objectclass", "top");
            sMSEntry.addAttribute("objectclass", "sunService");
        }
        sMSEntry.save(sSOToken);
        cachedSMSEntry.refresh(sMSEntry);
    }
}

