/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.sm;

import com.iplanet.am.util.Debug;
import com.iplanet.am.util.XMLUtils;
import com.sun.identity.common.CaseInsensitiveHashMap;
import com.sun.identity.sm.AttributeSchemaImpl;
import com.sun.identity.sm.AttributeValidator;
import com.sun.identity.sm.InvalidAttributeNameException;
import com.sun.identity.sm.InvalidAttributeValueException;
import com.sun.identity.sm.RequiredValueValidator;
import com.sun.identity.sm.SMSEntry;
import com.sun.identity.sm.SMSException;
import com.sun.identity.sm.SMSUtils;
import com.sun.identity.sm.ServiceAttributeValidator;
import com.sun.identity.sm.ServiceSchemaManagerImpl;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

class ServiceSchemaImpl {
    Node schemaNode;
    String name;
    String i18nKey;
    String statusAttribute;
    String validate;
    String inheritance;
    Set serviceAttributes;
    Set searchableAttributeNames;
    Map attrSchemas;
    Map attrValidators;
    Map attrDefaults;
    Map attrReadOnlyDefaults;
    Map subSchemas;
    ServiceSchemaImpl orgAttrSchema;
    ServiceSchemaManagerImpl ssm;
    boolean isOrgAttrSchema;
    String serviceName;
    static Debug debug = SMSEntry.debug;

    ServiceSchemaImpl() {
    }

    protected ServiceSchemaImpl(Node node) {
        this(null, node);
    }

    protected ServiceSchemaImpl(ServiceSchemaManagerImpl serviceSchemaManagerImpl, Node node) {
        this.ssm = serviceSchemaManagerImpl;
        this.update(node);
    }

    String getName() {
        return this.name;
    }

    String getI18NKey() {
        return this.i18nKey == null && this.ssm != null ? this.ssm.getI18NKey() : this.i18nKey;
    }

    String getStatusAttribute() {
        return this.statusAttribute;
    }

    String getValidate() {
        return this.validate;
    }

    boolean supportsMultipleConfigurations() {
        return this.inheritance != null && this.inheritance.equalsIgnoreCase("multiple");
    }

    Set getAttributeSchemaNames() {
        return new HashSet(this.attrSchemas.keySet());
    }

    protected Set getSearchableAttributeNames() {
        HashSet<String> hashSet = new HashSet<String>();
        if (this.searchableAttributeNames != null && !this.searchableAttributeNames.isEmpty()) {
            Iterator iterator = this.searchableAttributeNames.iterator();
            while (iterator.hasNext()) {
                String string = (String)iterator.next();
                if (this.isOrgAttrSchema && !string.toLowerCase().startsWith(this.serviceName.toLowerCase())) {
                    hashSet.add((this.serviceName + "-" + string).toLowerCase());
                    continue;
                }
                hashSet.add(string);
            }
        }
        this.searchableAttributeNames = hashSet;
        return this.searchableAttributeNames;
    }

    Set getServiceAttributeNames() {
        return new HashSet(this.serviceAttributes);
    }

    AttributeSchemaImpl getAttributeSchema(String string) {
        return (AttributeSchemaImpl)this.attrSchemas.get(string);
    }

    Set getAttributeSchemas() {
        return new HashSet(this.attrSchemas.values());
    }

    Map getAttributeDefaults() {
        return SMSUtils.copyAttributes(this.attrDefaults);
    }

    Map getReadOnlyAttributeDefaults() {
        return this.attrReadOnlyDefaults;
    }

    Set getSubSchemaNames() {
        return new HashSet(this.subSchemas.keySet());
    }

    ServiceSchemaImpl getSubSchema(String string) throws SMSException {
        return (ServiceSchemaImpl)this.subSchemas.get(string);
    }

    ServiceSchemaImpl getOrgAttrSchema() {
        return this.orgAttrSchema;
    }

    boolean validateAttributes(Map map, boolean bl) throws SMSException {
        return this.validateAttributes(map, bl, null);
    }

    boolean validateAttributes(Map map, boolean bl, String string) throws SMSException {
        if (this.validate != null && this.validate.equalsIgnoreCase("no")) {
            return true;
        }
        Iterator iterator = map.keySet().iterator();
        while (iterator.hasNext()) {
            String string2 = (String)iterator.next();
            if (string2.equalsIgnoreCase("cospriority")) continue;
            Set set = (Set)map.get(string2);
            this.validateAttrValues(string2, set, bl, string);
        }
        return true;
    }

    public String toString() {
        Iterator iterator;
        StringBuffer stringBuffer = new StringBuffer(100);
        if (this.getName() != null) {
            stringBuffer.append("Schema name: ").append(this.getName()).append("\n");
        }
        if (this.attrSchemas.size() > 0) {
            stringBuffer.append("Attribute Schemas:\n");
            iterator = this.attrSchemas.keySet().iterator();
            while (iterator.hasNext()) {
                stringBuffer.append(this.attrSchemas.get(iterator.next()).toString());
            }
        }
        if (this.subSchemas.size() > 0) {
            stringBuffer.append("Sub-Schemas:\n");
            iterator = this.subSchemas.keySet().iterator();
            while (iterator.hasNext()) {
                stringBuffer.append(this.subSchemas.get(iterator.next()).toString());
            }
        }
        return stringBuffer.toString();
    }

    Node getSchemaNode() {
        return this.schemaNode;
    }

    synchronized void update(Node node) {
        this.schemaNode = node;
        if (this.schemaNode == null) {
            if (debug.warningEnabled()) {
                debug.warning("ServiceSchemaImpl::update schema node is NULL");
            }
            this.name = "";
            this.i18nKey = null;
            this.statusAttribute = null;
            this.serviceAttributes = new HashSet();
            this.searchableAttributeNames = new HashSet();
            this.attrValidators = this.attrDefaults = new HashMap();
            this.attrSchemas = this.attrDefaults;
            this.subSchemas = new CaseInsensitiveHashMap();
            this.attrReadOnlyDefaults = Collections.unmodifiableMap(new HashMap());
        }
        this.name = XMLUtils.getNodeAttributeValue((Node)this.schemaNode, (String)"name");
        this.i18nKey = XMLUtils.getNodeAttributeValue((Node)this.schemaNode, (String)"i18nKey");
        this.statusAttribute = XMLUtils.getNodeAttributeValue((Node)this.schemaNode, (String)"statusAttribute");
        this.inheritance = XMLUtils.getNodeAttributeValue((Node)this.schemaNode, (String)"inheritance");
        this.validate = XMLUtils.getNodeAttributeValue((Node)this.schemaNode, (String)"validate");
        HashSet<String> hashSet = new HashSet<String>();
        HashSet<String> hashSet2 = new HashSet<String>();
        HashMap<String, AttributeSchemaImpl> hashMap = new HashMap<String, AttributeSchemaImpl>();
        HashMap<String, AttributeValidator> hashMap2 = new HashMap<String, AttributeValidator>();
        HashMap<String, Set> hashMap3 = new HashMap<String, Set>();
        CaseInsensitiveHashMap caseInsensitiveHashMap = new CaseInsensitiveHashMap();
        HashMap hashMap4 = new HashMap();
        NodeList nodeList = this.schemaNode.getChildNodes();
        int n = 0;
        while (n < nodeList.getLength()) {
            Object object;
            Node node2 = nodeList.item(n);
            String string = XMLUtils.getNodeAttributeValue((Node)node2, (String)"name");
            if (node2.getNodeName().equals("AttributeSchema")) {
                object = null;
                if (this.attrSchemas != null) {
                    object = (AttributeSchemaImpl)this.attrSchemas.get(string);
                }
                if (object == null) {
                    object = new AttributeSchemaImpl(node2);
                } else {
                    ((AttributeSchemaImpl)object).update(node2);
                }
                hashMap.put(string, (AttributeSchemaImpl)object);
                if (!((AttributeSchemaImpl)object).isStatusAttribute() && !((AttributeSchemaImpl)object).isServiceIdentifier()) {
                    hashSet.add(string);
                }
                if (((AttributeSchemaImpl)object).isSearchable()) {
                    hashSet2.add(string);
                }
                hashMap2.put(string, new AttributeValidator((AttributeSchemaImpl)object));
                hashMap3.put(string, ((AttributeSchemaImpl)object).getDefaultValues());
                hashMap4.put(string, Collections.unmodifiableSet(((AttributeSchemaImpl)object).getDefaultValues()));
            } else if (node2.getNodeName().equals("SubSchema")) {
                object = null;
                if (this.subSchemas != null) {
                    object = (ServiceSchemaImpl)this.subSchemas.get(string);
                }
                if (object == null) {
                    caseInsensitiveHashMap.put(string, new ServiceSchemaImpl(this.ssm, node2));
                } else {
                    ((ServiceSchemaImpl)object).update(node2);
                    caseInsensitiveHashMap.put(string, object);
                }
            } else if (node2.getNodeName().equals("OrganizationAttributeSchema")) {
                this.orgAttrSchema = new ServiceSchemaImpl(this.ssm, node2);
            }
            ++n;
        }
        this.serviceAttributes = hashSet;
        this.attrSchemas = hashMap;
        this.searchableAttributeNames = hashSet2;
        this.attrValidators = hashMap2;
        this.attrDefaults = hashMap3;
        this.attrReadOnlyDefaults = Collections.unmodifiableMap(hashMap4);
        this.subSchemas = caseInsensitiveHashMap;
    }

    AttributeValidator getAttributeValidator(String string) {
        AttributeValidator attributeValidator = (AttributeValidator)this.attrValidators.get(string);
        if (attributeValidator == null) {
            AttributeSchemaImpl attributeSchemaImpl = this.getAttributeSchema(string);
            if (attributeSchemaImpl == null) {
                return null;
            }
            attributeValidator = new AttributeValidator(attributeSchemaImpl);
            this.attrValidators.put(string, attributeValidator);
        }
        return attributeValidator;
    }

    void validateAttrValues(String string, Set set, boolean bl, String string2) throws SMSException {
        Object object;
        String string3;
        if (this.validate != null && this.validate.equalsIgnoreCase("no")) {
            return;
        }
        AttributeValidator attributeValidator = this.getAttributeValidator(string);
        if (attributeValidator == null) {
            if (debug.messageEnabled()) {
                debug.message("ServiceSchemaImpl::validateAttrValues Invalid Attribute: " + string + " in service: " + this.ssm.getName() + " sub-schema: " + this.name);
            }
            Object[] objectArray = new String[]{string};
            throw new InvalidAttributeNameException("amSDK", "sms-validation_failed_invalid_name", objectArray);
        }
        if (string2 != null && (string3 = ((AttributeSchemaImpl)(object = this.getAttributeSchema(string))).getAny()) != null && string3.indexOf("required") > -1 && (set == null || set.isEmpty())) {
            Object[] objectArray = new Object[]{string};
            SMSException sMSException = new SMSException("amSDK", "sms-required-attribute-delete", objectArray);
            debug.error("ServiceSchemaImpl.validateAttrValues: " + string + " is a required attribute and cannot" + " be deleted", (Throwable)sMSException);
            throw sMSException;
        }
        if (string2 != null) {
            object = new HashMap();
            ((HashMap)object).put("organization_name", string2);
            string3 = this.ssm != null ? this.ssm.getI18NFileName() : null;
            attributeValidator.validate(set, string3, bl, (Map)object);
        } else {
            object = this.ssm != null ? this.ssm.getI18NFileName() : null;
            attributeValidator.validate(set, (String)object, bl);
        }
        this.validatePlugin(string, set);
    }

    boolean validatePlugin(String string, Set set) throws SMSException, InvalidAttributeNameException {
        AttributeSchemaImpl attributeSchemaImpl = this.getAttributeSchema(string);
        if (attributeSchemaImpl == null) {
            Object[] objectArray = new String[]{string};
            throw new InvalidAttributeNameException("amSDK", "sms-validation_failed_invalid_name", objectArray);
        }
        String string2 = attributeSchemaImpl.getValidator();
        if (string2 == null) {
            return true;
        }
        AttributeSchemaImpl attributeSchemaImpl2 = this.getAttributeSchema(string2);
        if (attributeSchemaImpl2 == null) {
            if (debug.warningEnabled()) {
                debug.warning("ServiceConfigValidator.validatePlugin: no definition found for the validator " + string2);
            }
            return true;
        }
        Set set2 = attributeSchemaImpl2.getDefaultValues();
        Iterator iterator = set2.iterator();
        while (iterator.hasNext()) {
            String string3 = (String)iterator.next();
            if (debug.messageEnabled()) {
                debug.message("ServiceConfigValidator.validatePlugin: validate the attribute " + string + " by the validator " + string3);
            }
            ServiceAttributeValidator serviceAttributeValidator = null;
            try {
                Class<?> clazz = Class.forName(string3);
                serviceAttributeValidator = (ServiceAttributeValidator)clazz.newInstance();
            }
            catch (Exception exception) {
                debug.error("ServiceConfigValidator.validatePlugin: unable to instantiate the validator class " + string3);
                Object[] objectArray = new String[]{string3};
                throw new SMSException("amSDK", "sms-validator_cannot_instantiate_class", objectArray);
            }
            this.validatePlugin(serviceAttributeValidator, attributeSchemaImpl, string, set);
        }
        return true;
    }

    private void validatePlugin(ServiceAttributeValidator serviceAttributeValidator, AttributeSchemaImpl attributeSchemaImpl, String string, Set set) throws InvalidAttributeValueException {
        if (!serviceAttributeValidator.validate(set)) {
            String string2;
            if (debug.messageEnabled()) {
                debug.message("ServiceSchemaImpl.validatePlugin: validation failed for the the attribute: " + string + " and its values: " + set);
            }
            String string3 = this.ssm != null ? this.ssm.getI18NFileName() : null;
            String string4 = string2 = serviceAttributeValidator instanceof RequiredValueValidator ? "sms-attribute-values-missing" : "sms-attribute-values-does-not-match-schema";
            if (string3 != null) {
                Object[] objectArray = new String[]{string, string3, attributeSchemaImpl.getI18NKey()};
                throw new InvalidAttributeValueException("amSDK", string2, objectArray);
            }
            Object[] objectArray = new String[]{string};
            throw new InvalidAttributeValueException("amSDK", string2, objectArray);
        }
    }
}

