/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.sm;

import com.iplanet.am.util.Debug;
import com.iplanet.am.util.XMLUtils;
import com.iplanet.sso.SSOException;
import com.iplanet.sso.SSOToken;
import com.iplanet.sso.SSOTokenManager;
import com.sun.identity.authentication.config.AMAuthenticationManager;
import com.sun.identity.common.CaseInsensitiveHashMap;
import com.sun.identity.security.AdminTokenAction;
import com.sun.identity.security.EncodeAction;
import com.sun.identity.sm.AttributeSchema;
import com.sun.identity.sm.AttributeSchemaImpl;
import com.sun.identity.sm.CachedSMSEntry;
import com.sun.identity.sm.CachedSubEntries;
import com.sun.identity.sm.CreateServiceConfig;
import com.sun.identity.sm.OrganizationConfigManager;
import com.sun.identity.sm.PluginSchema;
import com.sun.identity.sm.PluginSchemaImpl;
import com.sun.identity.sm.SMSEntry;
import com.sun.identity.sm.SMSException;
import com.sun.identity.sm.SMSSchema;
import com.sun.identity.sm.SMSUtils;
import com.sun.identity.sm.SchemaType;
import com.sun.identity.sm.ServiceConfigImpl;
import com.sun.identity.sm.ServiceConfigManager;
import com.sun.identity.sm.ServiceConfigManagerImpl;
import com.sun.identity.sm.ServiceInstanceImpl;
import com.sun.identity.sm.ServiceNotFoundException;
import com.sun.identity.sm.ServiceSchemaImpl;
import com.sun.identity.sm.ServiceSchemaManager;
import com.sun.identity.sm.ServiceSchemaManagerImpl;
import java.io.InputStream;
import java.security.AccessController;
import java.text.MessageFormat;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentType;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class ServiceManager {
    private static boolean initialized;
    private static boolean loadedAuthServices;
    private static SSOTokenManager ssoTokenManager;
    protected static final String serviceDN;
    protected static final String COEXISTENCE_ATTR_NAME = "coexistenceMode";
    protected static final String REALM_ATTR_NAME = "realmMode";
    protected static final String REALM_SERVICE = "sunidentityrepositoryservice";
    protected static final String DEFAULT_SERVICES_FOR_REALMS = "serviceNamesForAutoAssignment";
    protected static final String SERVICE_VERSION = "1.0";
    protected static final String REALM_ENTRY;
    protected static final String PLATFORM_SERVICE = "iPlanetAMPlatformService";
    protected static final String ATTR_SERVER_LIST = "iplanet-am-platform-server-list";
    private static boolean realmCache;
    private static boolean coexistenceCache;
    private static boolean ditUpgradedCache;
    protected static Set defaultServicesToLoad;
    private static final String SERVICE_OC_ATTR_NAME = "serviceObjectClasses";
    private static final String ALL_SERVICES = "null";
    private static Map serviceNameAndOCs;
    private static Map schemaAndServiceNames;
    protected static SMSEntry smsEntry;
    protected static CachedSubEntries serviceNames;
    protected static HashMap serviceVersions;
    protected static HashMap serviceNameDefaultVersion;
    protected static Set accessManagerServers;
    private SSOToken token;
    private CachedSubEntries subEntries = null;
    protected HashMap serviceSchemaMgrs = new HashMap();
    protected HashMap serviceConfigMgrs = new HashMap();
    protected HashMap organizationConfigMgrs = new HashMap();
    private static Debug debug;

    public ServiceManager(SSOToken sSOToken) throws SSOException, SMSException {
        ServiceManager.initialize(sSOToken);
        ssoTokenManager.validateToken(sSOToken);
        this.token = sSOToken;
    }

    public ServiceSchemaManager getSchemaManager(String string, String string2) throws SMSException, SSOException {
        SMSEntry.validateToken(this.token);
        String string3 = ServiceManager.getCacheIndex(string, string2);
        ServiceSchemaManager serviceSchemaManager = (ServiceSchemaManager)this.serviceSchemaMgrs.get(string3);
        if (serviceSchemaManager == null) {
            serviceSchemaManager = new ServiceSchemaManager(this.token, string, string2);
            if (SMSEntry.cacheSMSEntries) {
                this.serviceSchemaMgrs.put(string3, serviceSchemaManager);
            }
        }
        return serviceSchemaManager;
    }

    public ServiceConfigManager getConfigManager(String string, String string2) throws SMSException, SSOException {
        SMSEntry.validateToken(this.token);
        String string3 = ServiceManager.getCacheIndex(string, string2);
        ServiceConfigManager serviceConfigManager = (ServiceConfigManager)this.serviceConfigMgrs.get(string3);
        if (serviceConfigManager == null) {
            serviceConfigManager = new ServiceConfigManager(this.token, string, string2);
            if (SMSEntry.cacheSMSEntries) {
                this.serviceConfigMgrs.put(string3, serviceConfigManager);
            }
        }
        return serviceConfigManager;
    }

    public OrganizationConfigManager getOrganizationConfigManager(String string) throws SMSException, SSOException {
        SMSEntry.validateToken(this.token);
        OrganizationConfigManager organizationConfigManager = (OrganizationConfigManager)this.organizationConfigMgrs.get(string);
        if (organizationConfigManager == null) {
            organizationConfigManager = new OrganizationConfigManager(this.token, string);
            if (SMSEntry.cacheSMSEntries) {
                this.organizationConfigMgrs.put(string, organizationConfigManager);
            }
        }
        return organizationConfigManager;
    }

    public Set getServiceNames() throws SMSException {
        try {
            if (serviceNames == null) {
                serviceNames = CachedSubEntries.getInstance(this.token, serviceDN);
            }
            return serviceNames.getSubEntries(this.token);
        }
        catch (SSOException sSOException) {
            debug.error("ServiceManager: Unable to get service names", (Throwable)sSOException);
            throw new SMSException(sSOException, "sms-service-not-found");
        }
    }

    public Map getServiceNamesAndOCs() {
        return this.getServiceNamesAndOCs(null);
    }

    public Map getServiceNamesAndOCs(String string) {
        HashMap hashMap;
        block12: {
            if (string == null) {
                string = ALL_SERVICES;
            } else if (string.equalsIgnoreCase("realm")) {
                string = "filteredrole";
            }
            hashMap = (HashMap)serviceNameAndOCs.get(string);
            if (hashMap == null) {
                try {
                    hashMap = new HashMap();
                    Set set = this.getServiceNames();
                    if (set != null && !set.isEmpty()) {
                        Iterator iterator = set.iterator();
                        while (iterator.hasNext()) {
                            try {
                                Map map;
                                ServiceSchemaImpl serviceSchemaImpl;
                                String string2 = (String)iterator.next();
                                ServiceSchemaManagerImpl serviceSchemaManagerImpl = ServiceSchemaManagerImpl.getInstance(this.token, string2, ServiceManager.serviceDefaultVersion(this.token, string2));
                                if (serviceSchemaManagerImpl == null || string != ALL_SERVICES && serviceSchemaManagerImpl.getSchema(new SchemaType(string)) == null && (string.equalsIgnoreCase("User") && serviceSchemaManagerImpl.getSchema(SchemaType.DYNAMIC) == null || string.toLowerCase().indexOf("role") != -1 && serviceSchemaManagerImpl.getSchema(SchemaType.DYNAMIC) == null) || (serviceSchemaImpl = serviceSchemaManagerImpl.getSchema(SchemaType.GLOBAL)) == null || !(map = serviceSchemaImpl.getAttributeDefaults()).containsKey(SERVICE_OC_ATTR_NAME)) continue;
                                hashMap.put(string2, map.get(SERVICE_OC_ATTR_NAME));
                            }
                            catch (SMSException sMSException) {
                                if (!debug.messageEnabled()) continue;
                                debug.message("ServiceManager.getServiceNamesandOCs caught SMSException ", (Throwable)sMSException);
                            }
                        }
                    }
                    serviceNameAndOCs.put(string, hashMap);
                }
                catch (SMSException sMSException) {
                    if (debug.messageEnabled()) {
                        debug.message("ServiceManager.getServiceNamesandOCs caught SMSException ", (Throwable)sMSException);
                    }
                }
                catch (SSOException sSOException) {
                    if (!debug.messageEnabled()) break block12;
                    debug.message("ServiceManager.getServiceNamesandOCs caught SSOException ", (Throwable)sSOException);
                }
            }
        }
        return SMSUtils.copyAttributes(hashMap);
    }

    public Set getServiceVersions(String string) throws SMSException {
        try {
            return ServiceManager.getVersions(this.token, string);
        }
        catch (SSOException sSOException) {
            debug.error("ServiceManager: Unable to get service versions", (Throwable)sSOException);
            throw new SMSException(sSOException, "sms-version-not-found");
        }
    }

    public Set registerServices(InputStream inputStream) throws SMSException, SSOException {
        SMSEntry.validateToken(this.token);
        HashSet<String> hashSet = new HashSet<String>();
        Document document = SMSSchema.getXMLDocument(inputStream);
        if (!this.validSMSDtdDocType(document)) {
            throw new SMSException("amSDK", "sms-invalid-doctype", null);
        }
        NodeList nodeList = document.getElementsByTagName("Service");
        int n = 0;
        while (nodeList != null && n < nodeList.getLength()) {
            Node node;
            Object object;
            Node node2 = nodeList.item(n);
            String string = XMLUtils.getNodeAttributeValue((Node)node2, (String)"name");
            String string2 = XMLUtils.getNodeAttributeValue((Node)node2, (String)"version");
            SMSSchema sMSSchema = new SMSSchema(string, string2, document);
            if (XMLUtils.getChildNode((Node)node2, (String)"Schema") != null) {
                ServiceManager.checkAndEncryptPasswordSyntax(document);
                ServiceManager.validateServiceSchema(node2);
                ServiceSchemaManager.createService(this.token, sMSSchema);
                if (serviceNames == null) {
                    serviceNames = CachedSubEntries.getInstance(this.token, serviceDN);
                }
                serviceNames.add(string);
                object = (CachedSubEntries)serviceVersions.get(string);
                if (object == null) {
                    object = CachedSubEntries.getInstance(this.token, ServiceManager.getServiceNameDN(string));
                    serviceVersions.put(string, object);
                }
                ((CachedSubEntries)object).add(string2);
                hashSet.add(string);
            }
            object = XMLUtils.getChildNodes((Node)node2, (String)"PluginSchema").iterator();
            while (object.hasNext()) {
                node = (Node)object.next();
                PluginSchema.createPluginSchema(this.token, node, sMSSchema);
            }
            node = XMLUtils.getChildNode((Node)node2, (String)"Configuration");
            if (node != null) {
                CreateServiceConfig.createService(this, string, string2, node);
            }
            ++n;
        }
        return hashSet;
    }

    private boolean validSMSDtdDocType(Document document) {
        String string;
        boolean bl = false;
        DocumentType documentType = document.getDoctype();
        if (documentType != null && (string = documentType.getSystemId()) != null) {
            int n = string.lastIndexOf(47);
            if (n != -1) {
                string = string.substring(n + 1);
            }
            bl = string.equals("sms.dtd");
        }
        return bl;
    }

    public void removeService(String string, String string2) throws SMSException, SSOException {
        SMSEntry.validateToken(this.token);
        Object[] objectArray = new String[]{string};
        Iterator iterator = SMSEntry.search(MessageFormat.format("(&(objectclass=top)(ou={0}))", objectArray)).iterator();
        while (iterator.hasNext()) {
            CachedSMSEntry cachedSMSEntry;
            SMSEntry sMSEntry;
            Iterator iterator2;
            String string3 = (String)iterator.next();
            String string4 = "ou=" + string2 + "," + string3;
            CachedSMSEntry cachedSMSEntry2 = CachedSMSEntry.getInstance(this.token, string4, null);
            SMSEntry sMSEntry2 = cachedSMSEntry2.getClonedSMSEntry();
            if (!sMSEntry2.isNewEntry()) {
                sMSEntry2.delete(this.token);
                cachedSMSEntry2.refresh(sMSEntry2);
            }
            if ((iterator2 = (sMSEntry = (cachedSMSEntry = CachedSMSEntry.getInstance(this.token, string3, null)).getSMSEntry()).subEntries(this.token, "*", 0, false, false).iterator()).hasNext()) continue;
            sMSEntry.delete(this.token);
            cachedSMSEntry.refresh(sMSEntry);
        }
    }

    public void deleteService(String string) throws SMSException, SSOException {
        Iterator iterator = this.getServiceVersions(string).iterator();
        while (iterator.hasNext()) {
            String string2 = (String)iterator.next();
            CachedSMSEntry cachedSMSEntry = CachedSMSEntry.getInstance(this.token, ServiceManager.getServiceNameDN(string, string2), null);
            SMSEntry sMSEntry = cachedSMSEntry.getClonedSMSEntry();
            String[] stringArray = new String[]{SMSSchema.getDummyXML(string, string2)};
            sMSEntry.setAttribute("sunServiceSchema", stringArray);
            sMSEntry.save(this.token);
            cachedSMSEntry.refresh(sMSEntry);
        }
    }

    public static String getBaseDN() {
        return SMSEntry.baseDN;
    }

    public static Set getAMServerInstances() {
        if (accessManagerServers == null) {
            try {
                SSOToken sSOToken = (SSOToken)AccessController.doPrivileged(AdminTokenAction.getInstance());
                ServiceSchemaManagerImpl serviceSchemaManagerImpl = ServiceSchemaManagerImpl.getInstance(sSOToken, PLATFORM_SERVICE, SERVICE_VERSION);
                ServiceSchemaImpl serviceSchemaImpl = serviceSchemaManagerImpl.getSchema(SchemaType.GLOBAL);
                AttributeSchemaImpl attributeSchemaImpl = serviceSchemaImpl.getAttributeSchema(ATTR_SERVER_LIST);
                Set set = attributeSchemaImpl.getDefaultValues();
                HashSet<String> hashSet = new HashSet<String>();
                Iterator iterator = set.iterator();
                while (iterator.hasNext()) {
                    String string = (String)iterator.next();
                    int n = string.indexOf("|");
                    if (n != -1) {
                        string = string.substring(0, n);
                    }
                    hashSet.add(string);
                }
                accessManagerServers = hashSet;
                if (debug.messageEnabled()) {
                    debug.message("ServiceManager::getAMServers server list: " + hashSet);
                }
            }
            catch (SMSException sMSException) {
                debug.error("ServiceManager::getAMServers unable to get server list", (Throwable)sMSException);
            }
            catch (SSOException sSOException) {
                debug.error("ServiceManager::getAMServers unable to get server list", (Throwable)sSOException);
            }
        }
        return accessManagerServers == null ? new HashSet() : new HashSet(accessManagerServers);
    }

    public Set searchOrganizationNames(String string, String string2, Set set) throws SMSException, SSOException {
        try {
            if (this.subEntries == null) {
                this.subEntries = CachedSubEntries.getInstance(this.token, "ou=services," + SMSEntry.baseDN);
            }
            return this.subEntries.searchOrgNames(this.token, string.toLowerCase(), string2, set);
        }
        catch (SSOException sSOException) {
            debug.error("OrganizationConfigManagerImpl: Unable to get sub organization names", (Throwable)sSOException);
            throw new SMSException(SMSEntry.bundle.getString("sms-INVALID_SSO_TOKEN"), "sms-INVALID_SSO_TOKEN");
        }
    }

    public synchronized void clearCache() {
        this.serviceSchemaMgrs = new HashMap();
        this.serviceConfigMgrs = new HashMap();
        CachedSMSEntry.clearCache();
        ServiceSchemaManagerImpl.clearCache();
        PluginSchemaImpl.clearCache();
        ServiceInstanceImpl.clearCache();
        ServiceConfigImpl.clearCache();
    }

    public static boolean isCoexistenceMode() {
        ServiceManager.isRealmEnabled();
        return coexistenceCache;
    }

    public static boolean isRealmEnabled() {
        if (!initialized) {
            try {
                ServiceManager.initialize((SSOToken)AccessController.doPrivileged(AdminTokenAction.getInstance()));
            }
            catch (Exception exception) {
                debug.error("ServiceManager::isRealmEnabled unable to initialize", (Throwable)exception);
            }
        }
        return realmCache;
    }

    public static boolean isConfigMigratedTo70() {
        ServiceManager.isRealmEnabled();
        return ditUpgradedCache;
    }

    SSOToken getSSOToken() {
        return this.token;
    }

    protected static String getCacheIndex(String string, String string2) {
        StringBuffer stringBuffer = new StringBuffer(20);
        return stringBuffer.append(string).append(string2).toString().toLowerCase();
    }

    protected static String getServiceNameDN(String string) {
        StringBuffer stringBuffer = new StringBuffer(100);
        stringBuffer.append("ou").append("=").append(string).append(",").append(serviceDN);
        return stringBuffer.toString();
    }

    protected static String getServiceNameDN(String string, String string2) {
        StringBuffer stringBuffer = new StringBuffer(100);
        stringBuffer.append("ou").append("=").append(string2).append(",").append(ServiceManager.getServiceNameDN(string));
        return stringBuffer.toString();
    }

    protected static Set getVersions(SSOToken sSOToken, String string) throws SMSException, SSOException {
        CachedSubEntries cachedSubEntries = (CachedSubEntries)serviceVersions.get(string);
        if (cachedSubEntries == null) {
            cachedSubEntries = CachedSubEntries.getInstance(sSOToken, ServiceManager.getServiceNameDN(string));
            if (cachedSubEntries == null || cachedSubEntries.getSMSEntry().isNewEntry() || cachedSubEntries.getSubEntries(sSOToken).isEmpty()) {
                Object[] objectArray = new String[]{string};
                throw new ServiceNotFoundException("amSDK", "sms-service_does_not_exist", objectArray);
            }
            serviceVersions.put(string, cachedSubEntries);
        }
        return cachedSubEntries.getSubEntries(sSOToken);
    }

    protected static String serviceDefaultVersion(SSOToken sSOToken, String string) throws SMSException, SSOException {
        String string2 = (String)serviceNameDefaultVersion.get(string);
        if (string2 == null) {
            Iterator iterator = ServiceManager.getVersions(sSOToken, string).iterator();
            if (!iterator.hasNext()) {
                Object[] objectArray = new String[]{string};
                throw new ServiceNotFoundException("amSDK", "sms-service_does_not_exist", objectArray);
            }
            string2 = (String)iterator.next();
            serviceNameDefaultVersion.put(string, string2);
        }
        return string2;
    }

    protected static void checkServiceNameAndVersion(SSOToken sSOToken, String string, String string2) throws SMSException, SSOException {
        Set set = ServiceManager.getVersions(sSOToken, string);
        if (set == null || !set.contains(string2)) {
            Object[] objectArray = new String[]{string};
            throw new ServiceNotFoundException("amSDK", "sms-service_does_not_exist", objectArray);
        }
    }

    protected static void checkAndEncryptPasswordSyntax(Document document) throws SMSException {
        NodeList nodeList = document.getElementsByTagName("AttributeSchema");
        int n = 0;
        while (n < nodeList.getLength()) {
            Node node = nodeList.item(n);
            String string = XMLUtils.getNodeAttributeValue((Node)node, (String)"syntax");
            if (string.equals(AttributeSchema.Syntax.PASSWORD.toString())) {
                Node node2;
                if (debug.messageEnabled()) {
                    debug.message("ServiceManager: encrypting password syntax");
                }
                if ((node2 = XMLUtils.getChildNode((Node)node, (String)"DefaultValues")) != null) {
                    Iterator iterator = XMLUtils.getChildNodes((Node)node2, (String)"Value").iterator();
                    while (iterator.hasNext()) {
                        Node node3 = (Node)iterator.next();
                        String string2 = XMLUtils.getValueOfValueNode((Node)node3);
                        String string3 = (String)AccessController.doPrivileged(new EncodeAction(string2));
                        StringBuffer stringBuffer = new StringBuffer(100);
                        stringBuffer.append("<Value>").append(string3).append("</Value>");
                        Document document2 = SMSSchema.getXMLDocument(stringBuffer.toString(), false);
                        Node node4 = XMLUtils.getRootNode((Document)document2, (String)"Value");
                        Node node5 = document.importNode(node4, true);
                        node2.replaceChild(node5, node3);
                    }
                }
            }
            ++n;
        }
    }

    protected static boolean validateServiceSchema(Node node) throws SMSException {
        Node node2 = XMLUtils.getChildNode((Node)node, (String)"Schema");
        String[] stringArray = new String[]{"Global", "Organization", "Dynamic", "User", "Policy", "Group", "Domain"};
        int n = 0;
        while (n < stringArray.length) {
            Node node3 = XMLUtils.getChildNode((Node)node2, (String)stringArray[n]);
            if (node3 != null) {
                ServiceSchemaImpl serviceSchemaImpl = new ServiceSchemaImpl(null, node3);
                Map map = serviceSchemaImpl.getAttributeDefaults();
                serviceSchemaImpl.validateAttributes(map, false);
            }
            ++n;
        }
        return true;
    }

    protected static void schemaChanged() {
        serviceNameAndOCs = new CaseInsensitiveHashMap();
        schemaAndServiceNames = new CaseInsensitiveHashMap();
        serviceNames = null;
    }

    public static Set servicesAssignedByDefault() {
        if (!loadedAuthServices) {
            defaultServicesToLoad.addAll(AMAuthenticationManager.getAuthenticationServiceNames());
            if (debug.messageEnabled()) {
                debug.message("ServiceManager::servicesAssignedByDefault:defaultServicesToLoad = " + defaultServicesToLoad);
            }
            loadedAuthServices = true;
            defaultServicesToLoad = Collections.unmodifiableSet(defaultServicesToLoad);
        }
        return defaultServicesToLoad;
    }

    static void initialize(SSOToken sSOToken) throws SMSException, SSOException {
        SMSEntry.validateToken(sSOToken);
        if (initialized) {
            return;
        }
        try {
            serviceNames = CachedSubEntries.getInstance(sSOToken, serviceDN);
            if (serviceNames.getSMSEntry().isNewEntry()) {
                if (debug.warningEnabled()) {
                    debug.warning("SeviceManager:: Root service node does not exists: " + serviceDN);
                }
                Object[] objectArray = new String[]{serviceDN};
                throw new SMSException("amSDK", "sms-services_node_does_not_exist", objectArray);
            }
        }
        catch (SMSException sMSException) {
            debug.error("ServiceManager::unable to get services node: " + serviceDN, (Throwable)sMSException);
            throw sMSException;
        }
        ServiceManager.checkFlags(sSOToken);
        initialized = true;
    }

    static void checkFlags(SSOToken sSOToken) throws SMSException, SSOException {
        try {
            CachedSMSEntry cachedSMSEntry = CachedSMSEntry.getInstance(sSOToken, REALM_ENTRY, null);
            if (!cachedSMSEntry.isNewEntry()) {
                Set set;
                ditUpgradedCache = true;
                ServiceConfigManagerImpl serviceConfigManagerImpl = ServiceConfigManagerImpl.getInstance(sSOToken, REALM_SERVICE, SERVICE_VERSION);
                ServiceConfigImpl serviceConfigImpl = null;
                Map map = null;
                if (serviceConfigManagerImpl == null || (serviceConfigImpl = serviceConfigManagerImpl.getGlobalConfig(sSOToken, null)) == null || (map = serviceConfigImpl.getAttributes()) == null) {
                    return;
                }
                Set set2 = (Set)map.get(COEXISTENCE_ATTR_NAME);
                if (set2 != null && set2.contains("false")) {
                    coexistenceCache = false;
                }
                if ((set = (Set)map.get(REALM_ATTR_NAME)) != null && set.contains("true")) {
                    realmCache = true;
                }
                defaultServicesToLoad = (Set)map.get(DEFAULT_SERVICES_FOR_REALMS);
            }
            if (debug.messageEnabled()) {
                debug.message("ServiceManager::checkFlags:realmEnabled=" + realmCache);
                debug.message("ServiceManager::checkFlags:coexistenceMode=" + coexistenceCache);
            }
        }
        catch (SMSException sMSException) {
            debug.error("ServiceManager::unable to check if Realm is enabled: ", (Throwable)sMSException);
            throw sMSException;
        }
    }

    static {
        ssoTokenManager = SMSEntry.tm;
        serviceDN = "ou=services," + SMSEntry.baseDN;
        REALM_ENTRY = "ou=1.0,ou=sunidentityrepositoryservice," + serviceDN;
        coexistenceCache = true;
        serviceNameAndOCs = new CaseInsensitiveHashMap();
        schemaAndServiceNames = new HashMap();
        serviceVersions = new HashMap();
        serviceNameDefaultVersion = new CaseInsensitiveHashMap();
        debug = SMSEntry.debug;
    }
}

