/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.sm;

import com.iplanet.am.util.XMLUtils;
import com.iplanet.sso.SSOException;
import com.iplanet.sso.SSOToken;
import com.iplanet.sso.SSOTokenManager;
import com.sun.identity.sm.CachedSMSEntry;
import com.sun.identity.sm.CachedSubEntries;
import com.sun.identity.sm.CreateServiceConfig;
import com.sun.identity.sm.DNMapper;
import com.sun.identity.sm.OrgConfigViaAMSDK;
import com.sun.identity.sm.PluginConfig;
import com.sun.identity.sm.PluginConfigImpl;
import com.sun.identity.sm.SMSEntry;
import com.sun.identity.sm.SMSException;
import com.sun.identity.sm.SMSSchema;
import com.sun.identity.sm.SchemaType;
import com.sun.identity.sm.ServiceAlreadyExistsException;
import com.sun.identity.sm.ServiceConfig;
import com.sun.identity.sm.ServiceConfigImpl;
import com.sun.identity.sm.ServiceConfigManagerImpl;
import com.sun.identity.sm.ServiceInstance;
import com.sun.identity.sm.ServiceListener;
import com.sun.identity.sm.ServiceManager;
import com.sun.identity.sm.ServiceSchemaImpl;
import com.sun.identity.sm.ServiceSchemaManagerImpl;
import java.io.InputStream;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class ServiceConfigManager {
    private SSOToken token;
    private String serviceName;
    private String version;
    private String serviceDN;
    private ServiceSchemaManagerImpl ssm;
    private ServiceConfigManagerImpl scm;
    private static Map instanceObjects;
    private static Map groupObjects;
    private static Map serviceNameToVersion;

    public ServiceConfigManager(String string, SSOToken sSOToken) throws SMSException, SSOException {
        this(sSOToken, string, ServiceManager.serviceDefaultVersion(sSOToken, string));
    }

    public ServiceConfigManager(SSOToken sSOToken, String string, String string2) throws SMSException, SSOException {
        if (sSOToken == null || string == null || string2 == null) {
            throw new IllegalArgumentException(SMSEntry.bundle.getString("sms-INVALID_PARAMETERS"));
        }
        SSOTokenManager.getInstance().validateToken(sSOToken);
        this.scm = ServiceConfigManagerImpl.getInstance(sSOToken, string, string2);
        this.ssm = this.scm.getServiceSchemaManagerImpl();
        this.token = sSOToken;
        this.serviceName = string;
        this.version = string2;
    }

    public String getName() {
        return this.serviceName;
    }

    public String getVersion() {
        return this.version;
    }

    public Set getInstanceNames() throws SMSException {
        try {
            return this.scm.getInstanceNames(this.token);
        }
        catch (SSOException sSOException) {
            SMSEntry.debug.error("ServiceConfigManager: Unable to get Instance Names", (Throwable)sSOException);
            return Collections.EMPTY_SET;
        }
    }

    public Set getGroupNames() throws SMSException {
        try {
            return this.scm.getGroupNames(this.token);
        }
        catch (SSOException sSOException) {
            SMSEntry.debug.error("ServiceConfigManager: Unable to get Group Names", (Throwable)sSOException);
            return Collections.EMPTY_SET;
        }
    }

    public ServiceInstance getInstance(String string) throws SMSException, SSOException {
        return new ServiceInstance(this, this.scm.getInstance(this.token, string));
    }

    public void removeInstance(String string) throws SMSException, SSOException {
        this.getInstance(string).delete();
    }

    public ServiceConfig getGlobalConfig(String string) throws SMSException, SSOException {
        ServiceConfigImpl serviceConfigImpl = this.scm.getGlobalConfig(this.token, string);
        return serviceConfigImpl == null ? null : new ServiceConfig(this, serviceConfigImpl);
    }

    public ServiceConfig getOrganizationConfig(String string, String string2) throws SMSException, SSOException {
        ServiceConfigImpl serviceConfigImpl = this.scm.getOrganizationConfig(this.token, string, string2);
        return serviceConfigImpl == null ? null : new ServiceConfig(this, serviceConfigImpl);
    }

    public ServiceConfig createGlobalConfig(Map map) throws SMSException, SSOException {
        ServiceSchemaImpl serviceSchemaImpl = this.ssm.getSchema(SchemaType.GLOBAL);
        if (serviceSchemaImpl == null) {
            Object[] objectArray = new String[]{this.serviceName};
            throw new SMSException("amSDK", "sms-service-does-not-have-global-schema", objectArray);
        }
        String string = this.scm.constructServiceConfigDN("default", "ou=GlobalConfig,", null);
        try {
            CreateServiceConfig.createSubConfigEntry(this.token, string, serviceSchemaImpl, null, null, map, SMSEntry.baseDN);
        }
        catch (ServiceAlreadyExistsException serviceAlreadyExistsException) {
            // empty catch block
        }
        return this.getGlobalConfig(null);
    }

    public ServiceConfig createOrganizationConfig(String string, Map map) throws SMSException, SSOException {
        ServiceSchemaImpl serviceSchemaImpl = this.ssm.getSchema(SchemaType.ORGANIZATION);
        if (serviceSchemaImpl == null) {
            Object[] objectArray = new String[]{this.serviceName};
            throw new SMSException("amSDK", "sms-service-does-not-have-org-schema", objectArray);
        }
        String string2 = DNMapper.orgNameToDN(string);
        CreateServiceConfig.checkBaseNodesForOrg(this.token, string2, this.serviceName, this.version);
        String string3 = this.scm.constructServiceConfigDN("default", "ou=OrganizationConfig,", string2);
        try {
            CachedSMSEntry cachedSMSEntry = CachedSMSEntry.getInstance(this.token, string3, null);
            if (cachedSMSEntry.isNewEntry()) {
                CreateServiceConfig.createSubConfigEntry(this.token, string3, serviceSchemaImpl, null, null, map, string);
                if (ServiceManager.isCoexistenceMode()) {
                    String string4 = DNMapper.orgNameToDN(string);
                    OrgConfigViaAMSDK orgConfigViaAMSDK = new OrgConfigViaAMSDK(this.token, DNMapper.realmNameToAMSDKName(string4), string4);
                    orgConfigViaAMSDK.assignService(this.serviceName);
                }
            } else if (map != null && !map.isEmpty()) {
                ServiceConfig serviceConfig = this.getOrganizationConfig(string, null);
                serviceConfig.setAttributes(map);
            }
        }
        catch (ServiceAlreadyExistsException serviceAlreadyExistsException) {
            // empty catch block
        }
        return this.getOrganizationConfig(string, null);
    }

    public void addConfiguration(InputStream inputStream) throws SMSException, SSOException {
        ServiceManager serviceManager = new ServiceManager(this.token);
        Document document = SMSSchema.getXMLDocument(inputStream);
        NodeList nodeList = document.getElementsByTagName("Service");
        int n = 0;
        while (nodeList != null && n < nodeList.getLength()) {
            Node node;
            Node node2 = nodeList.item(n);
            String string = XMLUtils.getNodeAttributeValue((Node)node2, (String)"name");
            String string2 = XMLUtils.getNodeAttributeValue((Node)node2, (String)"version");
            if (string.equals(this.serviceName) && string2.equals(this.version) && (node = XMLUtils.getChildNode((Node)node2, (String)"Configuration")) != null) {
                CreateServiceConfig.createService(serviceManager, string, string2, node);
            }
            ++n;
        }
    }

    public void removeGlobalConfiguration(String string) throws SMSException, SSOException {
        if (string == null || string.equals("")) {
            string = "default";
        }
        String string2 = this.scm.constructServiceConfigDN(string, "ou=GlobalConfig,", null);
        CachedSMSEntry cachedSMSEntry = CachedSMSEntry.getInstance(this.token, string2, null);
        SMSEntry sMSEntry = cachedSMSEntry.getClonedSMSEntry();
        sMSEntry.delete(this.token);
        cachedSMSEntry.refresh(sMSEntry);
    }

    public void deleteOrganizationConfig(String string) throws SMSException, SSOException {
        this.removeOrganizationConfiguration(string, "default");
    }

    public void removeOrganizationConfiguration(String string, String string2) throws SMSException, SSOException {
        this.removeOrganizationConfiguration(string, string2, true);
    }

    public void removeOrganizationConfiguration(String string, String string2, boolean bl) throws SMSException, SSOException {
        Object object;
        String string3;
        String string4;
        CachedSMSEntry cachedSMSEntry;
        if (string2 == null || string2.equals("")) {
            string2 = "default";
        }
        if ((cachedSMSEntry = CachedSMSEntry.getInstance(this.token, string4 = this.scm.constructServiceConfigDN(string2, "ou=OrganizationConfig,", string3 = DNMapper.orgNameToDN(string)), null)).isNewEntry()) {
            return;
        }
        if (bl && ServiceManager.isCoexistenceMode() && string2.equalsIgnoreCase("default")) {
            object = new OrgConfigViaAMSDK(this.token, DNMapper.realmNameToAMSDKName(string3), string3);
            ((OrgConfigViaAMSDK)object).unassignService(this.serviceName);
        }
        if (!cachedSMSEntry.isNewEntry()) {
            object = cachedSMSEntry.getClonedSMSEntry();
            ((SMSEntry)object).delete(this.token);
            cachedSMSEntry.refresh((SMSEntry)object);
        }
    }

    public Set getPluginConfigNames(String string, String string2, String string3) throws SMSException, SSOException {
        StringBuffer stringBuffer = new StringBuffer(100);
        stringBuffer.append("ou=").append(string).append(",ou=").append(string2).append(",").append("ou=PluginConfig,").append("ou=").append(this.version).append(",").append("ou=").append(this.serviceName).append(",").append("ou=services").append(",").append(DNMapper.orgNameToDN(string3));
        CachedSMSEntry.getInstance(this.token, stringBuffer.toString(), null);
        CachedSubEntries cachedSubEntries = CachedSubEntries.getInstance(this.token, stringBuffer.toString());
        return cachedSubEntries.getSubEntries(this.token);
    }

    public PluginConfig getPluginConfig(String string, String string2, String string3, String string4) throws SMSException, SSOException {
        PluginConfigImpl pluginConfigImpl = this.scm.getPluginConfig(this.token, string, string2, string3, string4);
        return new PluginConfig(string, this, pluginConfigImpl);
    }

    public void removePluginConfig(String string, String string2, String string3, String string4) throws SMSException, SSOException {
        PluginConfig pluginConfig = this.getPluginConfig(string, string2, string3, string4);
        if (pluginConfig != null) {
            pluginConfig.delete();
        }
    }

    public String addListener(ServiceListener serviceListener) {
        return this.scm.addListener(serviceListener);
    }

    public void removeListener(String string) {
        this.scm.removeListener(string);
    }

    public boolean equals(Object object) {
        if (object instanceof ServiceConfigManager) {
            ServiceConfigManager serviceConfigManager = (ServiceConfigManager)object;
            if (this.serviceName.equals(serviceConfigManager.serviceName) && this.version.equals(serviceConfigManager.version)) {
                return true;
            }
        }
        return false;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("\nService Config Manager: ").append(this.serviceName).append("\n\tVersion: ").append(this.version);
        try {
            Iterator iterator = this.getInstanceNames().iterator();
            while (iterator.hasNext()) {
                String string = (String)iterator.next();
                stringBuffer.append(this.getInstance(string));
                ServiceConfig serviceConfig = null;
                try {
                    serviceConfig = this.getGlobalConfig(string);
                    if (serviceConfig != null) {
                        stringBuffer.append("\nGlobal Configuation:\n").append(serviceConfig);
                    }
                }
                catch (SMSException sMSException) {
                    // empty catch block
                }
                try {
                    serviceConfig = this.getOrganizationConfig(null, string);
                    if (serviceConfig == null) continue;
                    stringBuffer.append("Org Configuation:\n").append(serviceConfig);
                }
                catch (SMSException sMSException) {
                    // empty catch block
                }
            }
            stringBuffer.append("\n");
        }
        catch (SMSException sMSException) {
            stringBuffer.append(sMSException.getMessage());
        }
        catch (SSOException sSOException) {
            stringBuffer.append(sSOException.getMessage());
        }
        return stringBuffer.toString();
    }

    SSOToken getSSOToken() {
        return this.token;
    }

    boolean containsGroup(String string) throws SMSException, SSOException {
        return this.scm.containsGroup(this.token, string);
    }

    static {
        serviceNameToVersion = new HashMap();
    }
}

