/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.sm;

import com.iplanet.sso.SSOException;
import com.iplanet.sso.SSOToken;
import com.sun.identity.sm.CachedSMSEntry;
import com.sun.identity.sm.CachedSubEntries;
import com.sun.identity.sm.CreateServiceConfig;
import com.sun.identity.sm.DNMapper;
import com.sun.identity.sm.SMSEntry;
import com.sun.identity.sm.SMSException;
import com.sun.identity.sm.SMSUtils;
import com.sun.identity.sm.ServiceConfigImpl;
import com.sun.identity.sm.ServiceConfigManager;
import com.sun.identity.sm.ServiceSchemaImpl;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import netscape.ldap.util.DN;

public class ServiceConfig {
    private SSOToken token;
    private ServiceConfigImpl sc;
    private ServiceSchemaImpl ss;
    private ServiceConfigManager scm;

    private ServiceConfig() {
    }

    protected ServiceConfig(ServiceConfigManager serviceConfigManager, ServiceConfigImpl serviceConfigImpl) throws SMSException, SSOException {
        this.scm = serviceConfigManager;
        this.token = serviceConfigManager.getSSOToken();
        this.sc = serviceConfigImpl;
        this.ss = serviceConfigImpl.getServiceSchemaImpl();
    }

    public String getServiceName() {
        return this.scm.getName();
    }

    public String getVersion() {
        return this.scm.getVersion();
    }

    public String getComponentName() {
        return this.sc.getComponentName();
    }

    public String getSchemaID() {
        return this.sc.getSchemaID();
    }

    public int getPriority() {
        return this.sc.getPriority();
    }

    public void setPriority(int n) throws SSOException, SMSException {
        StringBuffer stringBuffer = new StringBuffer(8);
        String[] stringArray = new String[]{stringBuffer.append(n).toString()};
        SMSEntry sMSEntry = this.sc.getSMSEntry();
        sMSEntry.setAttribute("sunsmspriority", stringArray);
        this.saveSMSEntry(sMSEntry);
    }

    public Set getSubConfigNames() throws SMSException {
        try {
            return this.sc.getSubConfigNames(this.token);
        }
        catch (SSOException sSOException) {
            SMSEntry.debug.error("ServiceConfig: Unable to get subConfig Names", (Throwable)sSOException);
            return Collections.EMPTY_SET;
        }
    }

    public Set getSubConfigNames(String string) throws SMSException {
        try {
            return this.sc.getSubConfigNames(this.token, string);
        }
        catch (SSOException sSOException) {
            SMSEntry.debug.error("ServiceConfigManager: Unable to get subConfig Names for filter: " + string, (Throwable)sSOException);
            return Collections.EMPTY_SET;
        }
    }

    public Set getSubConfigNames(String string, String string2) throws SMSException {
        try {
            return this.sc.getSubConfigNames(string, string2);
        }
        catch (SSOException sSOException) {
            SMSEntry.debug.error("ServiceConfigManager: Unable to get subConfig Names for filters: " + string + "AND" + string2, (Throwable)sSOException);
            return Collections.EMPTY_SET;
        }
    }

    public Set getExportedSubConfigNames(String string) throws SMSException {
        return null;
    }

    public ServiceConfig getSubConfig(String string) throws SSOException, SMSException {
        ServiceConfigImpl serviceConfigImpl = this.sc.getSubConfig(this.token, string);
        return serviceConfigImpl == null ? null : new ServiceConfig(this.scm, serviceConfigImpl);
    }

    public void addSubConfig(String string, String string2, int n, Map map) throws SMSException, SSOException {
        if (this.sc.isNewEntry()) {
            this.scm.createOrganizationConfig(this.sc.getOrganizationName(), null);
            this.checkAndCreateComponents(this.sc.getDN());
        }
        ServiceSchemaImpl serviceSchemaImpl = null;
        serviceSchemaImpl = string2 != null ? this.ss.getSubSchema(string2) : this.ss.getSubSchema(string);
        if (serviceSchemaImpl == null) {
            Object[] objectArray = new String[]{string};
            throw new SMSException("amSDK", "sms-invalid-add-sub-config", objectArray);
        }
        if (!serviceSchemaImpl.supportsMultipleConfigurations() && !this.getSubConfigNames().isEmpty()) {
            Object[] objectArray = new String[]{string};
            throw new SMSException("amSDK", "sms-invalid-add-sub-config", objectArray);
        }
        StringBuffer stringBuffer = new StringBuffer(8);
        stringBuffer.append(n);
        CreateServiceConfig.createSubConfigEntry(this.token, "ou=" + string + "," + this.sc.getDN(), serviceSchemaImpl, string2, stringBuffer.toString(), map, this.sc.getOrganizationName());
    }

    public void removeSubConfig(String string) throws SMSException, SSOException {
        CachedSMSEntry cachedSMSEntry = CachedSMSEntry.getInstance(this.token, "ou=" + string + "," + this.sc.getDN(), null);
        SMSEntry sMSEntry = cachedSMSEntry.getClonedSMSEntry();
        sMSEntry.delete(this.token);
        cachedSMSEntry.refresh(sMSEntry);
        CachedSubEntries cachedSubEntries = CachedSubEntries.getInstance(this.token, this.sc.getDN());
        cachedSubEntries.remove(string);
    }

    public void importSubConfig(String string, String string2) throws SMSException, SSOException {
    }

    public Map getAttributes() {
        return this.sc.getAttributes();
    }

    public Map getAttributesWithoutDefaults() {
        return this.sc.getAttributesWithoutDefaults();
    }

    public void setAttributes(Map map) throws SMSException, SSOException {
        Object object;
        Map map2 = this.sc.getAttributesWithoutDefaults();
        Iterator iterator = map2.keySet().iterator();
        Map map3 = SMSUtils.copyAttributes(map);
        while (iterator.hasNext()) {
            object = (String)iterator.next();
            if (map3.containsKey(object)) continue;
            map3.put(object, map2.get(object));
        }
        this.ss.validateAttributes(map3, true, this.sc.getOrganizationName());
        object = this.sc.getSMSEntry();
        SMSUtils.setAttributeValuePairs((SMSEntry)object, map3, this.ss.getSearchableAttributeNames());
        this.saveSMSEntry((SMSEntry)object);
    }

    public void addAttribute(String string, Set hashSet) throws SMSException, SSOException {
        Map map = this.getAttributes();
        HashSet hashSet2 = hashSet;
        Set set = (Set)map.get(string);
        if (set != null) {
            hashSet2 = new HashSet();
            hashSet2.addAll(hashSet);
            hashSet2.addAll(set);
        }
        this.ss.validateAttrValues(string, hashSet2, true, this.sc.getOrganizationName());
        SMSEntry sMSEntry = this.sc.getSMSEntry();
        SMSUtils.addAttribute(sMSEntry, string, hashSet, this.ss.getSearchableAttributeNames());
        this.saveSMSEntry(sMSEntry);
    }

    public void removeAttribute(String string) throws SMSException, SSOException {
        SMSEntry sMSEntry = this.sc.getSMSEntry();
        SMSUtils.removeAttribute(sMSEntry, string);
        this.saveSMSEntry(sMSEntry);
    }

    public void removeAttributes(Set set) throws SMSException, SSOException {
        SMSEntry sMSEntry = this.sc.getSMSEntry();
        if (set != null && !set.isEmpty()) {
            Iterator iterator = set.iterator();
            while (iterator.hasNext()) {
                SMSUtils.removeAttribute(sMSEntry, (String)iterator.next());
            }
            this.saveSMSEntry(sMSEntry);
        }
    }

    public void removeAttributeValues(String string, Set set) throws SMSException, SSOException {
        SMSEntry sMSEntry = this.sc.getSMSEntry();
        SMSUtils.removeAttributeValues(sMSEntry, string, set, this.ss.getSearchableAttributeNames());
        this.saveSMSEntry(sMSEntry);
    }

    public void replaceAttributeValue(String string, String string2, String string3) throws SMSException, SSOException {
        Map map = this.getAttributes();
        HashSet<String> hashSet = new HashSet<String>();
        Set set = (Set)map.get(string);
        if (set != null) {
            hashSet.addAll(set);
            hashSet.remove(string2);
        }
        hashSet.add(string3);
        this.ss.validateAttrValues(string, hashSet, true, this.sc.getOrganizationName());
        SMSEntry sMSEntry = this.sc.getSMSEntry();
        SMSUtils.replaceAttributeValue(sMSEntry, string, string2, string3, this.ss.getSearchableAttributeNames());
        this.saveSMSEntry(sMSEntry);
    }

    public void replaceAttributeValues(String string, Set set, Set set2) throws SMSException, SSOException {
        Map map = this.getAttributes();
        HashSet hashSet = new HashSet();
        Set set3 = (Set)map.get(string);
        if (set3 != null) {
            hashSet.addAll(set3);
            hashSet.removeAll(set);
        }
        hashSet.addAll(set2);
        this.ss.validateAttrValues(string, hashSet, true, this.sc.getOrganizationName());
        SMSEntry sMSEntry = this.sc.getSMSEntry();
        SMSUtils.replaceAttributeValues(sMSEntry, string, set, set2, this.ss.getSearchableAttributeNames());
        this.saveSMSEntry(sMSEntry);
    }

    public String getDN() {
        return this.sc.getDN();
    }

    public String getLastModifiedTime() throws SMSException, SSOException {
        SMSEntry sMSEntry = this.sc.getSMSEntry();
        String[] stringArray = sMSEntry.getAttributeValues("modifytimestamp", true);
        String string = null;
        if (stringArray != null) {
            string = stringArray[0];
        }
        return string;
    }

    public Set getExportedOrganizationNames() {
        return null;
    }

    public void setExportedOrganizationNames(Set set) throws SMSException, SSOException {
    }

    public void addExportedOrganizationNames(Set set) throws SMSException, SSOException {
    }

    public void removeSharedOrganizationNames(Set set) throws SMSException, SSOException {
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("Service Component name: " + this.getComponentName());
        stringBuffer.append("\n\tAttributes: " + this.getAttributes()).append("\n");
        try {
            Iterator iterator = this.getSubConfigNames().iterator();
            while (iterator.hasNext()) {
                ServiceConfig serviceConfig = this.getSubConfig((String)iterator.next());
                stringBuffer.append(serviceConfig);
            }
        }
        catch (Exception exception) {
            stringBuffer.append(exception.getMessage());
        }
        return stringBuffer.toString();
    }

    void saveSMSEntry(SMSEntry sMSEntry) throws SMSException, SSOException {
        if (sMSEntry.isNewEntry()) {
            CreateServiceConfig.checkBaseNodesForOrg(this.token, DNMapper.orgNameToDN(this.sc.getOrganizationName()), this.getServiceName(), this.getVersion());
            String string = new DN(sMSEntry.getDN()).getParent().toString();
            this.checkAndCreateComponents(string);
            sMSEntry.addAttribute("objectclass", "top");
            sMSEntry.addAttribute("objectclass", "sunServiceComponent");
        }
        sMSEntry.save(this.token);
        this.sc.refresh(sMSEntry);
    }

    void checkAndCreateComponents(String string) throws SMSException, SSOException {
        CachedSMSEntry cachedSMSEntry = CachedSMSEntry.getInstance(this.token, string, null);
        if (cachedSMSEntry.isNewEntry()) {
            String string2 = new DN(string).getParent().toString();
            CachedSMSEntry cachedSMSEntry2 = CachedSMSEntry.getInstance(this.token, string2, null);
            if (cachedSMSEntry2.isNewEntry()) {
                this.checkAndCreateComponents(string2);
            }
            SMSEntry sMSEntry = cachedSMSEntry.getClonedSMSEntry();
            sMSEntry.addAttribute("objectclass", "top");
            sMSEntry.addAttribute("objectclass", "sunServiceComponent");
            sMSEntry.save(this.token);
        }
    }
}

