/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.sm;

import com.iplanet.sso.SSOException;
import com.iplanet.sso.SSOToken;
import com.sun.identity.delegation.DelegationException;
import com.sun.identity.delegation.DelegationManager;
import com.sun.identity.delegation.DelegationPrivilege;
import com.sun.identity.sm.CachedSMSEntry;
import com.sun.identity.sm.CachedSubEntries;
import com.sun.identity.sm.CreateServiceConfig;
import com.sun.identity.sm.DNMapper;
import com.sun.identity.sm.OrgConfigViaAMSDK;
import com.sun.identity.sm.OrganizationConfigManager;
import com.sun.identity.sm.SMSEntry;
import com.sun.identity.sm.SMSException;
import com.sun.identity.sm.SMSUtils;
import com.sun.identity.sm.ServiceConfig;
import com.sun.identity.sm.ServiceConfigManager;
import com.sun.identity.sm.ServiceManager;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

public class SMSMigration70 {
    private static String orgNamingAttr;

    public static void main(String[] stringArray) {
    }

    public static void migrate63To70(SSOToken sSOToken, String string) {
        try {
            if (ServiceManager.isRealmEnabled()) {
                System.out.println("\n\n\nSMSMigration70::main() : Realms enabled. \n\nService Management Migration to 7.0 cannot be done. ");
                throw new Exception("\n\n\nSMSMigration70::main() : Realms enabled. \n\nService Management Migration to 7.0 cannot be done.");
            }
            string = string.toLowerCase();
            SMSMigration70.addIdRepoAMSDKPlugin(sSOToken, string);
            Map map = SMSMigration70.getOrgAttributes(sSOToken, string);
            String string2 = "ou=services," + string;
            OrganizationConfigManager organizationConfigManager = new OrganizationConfigManager(sSOToken, string2);
            organizationConfigManager.setAttributes("sunidentityrepositoryservice", map);
            SMSMigration70.migrateToRealms(sSOToken, string);
            ServiceConfigManager serviceConfigManager = new ServiceConfigManager("sunidentityrepositoryservice", sSOToken);
            ServiceConfig serviceConfig = serviceConfigManager.getGlobalConfig(null);
            if (serviceConfig != null) {
                HashMap hashMap = new HashMap(2);
                HashSet<String> hashSet = new HashSet<String>(2);
                hashSet.add("true");
                hashMap.put("realmMode", hashSet);
                HashSet<String> hashSet2 = new HashSet<String>(2);
                hashSet2.add("false");
                hashMap.put("coexistenceMode", hashSet2);
                serviceConfig.setAttributes(hashMap);
            }
            ServiceManager.checkFlags(sSOToken);
            System.out.println("migrateToRealms.REALM is " + ServiceManager.isRealmEnabled());
            System.out.println("migrateToRealms.COEXISTENCE is " + ServiceManager.isCoexistenceMode());
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public static void migrateToRealms(SSOToken sSOToken, String string) {
        try {
            OrganizationConfigManager organizationConfigManager = new OrganizationConfigManager(sSOToken, string);
            Set set = organizationConfigManager.getSubOrganizationNames("*", false);
            if (orgNamingAttr == null) {
                orgNamingAttr = organizationConfigManager.getNamingAttrForOrg();
            }
            System.out.println("Organization naming attr is " + orgNamingAttr);
            Iterator iterator = set.iterator();
            System.out.println("SIZE is " + set.size());
            while (iterator.hasNext()) {
                String string2 = orgNamingAttr + "=" + (String)iterator.next() + "," + string;
                System.out.println("Organization is " + string2);
                SMSMigration70.addIdRepoAMSDKPlugin(sSOToken, string2);
                SMSMigration70.migrateOrganization(sSOToken, string2);
                SMSMigration70.migrateDelegationPolicies(sSOToken, string2);
                SMSMigration70.migrateToRealms(sSOToken, string2);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    protected static void addIdRepoAMSDKPlugin(SSOToken sSOToken, String string) throws SMSException, SSOException {
        ServiceConfigManager serviceConfigManager = new ServiceConfigManager("sunidentityrepositoryservice", sSOToken);
        ServiceConfig serviceConfig = serviceConfigManager.getOrganizationConfig(string, null);
        HashMap hashMap = new HashMap();
        HashSet<String> hashSet = new HashSet<String>();
        hashSet.add("com.iplanet.am.sdk.AMSDKRepo");
        hashMap.put("sunIdRepoClass", hashSet);
        hashSet = new HashSet();
        hashSet.add(DNMapper.realmNameToAMSDKName(DNMapper.orgNameToDN(string)));
        hashMap.put("amSDKOrgName", hashSet);
        serviceConfig.addSubConfig("amsdk1", "amSDK", 0, hashMap);
    }

    protected static void migrateDelegationPolicies(SSOToken sSOToken, String string) throws SSOException {
        System.out.println("Migrating delegation policies for org: " + string);
        try {
            Object object;
            Object object2;
            DelegationManager delegationManager = new DelegationManager(sSOToken, string);
            Set set = delegationManager.getPrivileges();
            HashSet<DelegationPrivilege> hashSet = new HashSet<DelegationPrivilege>();
            Iterator iterator = set.iterator();
            while (iterator.hasNext()) {
                DelegationPrivilege delegationPrivilege = (DelegationPrivilege)iterator.next();
                object2 = delegationPrivilege.getName();
                delegationManager.removePrivilege((String)object2);
                object = delegationPrivilege.getOrganizationName();
                int n = ((String)object).toLowerCase().indexOf("," + SMSEntry.getRootSuffix());
                if (n != -1) {
                    object = ((String)object).substring(0, n) + "," + DNMapper.serviceDN + ((String)object).substring(n + SMSEntry.getRootSuffix().length() + 1);
                    delegationPrivilege.setOrganizationName((String)object);
                }
                Set set2 = delegationPrivilege.getSubjects();
                HashSet<String> hashSet2 = new HashSet<String>();
                Iterator iterator2 = set2.iterator();
                while (iterator2.hasNext()) {
                    String string2 = (String)iterator2.next();
                    n = string2.toLowerCase().indexOf("," + SMSEntry.getRootSuffix());
                    if (n != -1) {
                        string2 = string2.substring(0, n) + "," + DNMapper.serviceDN + string2.substring(n + SMSEntry.getRootSuffix().length() + 1);
                    }
                    hashSet2.add(string2);
                }
                delegationPrivilege.setSubjects(hashSet2);
                hashSet.add(delegationPrivilege);
            }
            int n = string.toLowerCase().indexOf("," + SMSEntry.getRootSuffix());
            if (n != -1) {
                string = string.substring(0, n) + "," + DNMapper.serviceDN + string.substring(n + 1 + SMSEntry.getRootSuffix().length());
            }
            delegationManager = new DelegationManager(sSOToken, string);
            object2 = hashSet.iterator();
            while (object2.hasNext()) {
                object = (DelegationPrivilege)object2.next();
                delegationManager.addPrivilege((DelegationPrivilege)object);
            }
            System.out.println("Delegation Policies for org: " + string + "\n" + set);
        }
        catch (DelegationException delegationException) {
            System.out.println("   " + delegationException.getMessage());
        }
    }

    protected static Map getOrgAttributes(SSOToken sSOToken, String string) {
        HashMap<String, Set> hashMap = new HashMap<String, Set>();
        try {
            OrgConfigViaAMSDK orgConfigViaAMSDK = new OrgConfigViaAMSDK(sSOToken, string, string);
            Set set = orgConfigViaAMSDK.getSDKAttributeValue("inetDomainStatus");
            Set set2 = orgConfigViaAMSDK.getSDKAttributeValue("sunPreferredDomain");
            Set set3 = orgConfigViaAMSDK.getSDKAttributeValue("associatedDomain");
            Set set4 = orgConfigViaAMSDK.getSDKAttributeValue("sunOrganizationAlias");
            set4.addAll(set2);
            set4.addAll(set3);
            hashMap.put("sunOrganizationStatus", set);
            hashMap.put("sunOrganizationAliases", set4);
            System.out.println("\n addIdRepoAMSDKPlugin.Org Status &  ");
            System.out.println("addIdRepoAMSDKPlugin.Org Alias. ");
            Iterator iterator = hashMap.keySet().iterator();
            while (iterator.hasNext()) {
                String string2 = (String)iterator.next();
                System.out.println(string2 + "=" + hashMap.get(string2));
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return hashMap;
    }

    public static void migrateOrganization(SSOToken sSOToken, String string) {
        HashMap hashMap = new HashMap(2);
        try {
            String string2 = string.toLowerCase();
            int n = string2.indexOf(SMSEntry.baseDN);
            if (n > 0) {
                String string3;
                System.out.println("\n migrateOrganization.Org Name: " + string);
                Map map = SMSMigration70.getOrgAttributes(sSOToken, string);
                String string4 = string;
                if (!orgNamingAttr.equalsIgnoreCase("o")) {
                    string3 = string.substring(0, n);
                    string4 = DNMapper.replaceString(string3, orgNamingAttr + "=", "o=") + string.substring(n);
                }
                System.out.println("\nmigrateOrganization.realm: " + string4);
                string3 = "ou=services," + string;
                System.out.println("\nmigrateOrganization.orgDN Name: " + string3);
                CachedSubEntries cachedSubEntries = CachedSubEntries.getInstance(sSOToken, string3);
                Set set = cachedSubEntries.getSubEntries(sSOToken);
                n = string4.toLowerCase().indexOf(SMSEntry.baseDN);
                String string5 = string4.substring(0, n) + "ou=services" + "," + string4.substring(n);
                System.out.println("\nmigrateOrganization.RealmDN Name: " + string5);
                CreateServiceConfig.createOrganization(sSOToken, string5);
                DNMapper.migration = true;
                OrganizationConfigManager organizationConfigManager = new OrganizationConfigManager(sSOToken, string5);
                organizationConfigManager.setAttributes("sunidentityrepositoryservice", map);
                Iterator iterator = set.iterator();
                while (iterator.hasNext()) {
                    String string6 = (String)iterator.next();
                    System.out.println("\nmigrateOrganization.ServiceName: " + string6);
                    SMSMigration70.migrateConfigData(sSOToken, string5, string6, string);
                }
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public static void migrateConfigData(SSOToken sSOToken, String string, String string2, String string3) {
        try {
            System.out.println("Initial value. migrateConfigData.REALM is " + ServiceManager.isRealmEnabled());
            System.out.println("initial value. migrateConfigData.COEXISTENCE is " + ServiceManager.isCoexistenceMode());
            OrganizationConfigManager organizationConfigManager = new OrganizationConfigManager(sSOToken, string);
            ServiceConfigManager serviceConfigManager = new ServiceConfigManager(string2, sSOToken);
            System.out.println("\nMigrating Organization Config data");
            ServiceConfig serviceConfig = serviceConfigManager.getOrganizationConfig(string3, null);
            SMSMigration70.migrateConfigs(sSOToken, serviceConfig, string2, organizationConfigManager);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public static void migrateConfigs(SSOToken sSOToken, ServiceConfig serviceConfig, String string, OrganizationConfigManager organizationConfigManager) {
        try {
            Object object;
            Map map = serviceConfig.getAttributes();
            Iterator iterator = map.keySet().iterator();
            while (iterator.hasNext()) {
                object = (String)iterator.next();
                System.out.println((String)object + "=" + map.get(object));
            }
            object = organizationConfigManager.addServiceConfig(string, map);
            Set set = serviceConfig.getSubConfigNames();
            Iterator iterator2 = set.iterator();
            int n = 0;
            while (iterator2.hasNext()) {
                String string2 = (String)iterator2.next();
                ServiceConfig serviceConfig2 = serviceConfig.getSubConfig(string2);
                String string3 = serviceConfig2.getSchemaID();
                if (string3 == null || string3.length() == 0) {
                    string3 = string2;
                }
                System.out.println("Sub Config Name " + string2);
                System.out.println("Sub ConfigID " + string3);
                Map map2 = serviceConfig2.getAttributes();
                ((ServiceConfig)object).addSubConfig(string2, string3, serviceConfig.getPriority(), map2);
                SMSMigration70.migrateSubEntries(sSOToken, (ServiceConfig)object, serviceConfig2, string2);
                ++n;
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public static void migrateSubEntries(SSOToken sSOToken, ServiceConfig serviceConfig, ServiceConfig serviceConfig2, String string) {
        try {
            Set set = serviceConfig2.getSubConfigNames();
            if (set != null && !set.isEmpty()) {
                Iterator iterator = set.iterator();
                int n = 0;
                while (iterator.hasNext()) {
                    String string2;
                    String string3 = (String)iterator.next();
                    System.out.println("Sub Config Name1 " + string3);
                    ServiceConfig serviceConfig3 = serviceConfig2.getSubConfig(string3);
                    Map map = serviceConfig3.getAttributes();
                    Iterator iterator2 = map.keySet().iterator();
                    while (iterator2.hasNext()) {
                        string2 = (String)iterator2.next();
                        System.out.println(string2 + "=" + map.get(string2));
                    }
                    string2 = serviceConfig3.getSchemaID();
                    if (string2.length() == 0) {
                        string2 = string3;
                    }
                    System.out.println("serviceID " + string2);
                    StringBuffer stringBuffer = new StringBuffer(8);
                    String string4 = "ou=" + string3 + "," + "ou=" + string + "," + serviceConfig.getDN();
                    SMSEntry sMSEntry = new SMSEntry(sSOToken, string4);
                    SMSUtils.setAttributeValuePairs(sMSEntry, map, Collections.EMPTY_SET);
                    sMSEntry.addAttribute("sunserviceID", string2);
                    sMSEntry.addAttribute("sunsmspriority", stringBuffer.append(serviceConfig2.getPriority()).toString());
                    sMSEntry.addAttribute("objectclass", "sunServiceComponent");
                    sMSEntry.addAttribute("objectclass", "top");
                    sMSEntry.save(sSOToken);
                    CachedSMSEntry cachedSMSEntry = CachedSMSEntry.getInstance(sSOToken, sMSEntry.getDN(), null);
                    cachedSMSEntry.refresh(sMSEntry);
                    SMSMigration70.migrateSubEntries(sSOToken, serviceConfig, serviceConfig3, string3);
                    ++n;
                }
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }
}

