/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.sm;

import com.iplanet.am.util.Debug;
import com.iplanet.sso.SSOException;
import com.iplanet.sso.SSOToken;
import com.sun.identity.sm.AttributeValidator;
import com.sun.identity.sm.CachedSMSEntry;
import com.sun.identity.sm.DNMapper;
import com.sun.identity.sm.PluginSchemaImpl;
import com.sun.identity.sm.SMSEntry;
import com.sun.identity.sm.SMSException;
import com.sun.identity.sm.SMSUtils;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

class PluginConfigImpl {
    private PluginSchemaImpl ps;
    private boolean newEntry;
    private String orgName;
    private int priority;
    private Map attributes;
    private CachedSMSEntry smsEntry;
    private static Map configImpls = new HashMap();
    private static Map userPrincipals = new HashMap();
    private static final String configImplsMutex = "ConfigImplsMutex";
    private static Debug debug = SMSEntry.debug;

    private PluginConfigImpl(PluginSchemaImpl pluginSchemaImpl, CachedSMSEntry cachedSMSEntry, String string) throws SMSException {
        this.ps = pluginSchemaImpl;
        this.smsEntry = cachedSMSEntry;
        this.smsEntry.addServiceListener(this);
        this.orgName = string == null ? SMSEntry.baseDN : string;
        this.update();
    }

    String getOrganizationName() {
        return this.orgName;
    }

    int getPriority() {
        return this.priority;
    }

    Map getAttributes() {
        if (!SMSEntry.cacheSMSEntries) {
            this.update();
        }
        return SMSUtils.copyAttributes(this.attributes);
    }

    String getDN() {
        return this.smsEntry.getDN();
    }

    SMSEntry getSMSEntry() {
        return this.smsEntry.getClonedSMSEntry();
    }

    void refresh(SMSEntry sMSEntry) throws SMSException {
        this.smsEntry.refresh(sMSEntry);
    }

    PluginSchemaImpl getPluginSchemaImpl() {
        return this.ps;
    }

    boolean isNewEntry() {
        return this.newEntry;
    }

    void updateAndNotifyListeners() {
        this.update();
    }

    void update() {
        Object object;
        SMSEntry sMSEntry = this.smsEntry.getSMSEntry();
        this.newEntry = sMSEntry.isNewEntry();
        this.attributes = SMSUtils.getAttrsFromEntry(sMSEntry);
        Iterator iterator = this.ps.getAttributeSchemaNames().iterator();
        while (iterator.hasNext()) {
            object = this.ps.getAttributeValidator((String)iterator.next());
            this.attributes = ((AttributeValidator)object).inheritDefaults(this.attributes);
        }
        this.priority = 0;
        object = sMSEntry.getAttributeValues("sunsmspriority");
        if (object != null) {
            try {
                this.priority = Integer.parseInt((String)object[0]);
            }
            catch (NumberFormatException numberFormatException) {
                SMSEntry.debug.error("ServiceConfig::getPriority() " + numberFormatException);
            }
        }
    }

    static PluginConfigImpl getInstance(SSOToken sSOToken, PluginSchemaImpl pluginSchemaImpl, String string, String string2) throws SSOException, SMSException {
        String string3;
        String string4;
        PluginConfigImpl pluginConfigImpl;
        if (debug.messageEnabled()) {
            debug.message("PluginConfigImpl::getInstance: called: " + string);
        }
        if ((pluginConfigImpl = PluginConfigImpl.getFromCache(string4 = PluginConfigImpl.getCacheName(pluginSchemaImpl, string3 = DNMapper.orgNameToDN(string2)), string, sSOToken)) != null) {
            if (!SMSEntry.cacheSMSEntries) {
                pluginConfigImpl.update();
            }
            return pluginConfigImpl;
        }
        if (!SMSEntry.checkIfEntryExists(DNMapper.orgNameToDN(string3), sSOToken)) {
            return null;
        }
        String string5 = configImplsMutex;
        synchronized (string5) {
            pluginConfigImpl = PluginConfigImpl.getFromCache(string4, string, sSOToken);
            if (pluginConfigImpl == null) {
                CachedSMSEntry cachedSMSEntry = PluginConfigImpl.checkAndUpdatePermission(string4, string, sSOToken);
                pluginConfigImpl = new PluginConfigImpl(pluginSchemaImpl, cachedSMSEntry, string3);
                HashMap<String, PluginConfigImpl> hashMap = new HashMap<String, PluginConfigImpl>(configImpls);
                hashMap.put(string4, pluginConfigImpl);
                configImpls = hashMap;
            }
        }
        if (debug.messageEnabled()) {
            debug.message("PluginConfigImpl::getInstance: return: " + string);
        }
        return pluginConfigImpl;
    }

    static void clearCache() {
        configImpls = new HashMap();
    }

    static String getCacheName(PluginSchemaImpl pluginSchemaImpl, String string) {
        StringBuffer stringBuffer = new StringBuffer(100);
        stringBuffer.append(pluginSchemaImpl.getName()).append(pluginSchemaImpl.getVersion()).append(string);
        return stringBuffer.toString().toLowerCase();
    }

    static PluginConfigImpl getFromCache(String string, String string2, SSOToken sSOToken) throws SMSException, SSOException {
        Set set;
        PluginConfigImpl pluginConfigImpl = (PluginConfigImpl)configImpls.get(string);
        if (pluginConfigImpl != null && !pluginConfigImpl.smsEntry.isValid()) {
            pluginConfigImpl = null;
        }
        if (pluginConfigImpl != null && !(set = (Set)userPrincipals.get(string)).contains(sSOToken.getTokenID().toString())) {
            PluginConfigImpl.checkAndUpdatePermission(string, string2, sSOToken);
        }
        return pluginConfigImpl;
    }

    static synchronized CachedSMSEntry checkAndUpdatePermission(String string, String string2, SSOToken sSOToken) throws SMSException, SSOException {
        CachedSMSEntry cachedSMSEntry = CachedSMSEntry.getInstance(sSOToken, string2, null);
        HashSet<String> hashSet = (HashSet<String>)userPrincipals.get(string);
        hashSet = hashSet == null ? new HashSet<String>() : new HashSet(hashSet);
        hashSet.add(sSOToken.getTokenID().toString());
        HashMap<String, HashSet<String>> hashMap = new HashMap<String, HashSet<String>>(userPrincipals);
        hashMap.put(string, hashSet);
        userPrincipals = hashMap;
        return cachedSMSEntry;
    }
}

