/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.sm;

import com.iplanet.am.util.XMLUtils;
import com.sun.identity.security.DecodeAction;
import com.sun.identity.sm.AttributeSchema;
import com.sun.identity.sm.ChoiceValues;
import com.sun.identity.sm.DefaultValues;
import com.sun.identity.sm.SMSEntry;
import java.security.AccessController;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class AttributeSchemaImpl {
    private Node attrSchemaNode;
    private String name;
    private String key;
    private AttributeSchema.Type type;
    private AttributeSchema.UIType uitype;
    private AttributeSchema.Syntax syntax;
    private Set defaultValues = null;
    private DefaultValues defaultsObject = null;
    private Map choiceValues;
    private ChoiceValues choiceObject = null;
    private String trueBooleanValue;
    private String trueValueKey;
    private String falseBooleanValue;
    private String falseValueKey;
    private String cosQualifier;
    private String rangeStart;
    private String rangeEnd;
    private int minValue;
    private int maxValue;
    private String validator;
    private boolean isOptional;
    private boolean isServiceIdentifier;
    private boolean isResourceNameAllowed;
    private boolean isStatusAttribute;
    private String any;
    private boolean displayAsLink;
    private String attributeViewBeanURL;
    boolean isSearchable;

    protected AttributeSchemaImpl(Node node) {
        this.update(node);
    }

    public String getName() {
        return this.name;
    }

    public AttributeSchema.Type getType() {
        return this.type;
    }

    public AttributeSchema.UIType getUIType() {
        return this.uitype;
    }

    public AttributeSchema.Syntax getSyntax() {
        return this.syntax;
    }

    public String getI18NKey() {
        return this.key;
    }

    public String getCosQualifier() {
        return this.cosQualifier;
    }

    public Set getDefaultValues() {
        if (this.defaultsObject != null) {
            this.defaultValues = this.defaultsObject.getDefaultValues();
        }
        if (this.defaultValues != null && this.defaultValues.size() != 0) {
            HashSet hashSet = new HashSet();
            hashSet.addAll(this.defaultValues);
            return hashSet;
        }
        return Collections.EMPTY_SET;
    }

    public Set getDefaultValues(Map map) {
        if (this.defaultsObject != null) {
            this.defaultValues = this.defaultsObject.getDefaultValues(map);
        }
        if (this.defaultValues != null && this.defaultValues.size() != 0) {
            HashSet hashSet = new HashSet();
            hashSet.addAll(this.defaultValues);
            return hashSet;
        }
        return Collections.EMPTY_SET;
    }

    public String[] getChoiceValues() {
        if (this.choiceObject != null) {
            this.choiceValues = this.choiceObject.getChoiceValues();
        }
        if (this.choiceValues != null) {
            Set set = this.choiceValues.keySet();
            return set.toArray(new String[set.size()]);
        }
        return null;
    }

    public String[] getChoiceValues(Map map) {
        if (this.choiceObject != null) {
            this.choiceValues = this.choiceObject.getChoiceValues(map);
        }
        if (this.choiceValues != null) {
            Set set = this.choiceValues.keySet();
            return set.toArray(new String[set.size()]);
        }
        return null;
    }

    protected Map getChoiceValuesMap() {
        if (this.choiceObject != null) {
            this.choiceValues = this.choiceObject.getChoiceValues();
        }
        if (this.choiceValues != null) {
            return this.choiceValues;
        }
        return new HashMap();
    }

    protected Set getChoiceValuesSet() {
        if (this.choiceObject != null) {
            this.choiceValues = this.choiceObject.getChoiceValues();
        }
        if (this.choiceValues != null) {
            return this.choiceValues.keySet();
        }
        return new HashSet();
    }

    protected Map getChoiceValuesMap(Map map) {
        if (this.choiceObject != null) {
            this.choiceValues = this.choiceObject.getChoiceValues(map);
        }
        if (this.choiceValues != null) {
            return this.choiceValues;
        }
        return new HashMap();
    }

    protected Set getChoiceValuesSet(Map map) {
        if (this.choiceObject != null) {
            this.choiceValues = this.choiceObject.getChoiceValues(map);
        }
        if (this.choiceValues != null) {
            return this.choiceValues.keySet();
        }
        return new HashSet();
    }

    public String getChoiceValueI18NKey(String string) {
        if (this.choiceObject != null) {
            this.choiceValues = this.choiceObject.getChoiceValues();
        }
        return (String)this.choiceValues.get(string);
    }

    public String getStartRange() {
        return this.rangeStart;
    }

    public String getEndRange() {
        return this.rangeEnd;
    }

    public String getValidator() {
        return this.validator;
    }

    public int getMinValue() {
        return this.minValue;
    }

    public int getMaxValue() {
        return this.maxValue;
    }

    public String getTrueValue() {
        return this.trueBooleanValue;
    }

    public String getTrueValueI18NKey() {
        return this.trueValueKey;
    }

    public String getFalseValue() {
        return this.falseBooleanValue;
    }

    public String getFalseValueI18NKey() {
        return this.falseValueKey;
    }

    public boolean isOptional() {
        return this.isOptional;
    }

    public boolean isServiceIdentifier() {
        return this.isServiceIdentifier;
    }

    public boolean isResourceNameAllowed() {
        return this.isResourceNameAllowed;
    }

    public boolean isStatusAttribute() {
        return this.isStatusAttribute;
    }

    public String getAny() {
        return this.any;
    }

    public String getPropertiesViewBeanURL() {
        return this.attributeViewBeanURL;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("Attr Name=").append(this.name);
        stringBuffer.append("\n\tType=").append(this.type);
        stringBuffer.append("\n\tUIType=").append(this.uitype);
        stringBuffer.append("\n\tSyntax=").append(this.syntax);
        stringBuffer.append("\n\tI18n Key=").append(this.key);
        stringBuffer.append("\n\tDefault values=").append(this.defaultValues);
        stringBuffer.append("\n\tChoice Values=").append(this.choiceValues);
        stringBuffer.append("\n\tRangeStart=").append(this.rangeStart);
        stringBuffer.append("\n\tRangeEnd=").append(this.rangeEnd);
        stringBuffer.append("\n\tMinValue=").append(this.minValue);
        stringBuffer.append("\n\tMaxValue=").append(this.maxValue);
        stringBuffer.append("\n\tCoS Qualifier=").append(this.cosQualifier);
        stringBuffer.append("\n\tAny=").append(this.any);
        stringBuffer.append("\n\tView Bean URL=").append(this.attributeViewBeanURL);
        stringBuffer.append("\n\tisOptional=").append(this.isOptional);
        stringBuffer.append("\n\tisServiceIdentifier=").append(this.isServiceIdentifier);
        stringBuffer.append("\n\tisResourceNameAllowed=").append(this.isResourceNameAllowed);
        stringBuffer.append("\n\tisStatusAttribute=").append(this.isStatusAttribute);
        stringBuffer.append("\n\tisSearchable=").append(this.isSearchable);
        stringBuffer.append("\n");
        return stringBuffer.toString();
    }

    void update(Node node) {
        Iterator iterator;
        Object object;
        Object object2;
        Node node2;
        Object object3;
        Object object4;
        Object object5;
        this.attrSchemaNode = node;
        this.name = XMLUtils.getNodeAttributeValue((Node)node, (String)"name");
        this.key = XMLUtils.getNodeAttributeValue((Node)node, (String)"i18nKey");
        String string = XMLUtils.getNodeAttributeValue((Node)node, (String)"type");
        this.type = AttributeSchema.Type.LIST;
        if (string != null) {
            try {
                object5 = AttributeSchema.Type.LIST.getClass();
                this.type = (AttributeSchema.Type)((Class)object5).getField(string.toUpperCase()).get(AttributeSchema.Type.LIST);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        object5 = XMLUtils.getNodeAttributeValue((Node)node, (String)"uitype");
        this.uitype = null;
        if (object5 != null) {
            try {
                object4 = AttributeSchema.UIType.LINK.getClass();
                this.uitype = (AttributeSchema.UIType)((Class)object4).getField(((String)object5).toUpperCase()).get(AttributeSchema.UIType.LINK);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        object4 = XMLUtils.getNodeAttributeValue((Node)node, (String)"syntax");
        this.syntax = AttributeSchema.Syntax.STRING;
        if (object4 != null) {
            try {
                object3 = AttributeSchema.Syntax.STRING.getClass();
                this.syntax = (AttributeSchema.Syntax)((Class)object3).getField(((String)object4).toUpperCase()).get(AttributeSchema.Syntax.STRING);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (this.syntax.equals(AttributeSchema.Syntax.BOOLEAN) && (object3 = XMLUtils.getChildNode((Node)node, (String)"BooleanValues")) != null) {
            node2 = XMLUtils.getChildNode((Node)object3, (String)"BooleanTrueValue");
            if (node2 != null) {
                this.trueBooleanValue = XMLUtils.getValueOfValueNode((Node)node2);
                this.trueValueKey = XMLUtils.getNodeAttributeValue((Node)node2, (String)"i18nKey");
            } else {
                this.trueBooleanValue = "true";
            }
            node2 = XMLUtils.getChildNode((Node)object3, (String)"BooleanFalseValue");
            if (node2 != null) {
                this.falseBooleanValue = XMLUtils.getValueOfValueNode((Node)node2);
                this.falseValueKey = XMLUtils.getNodeAttributeValue((Node)node2, (String)"i18nKey");
            } else {
                this.falseBooleanValue = "false";
            }
        } else {
            this.trueBooleanValue = "true";
            this.falseBooleanValue = "false";
        }
        if ((this.type.equals(AttributeSchema.Type.SINGLE_CHOICE) || this.type.equals(AttributeSchema.Type.MULTIPLE_CHOICE)) && (object2 = XMLUtils.getChildNode((Node)node, (String)"ChoiceValues")) != null) {
            Object object6;
            object = XMLUtils.getChildNode((Node)object2, (String)"ChoiceValuesClassName");
            if (object != null) {
                iterator = XMLUtils.getNodeAttributeValue((Node)object, (String)"className");
                try {
                    object6 = Class.forName((String)((Object)iterator));
                    this.choiceObject = (ChoiceValues)((Class)object6).newInstance();
                    this.choiceObject.setAttributeSchema(this);
                    this.choiceObject.setKeyValues((Node)object);
                    this.choiceObject.setParentNode(node);
                }
                catch (Exception exception) {
                    SMSEntry.debug.error("SMS AttributeSchema: Unable to load class: " + iterator, (Throwable)exception);
                    this.choiceObject = null;
                }
            }
            if (this.choiceObject == null) {
                this.choiceValues = new HashMap();
                iterator = XMLUtils.getChildNodes((Node)object2, (String)"ChoiceValue").iterator();
                while (iterator.hasNext()) {
                    object6 = (Node)iterator.next();
                    String string2 = XMLUtils.getValueOfValueNode((Node)object6);
                    String string3 = XMLUtils.getNodeAttributeValue((Node)object6, (String)"i18nKey");
                    this.choiceValues.put(string2, string3);
                }
            }
        }
        if ((node2 = XMLUtils.getChildNode((Node)node, (String)"DefaultValues")) != null) {
            object2 = XMLUtils.getChildNode((Node)node2, (String)"DefaultValuesClassName");
            if (object2 != null) {
                object = XMLUtils.getNodeAttributeValue((Node)object2, (String)"className");
                try {
                    iterator = Class.forName((String)object);
                    this.defaultsObject = (DefaultValues)((Class)((Object)iterator)).newInstance();
                    this.defaultsObject.setAttributeSchema(this);
                    this.defaultsObject.setKeyValues((Node)object2);
                    this.defaultsObject.setParentNode(node);
                }
                catch (Exception exception) {
                    SMSEntry.debug.error("SMS AttributeSchema: Unable to load class: " + (String)object, (Throwable)exception);
                    this.defaultValues = AttributeSchemaImpl.getValues(node2);
                }
            } else {
                this.defaultValues = AttributeSchemaImpl.getValues(node2);
            }
        }
        if ((this.syntax.equals(AttributeSchema.Syntax.PASSWORD) || this.syntax.equals(AttributeSchema.Syntax.ENCRYPTED_PASSWORD)) && this.defaultValues != null) {
            object2 = this.defaultValues.iterator();
            this.defaultValues = new HashSet();
            while (object2.hasNext()) {
                object = (String)object2.next();
                if (object != null) {
                    try {
                        object = (String)AccessController.doPrivileged(new DecodeAction((String)object));
                    }
                    catch (Throwable throwable) {
                        SMSEntry.debug.error("AttributeSchemaImpl: Unable to decode", throwable);
                    }
                }
                this.defaultValues.add(object);
            }
        }
        if ((this.cosQualifier = XMLUtils.getNodeAttributeValue((Node)node, (String)"cosQualifier")) == null) {
            this.cosQualifier = "default";
        }
        this.rangeStart = XMLUtils.getNodeAttributeValue((Node)node, (String)"rangeStart");
        this.rangeEnd = XMLUtils.getNodeAttributeValue((Node)node, (String)"rangeEnd");
        try {
            this.minValue = Integer.parseInt(XMLUtils.getNodeAttributeValue((Node)node, (String)"minValue"));
        }
        catch (NumberFormatException numberFormatException) {
            this.minValue = -1;
        }
        try {
            this.maxValue = Integer.parseInt(XMLUtils.getNodeAttributeValue((Node)node, (String)"maxValue"));
        }
        catch (NumberFormatException numberFormatException) {
            this.maxValue = -1;
        }
        this.validator = XMLUtils.getNodeAttributeValue((Node)node, (String)"validator");
        if (XMLUtils.getChildNode((Node)node, (String)"IsOptional") != null) {
            this.isOptional = true;
        }
        this.isServiceIdentifier = false;
        if (XMLUtils.getChildNode((Node)node, (String)"IsServiceIdentifier") != null) {
            this.isServiceIdentifier = true;
        }
        this.isResourceNameAllowed = false;
        if (XMLUtils.getChildNode((Node)node, (String)"IsResourceNameAllowed") != null) {
            this.isResourceNameAllowed = true;
        }
        this.isStatusAttribute = false;
        if (XMLUtils.getChildNode((Node)node, (String)"IsStatusAttribute") != null) {
            this.isStatusAttribute = true;
        }
        this.any = XMLUtils.getNodeAttributeValue((Node)node, (String)"any");
        this.attributeViewBeanURL = XMLUtils.getNodeAttributeValue((Node)node, (String)"propertiesViewBeanURL");
        this.isSearchable = false;
        object2 = XMLUtils.getNodeAttributeValue((Node)node, (String)"isSearchable");
        if (object2 != null && ((String)object2).equalsIgnoreCase("yes")) {
            this.isSearchable = true;
        }
    }

    protected static Set getValues(Node node) {
        HashSet<String> hashSet = new HashSet<String>();
        NodeList nodeList = node.getChildNodes();
        int n = 0;
        while (n < nodeList.getLength()) {
            Node node2 = nodeList.item(n);
            if (node2.getNodeName().equals("Value")) {
                hashSet.add(XMLUtils.getValueOfValueNode((Node)node2));
            }
            ++n;
        }
        return hashSet;
    }

    public boolean isSearchable() {
        return this.isSearchable;
    }
}

