/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.security.cert;

import com.iplanet.am.util.Debug;
import com.iplanet.am.util.Misc;
import com.iplanet.security.x509.X500Name;
import com.iplanet.sso.SSOToken;
import com.sun.identity.security.AdminTokenAction;
import com.sun.identity.security.SecurityDebug;
import com.sun.identity.security.cert.AMLDAPCertStoreParameters;
import com.sun.identity.sm.ServiceSchema;
import com.sun.identity.sm.ServiceSchemaManager;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.security.AccessController;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.CertificateParsingException;
import java.security.cert.X509Certificate;
import java.util.Enumeration;
import java.util.Map;
import netscape.ldap.LDAPAttribute;
import netscape.ldap.LDAPAttributeSet;
import netscape.ldap.LDAPConnection;
import netscape.ldap.LDAPEntry;
import netscape.ldap.LDAPException;
import netscape.ldap.LDAPSearchResults;
import netscape.ldap.util.ConnectionPool;

public class AMCertStore {
    protected AMLDAPCertStoreParameters storeParam = null;
    protected static ConnectionPool cPool;
    protected X509Certificate certificate = null;
    protected static CertificateFactory cf;
    private static final int MIN_CONNECTION_POOL_SIZE = 1;
    private static final int MAX_CONNECTION_POOL_SIZE = 10;
    private static final String CONNECTION_POOL_DEFAULT_SIZE_ATTR = "iplanet-am-auth-ldap-connection-pool-default-size";
    private static int minDefaultPoolSize;
    private static int maxDefaultPoolSize;
    static final String amSecurity = "amSecurity";
    static Debug debug;

    public AMCertStore(AMLDAPCertStoreParameters aMLDAPCertStoreParameters) {
        this.storeParam = aMLDAPCertStoreParameters;
    }

    protected void createConnectionPool() throws LDAPException {
        LDAPConnection lDAPConnection = null;
        lDAPConnection = this.storeParam.isSecure() ? new LDAPConnection(this.storeParam.getSecureSocketFactory()) : new LDAPConnection();
        lDAPConnection.connect(this.storeParam.getServerName(), this.storeParam.getPort());
        lDAPConnection.authenticate(3, this.storeParam.getUser(), this.storeParam.getPassword());
        cPool = new ConnectionPool(minDefaultPoolSize, maxDefaultPoolSize, lDAPConnection);
    }

    protected void releaseConnection(LDAPConnection lDAPConnection) {
        if (lDAPConnection == null) {
            return;
        }
        cPool.close(lDAPConnection);
    }

    LDAPConnection getConnection() throws LDAPException {
        if (cPool == null) {
            this.createConnectionPool();
        }
        LDAPConnection lDAPConnection = cPool.getConnection();
        if (this.storeParam.isSecure()) {
            debug.message("Cert:  initial ldc  using ssl.");
            try {
                lDAPConnection.setSocketFactory(this.storeParam.getSecureSocketFactory());
                debug.message("validate(): SSLSocketFactory called");
            }
            catch (Exception exception) {
                debug.error("validate.JSSSocketFactory", (Throwable)exception);
            }
        }
        try {
            lDAPConnection.connect(this.storeParam.getServerName(), this.storeParam.getPort());
            lDAPConnection.authenticate(3, this.storeParam.getUser(), this.storeParam.getPassword());
        }
        catch (LDAPException lDAPException) {
            debug.message("Certificate: dircontext", (Throwable)lDAPException);
        }
        return lDAPConnection;
    }

    LDAPSearchResults getSearchResults(LDAPConnection lDAPConnection) {
        LDAPSearchResults lDAPSearchResults = null;
        try {
            lDAPSearchResults = lDAPConnection.search(this.storeParam.getStartLoc(), 2, this.storeParam.getSearchFilter(), null, false);
            if (lDAPSearchResults == null || !lDAPSearchResults.hasMoreElements()) {
                debug.error("No ldap Entry found !");
                return null;
            }
            this.releaseConnection(lDAPConnection);
        }
        catch (Exception exception) {
            debug.error("Error in ldap search for " + this.storeParam.getSearchFilter());
            debug.error("" + exception.toString());
            try {
                this.releaseConnection(lDAPConnection);
            }
            catch (Exception exception2) {
                // empty catch block
            }
            return null;
        }
        return lDAPSearchResults;
    }

    LDAPEntry getLdapEntry(LDAPConnection lDAPConnection) {
        LDAPEntry lDAPEntry = null;
        try {
            LDAPSearchResults lDAPSearchResults = this.getSearchResults(lDAPConnection);
            lDAPEntry = lDAPSearchResults.next();
        }
        catch (Exception exception) {
            debug.error("Error in getting Cached CRL");
            return null;
        }
        return lDAPEntry;
    }

    public X509Certificate getCertificate(X509Certificate x509Certificate) {
        try {
            LDAPSearchResults lDAPSearchResults = this.getSearchResults(this.getConnection());
            while (lDAPSearchResults != null && lDAPSearchResults.hasMoreElements()) {
                LDAPEntry lDAPEntry = lDAPSearchResults.next();
                LDAPAttributeSet lDAPAttributeSet = lDAPEntry.getAttributeSet();
                LDAPAttribute lDAPAttribute = lDAPAttributeSet.getAttribute("usercertificate");
                if (lDAPAttribute == null && (lDAPAttribute = lDAPAttributeSet.getAttribute("usercertificate;binary")) == null) {
                    debug.message("Certificate - get usercertificate is null ");
                    continue;
                }
                Enumeration enumeration = lDAPAttribute.getByteValues();
                while (enumeration.hasMoreElements()) {
                    byte[] byArray = (byte[])enumeration.nextElement();
                    ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
                    X509Certificate x509Certificate2 = null;
                    try {
                        x509Certificate2 = (X509Certificate)cf.generateCertificate(byteArrayInputStream);
                    }
                    catch (CertificateParsingException certificateParsingException) {
                        debug.error("Error in Certificate parsing : ", (Throwable)certificateParsingException);
                    }
                    if (x509Certificate2 == null || !x509Certificate.equals(x509Certificate2)) continue;
                    return x509Certificate2;
                }
            }
        }
        catch (Exception exception) {
            debug.error("Certificate - Error finding registered certificate = ", (Throwable)exception);
        }
        return null;
    }

    public static X500Name getIssuerDN(X509Certificate x509Certificate) throws IOException {
        X500Name x500Name = null;
        try {
            sun.security.x509.X500Name x500Name2 = (sun.security.x509.X500Name)x509Certificate.getIssuerDN();
            x500Name = new X500Name(x500Name2.getEncoded());
        }
        catch (IOException iOException) {
            debug.error("Error in getting issuer DN : " + iOException.toString());
        }
        return x500Name;
    }

    public static X500Name getSubjectDN(X509Certificate x509Certificate) throws IOException {
        X500Name x500Name = null;
        try {
            sun.security.x509.X500Name x500Name2 = (sun.security.x509.X500Name)x509Certificate.getSubjectDN();
            x500Name = new X500Name(x500Name2.getEncoded());
        }
        catch (Exception exception) {
            debug.error("Error in getting subject DN : " + exception.toString());
        }
        return x500Name;
    }

    static {
        block9: {
            cPool = null;
            cf = null;
            minDefaultPoolSize = 1;
            maxDefaultPoolSize = 10;
            debug = SecurityDebug.debug;
            try {
                cf = CertificateFactory.getInstance("X.509");
            }
            catch (CertificateException certificateException) {
                debug.error("" + certificateException.toString());
            }
            try {
                SSOToken sSOToken = (SSOToken)AccessController.doPrivileged(AdminTokenAction.getInstance());
                ServiceSchemaManager serviceSchemaManager = new ServiceSchemaManager("iPlanetAMAuthService", sSOToken);
                ServiceSchema serviceSchema = serviceSchemaManager.getGlobalSchema();
                Map map = serviceSchema.getAttributeDefaults();
                String string = Misc.getMapAttr((Map)map, (String)CONNECTION_POOL_DEFAULT_SIZE_ATTR, (String)"");
                int n = string.indexOf(":");
                if (n == -1) break block9;
                try {
                    minDefaultPoolSize = Integer.parseInt(string.substring(0, n));
                }
                catch (NumberFormatException numberFormatException) {
                    debug.error("Invalid ldap connection pool min size", (Throwable)numberFormatException);
                }
                try {
                    maxDefaultPoolSize = Integer.parseInt(string.substring(n + 1));
                }
                catch (NumberFormatException numberFormatException) {
                    debug.error("Invalid ldap connection pool max size", (Throwable)numberFormatException);
                }
                if (maxDefaultPoolSize < minDefaultPoolSize) {
                    debug.error("ldap connection pool max size is less than min size");
                    minDefaultPoolSize = 1;
                    maxDefaultPoolSize = 10;
                }
            }
            catch (Exception exception) {
                debug.error("Unable to get ldap connection pool size", (Throwable)exception);
            }
        }
    }
}

