/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.security.cert;

import com.iplanet.am.util.AMURLEncDec;
import com.iplanet.security.x509.CRLDistributionPoint;
import com.iplanet.security.x509.CRLDistributionPointsExtension;
import com.iplanet.security.x509.IssuingDistributionPoint;
import com.iplanet.security.x509.IssuingDistributionPointExtension;
import com.iplanet.security.x509.X500Name;
import com.sun.identity.authentication.spi.AuthLoginException;
import com.sun.identity.security.cert.AMCertStore;
import com.sun.identity.security.cert.AMLDAPCertStoreParameters;
import java.io.ByteArrayInputStream;
import java.io.DataOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.security.cert.CertificateFactory;
import java.security.cert.X509CRL;
import java.security.cert.X509Certificate;
import java.util.Date;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.StringTokenizer;
import netscape.ldap.LDAPAttribute;
import netscape.ldap.LDAPAttributeSet;
import netscape.ldap.LDAPConnection;
import netscape.ldap.LDAPEntry;
import netscape.ldap.LDAPException;
import netscape.ldap.LDAPModification;
import netscape.ldap.LDAPSearchResults;
import netscape.ldap.LDAPUrl;
import sun.security.x509.CertificateExtensions;
import sun.security.x509.Extension;
import sun.security.x509.GeneralNames;
import sun.security.x509.X509CertImpl;
import sun.security.x509.X509CertInfo;

public class AMCRLStore
extends AMCertStore {
    private static Hashtable cachedcrls = new Hashtable();
    private String mCrlAttrName = null;

    public AMCRLStore(AMLDAPCertStoreParameters aMLDAPCertStoreParameters) {
        super(aMLDAPCertStoreParameters);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public X509CRL getCRL(X509Certificate x509Certificate) throws IOException, LDAPException {
        LDAPEntry lDAPEntry = null;
        X509CRL x509CRL = this.getCRLFromCache(x509Certificate);
        LDAPConnection lDAPConnection = this.getConnection();
        try {
            if (x509CRL == null) {
                lDAPEntry = this.getLdapEntry(lDAPConnection);
                x509CRL = this.getCRLFromEntry(lDAPEntry);
            }
            if (this.needCRLUpdate(x509CRL)) {
                X509CRL x509CRL2 = null;
                IssuingDistributionPointExtension issuingDistributionPointExtension = this.getCRLIDPExt(x509CRL);
                CRLDistributionPointsExtension cRLDistributionPointsExtension = this.getCRLDPExt(x509Certificate);
                if (x509CRL2 == null && issuingDistributionPointExtension != null) {
                    x509CRL2 = this.getUpdateCRLFromCrlIDP(issuingDistributionPointExtension);
                }
                if (x509CRL2 == null && cRLDistributionPointsExtension != null) {
                    x509CRL2 = this.getUpdateCRLFromCrlDP(cRLDistributionPointsExtension);
                }
                if (x509CRL2 != null) {
                    if (lDAPEntry == null) {
                        lDAPEntry = this.getLdapEntry(lDAPConnection);
                    }
                    this.updateCRL(lDAPConnection, lDAPEntry.getDN().toString(), x509CRL2.getEncoded());
                }
                x509CRL = x509CRL2;
            }
            this.updateCRLCache(x509Certificate, x509CRL);
        }
        catch (Exception exception) {
            debug.error("Error in getting CRL : " + exception.toString());
        }
        finally {
            try {
                this.releaseConnection(lDAPConnection);
            }
            catch (Exception exception) {}
        }
        return x509CRL;
    }

    public X509CRL getCRLFromCache(X509Certificate x509Certificate) throws IOException {
        X500Name x500Name = AMCRLStore.getIssuerDN(x509Certificate);
        X509CRL x509CRL = null;
        x509CRL = (X509CRL)cachedcrls.get(x500Name.toString());
        return x509CRL;
    }

    public void updateCRLCache(X509Certificate x509Certificate, X509CRL x509CRL) throws IOException {
        X500Name x500Name = AMCRLStore.getIssuerDN(x509Certificate);
        if (x509CRL == null) {
            cachedcrls.remove(x500Name.toString());
        } else {
            cachedcrls.put(x500Name.toString(), x509CRL);
        }
    }

    private X509CRL getCRLFromEntry(LDAPEntry lDAPEntry) throws AuthLoginException {
        LDAPAttributeSet lDAPAttributeSet = lDAPEntry.getAttributeSet();
        LDAPAttribute lDAPAttribute = null;
        X509CRL x509CRL = null;
        try {
            if (this.mCrlAttrName == null) {
                lDAPAttribute = lDAPAttributeSet.getAttribute("certificaterevocationlist");
                if (lDAPAttribute == null && (lDAPAttribute = lDAPAttributeSet.getAttribute("certificaterevocationlist;binary")) == null) {
                    debug.error("No CRL Cache is configured");
                    return null;
                }
                this.mCrlAttrName = lDAPAttribute.getName();
            } else {
                lDAPAttribute = lDAPAttributeSet.getAttribute(this.mCrlAttrName);
            }
            if (lDAPAttribute.size() > 1) {
                debug.error("More than one CRL entries are configured");
                return null;
            }
        }
        catch (Exception exception) {
            debug.error("Error in getting Cached CRL");
            return null;
        }
        try {
            Enumeration enumeration = lDAPAttribute.getByteValues();
            byte[] byArray = (byte[])enumeration.nextElement();
            cf = CertificateFactory.getInstance("X.509");
            x509CRL = (X509CRL)cf.generateCRL(new ByteArrayInputStream(byArray));
        }
        catch (Exception exception) {
            debug.error("Certificate: CertRevoked = ", (Throwable)exception);
        }
        return x509CRL;
    }

    private CRLDistributionPointsExtension getCRLDPExt(X509Certificate x509Certificate) {
        CRLDistributionPointsExtension cRLDistributionPointsExtension = null;
        CertificateExtensions certificateExtensions = null;
        try {
            X509CertImpl x509CertImpl = new X509CertImpl(x509Certificate.getEncoded());
            X509CertInfo x509CertInfo = new X509CertInfo(x509CertImpl.getTBSCertificate());
            certificateExtensions = (CertificateExtensions)x509CertInfo.get("extensions");
            Enumeration enumeration = certificateExtensions.getElements();
            while (cRLDistributionPointsExtension == null && enumeration.hasMoreElements()) {
                Extension extension = (Extension)enumeration.nextElement();
                String string = extension.getExtensionId().toString();
                if (!string.equals("2.5.29.31")) continue;
                cRLDistributionPointsExtension = new CRLDistributionPointsExtension(Boolean.FALSE, extension.getExtensionValue());
            }
        }
        catch (Exception exception) {
            debug.error("Error finding CRL distribution Point configured: ", (Throwable)exception);
        }
        return cRLDistributionPointsExtension;
    }

    private IssuingDistributionPointExtension getCRLIDPExt(X509CRL x509CRL) {
        IssuingDistributionPointExtension issuingDistributionPointExtension = null;
        try {
            byte[] byArray = x509CRL.getExtensionValue("2.5.29.28");
            if (byArray != null) {
                issuingDistributionPointExtension = new IssuingDistributionPointExtension(Boolean.FALSE, byArray);
            }
        }
        catch (Exception exception) {
            debug.error("Error finding CRL distribution Point configured: ", (Throwable)exception);
        }
        return issuingDistributionPointExtension;
    }

    private CRLDistributionPoint[] getCRLdp(CRLDistributionPointsExtension cRLDistributionPointsExtension) {
        CRLDistributionPoint[] cRLDistributionPointArray = null;
        if (cRLDistributionPointsExtension != null && cRLDistributionPointsExtension.getNumPoints() > 0) {
            cRLDistributionPointArray = new CRLDistributionPoint[cRLDistributionPointsExtension.getNumPoints()];
            for (int i = 0; i < cRLDistributionPointsExtension.getNumPoints(); ++i) {
                cRLDistributionPointArray[i] = cRLDistributionPointsExtension.getPointAt(i);
            }
        }
        return cRLDistributionPointArray;
    }

    private synchronized X509CRL getUpdateCRLFromCrlDP(CRLDistributionPointsExtension cRLDistributionPointsExtension) {
        CRLDistributionPoint[] cRLDistributionPointArray = this.getCRLdp(cRLDistributionPointsExtension);
        byte[] byArray = null;
        X509CRL x509CRL = null;
        GeneralNames generalNames = null;
        int n = 0;
        if (cRLDistributionPointArray == null) {
            return null;
        }
        while (byArray == null && n < cRLDistributionPointArray.length) {
            generalNames = cRLDistributionPointArray[n++].getFullName();
            byArray = this.getCRLsFromGeneralNames(generalNames);
        }
        if (byArray != null) {
            try {
                x509CRL = (X509CRL)cf.generateCRL(new ByteArrayInputStream(byArray));
            }
            catch (Exception exception) {
                debug.error("Error in generating X509CRL" + exception.toString());
            }
        }
        return x509CRL;
    }

    private synchronized X509CRL getUpdateCRLFromCrlIDP(IssuingDistributionPointExtension issuingDistributionPointExtension) {
        IssuingDistributionPoint issuingDistributionPoint = issuingDistributionPointExtension.getIssuingDistributionPoint();
        byte[] byArray = null;
        X509CRL x509CRL = null;
        GeneralNames generalNames = null;
        if (issuingDistributionPoint != null) {
            generalNames = issuingDistributionPoint.getFullName();
            byArray = this.getCRLsFromGeneralNames(generalNames);
        }
        if (byArray != null) {
            try {
                x509CRL = (X509CRL)cf.generateCRL(new ByteArrayInputStream(byArray));
            }
            catch (Exception exception) {
                debug.error("Error in generating X509CRL" + exception.toString());
            }
        }
        return x509CRL;
    }

    private byte[] getCRLsFromGeneralNames(GeneralNames generalNames) {
        byte[] byArray = null;
        int n = 0;
        do {
            String string;
            String string2;
            int n2;
            if ((n2 = (string2 = (string = generalNames.get(n++).toString().trim()).toLowerCase()).indexOf("http")) == -1 && (n2 = string2.indexOf("https")) == -1 && (n2 = string2.indexOf("ldap")) == -1 && (n2 = string2.indexOf("ldaps")) == -1) continue;
            string = string.substring(n2, string.length());
            if (debug.messageEnabled()) {
                debug.message("DP Name : " + string);
            }
            byArray = this.getCRLByURI(string);
        } while (byArray != null && n < generalNames.size());
        return byArray;
    }

    private boolean updateCRL(LDAPConnection lDAPConnection, String string, byte[] byArray) {
        LDAPAttribute lDAPAttribute = new LDAPAttribute(this.mCrlAttrName, byArray);
        LDAPModification lDAPModification = new LDAPModification(2, lDAPAttribute);
        try {
            lDAPConnection.modify(string, lDAPModification);
        }
        catch (LDAPException lDAPException) {
            debug.error("Error updating CRL Cache : ", (Throwable)lDAPException);
            return false;
        }
        return true;
    }

    private byte[] getCRLByURI(String string) {
        if (string == null) {
            return null;
        }
        String string2 = string.trim().toLowerCase();
        if (string2.startsWith("http") || string2.startsWith("https")) {
            return this.getCRLByHttpURI(string);
        }
        if (string2.startsWith("ldap") || string2.startsWith("ldaps")) {
            return this.getCRLByLdapURI(string);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private byte[] getCRLByLdapURI(String string) {
        LDAPUrl lDAPUrl = null;
        LDAPConnection lDAPConnection = cPool.getConnection();
        byte[] byArray = null;
        try {
            lDAPUrl = new LDAPUrl(string);
            if (lDAPUrl.isSecure()) {
                lDAPConnection.setSocketFactory(this.storeParam.getSecureSocketFactory());
            }
            lDAPConnection.connect(lDAPUrl.getHost(), lDAPUrl.getPort(), "", "");
            LDAPSearchResults lDAPSearchResults = lDAPConnection.search(lDAPUrl.getDN().toString(), 0, null, null, false);
            if (lDAPSearchResults == null || !lDAPSearchResults.hasMoreElements()) {
                debug.error("verifyCertificate - No CRL distribution Point configured");
                byte[] byArray2 = null;
                return byArray2;
            }
            LDAPEntry lDAPEntry = lDAPSearchResults.next();
            LDAPAttributeSet lDAPAttributeSet = lDAPEntry.getAttributeSet();
            LDAPAttribute lDAPAttribute = lDAPAttributeSet.getAttribute("certificaterevocationlist");
            if (lDAPAttribute == null && (lDAPAttribute = lDAPAttributeSet.getAttribute("certificaterevocationlist;binary")) == null) {
                debug.error("verifyCertificate - No CRL distribution Point configured");
                byte[] byArray3 = null;
                return byArray3;
            }
            byArray = (byte[])lDAPAttribute.getByteValues().nextElement();
            return byArray;
        }
        catch (Exception exception) {
            debug.error("Error in getting CRL", (Throwable)exception);
            return byArray;
        }
        finally {
            try {
                this.releaseConnection(lDAPConnection);
            }
            catch (Exception exception) {}
        }
    }

    private byte[] getCRLByHttpURI(String string) {
        String string2 = "";
        StringBuffer stringBuffer = null;
        HttpURLConnection httpURLConnection = null;
        byte[] byArray = null;
        String string3 = this.storeParam.getURIParams();
        try {
            int n;
            CharSequence charSequence;
            Object object;
            Object object2;
            Object object3;
            if (string3 != null) {
                stringBuffer = new StringBuffer();
                object3 = new StringTokenizer(string3, ",");
                while (((StringTokenizer)object3).hasMoreTokens()) {
                    String string4 = ((StringTokenizer)object3).nextToken();
                    object2 = new StringTokenizer(string4, "=");
                    if (((StringTokenizer)object2).countTokens() != 2) continue;
                    object = ((StringTokenizer)object2).nextToken();
                    charSequence = ((StringTokenizer)object2).nextToken();
                    stringBuffer.append(AMURLEncDec.encode((String)object) + "=" + AMURLEncDec.encode((String)charSequence));
                    if (!((StringTokenizer)object3).hasMoreTokens()) continue;
                    stringBuffer.append("&");
                }
            }
            object3 = new URL(string);
            httpURLConnection = (HttpURLConnection)((URL)object3).openConnection();
            httpURLConnection.setDoOutput(true);
            httpURLConnection.setDoInput(true);
            httpURLConnection.setUseCaches(false);
            int n2 = stringBuffer.toString().trim().getBytes("UTF-8").length;
            httpURLConnection.setRequestProperty("Content-Length", Integer.toString(n2));
            object2 = new DataOutputStream(httpURLConnection.getOutputStream());
            ((DataOutputStream)object2).writeBytes(stringBuffer.toString().trim());
            ((DataOutputStream)object2).flush();
            ((FilterOutputStream)object2).close();
            object = httpURLConnection.getInputStream();
            charSequence = new StringBuffer();
            byte[] byArray2 = new byte[1024];
            while ((n = ((InputStream)object).read(byArray2, 0, byArray2.length)) != -1) {
                ((StringBuffer)charSequence).append(new String(byArray2));
            }
            byArray = ((StringBuffer)charSequence).toString().getBytes();
        }
        catch (Exception exception) {
            debug.error("Error in getting CRL", (Throwable)exception);
        }
        return byArray;
    }

    private boolean needCRLUpdate(X509CRL x509CRL) {
        Date date = null;
        date = x509CRL.getNextUpdate();
        return date != null && date.before(new Date());
    }
}

