/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.saml.servlet;

import com.iplanet.services.util.Base64;
import com.iplanet.sso.SSOException;
import com.iplanet.sso.SSOToken;
import com.iplanet.sso.SSOTokenManager;
import com.sun.identity.authentication.modules.saml.SAMLPrincipal;
import com.sun.identity.saml.AssertionManager;
import com.sun.identity.saml.assertion.Assertion;
import com.sun.identity.saml.common.LogUtils;
import com.sun.identity.saml.common.SAMLConstants;
import com.sun.identity.saml.common.SAMLException;
import com.sun.identity.saml.common.SAMLServiceManager;
import com.sun.identity.saml.common.SAMLUtils;
import com.sun.identity.saml.common.SAMLUtilsCommon;
import com.sun.identity.saml.protocol.Response;
import com.sun.identity.saml.protocol.Status;
import com.sun.identity.saml.protocol.StatusCode;
import java.io.IOException;
import java.io.PrintWriter;
import java.net.URL;
import java.security.Principal;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.logging.Level;
import javax.security.auth.Subject;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class SAMLPOSTProfileServlet
extends HttpServlet {
    public void doGet(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws ServletException, IOException {
        Object object;
        Object object2;
        if (httpServletRequest == null || httpServletResponse == null) {
            String[] stringArray = new String[]{SAMLUtilsCommon.bundle.getString("nullInputParameter")};
            LogUtils.error(Level.INFO, "NULL_PARAMETER", stringArray);
            httpServletResponse.sendError(500, SAMLUtilsCommon.bundle.getString("nullInputParameter"));
            return;
        }
        SAMLUtils.checkHTTPContentLength(httpServletRequest);
        SSOToken sSOToken = this.getSSOToken(httpServletRequest);
        if (sSOToken == null) {
            httpServletResponse.sendError(500, SAMLUtilsCommon.bundle.getString("nullSSOToken"));
            return;
        }
        String string = httpServletRequest.getParameter("TARGET");
        if (string == null || string.equals("")) {
            String[] stringArray = new String[]{SAMLUtilsCommon.bundle.getString("missingTargetSite")};
            LogUtils.error(Level.INFO, "MISSING_TARGET", stringArray, sSOToken);
            httpServletResponse.sendError(400, SAMLUtilsCommon.bundle.getString("missingTargetSite"));
            return;
        }
        SAMLServiceManager.SiteEntry siteEntry = this.getDestSite(string);
        String string2 = null;
        if (siteEntry == null || (string2 = siteEntry.getPOSTUrl()) == null) {
            String[] stringArray = new String[]{SAMLUtilsCommon.bundle.getString("targetForbidden"), string};
            LogUtils.error(Level.INFO, "TARGET_FORBIDDEN", stringArray, sSOToken);
            httpServletResponse.sendError(400, SAMLUtilsCommon.bundle.getString("targetForbidden") + " " + string);
            return;
        }
        Response response = null;
        try {
            Object object3;
            object2 = siteEntry.getVersion();
            int n = 1;
            int n2 = SAMLConstants.PROTOCOL_MINOR_VERSION;
            if (object2 != null && ((StringTokenizer)(object3 = new StringTokenizer((String)object2, "."))).countTokens() == 2) {
                n = Integer.parseInt(((StringTokenizer)object3).nextToken().trim());
                n2 = Integer.parseInt(((StringTokenizer)object3).nextToken().trim());
            }
            object3 = AssertionManager.getInstance();
            Assertion assertion = ((AssertionManager)object3).createSSOAssertion(sSOToken.getTokenID().toString(), null, siteEntry.getSourceID(), string, n + "." + n2);
            StatusCode statusCode = new StatusCode("samlp:Success");
            Status status = new Status(statusCode);
            ArrayList<Assertion> arrayList = new ArrayList<Assertion>();
            arrayList.add(assertion);
            response = new Response(null, status, string2, arrayList);
            response.setMajorVersion(n);
            response.setMinorVersion(n2);
        }
        catch (NumberFormatException numberFormatException) {
            SAMLUtilsCommon.debug.error("SAMLPOSTProfileServlet.doGet: Exception when creating Response: ", (Throwable)numberFormatException);
            httpServletResponse.sendError(500, numberFormatException.getMessage());
            return;
        }
        catch (SAMLException sAMLException) {
            SAMLUtilsCommon.debug.error("SAMLPOSTProfileServlet.doGet: Exception when creating Response: ", (Throwable)sAMLException);
            httpServletResponse.sendError(500, sAMLException.getMessage());
            return;
        }
        object2 = null;
        try {
            response.signXML();
            if (SAMLUtilsCommon.debug.messageEnabled()) {
                SAMLUtilsCommon.debug.message("SAMLPOSTProfileServlet.doGet - signResponse: signed samlResponse is" + response.toString(true, true, true));
            }
            object2 = SAMLUtils.getResponseBytes(response);
        }
        catch (Exception exception) {
            SAMLUtilsCommon.debug.error("SAMLPOSTProfileServlet.doGet: Exception when signing the response:", (Throwable)exception);
            httpServletResponse.sendError(500, SAMLUtilsCommon.bundle.getString("errorSigningResponse"));
            return;
        }
        String string3 = null;
        try {
            string3 = Base64.encode((byte[])object2, (int)76).trim();
        }
        catch (Exception exception) {
            SAMLUtilsCommon.debug.error("SAMLPOSTProfileServlet.doGet: Exception when encoding the response:", (Throwable)exception);
            httpServletResponse.sendError(500, SAMLUtilsCommon.bundle.getString("errorEncodeResponse"));
            return;
        }
        if (LogUtils.isLoggable(Level.FINER)) {
            object = new String[]{SAMLUtilsCommon.bundle.getString("redirectTo"), string, string2, new String((byte[])object2, "UTF-8")};
            LogUtils.access(Level.FINER, "REDIRECT_TO_URL", (String[])object, sSOToken);
        } else {
            object = new String[]{SAMLUtilsCommon.bundle.getString("redirectTo"), string, string2};
            LogUtils.access(Level.INFO, "REDIRECT_TO_URL", (String[])object, sSOToken);
        }
        httpServletResponse.setContentType("text/html; charset=UTF-8");
        object = httpServletResponse.getWriter();
        ((PrintWriter)object).println("<HTML>");
        ((PrintWriter)object).println("<BODY Onload=\"document.forms[0].submit()\">");
        ((PrintWriter)object).println("<FORM METHOD=\"POST\" ACTION=\"" + string2 + "\">");
        ((PrintWriter)object).println("<INPUT TYPE=\"HIDDEN\" NAME=\"SAMLResponse\" ");
        ((PrintWriter)object).println("VALUE=\"" + string3 + "\">");
        ((PrintWriter)object).println("<INPUT TYPE=\"HIDDEN\" NAME=\"TARGET\" VALUE=\"" + string + "\"> </FORM>");
        ((PrintWriter)object).println("</BODY></HTML>");
        ((PrintWriter)object).close();
    }

    private SAMLServiceManager.SiteEntry getDestSite(String string) {
        SAMLServiceManager.SiteEntry siteEntry = null;
        try {
            URL uRL = new URL(string);
            String string2 = uRL.getHost();
            int n = uRL.getPort();
            if (string2 == null) {
                SAMLUtilsCommon.debug.error("SAMLPOSTProfileServlet.getDestSite: missing host in target.");
                return null;
            }
            SAMLServiceManager.SiteEntry siteEntry2 = null;
            Iterator iterator = ((Set)SAMLServiceManager.getAttribute("iplanet-am-saml-trusted-server-list")).iterator();
            String string3 = null;
            int n2 = -1;
            while (iterator.hasNext()) {
                siteEntry2 = (SAMLServiceManager.SiteEntry)iterator.next();
                string3 = siteEntry2.getHostName();
                n2 = siteEntry2.getPort();
                if (string3 == null || string2.indexOf(string3) == -1) continue;
                if (n2 != -1) {
                    if (n2 != n) continue;
                    siteEntry = siteEntry2;
                    break;
                }
                siteEntry = siteEntry2;
            }
            if (siteEntry == null) {
                SAMLUtilsCommon.debug.error("SAMLPOSTProfileServlet.getDestSite:  No destSite found from the target.");
                return null;
            }
        }
        catch (Exception exception) {
            SAMLUtilsCommon.debug.error("SAMLPOSTProfileServlet.getDestSite: ", (Throwable)exception);
            return null;
        }
        return siteEntry;
    }

    private SSOToken getSSOToken(HttpServletRequest httpServletRequest) {
        SSOToken sSOToken = null;
        try {
            SSOTokenManager sSOTokenManager = SSOTokenManager.getInstance();
            sSOToken = sSOTokenManager.createSSOToken(httpServletRequest);
            if (sSOToken == null) {
                SAMLUtilsCommon.debug.error("SAMLPOSTProfileServlet.getSSOToken: SSOToken is null.");
                return null;
            }
            if (!sSOTokenManager.isValidToken(sSOToken)) {
                SAMLUtilsCommon.debug.error("SAMLPOSTProfileServlet.getSSOToken: SSOToken is invalid.");
                return null;
            }
        }
        catch (SSOException sSOException) {
            SAMLUtilsCommon.debug.error("SAMLPOSTProfileServlet.getSSOToken: Exception when getting SSOToken:", (Throwable)sSOException);
            return null;
        }
        return sSOToken;
    }

    public void doPost(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws ServletException, IOException {
        String[] stringArray;
        List list;
        Map map;
        byte[] byArray;
        String string;
        block19: {
            boolean bl;
            httpServletResponse.setContentType("text/html; charset=UTF-8");
            if (httpServletRequest == null || httpServletResponse == null) {
                String[] stringArray2 = new String[]{SAMLUtilsCommon.bundle.getString("nullInputParameter")};
                LogUtils.error(Level.INFO, "NULL_PARAMETER", stringArray2);
                httpServletResponse.sendError(400, SAMLUtilsCommon.bundle.getString("nullInputParameter"));
                return;
            }
            SAMLUtils.checkHTTPContentLength(httpServletRequest);
            string = httpServletRequest.getParameter("TARGET");
            if (string == null || string.equals("")) {
                String[] stringArray3 = new String[]{SAMLUtilsCommon.bundle.getString("missingTargetSite")};
                LogUtils.error(Level.INFO, "MISSING_TARGET", stringArray3);
                httpServletResponse.sendError(400, SAMLUtilsCommon.bundle.getString("missingTargetSite"));
                return;
            }
            String string2 = httpServletRequest.getParameter("SAMLResponse");
            if (string2 == null) {
                String[] stringArray4 = new String[]{SAMLUtilsCommon.bundle.getString("missingSAMLResponse")};
                LogUtils.error(Level.INFO, "MISSING_RESPONSE", stringArray4);
                httpServletResponse.sendError(400, SAMLUtilsCommon.bundle.getString("missingSAMLResponse"));
                return;
            }
            byArray = null;
            try {
                byArray = Base64.decode((String)string2);
            }
            catch (Exception exception) {
                SAMLUtilsCommon.debug.error("SAMLPOSTProfileServlet.doPost: Exception when decoding SAMLResponse:", (Throwable)exception);
                httpServletResponse.sendError(500, SAMLUtilsCommon.bundle.getString("errorDecodeResponse"));
                return;
            }
            Response response = SAMLUtils.getResponse(byArray);
            if (response == null) {
                String[] stringArray5 = new String[]{SAMLUtilsCommon.bundle.getString("errorObtainResponse")};
                LogUtils.error(Level.INFO, "RESPONSE_MESSAGE_ERROR", stringArray5);
                httpServletResponse.sendError(400, SAMLUtilsCommon.bundle.getString("errorObtainResponse"));
                return;
            }
            if (SAMLUtilsCommon.debug.messageEnabled()) {
                SAMLUtilsCommon.debug.message("SAMLPOSTProfileServlet.doPost: Received " + response.toString());
            }
            StringBuffer stringBuffer = httpServletRequest.getRequestURL();
            if (SAMLUtilsCommon.debug.messageEnabled()) {
                SAMLUtilsCommon.debug.message("SAMLPOSTProfileServlet.doPost: requestUrl=" + stringBuffer);
            }
            if (!(bl = SAMLUtils.verifyResponse(response, stringBuffer.toString(), httpServletRequest))) {
                String[] stringArray6 = new String[]{SAMLUtilsCommon.bundle.getString("invalidResponse")};
                LogUtils.error(Level.INFO, "INVALID_RESPONSE", stringArray6);
                httpServletResponse.sendError(400, SAMLUtilsCommon.bundle.getString("invalidResponse"));
                return;
            }
            map = null;
            list = null;
            Subject subject = null;
            try {
                subject = SAMLUtils.getAuthSubject(null, response, httpServletRequest, httpServletResponse, string);
                if (subject != null) {
                    SAMLUtilsCommon.debug.message("Your authenticated principals are : ");
                    stringArray = subject.getPrincipals().iterator();
                    while (stringArray.hasNext()) {
                        Principal principal = stringArray.next();
                        if (SAMLUtilsCommon.debug.messageEnabled()) {
                            SAMLUtilsCommon.debug.message("Principal name : " + principal.getClass().getName() + " Principal : " + principal.getName());
                        }
                        if (!(principal instanceof SAMLPrincipal)) continue;
                        SAMLPrincipal sAMLPrincipal = (SAMLPrincipal)principal;
                        list = sAMLPrincipal.getAssertions();
                        map = sAMLPrincipal.getAttrMap();
                        if (!SAMLUtilsCommon.debug.messageEnabled()) continue;
                        SAMLUtilsCommon.debug.message("GET Assertion : " + list);
                        SAMLUtilsCommon.debug.message("GET attrMap : " + map);
                    }
                    break block19;
                }
                SAMLUtilsCommon.debug.error("getAuthSubject: null subject");
                String[] stringArray7 = new String[]{SAMLUtilsCommon.bundle.getString("failedCreateSSOToken")};
                LogUtils.error(Level.INFO, "FAILED_TO_CREATE_SSO_TOKEN", stringArray7);
                httpServletResponse.sendError(500, SAMLUtilsCommon.bundle.getString("failedCreateSSOToken"));
                return;
            }
            catch (Exception exception) {
                SAMLUtilsCommon.debug.error("getAuthSubject: ", (Throwable)exception);
                String[] stringArray8 = new String[]{SAMLUtilsCommon.bundle.getString("failedCreateSSOToken")};
                LogUtils.error(Level.INFO, "FAILED_TO_CREATE_SSO_TOKEN", stringArray8);
                httpServletResponse.sendError(500, exception.getMessage());
                return;
            }
        }
        if (LogUtils.isLoggable(Level.FINER)) {
            stringArray = new String[]{SAMLUtilsCommon.bundle.getString("accessGranted"), new String(byArray, "UTF-8")};
            LogUtils.access(Level.FINER, "ACCESS_GRANTED", stringArray);
        } else {
            stringArray = new String[]{SAMLUtilsCommon.bundle.getString("accessGranted")};
            LogUtils.access(Level.INFO, "ACCESS_GRANTED", stringArray);
        }
        if (SAMLUtils.postYN(string)) {
            if (SAMLUtilsCommon.debug.messageEnabled()) {
                SAMLUtilsCommon.debug.message("POST to target:" + string);
            }
            SAMLUtils.postToTarget(httpServletResponse, list, string, map);
        } else {
            httpServletResponse.setHeader("Location", string);
            httpServletResponse.sendRedirect(string);
        }
    }
}

