/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.saml.protocol;

import com.sun.identity.saml.assertion.Subject;
import com.sun.identity.saml.common.SAMLException;
import com.sun.identity.saml.common.SAMLRequesterException;
import com.sun.identity.saml.common.SAMLUtils;
import com.sun.identity.saml.common.SAMLUtilsCommon;
import com.sun.identity.saml.protocol.SubjectQuery;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class AuthenticationQuery
extends SubjectQuery {
    protected String authMethod = null;

    protected AuthenticationQuery() {
    }

    public AuthenticationQuery(Element element) throws SAMLException {
        if (element == null) {
            SAMLUtilsCommon.debug.message("AuthenticationQuery: null input.");
            throw new SAMLRequesterException(SAMLUtilsCommon.bundle.getString("nullInput"));
        }
        boolean bl = SAMLUtils.checkQuery(element, "AuthenticationQuery");
        if (!bl) {
            SAMLUtilsCommon.debug.message("AuthenticationQuery: Wrong input.");
            throw new SAMLRequesterException(SAMLUtilsCommon.bundle.getString("wrongInput"));
        }
        NodeList nodeList = element.getChildNodes();
        int n = nodeList.getLength();
        int n2 = 0;
        while (n2 < n) {
            Node node = nodeList.item(n2);
            String string = node.getLocalName();
            if (string != null) {
                if (string.equals("Subject")) {
                    if (this.subject != null) {
                        if (SAMLUtilsCommon.debug.messageEnabled()) {
                            SAMLUtilsCommon.debug.message("AuthenticationQuery: contained more than one <Subject>");
                        }
                        throw new SAMLRequesterException(SAMLUtilsCommon.bundle.getString("moreElement"));
                    }
                    this.subject = new Subject((Element)node);
                } else {
                    if (SAMLUtilsCommon.debug.messageEnabled()) {
                        SAMLUtilsCommon.debug.message("AuthenticationQuery: included wrong element:" + string);
                    }
                    throw new SAMLRequesterException(SAMLUtilsCommon.bundle.getString("wrongInput"));
                }
            }
            ++n2;
        }
        if (this.subject == null) {
            SAMLUtilsCommon.debug.message("AuthenticationQuery: missing Subject.");
            throw new SAMLRequesterException(SAMLUtilsCommon.bundle.getString("missingElement"));
        }
        if (element.hasAttribute("AuthenticationMethod")) {
            this.authMethod = element.getAttribute("AuthenticationMethod");
        }
    }

    public AuthenticationQuery(Subject subject, String string) throws SAMLException {
        if (subject == null) {
            SAMLUtilsCommon.debug.message("AuthenticationQuery: missing Subject.");
            throw new SAMLRequesterException(SAMLUtilsCommon.bundle.getString("missingElement"));
        }
        this.subject = subject;
        this.authMethod = string;
    }

    public AuthenticationQuery(Subject subject) throws SAMLException {
        if (subject == null) {
            SAMLUtilsCommon.debug.message("AuthenticationQuery: missing Subject.");
            throw new SAMLRequesterException(SAMLUtilsCommon.bundle.getString("missingElement"));
        }
        this.subject = subject;
    }

    public String getAuthenticationMethod() {
        return this.authMethod;
    }

    public int getQueryType() {
        return 0;
    }

    public String toString() {
        return this.toString(true, false);
    }

    public String toString(boolean bl, boolean bl2) {
        StringBuffer stringBuffer = new StringBuffer(200);
        String string = "";
        String string2 = "";
        if (bl) {
            string = "samlp:";
        }
        if (bl2) {
            string2 = " xmlns:samlp=\"urn:oasis:names:tc:SAML:1.0:protocol\"";
        }
        stringBuffer.append("<").append(string).append("AuthenticationQuery").append(string2);
        if (this.authMethod != null) {
            stringBuffer.append(" AuthenticationMethod=\"").append(this.authMethod).append("\"");
        }
        stringBuffer.append(">\n").append(this.subject.toString(true, true));
        stringBuffer.append("</").append(string).append("AuthenticationQuery>\n");
        return stringBuffer.toString();
    }
}

