/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.saml.common;

import com.iplanet.am.util.AMURLEncDec;
import com.iplanet.am.util.Debug;
import com.iplanet.am.util.SystemProperties;
import com.iplanet.am.util.XMLUtils;
import com.iplanet.services.naming.ServerEntryNotFoundException;
import com.iplanet.services.naming.WebtopNaming;
import com.iplanet.services.util.Base64;
import com.iplanet.services.util.CookieUtils;
import com.iplanet.sso.SSOException;
import com.iplanet.sso.SSOToken;
import com.iplanet.sso.SSOTokenManager;
import com.sun.identity.authentication.AuthContext;
import com.sun.identity.authentication.spi.AuthLoginException;
import com.sun.identity.authentication.spi.SAMLCallback;
import com.sun.identity.idm.AMIdentity;
import com.sun.identity.idm.AMIdentityRepository;
import com.sun.identity.idm.IdRepoException;
import com.sun.identity.idm.IdSearchControl;
import com.sun.identity.idm.IdSearchResults;
import com.sun.identity.idm.IdType;
import com.sun.identity.saml.assertion.Assertion;
import com.sun.identity.saml.assertion.Attribute;
import com.sun.identity.saml.assertion.AttributeStatement;
import com.sun.identity.saml.assertion.AudienceRestrictionCondition;
import com.sun.identity.saml.assertion.AuthenticationStatement;
import com.sun.identity.saml.assertion.Condition;
import com.sun.identity.saml.assertion.Conditions;
import com.sun.identity.saml.assertion.Statement;
import com.sun.identity.saml.assertion.Subject;
import com.sun.identity.saml.assertion.SubjectConfirmation;
import com.sun.identity.saml.assertion.SubjectStatement;
import com.sun.identity.saml.common.SAMLConstants;
import com.sun.identity.saml.common.SAMLException;
import com.sun.identity.saml.common.SAMLServiceManager;
import com.sun.identity.saml.common.SAMLUtilsCommon;
import com.sun.identity.saml.plugins.PartnerAccountMapper;
import com.sun.identity.saml.protocol.Response;
import com.sun.identity.saml.servlet.POSTCleanUpThread;
import com.sun.identity.saml.xmlsig.XMLSignatureManager;
import com.sun.identity.sm.ServiceSchema;
import com.sun.identity.sm.ServiceSchemaManager;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URL;
import java.security.MessageDigest;
import java.text.StringCharacterIterator;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.NameCallback;
import javax.security.auth.callback.UnsupportedCallbackException;
import javax.servlet.ServletException;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import netscape.ldap.util.DN;
import netscape.ldap.util.RDN;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;

public class SAMLUtils
extends SAMLUtilsCommon {
    public static final String HTTP_MAX_CONTENT_LENGTH = "com.sun.identity.saml.request.maxContentLength";
    public static final int defaultMaxLength = 16384;
    public static final String DEFAULT_CONTENT_LENGTH = String.valueOf(16384);
    private static int maxContentLength = 0;
    private static Map idTimeMap = new HashMap();
    private static Thread cThread = null;
    private static SSOToken ssoToken;

    private SAMLUtils() {
    }

    public static String generateAssertionID() {
        String string;
        String string2;
        block4: {
            string2 = SAMLUtilsCommon.generateID();
            if (string2 == null) {
                return null;
            }
            string = null;
            try {
                string = WebtopNaming.getServerID((String)SAMLServiceManager.getServerProtocol(), (String)SAMLServiceManager.getServerHost(), (String)SAMLServiceManager.getServerPort());
            }
            catch (Exception exception) {
                if (!SAMLUtilsCommon.debug.messageEnabled()) break block4;
                SAMLUtilsCommon.debug.message("SAMLUtil:generateAssertionID: exception obtain serverID:", (Throwable)exception);
            }
        }
        if (string == null) {
            return string2;
        }
        return string2 + string;
    }

    public static boolean checkQuery(Element element, String string) {
        String string2 = element.getLocalName();
        if (string2 == null) {
            return false;
        }
        if (string2.equals("Query") || string2.equals("SubjectQuery")) {
            NamedNodeMap namedNodeMap = element.getAttributes();
            int n = namedNodeMap.getLength();
            boolean bl = false;
            int n2 = 0;
            while (n2 < n) {
                Attr attr = (Attr)namedNodeMap.item(n2);
                String string3 = attr.getLocalName();
                if (string3 != null && string3.equals("type") && attr.getNodeValue().equals(string + "Type")) {
                    bl = true;
                    break;
                }
                ++n2;
            }
            if (!bl) {
                return false;
            }
        } else if (!string2.equals(string)) {
            return false;
        }
        return true;
    }

    public static String getDecodedSourceIDString(String string) {
        String string2 = null;
        if (string == null) {
            SAMLUtilsCommon.debug.error("SAMLUtils.getDecodedSourceIDString: null input.");
            return null;
        }
        try {
            string2 = SAMLUtils.byteArrayToString(Base64.decode((String)string));
        }
        catch (Exception exception) {
            SAMLUtilsCommon.debug.error("SAMLUtils.getDecodedSourceIDString: ", (Throwable)exception);
            return null;
        }
        return string2;
    }

    public static String generateSourceID(String string) {
        if (string == null || string.length() == 0) {
            SAMLUtilsCommon.debug.error("SAMLUtils.genrateSourceID: empty siteURL.");
            return null;
        }
        MessageDigest messageDigest = null;
        try {
            messageDigest = MessageDigest.getInstance("SHA");
        }
        catch (Exception exception) {
            SAMLUtilsCommon.debug.error("SAMLUtils.generateSourceID: Exception when generating digest:", (Throwable)exception);
            return null;
        }
        messageDigest.update(SAMLUtils.stringToByteArray(string));
        byte[] byArray = messageDigest.digest();
        String string2 = null;
        try {
            string2 = Base64.encode((byte[])byArray).trim();
        }
        catch (Exception exception) {
            SAMLUtilsCommon.debug.error("SAMLUtils.generateSourceID: Exception:", (Throwable)exception);
        }
        return string2;
    }

    public static String generateAssertionHandle() {
        byte[] byArray;
        String string;
        byte[] byArray2;
        block5: {
            if (SAMLUtilsCommon.random == null) {
                return null;
            }
            byArray2 = new byte[20];
            SAMLUtilsCommon.random.nextBytes(byArray2);
            string = null;
            try {
                string = WebtopNaming.getServerID((String)SAMLServiceManager.getServerProtocol(), (String)SAMLServiceManager.getServerHost(), (String)SAMLServiceManager.getServerPort());
            }
            catch (Exception exception) {
                if (!SAMLUtilsCommon.debug.messageEnabled()) break block5;
                SAMLUtilsCommon.debug.message("SAMLUtil:generateAssertionHandle: exception obtain serverID:", (Throwable)exception);
            }
        }
        if (string != null && (byArray = SAMLUtils.stringToByteArray(string)).length < byArray2.length) {
            int n = 1;
            while (n <= byArray.length) {
                byArray2[byArray2.length - n] = byArray[byArray.length - n];
                ++n;
            }
        }
        return SAMLUtils.byteArrayToString(byArray2);
    }

    public static byte[] hexStringToByteArray(String string) {
        int n = string.length();
        byte[] byArray = new byte[n / 2];
        int n2 = 0;
        int n3 = 0;
        while (n2 < n) {
            String string2 = string.substring(n2, n2 + 2);
            byArray[n3] = new Short(Integer.toString(Integer.parseInt(string2, 16))).byteValue();
            ++n2;
            ++n2;
            ++n3;
        }
        return byArray;
    }

    public static String hexStringToBase64(String string) {
        String string2;
        block4: {
            int n = string.length();
            byte[] byArray = new byte[n / 2];
            int n2 = 0;
            int n3 = 0;
            while (n2 < n) {
                string2 = string.substring(n2, n2 + 2);
                byArray[n3] = new Short(Integer.toString(Integer.parseInt(string2, 16))).byteValue();
                ++n2;
                ++n2;
                ++n3;
            }
            string2 = null;
            try {
                string2 = Base64.encode((byte[])byArray).trim();
            }
            catch (Exception exception) {
                if (!SAMLUtilsCommon.debug.messageEnabled()) break block4;
                SAMLUtilsCommon.debug.message("SAMLUtil:hexStringToBase64: exception encode input:", (Throwable)exception);
            }
        }
        if (SAMLUtilsCommon.debug.messageEnabled()) {
            SAMLUtilsCommon.debug.message("base 64 source id is :" + string2);
        }
        return string2;
    }

    public static SAMLServiceManager.SOAPEntry getSourceSite(String string) {
        if (string == null) {
            return null;
        }
        Map map = (Map)SAMLServiceManager.getAttribute("iplanet-am-saml-partner-urls");
        if (map == null) {
            SAMLUtilsCommon.debug.error("SAMLUtils.isOnPartnerURLList: PartnerURL list is null.");
            return null;
        }
        Iterator iterator = map.values().iterator();
        boolean bl = false;
        SAMLServiceManager.SOAPEntry sOAPEntry = null;
        String string2 = null;
        while (iterator.hasNext()) {
            sOAPEntry = (SAMLServiceManager.SOAPEntry)iterator.next();
            if (sOAPEntry == null || (string2 = sOAPEntry.getIssuer()) == null || !string2.equals(string)) continue;
            bl = true;
            break;
        }
        if (bl) {
            return sOAPEntry;
        }
        return null;
    }

    public static void main(String[] stringArray) {
        if (stringArray.length != 1) {
            System.out.println("usage : java SAMLUtils <host_name>");
            return;
        }
        System.out.println(SAMLUtils.generateSourceID(stringArray[0]));
    }

    public static boolean isCorrectConfirmationMethod(SubjectConfirmation subjectConfirmation) {
        if (subjectConfirmation == null) {
            return false;
        }
        Set set = subjectConfirmation.getConfirmationMethod();
        if (set == null || set.size() != 1) {
            if (SAMLUtilsCommon.debug.messageEnabled()) {
                SAMLUtilsCommon.debug.message("SAMLUtils.isCorrectConfirmationMethod: missing ConfirmationMethod in the Subject.");
            }
            return false;
        }
        String string = (String)set.iterator().next();
        if (string == null || !string.equals("urn:com:sun:identity")) {
            if (SAMLUtilsCommon.debug.messageEnabled()) {
                SAMLUtilsCommon.debug.message("SAMLUtils.isCorrectConfirmationMethod: wrong ConfirmationMethod value.");
            }
            return false;
        }
        return true;
    }

    public static boolean isAuthNAssertion(Assertion assertion) {
        if (assertion == null) {
            return false;
        }
        if (!assertion.isTimeValid() || !assertion.isSignatureValid()) {
            return false;
        }
        Set set = assertion.getStatement();
        Statement statement = null;
        Iterator iterator = set.iterator();
        while (iterator.hasNext()) {
            statement = (Statement)iterator.next();
            if (statement.getStatementType() != 1) continue;
            return true;
        }
        return false;
    }

    public static byte[] stringToByteArray(String string) {
        char[] cArray = string.toCharArray();
        byte[] byArray = new byte[cArray.length];
        int n = 0;
        while (n < cArray.length) {
            byArray[n] = (byte)cArray[n];
            ++n;
        }
        return byArray;
    }

    public static String byteArrayToString(byte[] byArray) {
        char[] cArray = new char[byArray.length];
        int n = 0;
        while (n < byArray.length) {
            cArray[n] = (char)byArray[n];
            ++n;
        }
        return new String(cArray);
    }

    public static String getServerID(String string) {
        if (string == null) {
            return null;
        }
        int n = string.length();
        String string2 = null;
        if (n >= 2) {
            string2 = string.substring(n - 2, n);
            return string2;
        }
        return null;
    }

    public static String getServerURL(String string) {
        String string2 = SAMLUtils.getServerID(string);
        if (string2 == null) {
            return null;
        }
        if (SAMLUtilsCommon.debug.messageEnabled()) {
            SAMLUtilsCommon.debug.message("SAMLUtils.getServerURL: id=" + string2);
        }
        String string3 = null;
        try {
            string3 = WebtopNaming.getServerFromID((String)string2);
        }
        catch (ServerEntryNotFoundException serverEntryNotFoundException) {
            if (SAMLUtilsCommon.debug.messageEnabled()) {
                SAMLUtilsCommon.debug.message("SAMLUtils.getServerURL: ServerEntryNotFoundException for " + string2);
            }
            return null;
        }
        String string4 = SAMLServiceManager.getServerURL();
        if (SAMLUtilsCommon.debug.messageEnabled()) {
            SAMLUtilsCommon.debug.message("SAMLUtils.getServerURL: remoteUrl=" + string3 + ", thisUrl=" + string4);
        }
        if (string3 == null || string4 == null || string3.equals(string4)) {
            return null;
        }
        return string3;
    }

    public static String getFullServiceURL(String string) {
        String string2;
        block3: {
            string2 = null;
            try {
                URL uRL = new URL(string);
                URL uRL2 = WebtopNaming.getServiceURL((String)"samlassertionmanager", (String)uRL.getProtocol(), (String)uRL.getHost(), (String)Integer.toString(uRL.getPort()));
                string2 = uRL2.toString();
                if (SAMLUtilsCommon.debug.messageEnabled()) {
                    SAMLUtilsCommon.debug.message("SAMLUtils.getFullServiceURL:full remote URL is: " + string2);
                }
            }
            catch (Exception exception) {
                if (!SAMLUtilsCommon.debug.warningEnabled()) break block3;
                SAMLUtilsCommon.debug.warning("SAMLUtils.getFullServiceURL:Exception:", (Throwable)exception);
            }
        }
        return string2;
    }

    public static void addEnvParamsFromAssertion(Map map, Assertion assertion, Subject subject) {
        Set set = assertion.getStatement();
        Statement statement = null;
        Iterator iterator = null;
        List list = null;
        Iterator iterator2 = null;
        Attribute attribute = null;
        Element element = null;
        List list2 = null;
        String string = null;
        String string2 = null;
        if (set != null && !set.isEmpty()) {
            iterator = set.iterator();
            while (iterator.hasNext()) {
                statement = (Statement)iterator.next();
                if (statement.getStatementType() != 3 || !subject.equals(((AttributeStatement)statement).getSubject())) continue;
                list = ((AttributeStatement)statement).getAttribute();
                iterator2 = list.iterator();
                while (iterator2.hasNext()) {
                    attribute = (Attribute)iterator2.next();
                    try {
                        list2 = attribute.getAttributeValue();
                    }
                    catch (Exception exception) {
                        SAMLUtilsCommon.debug.error("SAMLUtils.addEnvParamsFromAssertion: cannot obtain attribute value:", (Throwable)exception);
                        continue;
                    }
                    string = attribute.getAttributeName();
                    element = (Element)list2.get(0);
                    if (list2.size() == 1 && !XMLUtils.hasElementChild((Node)element)) {
                        string2 = XMLUtils.getElementValue((Element)element);
                        try {
                            if (SAMLUtilsCommon.debug.messageEnabled()) {
                                SAMLUtilsCommon.debug.message("SAMLUtils.addEnvParamsFromAssertion: attrName = " + string + " attrValue = " + string2);
                            }
                            map.put(string, string2);
                        }
                        catch (Exception exception) {}
                        continue;
                    }
                    try {
                        map.put(string, list2);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            }
        }
    }

    public static int getMaxContentLength() {
        return maxContentLength;
    }

    public static void checkHTTPContentLength(HttpServletRequest httpServletRequest) throws ServletException {
        if (maxContentLength != 0) {
            int n = httpServletRequest.getContentLength();
            if (SAMLUtilsCommon.debug.messageEnabled()) {
                SAMLUtilsCommon.debug.message("HttpRequest content length= " + n);
            }
            if (n > maxContentLength) {
                if (SAMLUtilsCommon.debug.messageEnabled()) {
                    SAMLUtilsCommon.debug.message("content length too large" + n);
                }
                throw new ServletException(SAMLUtilsCommon.bundle.getString("largeContentLength"));
            }
        }
    }

    public static void postToTarget(HttpServletResponse httpServletResponse, List list, String string, Map map) throws IOException {
        PrintWriter printWriter = httpServletResponse.getWriter();
        printWriter.println("<HTML>");
        printWriter.println("<HEAD>\n");
        printWriter.println("<TITLE>Access rights validated</TITLE>\n");
        printWriter.println("</HEAD>\n");
        printWriter.println("<BODY Onload=\"document.forms[0].submit()\">");
        Iterator iterator = null;
        if (SAMLUtilsCommon.debug.messageEnabled()) {
            printWriter.println("<H1>Access rights validated</H1>\n");
            printWriter.println("<meta http-equiv=\"refresh\" content=\"20\">\n");
            printWriter.println("<P>We have verified your access rights <STRONG></STRONG> according to the assertion shown below. \n");
            printWriter.println("You are being redirected to the resource.\n");
            printWriter.println("Please wait ......\n");
            printWriter.println("</P>\n");
            printWriter.println("<HR><P>\n");
            if (list != null) {
                iterator = list.iterator();
                while (iterator.hasNext()) {
                    printWriter.println(SAMLUtils.displayXML((String)iterator.next()));
                }
            }
            printWriter.println("</P>\n");
        }
        printWriter.println("<FORM METHOD=\"POST\" ACTION=\"" + string + "\">");
        if (list != null) {
            iterator = list.iterator();
            while (iterator.hasNext()) {
                printWriter.println("<INPUT TYPE=\"HIDDEN\" NAME=\"ASSERTION\"");
                printWriter.println("VALUE=\"" + AMURLEncDec.encode((String)((String)iterator.next())) + "\">");
            }
        }
        if (map != null && !map.isEmpty()) {
            StringBuffer stringBuffer = new StringBuffer();
            Set set = map.entrySet();
            Iterator iterator2 = set.iterator();
            while (iterator2.hasNext()) {
                Map.Entry entry = iterator2.next();
                String string2 = SAMLUtils.HTMLEncode((String)entry.getKey(), '\"');
                String string3 = SAMLUtils.HTMLEncode((String)entry.getValue(), '\"');
                printWriter.println("<INPUT TYPE=\"HIDDEN\" NAME=\"" + string2 + "\" VALUE=\"" + string3 + "\">");
                if (stringBuffer.length() > 0) {
                    stringBuffer.append(":");
                }
                stringBuffer.append(string2);
            }
            printWriter.println("<INPUT TYPE=\"HIDDEN\" NAME=\"ATTRIBUTENAMES\" VALUE=\"" + stringBuffer + "\">");
        }
        printWriter.println("</FORM>");
        printWriter.println("</BODY></HTML>");
        printWriter.close();
    }

    public static boolean postYN(String string) {
        SAMLUtilsCommon.debug.message("Inside postYN()");
        if (string == null || string.equals("")) {
            return false;
        }
        Set set = (Set)SAMLServiceManager.getAttribute("iplanet-am-saml-post-to-target-urls");
        if (set == null || set.size() == 0) {
            return false;
        }
        URL uRL = null;
        try {
            uRL = new URL(string);
        }
        catch (MalformedURLException malformedURLException) {
            SAMLUtilsCommon.debug.error("SAMLUtils:postYN(): Malformed URL passed");
            return false;
        }
        String string2 = uRL.getHost();
        int n = uRL.getPort();
        String string3 = uRL.getPath();
        String string4 = string2.toLowerCase() + ":" + String.valueOf(n) + "/" + string3;
        return set.contains(string4);
    }

    public static String HTMLEncode(String string, char c) {
        int n;
        if (string == null) {
            return null;
        }
        int n2 = 0;
        StringBuffer stringBuffer = new StringBuffer();
        while ((n = string.indexOf(c, n2)) != -1) {
            stringBuffer.append(string.substring(n2, n)).append("&#" + c + ";");
            n2 = n + 1;
        }
        stringBuffer.append(string.substring(n2));
        return stringBuffer.toString();
    }

    public static String displayXML(String string) {
        SAMLUtilsCommon.debug.message("In displayXML ");
        StringCharacterIterator stringCharacterIterator = new StringCharacterIterator(string);
        StringBuffer stringBuffer = new StringBuffer();
        char c = stringCharacterIterator.first();
        while (c != '\uffff') {
            if (c == '>') {
                stringBuffer.append("&gt;");
            } else if (c == '<') {
                stringBuffer.append("&lt;");
            } else if (c == '\n') {
                stringBuffer.append("<BR>\n");
            } else {
                stringBuffer.append(c);
            }
            c = stringCharacterIterator.next();
        }
        return stringBuffer.toString();
    }

    public static javax.security.auth.Subject getAuthSubject(String[] stringArray, Response response, HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, String string) throws Exception {
        Callback[] callbackArray;
        String string2;
        AuthContext authContext;
        SSOToken sSOToken;
        javax.security.auth.Subject subject;
        block13: {
            subject = null;
            sSOToken = null;
            authContext = null;
            string2 = "/";
            SSOTokenManager sSOTokenManager = null;
            try {
                sSOTokenManager = SSOTokenManager.getInstance();
                sSOToken = sSOTokenManager.createSSOToken(httpServletRequest);
                if (sSOToken != null && !sSOTokenManager.isValidToken(sSOToken)) {
                    sSOToken = null;
                }
            }
            catch (SSOException sSOException) {
                if (!SAMLUtilsCommon.debug.messageEnabled()) break block13;
                SAMLUtilsCommon.debug.message("getAuthSubject : No SSOToken in the request cookie. Generating from Auth...", (Throwable)sSOException);
            }
        }
        try {
            authContext = sSOToken != null ? new AuthContext(sSOToken) : new AuthContext(string2);
            callbackArray = AuthContext.IndexType.MODULE_INSTANCE;
            String string3 = "SAML";
            SAMLUtilsCommon.debug.message("SAML auth module : Obtained AuthContext");
            authContext.login((AuthContext.IndexType)callbackArray, string3);
        }
        catch (AuthLoginException authLoginException) {
            authLoginException.printStackTrace();
            SAMLUtilsCommon.debug.message("Login failed!!");
            return null;
        }
        callbackArray = null;
        while (authContext.hasMoreRequirements()) {
            callbackArray = authContext.getRequirements();
            if (callbackArray == null) continue;
            try {
                SAMLUtils.processCallbacks(callbackArray, stringArray, response, string);
                authContext.submitRequirements(callbackArray);
            }
            catch (Exception exception) {
                SAMLUtilsCommon.debug.message("Login failed!!" + exception.toString());
                return null;
            }
        }
        if (authContext.getStatus() == AuthContext.Status.SUCCESS) {
            SAMLUtilsCommon.debug.message("Login success!!");
            SAMLUtilsCommon.debug.message("Getting SSOToken from Auth API");
            sSOToken = authContext.getSSOToken();
            SAMLUtilsCommon.debug.message("Getting Subject from Auth API");
            subject = authContext.getSubject();
            SAMLUtils.setCookieInHttpResponse(sSOToken, httpServletResponse);
        } else if (authContext.getStatus() == AuthContext.Status.FAILED) {
            SAMLUtilsCommon.debug.message("Login has failed!!");
        } else if (SAMLUtilsCommon.debug.messageEnabled()) {
            SAMLUtilsCommon.debug.message("Unknown status: " + authContext.getStatus());
        }
        return subject;
    }

    private static void processCallbacks(Callback[] callbackArray, String[] stringArray, Response response, String string) throws UnsupportedCallbackException {
        SAMLUtilsCommon.debug.message("begin processCallbacks()");
        int n = 0;
        try {
            n = 0;
            while (n < callbackArray.length) {
                Callback callback;
                if (callbackArray[n] instanceof SAMLCallback) {
                    SAMLUtilsCommon.debug.message("Got SAMLCallback");
                    callback = (SAMLCallback)callbackArray[n];
                    SAMLUtilsCommon.debug.message(((SAMLCallback)callback).getPrompt());
                    if (stringArray != null) {
                        ((SAMLCallback)callback).setType(1);
                        ((SAMLCallback)callback).setArtifact(stringArray);
                    } else if (response != null) {
                        ((SAMLCallback)callback).setType(2);
                        ((SAMLCallback)callback).setSamlResponse(response);
                        ((SAMLCallback)callback).setCheckSignature(true);
                    } else {
                        SAMLUtilsCommon.debug.error("Invalid input to SAMLCallback");
                    }
                } else if (callbackArray[n] instanceof NameCallback) {
                    SAMLUtilsCommon.debug.message("Got NameCallback");
                    callback = (NameCallback)callbackArray[n];
                    SAMLUtilsCommon.debug.message(((NameCallback)callback).getPrompt());
                    ((NameCallback)callback).setName(string);
                }
                ++n;
            }
        }
        catch (Exception exception) {
            throw new UnsupportedCallbackException(callbackArray[n], "Callback exception: " + exception);
        }
    }

    public static void setCookieInHttpResponse(SSOToken sSOToken, HttpServletResponse httpServletResponse) throws Exception {
        try {
            ServiceSchemaManager serviceSchemaManager = new ServiceSchemaManager("iPlanetAMPlatformService", sSOToken);
            ServiceSchema serviceSchema = serviceSchemaManager.getGlobalSchema();
            Set set = (Set)serviceSchema.getAttributeDefaults().get("iplanet-am-platform-cookie-domains");
            String string = sSOToken.getTokenID().toString();
            String string2 = SystemProperties.get((String)"com.iplanet.am.cookie.name");
            if (set.size() == 0) {
                if (SAMLUtilsCommon.debug.messageEnabled()) {
                    SAMLUtilsCommon.debug.message("SAMLUtils.generateSSOToken: cookie domain is null");
                }
                Cookie cookie = CookieUtils.newCookie((String)string2, (String)string, (String)"/");
                httpServletResponse.addCookie(cookie);
            } else {
                Iterator iterator = set.iterator();
                Cookie cookie = null;
                while (iterator.hasNext()) {
                    cookie = CookieUtils.newCookie((String)string2, (String)string, (String)"/", (String)((String)iterator.next()));
                    httpServletResponse.addCookie(cookie);
                }
            }
        }
        catch (Exception exception) {
            SAMLUtilsCommon.debug.message("setCookieInHttpResponse : " + exception);
        }
    }

    public static List getListOfAssertions(List list) {
        ArrayList<Assertion> arrayList;
        block4: {
            arrayList = new ArrayList<Assertion>();
            try {
                if (list != null) {
                    Iterator iterator = list.iterator();
                    while (iterator.hasNext()) {
                        Document document = XMLUtils.toDOMDocument((String)((String)iterator.next()), (Debug)SAMLUtilsCommon.debug);
                        Element element = document.getDocumentElement();
                        if (element == null) continue;
                        Assertion assertion = new Assertion(element);
                        arrayList.add(assertion);
                    }
                }
            }
            catch (Exception exception) {
                if (!SAMLUtilsCommon.debug.messageEnabled()) break block4;
                SAMLUtilsCommon.debug.message("SAMLUtils.getListOfAssertions : Exception : ", (Throwable)exception);
            }
        }
        return arrayList;
    }

    public static byte[] getResponseBytes(Response response) throws SAMLException {
        byte[] byArray = null;
        try {
            byArray = response.toString(true, true, true).getBytes("UTF-8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            if (SAMLUtilsCommon.debug.messageEnabled()) {
                SAMLUtilsCommon.debug.message("getResponseBytes : ", (Throwable)unsupportedEncodingException);
            }
            throw new SAMLException(unsupportedEncodingException.getMessage());
        }
        return byArray;
    }

    public static Response getResponse(byte[] byArray) {
        Response response = null;
        if (byArray == null) {
            return null;
        }
        try {
            response = Response.parseXML(new ByteArrayInputStream(byArray));
        }
        catch (SAMLException sAMLException) {
            SAMLUtilsCommon.debug.error("getResponse : ", (Throwable)sAMLException);
        }
        return response;
    }

    public static boolean verifyResponse(Response response, String string, HttpServletRequest httpServletRequest) {
        String string2 = response.getRecipient();
        if (string2 == null || string2.length() == 0 || !string2.equals(string) && !string2.equals(SAMLUtils.getLBURL(string, httpServletRequest))) {
            SAMLUtilsCommon.debug.error("verifyResponse : Incorrect Recipient.");
            return false;
        }
        if (!response.getStatus().getStatusCode().getValue().endsWith(":Success")) {
            SAMLUtilsCommon.debug.error("verifyResponse : Incorrect StatusCode value.");
            return false;
        }
        return true;
    }

    private static String getLBURL(String string, HttpServletRequest httpServletRequest) {
        String string2 = httpServletRequest.getHeader("host");
        if (string2 == null) {
            return string;
        }
        int n = string.indexOf("//");
        if (n == -1) {
            return string;
        }
        StringBuffer stringBuffer = new StringBuffer(200);
        stringBuffer.append(string.substring(0, n + 2)).append(string2);
        String string3 = string.substring(n + 2, string.length());
        n = string3.indexOf("/");
        if (n != -1) {
            stringBuffer.append(string3.substring(n, string3.length()));
        }
        if (SAMLUtilsCommon.debug.messageEnabled()) {
            SAMLUtilsCommon.debug.message("getLBURL: LBURL = " + stringBuffer.toString());
        }
        return stringBuffer.toString().trim();
    }

    public static List getStrAssertions(List list) {
        ArrayList<String> arrayList = new ArrayList<String>();
        if (list != null) {
            Iterator iterator = list.iterator();
            while (iterator.hasNext()) {
                arrayList.add(((Assertion)iterator.next()).toString(true, true));
            }
        }
        return arrayList;
    }

    public static boolean verifySignature(Response response) {
        return response == null || response.isSigned() && response.isSignatureValid();
    }

    public static Map getAttributeMap(SAMLServiceManager.SOAPEntry sOAPEntry, List list, Subject subject, String string) throws Exception {
        String string2 = sOAPEntry.getSourceID();
        String string3 = null;
        Object var6_6 = null;
        Map<String, String> map = new HashMap<String, String>();
        PartnerAccountMapper partnerAccountMapper = sOAPEntry.getPartnerAccountMapper();
        if (partnerAccountMapper != null) {
            Map map2 = partnerAccountMapper.getUser(list, string2, string);
            string3 = (String)map2.get("name");
            map = (Map)map2.get("attribute");
        } else {
            Map map3 = sOAPEntry.getAccountMapper().getUser(subject, string2);
            string3 = (String)map3.get("name");
        }
        if (map == null) {
            map = new HashMap();
        }
        map.put("USER_NAME", string3);
        if (SAMLUtilsCommon.debug.messageEnabled()) {
            SAMLUtilsCommon.debug.message("getAttributeMap : name = " + string3 + ", attrMap = " + map);
        }
        return map;
    }

    public static Map verifyAssertionAndGetSSMap(Response response) {
        Object object;
        Subject subject = null;
        SAMLServiceManager.SOAPEntry sOAPEntry = null;
        List list = response.getAssertion();
        Iterator iterator = list.iterator();
        Assertion assertion = null;
        String string = null;
        String string2 = null;
        Iterator iterator2 = null;
        Statement statement = null;
        int n = -1;
        Subject subject2 = null;
        SubjectConfirmation subjectConfirmation = null;
        Set set = null;
        String string3 = null;
        Date date = null;
        long l = System.currentTimeMillis() + 180000L;
        while (iterator.hasNext()) {
            assertion = (Assertion)iterator.next();
            string = assertion.getAssertionID();
            if (idTimeMap.containsKey(string)) {
                SAMLUtilsCommon.debug.error("verifyAssertion AndGetSSMap: Assertion: " + string + " is used.");
                return null;
            }
            string2 = assertion.getIssuer();
            sOAPEntry = SAMLUtils.getSourceSite(string2);
            if (sOAPEntry == null) {
                SAMLUtilsCommon.debug.error("verifyAsserti onAndGetSSMap: issuer is not on the Partner list.");
                return null;
            }
            if (!assertion.isSignatureValid()) {
                SAMLUtilsCommon.debug.error("verifyAssertion AndGetSSMap: assertion's signature is not valid.");
                return null;
            }
            if (!assertion.isTimeValid()) {
                SAMLUtilsCommon.debug.error("verifyAssertion AndGetSSMap: assertion's time is not valid.");
                return null;
            }
            iterator2 = assertion.getStatement().iterator();
            while (iterator2.hasNext()) {
                statement = (Statement)iterator2.next();
                n = statement.getStatementType();
                if (n != 1 && n != 3 && n != 2) continue;
                subject2 = ((SubjectStatement)statement).getSubject();
                subjectConfirmation = subject2.getSubjectConfirmation();
                if (subjectConfirmation == null || (set = subjectConfirmation.getConfirmationMethod()) == null || set.size() != 1) {
                    SAMLUtilsCommon.debug.error("verify AssertionAndGetSSMap: missing or extra ConfirmationMethod.");
                    return null;
                }
                string3 = (String)set.iterator().next();
                if (string3 == null || !string3.equals("urn:oasis:names:tc:SAML:1.0:cm:bearer")) {
                    SAMLUtilsCommon.debug.error("verify AssertionAndGetSSMap:wrong ConfirmationMethod.");
                    return null;
                }
                if (n != 1 || subject != null) continue;
                subject = subject2;
            }
            object = assertion.getConditions();
            if (object != null && (date = ((Conditions)object).getNotOnorAfter()) != null) {
                l = date.getTime();
            }
            if (SAMLUtilsCommon.debug.messageEnabled()) {
                SAMLUtilsCommon.debug.message("Adding " + string + " to idTimeMap.");
            }
            Map map = idTimeMap;
            synchronized (map) {
                idTimeMap.put(string, new Long(l));
            }
        }
        if (subject == null || sOAPEntry == null) {
            SAMLUtilsCommon.debug.error("verifyAssertion AndGetSSMap: couldn't find Subject.");
            return null;
        }
        object = new HashMap<String, Object>();
        object.put("subject", subject);
        object.put("sourceSite", sOAPEntry);
        object.put("assertion", list);
        return object;
    }

    private static boolean checkCondition(Assertion assertion) throws IOException {
        if (assertion == null) {
            return false;
        }
        if (!assertion.isSignatureValid()) {
            SAMLUtilsCommon.debug.error(SAMLUtilsCommon.bundle.getString("assertionSignatureNotValid"));
            return false;
        }
        if (!assertion.isTimeValid()) {
            SAMLUtilsCommon.debug.error(SAMLUtilsCommon.bundle.getString("assertionTimeNotValid"));
            return false;
        }
        Conditions conditions = assertion.getConditions();
        Set set = new HashSet();
        set = conditions.getAudienceRestrictionCondition();
        Iterator iterator = null;
        if (set != null && !set.isEmpty()) {
            iterator = set.iterator();
            while (iterator.hasNext()) {
                if (((AudienceRestrictionCondition)iterator.next()).evaluate() == Condition.INDETERMINATE) {
                    if (!SAMLUtilsCommon.debug.messageEnabled()) continue;
                    SAMLUtilsCommon.debug.message("Audience RestrictionConditions is indeterminate.");
                    continue;
                }
                SAMLUtilsCommon.debug.error("Failed AudienceRestrictionCondition");
                return false;
            }
        }
        return true;
    }

    public static Subject examAssertions(List list) throws IOException {
        if (list == null) {
            return null;
        }
        boolean bl = false;
        Subject subject = null;
        Iterator iterator = list.iterator();
        ArrayList arrayList = new ArrayList();
        while (iterator.hasNext()) {
            Assertion assertion = (Assertion)iterator.next();
            if (!SAMLUtils.checkCondition(assertion)) {
                return null;
            }
            SAMLUtilsCommon.debug.message("Passed checking Conditions!");
            Set set = new HashSet();
            set = assertion.getStatement();
            if (set == null || set.isEmpty()) {
                SAMLUtilsCommon.debug.error(SAMLUtilsCommon.bundle.getString("noStatement"));
                return null;
            }
            Iterator iterator2 = set.iterator();
            while (iterator2.hasNext()) {
                Statement statement = (Statement)iterator2.next();
                subject = ((SubjectStatement)statement).getSubject();
                SubjectConfirmation subjectConfirmation = subject.getSubjectConfirmation();
                Set set2 = new HashSet();
                set2 = subjectConfirmation.getConfirmationMethod();
                if (set2 == null || set2.isEmpty()) {
                    SAMLUtilsCommon.debug.error("Subject confirmation method is null");
                    return null;
                }
                String string = (String)set2.iterator().next();
                if (string != null && assertion.getMajorVersion() == 1 && (assertion.getMinorVersion() == 1 && string.equals(SAMLConstants.CONFIRMATION_METHOD_ARTIFACT) || assertion.getMinorVersion() == 0 && string.equals("urn:oasis:names:tc:SAML:1.0:cm:artifact-01"))) {
                    if (SAMLUtilsCommon.debug.messageEnabled()) {
                        SAMLUtilsCommon.debug.message("Correct Confirmation method");
                    }
                } else {
                    SAMLUtilsCommon.debug.error("Wrong Confirmation Method.");
                    return null;
                }
                if (!(statement instanceof AuthenticationStatement)) continue;
                bl = true;
            }
        }
        if (!bl) {
            SAMLUtilsCommon.debug.error(SAMLUtilsCommon.bundle.getString("noSSOAssertion"));
            return null;
        }
        return subject;
    }

    public static String removeNewLineChars(String string) {
        String string2 = null;
        if (string != null && string.length() > 0 && string.indexOf(10) != -1) {
            char[] cArray = string.toCharArray();
            int n = cArray.length;
            StringBuffer stringBuffer = new StringBuffer(n);
            int n2 = 0;
            while (n2 < n) {
                char c = cArray[n2];
                if (c != '\n') {
                    stringBuffer.append(c);
                }
                ++n2;
            }
            string2 = stringBuffer.toString();
        } else {
            string2 = string;
        }
        return string2;
    }

    public static boolean checkSignatureValid(String string, String string2, String string3) {
        Object object;
        String string4 = null;
        boolean bl = true;
        Map map = (Map)SAMLServiceManager.getAttribute("iplanet-am-saml-partner-urls");
        if (map != null && (object = (SAMLServiceManager.SOAPEntry)map.get(string3)) != null) {
            string4 = ((SAMLServiceManager.SOAPEntry)object).getCertAlias();
        }
        try {
            object = XMLSignatureManager.getInstance();
            bl = ((XMLSignatureManager)object).verifyXMLSignature(string, string2, string4);
        }
        catch (Exception exception) {
            SAMLUtilsCommon.debug.warning("SAMLUtils.checkSignatureValid: signature validation exception", (Throwable)exception);
            bl = false;
        }
        if (!bl && SAMLUtilsCommon.debug.messageEnabled()) {
            SAMLUtilsCommon.debug.message("SAMLUtils.checkSignatureValid: Couldn't verify signature.");
        }
        return bl;
    }

    public static AMIdentity getAMIdentity(IdType idType, String string, String string2) {
        block10: {
            if (SAMLUtilsCommon.debug.messageEnabled()) {
                SAMLUtilsCommon.debug.message("SAMLServiceManager.getAMIdentity: type=" + idType + ", name=" + string + ", realm=" + string2);
            }
            try {
                Object object;
                Object object2;
                if (string2 == null || string2.equals("")) {
                    string2 = "/";
                }
                if (ssoToken == null) {
                    ssoToken = SAMLServiceManager.getSSOToken();
                }
                String string3 = string;
                if (DN.isDN((String)string) && (object2 = (object = new DN(string)).getRDNs()) != null && ((Vector)object2).size() > 0) {
                    string3 = ((RDN)((Vector)object2).firstElement()).getValues()[0];
                }
                object = new AMIdentityRepository(ssoToken, string2);
                object2 = new IdSearchControl();
                ((IdSearchControl)object2).setRecursive(true);
                ((IdSearchControl)object2).setTimeOut(0);
                ((IdSearchControl)object2).setMaxResults(0);
                ((IdSearchControl)object2).setAllReturnAttributes(false);
                IdSearchResults idSearchResults = ((AMIdentityRepository)object).searchIdentities(idType, string3, (IdSearchControl)object2);
                Set set = idSearchResults.getSearchResults();
                if (set == null || set.isEmpty()) {
                    SAMLUtilsCommon.debug.warning("SAMLSM.getAMIdentity(): no match");
                    break block10;
                }
                if (set.size() > 1) {
                    if (SAMLUtilsCommon.debug.warningEnabled()) {
                        SAMLUtilsCommon.debug.warning("SAMLSM.getAMIdentity(): multiple matches found " + set);
                    }
                    break block10;
                }
                SAMLUtilsCommon.debug.message("single entry found");
                return (AMIdentity)set.iterator().next();
            }
            catch (IdRepoException idRepoException) {
                SAMLUtilsCommon.debug.error("SAMLSM.getAMIdentity()() : IdRepoException", (Throwable)idRepoException);
            }
            catch (SSOException sSOException) {
                SAMLUtilsCommon.debug.error("SAMLSM.getAMIdentity() : SSOException", (Throwable)sSOException);
            }
        }
        return null;
    }

    static {
        if (WebtopNaming.isServerMode()) {
            cThread = new POSTCleanUpThread(idTimeMap);
            cThread.start();
        }
        try {
            maxContentLength = Integer.parseInt(SystemProperties.get((String)HTTP_MAX_CONTENT_LENGTH, (String)DEFAULT_CONTENT_LENGTH));
        }
        catch (NumberFormatException numberFormatException) {
            SAMLUtilsCommon.debug.error("Wrong format of SAML request max content length. Take default value.");
            maxContentLength = 16384;
        }
    }
}

