/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.saml.common;

import com.iplanet.am.util.SystemProperties;
import com.iplanet.sso.SSOToken;
import com.sun.identity.log.LogRecord;
import com.sun.identity.log.Logger;
import com.sun.identity.log.messageid.LogMessageProvider;
import com.sun.identity.log.messageid.MessageProviderFactory;
import com.sun.identity.saml.common.SAMLUtilsCommon;
import com.sun.identity.security.AdminTokenAction;
import java.security.AccessController;
import java.util.logging.Level;

public class LogUtils {
    private static SSOToken loggingSSOToken = null;
    private static final String SAML_LOG = "SAML";
    private static LogMessageProvider msgProvider = null;
    public static final String ASSERTION_CREATED = "ASSERTION_CREATED";
    public static final String ASSERTION_ARTIFACT_CREATED = "ASSERTION_ARTIFACT_CREATED";
    public static final String ASSERTION_ARTIFACT_REMOVED = "ASSERTION_ARTIFACT_REMOVED";
    public static final String ASSERTION_REMOVED = "ASSERTION_REMOVED";
    public static final String ASSERTION_ARTIFACT_VERIFIED = "ASSERTION_ARTIFACT_VERIFIED";
    public static final String AUTH_PROTOCOL_MISMATCH = "AUTH_PROTOCOL_MISMATCH";
    public static final String INVALID_AUTH_TYPE = "INVALID_AUTH_TYPE";
    public static final String SOAP_RECEIVER_URL = "SOAP_RECEIVER_URL";
    public static final String NO_ASSERTION_IN_RESPONSE = "NO_ASSERTION_IN_RESPONSE";
    public static final String MISMATCHED_ASSERTION_AND_ARTIFACT = "MISMATCHED_ASSERTION_AND_ARTIFACT";
    public static final String ARTIFACT_TO_SEND = "ARTIFACT_TO_SEND";
    public static final String WRONG_SOAP_URL = "WRONG_SOAP_URL";
    public static final String SAML_ARTIFACT_QUERY = "SAML_ARTIFACT_QUERY";
    public static final String NO_REPLY_FROM_SOAP_RECEIVER = "NO_REPLY_FROM_SOAP_RECEIVER";
    public static final String REPLIED_SOAP_MESSAGE = "REPLIED_SOAP_MESSAGE";
    public static final String NULL_SAML_RESPONSE = "NULL_SAML_RESPONSE";
    public static final String INVALID_RESPONSE_SIGNATURE = "INVALID_RESPONSE_SIGNATURE";
    public static final String ERROR_RESPONSE_STATUS = "ERROR_RESPONSE_STATUS";
    public static final String NULL_PARAMETER = "NULL_PARAMETER";
    public static final String MISSING_TARGET = "MISSING_TARGET";
    public static final String REDIRECT_TO_URL = "REDIRECT_TO_URL";
    public static final String TARGET_FORBIDDEN = "TARGET_FORBIDDEN";
    public static final String FAILED_TO_CREATE_SSO_TOKEN = "FAILED_TO_CREATE_SSO_TOKEN";
    public static final String ACCESS_GRANTED = "ACCESS_GRANTED";
    public static final String MISSING_RESPONSE = "MISSING_RESPONSE";
    public static final String RESPONSE_MESSAGE_ERROR = "RESPONSE_MESSAGE_ERROR";
    public static final String INVALID_RESPONSE = "INVALID_RESPONSE";
    public static final String SOAP_MESSAGE_FACTORY_ERROR = "SOAP_MESSAGE_FACTORY_ERROR";
    public static final String UNTRUSTED_SITE = "UNTRUSTED_SITE";
    public static final String INVALID_REQUEST = "INVALID_REQUEST";
    public static final String SOAP_REQUEST_MESSAGE = "SOAP_REQUEST_MESSAGE";
    public static final String BUILD_RESPONSE_ERROR = "BUILD_RESPONSE_ERROR";
    public static final String SENDING_RESPONSE = "SENDING_RESPONSE";
    public static final String SOAP_FAULT_ERROR = "SOAP_FAULT_ERROR";

    public static void access(Level level, String string, String[] stringArray) {
        LogUtils.access(level, string, stringArray, loggingSSOToken);
    }

    public static void access(Level level, String string, String[] stringArray, SSOToken sSOToken) {
        if (loggingSSOToken == null) {
            if (SAMLUtilsCommon.debug.messageEnabled()) {
                SAMLUtilsCommon.debug.message("LogUtils.access: null sso token for " + string);
            }
            return;
        }
        try {
            LogRecord logRecord;
            Logger logger = (Logger)Logger.getLogger("amSAML.access");
            if (logger.isLoggable(level) && (logRecord = msgProvider.createLogRecord(string, stringArray, sSOToken)) != null) {
                logger.log(logRecord, loggingSSOToken);
            }
        }
        catch (Exception exception) {
            SAMLUtilsCommon.debug.error("LogUtils.access: error writing  to amSAML.access log:", (Throwable)exception);
        }
    }

    public static void error(Level level, String string, String[] stringArray) {
        LogUtils.error(level, string, stringArray, loggingSSOToken);
    }

    public static void error(Level level, String string, String[] stringArray, SSOToken sSOToken) {
        if (loggingSSOToken == null) {
            if (SAMLUtilsCommon.debug.messageEnabled()) {
                SAMLUtilsCommon.debug.message("LogUtils.error: null sso token for " + string);
            }
            return;
        }
        try {
            LogRecord logRecord;
            Logger logger = (Logger)Logger.getLogger("amSAML.error");
            if (logger.isLoggable(level) && (logRecord = msgProvider.createLogRecord(string, stringArray, sSOToken)) != null) {
                logger.log(logRecord, loggingSSOToken);
            }
        }
        catch (Exception exception) {
            SAMLUtilsCommon.debug.error("LogUtils.error: error writing  to amSAML.error log:", (Throwable)exception);
        }
    }

    public static boolean isLoggable(Level level) {
        if (loggingSSOToken == null) {
            return false;
        }
        Logger logger = (Logger)Logger.getLogger("amSAML.error");
        return logger.isLoggable(level);
    }

    static {
        try {
            loggingSSOToken = (SSOToken)AccessController.doPrivileged(AdminTokenAction.getInstance());
            String string = SystemProperties.get((String)"com.iplanet.am.defaultOrg");
            loggingSSOToken.setProperty("Organization", string);
            msgProvider = MessageProviderFactory.getProvider(SAML_LOG);
        }
        catch (Exception exception) {
            SAMLUtilsCommon.debug.error("LogUtils.static", (Throwable)exception);
        }
    }
}

