/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.saml.assertion;

import com.iplanet.am.util.XMLUtils;
import com.sun.identity.saml.assertion.AssertionBase;
import com.sun.identity.saml.assertion.AssertionIDReference;
import com.sun.identity.saml.common.SAMLConstants;
import com.sun.identity.saml.common.SAMLException;
import com.sun.identity.saml.common.SAMLRequesterException;
import com.sun.identity.saml.common.SAMLUtilsCommon;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public abstract class EvidenceBase {
    static SAMLConstants sc;
    private Set _assertionIDRef = new HashSet();
    private Set _assertion = new HashSet();
    private int dataContentType;

    public EvidenceBase(Element element) throws SAMLException {
        String string = element.getLocalName();
        if (string == null) {
            if (SAMLUtilsCommon.debug.messageEnabled()) {
                SAMLUtilsCommon.debug.message("Evidence:local name missing");
            }
            throw new SAMLRequesterException(SAMLUtilsCommon.bundle.getString("nullInput"));
        }
        if (!string.equals("Evidence")) {
            if (SAMLUtilsCommon.debug.messageEnabled()) {
                SAMLUtilsCommon.debug.message("Evidence: invalid root element");
            }
            throw new SAMLRequesterException(SAMLUtilsCommon.bundle.getString("invalidElement") + ":" + string);
        }
        NodeList nodeList = element.getChildNodes();
        int n = nodeList.getLength();
        if (n <= 0) {
            if (SAMLUtilsCommon.debug.messageEnabled()) {
                SAMLUtilsCommon.debug.message(string + ":" + "no sub elements found in this Element");
            }
            throw new SAMLRequesterException(SAMLUtilsCommon.bundle.getString("noElement"));
        }
        for (int i = 0; i < n; ++i) {
            Node node = nodeList.item(i);
            if (node.getNodeType() != 1) continue;
            String string2 = node.getLocalName();
            if (string2.equals("Assertion")) {
                this._assertion.add(this.createAssertion((Element)node));
                continue;
            }
            if (string2.equals("AssertionIDReference")) {
                this._assertionIDRef.add(this.createAssertionIDReference(XMLUtils.getElementValue((Element)((Element)node))));
                continue;
            }
            if (SAMLUtilsCommon.debug.messageEnabled()) {
                SAMLUtilsCommon.debug.message("Evidence:  invalid sub element");
            }
            throw new SAMLRequesterException(SAMLUtilsCommon.bundle.getString("invalidElement"));
        }
    }

    public EvidenceBase(Set set) throws SAMLException {
        if (set.isEmpty()) {
            if (SAMLUtilsCommon.debug.messageEnabled()) {
                SAMLUtilsCommon.debug.message("Evidence:  null input specified");
            }
            throw new SAMLRequesterException(SAMLUtilsCommon.bundle.getString("nullInput"));
        }
        Iterator iterator = set.iterator();
        while (iterator.hasNext()) {
            Object e = iterator.next();
            if (e instanceof AssertionBase) {
                this._assertion.add((AssertionBase)e);
                continue;
            }
            if (e instanceof AssertionIDReference) {
                this._assertionIDRef.add((AssertionIDReference)e);
                continue;
            }
            SAMLUtilsCommon.debug.message("Evidence: Invalid input Element");
            throw new SAMLRequesterException(SAMLUtilsCommon.bundle.getString("invalidElement"));
        }
    }

    public EvidenceBase(Set set, Set set2) throws SAMLException {
        Object e;
        if (set.isEmpty() && set2.isEmpty()) {
            if (SAMLUtilsCommon.debug.messageEnabled()) {
                SAMLUtilsCommon.debug.message("Evidence:  null input specified");
            }
            throw new SAMLRequesterException(SAMLUtilsCommon.bundle.getString("nullInput"));
        }
        Iterator iterator = set.iterator();
        while (iterator.hasNext()) {
            e = iterator.next();
            if (e instanceof AssertionIDReference) {
                this._assertionIDRef.add((AssertionIDReference)e);
                continue;
            }
            SAMLUtilsCommon.debug.message("Evidence: Invalid input Element");
            throw new SAMLRequesterException(SAMLUtilsCommon.bundle.getString("invalidElement"));
        }
        iterator = set2.iterator();
        while (iterator.hasNext()) {
            e = iterator.next();
            if (e instanceof AssertionBase) {
                this._assertion.add((AssertionBase)e);
                continue;
            }
            SAMLUtilsCommon.debug.message("Evidence: Invalid input Element");
            throw new SAMLRequesterException(SAMLUtilsCommon.bundle.getString("invalidElement"));
        }
    }

    public boolean addAssertion(AssertionBase assertionBase) {
        if (assertionBase == null) {
            if (SAMLUtilsCommon.debug.messageEnabled()) {
                SAMLUtilsCommon.debug.message("Evidence:  null input specified");
            }
            return false;
        }
        this._assertion.add(assertionBase);
        return true;
    }

    public boolean addAssertionIDReference(AssertionIDReference assertionIDReference) {
        if (assertionIDReference == null) {
            if (SAMLUtilsCommon.debug.messageEnabled()) {
                SAMLUtilsCommon.debug.message("Evidence:  null input specified");
            }
            return false;
        }
        this._assertionIDRef.add(assertionIDReference);
        return true;
    }

    public boolean removeAssertion(AssertionBase assertionBase) {
        if (assertionBase != null) {
            if (this._assertionIDRef.size() + this._assertion.size() > 1) {
                this._assertion.remove(assertionBase);
                return true;
            }
        } else if (SAMLUtilsCommon.debug.messageEnabled()) {
            SAMLUtilsCommon.debug.message("Evidence:  null input specified");
        }
        return false;
    }

    public boolean removeAssertionIDReference(AssertionIDReference assertionIDReference) {
        if (assertionIDReference != null) {
            if (this._assertionIDRef.size() + this._assertion.size() > 1) {
                this._assertionIDRef.remove(assertionIDReference);
                return true;
            }
        } else if (SAMLUtilsCommon.debug.messageEnabled()) {
            SAMLUtilsCommon.debug.message("Evidence:  null input specified");
        }
        return false;
    }

    public Set getAssertionIDReference() {
        return this._assertionIDRef;
    }

    public Set getAssertion() {
        return this._assertion;
    }

    public String toString() {
        String string = this.toString(true, false);
        return string;
    }

    public String toString(boolean bl, boolean bl2) {
        Object object;
        StringBuffer stringBuffer = new StringBuffer(3000);
        String string = null;
        string = SAMLUtilsCommon.makeStartElementTagXML("Evidence", bl, bl2);
        stringBuffer.append(string).append("\n");
        Iterator iterator = this._assertion.iterator();
        while (iterator.hasNext()) {
            object = (AssertionBase)iterator.next();
            stringBuffer.append(((AssertionBase)object).toString(bl, false));
        }
        iterator = this._assertionIDRef.iterator();
        while (iterator.hasNext()) {
            object = (AssertionIDReference)iterator.next();
            stringBuffer.append(((AssertionIDReference)object).toString(bl, false));
        }
        string = SAMLUtilsCommon.makeEndElementTagXML("Evidence", bl);
        stringBuffer.append(string);
        return stringBuffer.toString();
    }

    protected abstract AssertionBase createAssertion(Element var1) throws SAMLException;

    protected abstract AssertionIDReference createAssertionIDReference(String var1) throws SAMLException;
}

