/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.saml.assertion;

import com.sun.identity.common.DateUtils;
import com.sun.identity.saml.assertion.AuthorityBinding;
import com.sun.identity.saml.assertion.Subject;
import com.sun.identity.saml.assertion.SubjectLocality;
import com.sun.identity.saml.assertion.SubjectStatement;
import com.sun.identity.saml.common.SAMLException;
import com.sun.identity.saml.common.SAMLRequesterException;
import com.sun.identity.saml.common.SAMLUtilsCommon;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import org.w3c.dom.Attr;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;

public class AuthenticationStatement
extends SubjectStatement {
    protected String _authenticationMethod = null;
    protected Date _authenticationInstant = null;
    protected SubjectLocality _subjectLocality = null;
    protected List _authorityBinding = null;

    protected AuthenticationStatement() {
    }

    public AuthenticationStatement(Element element) throws SAMLException {
        Object object;
        if (element == null) {
            SAMLUtilsCommon.debug.message("AuthenticationStatement: null input.");
            throw new SAMLRequesterException(SAMLUtilsCommon.bundle.getString("nullInput"));
        }
        boolean bl = SAMLUtilsCommon.checkStatement(element, "AuthenticationStatement");
        if (!bl) {
            SAMLUtilsCommon.debug.message("AuthenticationStatement: Wrong input.");
            throw new SAMLRequesterException(SAMLUtilsCommon.bundle.getString("wrongInput"));
        }
        int n = 0;
        NamedNodeMap namedNodeMap = element.getAttributes();
        int n2 = namedNodeMap.getLength();
        n = 0;
        while (n < n2) {
            object = namedNodeMap.item(n);
            if (object.getNodeType() == 2) {
                String string = object.getLocalName();
                if (string == null || string.equals("")) {
                    if (SAMLUtilsCommon.debug.messageEnabled()) {
                        SAMLUtilsCommon.debug.message("AuthenticationStatement:Attribute name is either null or empty.");
                    }
                    throw new SAMLRequesterException(SAMLUtilsCommon.bundle.getString("nullInput"));
                }
                if (string.equals("AuthenticationMethod")) {
                    this._authenticationMethod = ((Attr)object).getValue().trim();
                } else if (string.equals("AuthenticationInstant")) {
                    try {
                        this._authenticationInstant = DateUtils.stringToDate((String)((Attr)object).getValue());
                    }
                    catch (ParseException parseException) {
                        SAMLUtilsCommon.debug.error("AuthenticationStatement:StringToDate", (Throwable)parseException);
                        throw new SAMLRequesterException(SAMLUtilsCommon.bundle.getString("wrongDateFormat"));
                    }
                }
            }
            ++n;
        }
        object = element.getChildNodes();
        int n3 = object.getLength();
        if (n3 > 0) {
            n = 0;
            while (n < n3) {
                Node node = object.item(n);
                if (node.getNodeType() == 1) {
                    String string = node.getLocalName();
                    String string2 = node.getNamespaceURI();
                    if (string == null || string.equals("") || string2 == null || string2.equals("")) {
                        if (SAMLUtilsCommon.debug.messageEnabled()) {
                            SAMLUtilsCommon.debug.message("AuthenticationStatement: The tag name or tag namespace of child element is either null or empty.");
                        }
                        throw new SAMLRequesterException(SAMLUtilsCommon.bundle.getString("nullInput"));
                    }
                    if (string.equals("Subject") && string2.equals("urn:oasis:names:tc:SAML:1.0:assertion")) {
                        if (this._subject != null) {
                            if (SAMLUtilsCommon.debug.messageEnabled()) {
                                SAMLUtilsCommon.debug.message("AuthenticationStatement:should only contain one subject");
                            }
                            throw new SAMLRequesterException(SAMLUtilsCommon.bundle.getString("oneElement"));
                        }
                        this._subject = this.createSubject((Element)node);
                    } else if (string.equals("SubjectLocality") && string2.equals("urn:oasis:names:tc:SAML:1.0:assertion")) {
                        if (this._subjectLocality != null) {
                            if (SAMLUtilsCommon.debug.messageEnabled()) {
                                SAMLUtilsCommon.debug.message("AuthenticationStatement: should at most contain one SubjectLocality.");
                            }
                            throw new SAMLRequesterException(SAMLUtilsCommon.bundle.getString("oneElement"));
                        }
                        this._subjectLocality = this.createSubjectLocality((Element)node);
                    } else if (string.equals("AuthorityBinding") && string2.equals("urn:oasis:names:tc:SAML:1.0:assertion")) {
                        if (this._authorityBinding == null) {
                            this._authorityBinding = new ArrayList();
                        }
                        if (!this._authorityBinding.add(this.createAuthorityBinding((Element)node))) {
                            if (SAMLUtilsCommon.debug.messageEnabled()) {
                                SAMLUtilsCommon.debug.message("AuthenticationStatment: failed to add to the AuthorityBinding list.");
                            }
                            throw new SAMLRequesterException(SAMLUtilsCommon.bundle.getString("addListError"));
                        }
                    } else {
                        if (SAMLUtilsCommon.debug.messageEnabled()) {
                            SAMLUtilsCommon.debug.message("AuthenticationStatement:Wrong element " + string + "included.");
                        }
                        throw new SAMLRequesterException(SAMLUtilsCommon.bundle.getString("wrongInput"));
                    }
                }
                ++n;
            }
        }
        if (this._subject == null) {
            if (SAMLUtilsCommon.debug.messageEnabled()) {
                SAMLUtilsCommon.debug.message("AuthenticationStatement should contain one subject.");
            }
            throw new SAMLRequesterException(SAMLUtilsCommon.bundle.getString("missingElement"));
        }
    }

    public AuthenticationStatement(String string, Date date, Subject subject) throws SAMLException {
        this._authenticationMethod = string;
        this._authenticationInstant = date;
        if (subject == null) {
            if (SAMLUtilsCommon.debug.messageEnabled()) {
                SAMLUtilsCommon.debug.message("AuthenticationStatement:missingthe subject.");
            }
            throw new SAMLRequesterException(SAMLUtilsCommon.bundle.getString("missingElement"));
        }
        this._subject = subject;
    }

    public AuthenticationStatement(String string, Date date, Subject subject, SubjectLocality subjectLocality, List list) throws SAMLException {
        this._authenticationMethod = string;
        this._authenticationInstant = date;
        if (subject == null) {
            if (SAMLUtilsCommon.debug.messageEnabled()) {
                SAMLUtilsCommon.debug.message("AuthenticationStatement: should contain one subject.");
            }
            throw new SAMLRequesterException(SAMLUtilsCommon.bundle.getString("oneElement"));
        }
        this._subject = subject;
        this._subjectLocality = subjectLocality;
        if (list != null && !list.isEmpty()) {
            if (this._authorityBinding == null) {
                this._authorityBinding = new ArrayList();
            }
            this._authorityBinding = list;
        }
    }

    public SubjectLocality getSubjectLocality() {
        return this._subjectLocality;
    }

    public boolean setSubjectLocality(SubjectLocality subjectLocality) {
        if (subjectLocality == null) {
            if (SAMLUtilsCommon.debug.messageEnabled()) {
                SAMLUtilsCommon.debug.message("AuthenticationStatement: setSubjectLocality:Input is null.");
            }
            return false;
        }
        this._subjectLocality = subjectLocality;
        return true;
    }

    public String getAuthenticaionMethod() {
        return this._authenticationMethod;
    }

    public boolean setAuthenticaionMethod(String string) {
        if (string == null || string.equals("")) {
            if (SAMLUtilsCommon.debug.messageEnabled()) {
                SAMLUtilsCommon.debug.message("AuthenticationStatement: setAuthenticationMethod:Input is null.");
            }
            return false;
        }
        this._authenticationMethod = string;
        return true;
    }

    public Date getAuthenticationInstant() {
        return this._authenticationInstant;
    }

    public boolean setAuthenticationInstant(Date date) {
        if (date == null) {
            if (SAMLUtilsCommon.debug.messageEnabled()) {
                SAMLUtilsCommon.debug.message("AuthenticationStatement: setAuthenticationInstant:Input is null.");
            }
            return false;
        }
        this._authenticationInstant = date;
        return true;
    }

    public List getAuthorityBinding() {
        return this._authorityBinding;
    }

    public boolean setAuthorityBinding(List list) {
        if (list == null || list.equals("")) {
            if (SAMLUtilsCommon.debug.messageEnabled()) {
                SAMLUtilsCommon.debug.message("AuthenticationStatement: setAuthorityBinding:Input is null.");
            }
            return false;
        }
        this._authorityBinding = list;
        return true;
    }

    public int getStatementType() {
        return 1;
    }

    public String toString() {
        return this.toString(true, false);
    }

    public String toString(boolean bl, boolean bl2) {
        StringBuffer stringBuffer = new StringBuffer(1000);
        String string = "";
        String string2 = "";
        if (bl) {
            string = "saml:";
        }
        if (bl2) {
            string2 = " xmlns:saml=\"urn:oasis:names:tc:SAML:1.0:assertion\"";
        }
        stringBuffer.append("<").append(string).append("AuthenticationStatement").append(string2);
        if (this._authenticationMethod != null && !this._authenticationMethod.equals("")) {
            stringBuffer.append(" AuthenticationMethod=\"").append(this._authenticationMethod).append("\"");
        }
        if (this._authenticationInstant != null && !this._authenticationInstant.equals("")) {
            stringBuffer.append(" AuthenticationInstant=\"").append(DateUtils.toUTCDateFormat((Date)this._authenticationInstant)).append("\"");
        }
        stringBuffer.append(">\n").append(this._subject.toString(bl, false));
        if (this._subjectLocality != null) {
            stringBuffer.append(this._subjectLocality.toString(bl, false));
        }
        if (this._authorityBinding != null && !this._authorityBinding.isEmpty()) {
            Iterator iterator = this.getAuthorityBinding().iterator();
            while (iterator.hasNext()) {
                AuthorityBinding authorityBinding = (AuthorityBinding)iterator.next();
                stringBuffer.append(authorityBinding.toString(bl, false));
            }
        }
        stringBuffer.append("</").append(string).append("AuthenticationStatement>\n");
        return stringBuffer.toString();
    }

    protected Subject createSubject(Element element) throws SAMLException {
        return new Subject(element);
    }

    protected SubjectLocality createSubjectLocality(Element element) throws SAMLException {
        return new SubjectLocality(element);
    }

    protected AuthorityBinding createAuthorityBinding(Element element) throws SAMLException {
        return new AuthorityBinding(element);
    }
}

