/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.policy.remote;

import com.iplanet.am.util.Debug;
import com.iplanet.am.util.XMLUtils;
import com.sun.identity.policy.remote.PolicyEvaluationException;
import com.sun.identity.policy.remote.PolicyService;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.w3c.dom.Node;

public class PolicyChangeNotification {
    static final String SERVICE_NAME = "serviceName";
    static final String POLICY_CHANGE_TYPE = "type";
    static final String RESOURCE_NAME = "ResourceName";
    static final String ADDED = "added";
    static final String MODIFIED = "modified";
    static final String DELETED = "deleted";
    static final String CRLF = "\r\n";
    static Debug debug = PolicyService.debug;
    private String serviceName;
    private String changeType = "modified";
    private Set resourceNames = null;

    PolicyChangeNotification() {
    }

    public String getServiceName() {
        return this.serviceName;
    }

    public void setServiceName(String string) {
        this.serviceName = string;
    }

    public String getPolicyChangeType() {
        return this.changeType;
    }

    public void setPolicyChangeType(String string) {
        this.changeType = string;
    }

    public Set getResourceNames() {
        return this.resourceNames;
    }

    void setResourceNames(Set set) {
        this.resourceNames = set;
    }

    public static PolicyChangeNotification parseXML(Node node) throws PolicyEvaluationException {
        PolicyChangeNotification policyChangeNotification = new PolicyChangeNotification();
        String string = XMLUtils.getNodeAttributeValue((Node)node, (String)SERVICE_NAME);
        if (string == null) {
            debug.error("PolicyChangeNotification: missing attribute serviceName");
            Object[] objectArray = new String[]{SERVICE_NAME};
            throw new PolicyEvaluationException("amPolicy", "missing_attribute", objectArray, null);
        }
        policyChangeNotification.setServiceName(string);
        string = XMLUtils.getNodeAttributeValue((Node)node, (String)POLICY_CHANGE_TYPE);
        if (string == null) {
            debug.error("PolicyChangeNotification: missing attribute type");
            Object[] objectArray = new String[]{POLICY_CHANGE_TYPE};
            throw new PolicyEvaluationException("amPolicy", "missing_attribute", objectArray, null);
        }
        policyChangeNotification.setPolicyChangeType(string);
        Set set = XMLUtils.getChildNodes((Node)node, (String)RESOURCE_NAME);
        if (set == null) {
            if (debug.messageEnabled()) {
                debug.message("PolicyChangeNotification: no resource name specified");
            }
            return policyChangeNotification;
        }
        HashSet<String> hashSet = new HashSet<String>();
        Node node2 = null;
        Iterator iterator = set.iterator();
        while (iterator.hasNext()) {
            node2 = (Node)iterator.next();
            String string2 = XMLUtils.getValueOfValueNode((Node)node2);
            if (string2 == null) continue;
            hashSet.add(string2);
        }
        policyChangeNotification.setResourceNames(hashSet);
        return policyChangeNotification;
    }

    public String toXMLString() {
        StringBuffer stringBuffer = new StringBuffer(200);
        stringBuffer.append("<PolicyChangeNotification ");
        stringBuffer.append("serviceName=\"" + this.serviceName + "\" ");
        stringBuffer.append("type=\"" + this.changeType + "\">" + CRLF);
        if (this.resourceNames != null) {
            Iterator iterator = this.resourceNames.iterator();
            while (iterator.hasNext()) {
                String string = (String)iterator.next();
                stringBuffer.append("<ResourceName>");
                stringBuffer.append(XMLUtils.escapeSpecialCharacters((String)string));
                stringBuffer.append("</ResourceName>\r\n");
            }
        }
        stringBuffer.append("</PolicyChangeNotification>\r\n");
        return stringBuffer.toString();
    }
}

