/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.policy.plugins;

import com.iplanet.am.util.Debug;
import com.iplanet.sso.SSOException;
import com.iplanet.sso.SSOToken;
import com.sun.identity.policy.ConditionDecision;
import com.sun.identity.policy.PolicyException;
import com.sun.identity.policy.PolicyUtils;
import com.sun.identity.policy.Syntax;
import com.sun.identity.policy.interfaces.Condition;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;

public class SessionPropertyCondition
implements Condition {
    public static final String VALUE_CASE_INSENSITIVE = "valueCaseInsensitive";
    private static final boolean IGNORE_VALUE_CASE_DEFAULT = true;
    private static final String IGNORE_VALUE_CASE_FALSE_STRING = "false";
    private static final String DELIMITER = "|";
    private List propertyNames = new ArrayList();
    private Map properties;
    private static final Debug debug = Debug.getInstance((String)"amPolicy");
    private boolean ignoreValueCase = true;

    public List getPropertyNames() {
        return this.propertyNames;
    }

    public Syntax getPropertySyntax(String string) {
        return Syntax.ANY;
    }

    public String getDisplayName(String string, Locale locale) throws PolicyException {
        return string;
    }

    public Set getValidValues(String string) throws PolicyException {
        return Collections.EMPTY_SET;
    }

    public void setProperties(Map map) throws PolicyException {
        this.properties = (HashMap)map;
        if (map == null || map.isEmpty()) {
            throw new PolicyException("amPolicy", "properties_can_not_be_null_or_empty", null, null);
        }
        if (debug.messageEnabled()) {
            debug.message("SessionPropertyCondition.setProperties():properties=" + map);
        }
        this.properties = map;
        this.resetIgnoreValueCase();
    }

    public Map getProperties() {
        return Collections.unmodifiableMap(this.properties);
    }

    public ConditionDecision getConditionDecision(SSOToken sSOToken, Map map) throws PolicyException, SSOException {
        boolean bl = true;
        if (debug.messageEnabled()) {
            debug.message("SessionPropertyCondition.getConditionDecision():entering, ignoreValueCase= " + this.ignoreValueCase);
        }
        if (this.properties != null && !this.properties.isEmpty()) {
            Set set = this.properties.keySet();
            Iterator iterator = set.iterator();
            block0: while (iterator.hasNext() && bl) {
                String string;
                Iterator iterator2;
                String string2 = (String)iterator.next();
                Set set2 = (Set)this.properties.get(string2);
                if (debug.messageEnabled()) {
                    debug.message("SessionPropertyCondition.getConditionDecision():propertyName = " + string2 + ",conditionValues = " + set2);
                }
                if (string2.equals(VALUE_CASE_INSENSITIVE) || set2 == null || set2.isEmpty()) continue;
                String string3 = sSOToken.getProperty(string2);
                Set set3 = null;
                if (string3 != null && string3.indexOf(DELIMITER) != -1) {
                    set3 = PolicyUtils.delimStringToSet(string3, DELIMITER);
                }
                if (debug.messageEnabled()) {
                    debug.message("SessionPropertyCondition.getConditionDecision():,sessionValue = " + string3 + ",sessionValues = " + set3);
                }
                if (string3 == null) {
                    bl = false;
                    continue;
                }
                if (set3 != null) {
                    if (!this.ignoreValueCase) {
                        iterator2 = set3.iterator();
                        while (iterator2.hasNext()) {
                            string = (String)iterator2.next();
                            if (set2.contains(string)) continue block0;
                        }
                    } else {
                        iterator2 = set3.iterator();
                        while (iterator2.hasNext()) {
                            string = (String)iterator2.next();
                            Iterator iterator3 = set2.iterator();
                            while (iterator3.hasNext()) {
                                String string4 = (String)iterator3.next();
                                if (string.equalsIgnoreCase(string4)) continue block0;
                            }
                        }
                    }
                } else if (!this.ignoreValueCase) {
                    if (set2.contains(string3)) {
                        continue;
                    }
                } else {
                    iterator2 = set2.iterator();
                    while (iterator2.hasNext()) {
                        string = (String)iterator2.next();
                        if (string3.equalsIgnoreCase(string)) continue block0;
                    }
                }
                bl = false;
            }
        } else {
            if (debug.messageEnabled()) {
                debug.message("SessionPropertyCondition.getConditionDecision():no  parameter defined, defaulting allow = true ");
            }
            bl = true;
        }
        if (debug.messageEnabled()) {
            debug.message("SessionPropertyCondition.getConditionDecision():allowed= " + bl);
        }
        return new ConditionDecision(bl);
    }

    public Object clone() {
        SessionPropertyCondition sessionPropertyCondition = null;
        try {
            sessionPropertyCondition = (SessionPropertyCondition)super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new InternalError();
        }
        if (this.properties != null) {
            sessionPropertyCondition.properties = new HashMap();
            Iterator iterator = this.properties.keySet().iterator();
            while (iterator.hasNext()) {
                Object k = iterator.next();
                HashSet hashSet = new HashSet();
                hashSet.addAll((Set)this.properties.get(k));
                sessionPropertyCondition.properties.put(k, hashSet);
            }
        }
        return sessionPropertyCondition;
    }

    private void resetIgnoreValueCase() {
        if (this.properties != null) {
            Set set = (Set)this.properties.get(VALUE_CASE_INSENSITIVE);
            if (set != null && !set.isEmpty()) {
                Iterator iterator = set.iterator();
                while (iterator.hasNext()) {
                    String string = (String)iterator.next();
                    this.ignoreValueCase = !IGNORE_VALUE_CASE_FALSE_STRING.equalsIgnoreCase(string.trim());
                }
            } else {
                this.ignoreValueCase = true;
            }
        }
        if (debug.messageEnabled()) {
            debug.message("SessionPropertyCondition.resetIgnoreValueCase():ignoreValueCase= " + this.ignoreValueCase);
        }
    }
}

