/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.policy.plugins;

import com.iplanet.am.util.Debug;
import com.iplanet.sso.SSOException;
import com.iplanet.sso.SSOToken;
import com.sun.identity.policy.ConditionDecision;
import com.sun.identity.policy.PolicyConfig;
import com.sun.identity.policy.PolicyEvaluator;
import com.sun.identity.policy.PolicyException;
import com.sun.identity.policy.PolicyUtils;
import com.sun.identity.policy.SubjectEvaluationCache;
import com.sun.identity.policy.Syntax;
import com.sun.identity.policy.interfaces.Condition;
import com.sun.identity.policy.plugins.LDAPConnectionPools;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import netscape.ldap.LDAPConnection;
import netscape.ldap.LDAPException;
import netscape.ldap.LDAPSearchConstraints;
import netscape.ldap.LDAPSearchResults;
import netscape.ldap.util.ConnectionPool;

public class LDAPFilterCondition
implements Condition {
    public static final String LDAP_FILTER = "ldapFilter";
    static final String LDAP_SCOPE_BASE = "SCOPE_BASE";
    static final String LDAP_SCOPE_ONE = "SCOPE_ONE";
    private static final Debug debug = Debug.getInstance((String)"amPolicy");
    private static List propertyNames = new ArrayList(1);
    private static final String AMPERSAND = "&";
    private static final String OPEN_PARENTHESIS = "(";
    private static final String CLOSE_PARENTHESIS = ")";
    private Map properties;
    private String ldapConditionFilter;
    private long policyConfigExpiresAt;
    private String authid;
    private String authpw;
    private String baseDN;
    private String userSearchFilter;
    private int userSearchScope = 2;
    private String userRDNAttrName;
    private int timeLimit;
    private int maxResults;
    private boolean sslEnabled = false;
    private int minPoolSize;
    private int maxPoolSize;
    private String orgName;
    private ConnectionPool connPool;
    private boolean localDS;
    private String ldapServer;
    private boolean aliasEnabled;

    public List getPropertyNames() {
        return Collections.unmodifiableList(propertyNames);
    }

    public Syntax getPropertySyntax(String string) {
        return Syntax.ANY;
    }

    public String getDisplayName(String string, Locale locale) throws PolicyException {
        return string;
    }

    public Set getValidValues(String string) throws PolicyException {
        return Collections.EMPTY_SET;
    }

    public void setProperties(Map map) throws PolicyException {
        if (debug.messageEnabled()) {
            debug.message("LDAPFilterCondition.setProperties():properties=" + map);
        }
        this.validateProperties(map);
        this.properties = map;
        if (debug.messageEnabled()) {
            debug.message("LDAPFilterCondition.setProperties():ldapConditionFilter=" + this.ldapConditionFilter);
        }
    }

    public Map getProperties() {
        return Collections.unmodifiableMap(this.properties);
    }

    public ConditionDecision getConditionDecision(SSOToken sSOToken, Map map) throws PolicyException, SSOException {
        if (debug.messageEnabled()) {
            debug.message("LDAPFilterCondition.getConditionDecision():entering:principalDN=" + sSOToken.getPrincipal().getName() + ":ldapConditionFilter=" + this.ldapConditionFilter);
        }
        boolean bl = true;
        this.resetPolicyConfig(map);
        bl = this.isMember(sSOToken);
        if (debug.messageEnabled()) {
            debug.message("LDAPFilterCondition.getConditionDecision():allowed= " + bl);
        }
        return new ConditionDecision(bl);
    }

    private boolean isMember(SSOToken sSOToken) throws SSOException, PolicyException {
        int n;
        boolean bl = false;
        boolean bl2 = false;
        Object var4_4 = null;
        String string = sSOToken.getPrincipal().getName();
        String string2 = sSOToken.getTokenID().toString();
        if (debug.messageEnabled()) {
            debug.message("LDAPFilterCondition.isMember(): userLocalDN from ssoToken is: " + string);
        }
        Boolean bl3 = null;
        bl3 = SubjectEvaluationCache.isMember(string2, this.ldapServer, this.ldapConditionFilter);
        if (bl3 != null) {
            if (debug.messageEnabled()) {
                debug.message("LDAPFilterCondition.isMember():Got membership from cache userLocalDN: " + string + ", ldapConditionFilter: " + this.ldapConditionFilter + " , member:" + bl3);
            }
            if ((n = bl3.booleanValue()) != 0) {
                return n != 0;
            }
        }
        if (debug.messageEnabled()) {
            debug.message("LDAPFilterCondition:isMember(): ldapConditionFilter:" + this.ldapConditionFilter + " not in subject evaluation cache, " + " fetching from directory server.");
        }
        n = string.indexOf("=");
        int n2 = string.indexOf(",");
        if (n <= 0 || n2 <= 0 || n >= n2) {
            throw new PolicyException("amPolicy", "ldapusers_subject_invalid_local_user_dn", null, null);
        }
        String string3 = string.substring(n + 1, n2);
        String string4 = PolicyUtils.constructUserFilter(sSOToken, this.userRDNAttrName, string3, this.aliasEnabled);
        boolean bl4 = false;
        String string5 = null;
        if (this.userSearchFilter != null && !this.userSearchFilter.equals("")) {
            string5 = this.trimAndParenthesise(this.userSearchFilter) + this.trimAndParenthesise(string4);
            bl4 = true;
        }
        if (debug.messageEnabled()) {
            debug.message("LDAPFilterCondition.getConditionDecision():  user search filter is: " + this.userSearchFilter);
            debug.message("LDAPFilterCondition.getConditionDecision():  user mapping filter is: " + string4);
            debug.message("LDAPFilterCondition.getConditionDecision():  condition ldapConditionFilter is: " + this.ldapConditionFilter);
        }
        if (this.ldapConditionFilter != null && this.ldapConditionFilter.length() != 0) {
            bl4 = true;
            string5 = string5 + this.trimAndParenthesise(this.ldapConditionFilter);
        }
        if (bl4) {
            string5 = this.trimAndParenthesise(AMPERSAND + string5);
        }
        if (debug.messageEnabled()) {
            debug.message("LDAPFilterCondition.getConditionDecision():  combined filter : " + string5);
        }
        bl = this.searchFilterSatisfied(string5);
        if (debug.messageEnabled()) {
            debug.message("LDAPFilterCondition:isMember(): caching result, searchFilter:" + string5 + ", member:" + bl);
        }
        SubjectEvaluationCache.addEntry(string2, this.ldapServer, this.ldapConditionFilter, bl);
        if (!bl2 && !PolicyEvaluator.ssoListenerRegistry.containsKey(string2)) {
            sSOToken.addSSOTokenListener(PolicyEvaluator.ssoListener);
            PolicyEvaluator.ssoListenerRegistry.put(string2, PolicyEvaluator.ssoListener);
            if (debug.messageEnabled()) {
                debug.message("LDAPFilterCondition.isMember(): sso listener added .\n");
            }
            bl2 = true;
        }
        if (debug.messageEnabled()) {
            debug.message("LDAPFilterCondition.isMember():member=" + bl);
        }
        return bl;
    }

    private boolean searchFilterSatisfied(String string) throws SSOException, PolicyException {
        if (debug.messageEnabled()) {
            debug.message("LDAPFilterCondition.searchFilterSatified():entering, searchFitler=" + string);
        }
        boolean bl = false;
        String[] stringArray = new String[]{this.userRDNAttrName};
        LDAPConnection lDAPConnection = this.connPool.getConnection();
        LDAPSearchConstraints lDAPSearchConstraints = lDAPConnection.getSearchConstraints();
        lDAPSearchConstraints.setMaxResults(this.maxResults);
        lDAPSearchConstraints.setServerTimeLimit(this.timeLimit);
        try {
            block9: {
                try {
                    lDAPConnection.authenticate(this.authid, this.authpw);
                    LDAPSearchResults lDAPSearchResults = lDAPConnection.search(this.baseDN, this.userSearchScope, string, stringArray, false, lDAPSearchConstraints);
                    if (!lDAPSearchResults.hasMoreElements()) break block9;
                    bl = true;
                }
                catch (LDAPException lDAPException) {
                    int n = lDAPException.getLDAPResultCode();
                    if (n == 49) {
                        throw new PolicyException("amPolicy", "ldap_invalid_password", null, null);
                    }
                    if (n == 32) {
                        Object[] objectArray = new String[]{this.baseDN};
                        throw new PolicyException("amPolicy", "no_such_ldap_users_base_dn", objectArray, null);
                    }
                    String string2 = lDAPException.getLDAPErrorMessage();
                    String string3 = lDAPException.errorCodeToString();
                    if (string3 != null) {
                        throw new PolicyException(string2 + ": " + string3);
                    }
                    throw new PolicyException(string2);
                }
            }
            Object var11_8 = null;
        }
        catch (Throwable throwable) {
            Object var11_9 = null;
            this.connPool.close(lDAPConnection);
            throw throwable;
        }
        this.connPool.close(lDAPConnection);
        if (debug.messageEnabled()) {
            debug.message("LDAPFilterCondition.searchFilterSatified():returning, filterSatisfied=" + bl);
        }
        return bl;
    }

    private void resetPolicyConfig(Map map) throws PolicyException {
        if (System.currentTimeMillis() > this.policyConfigExpiresAt) {
            Map map2 = (Map)map.get("sun.am.policyConfig");
            this.setPolicyConfig(map2);
        }
    }

    private synchronized void setPolicyConfig(Map map) throws PolicyException {
        if (System.currentTimeMillis() < this.policyConfigExpiresAt) {
            return;
        }
        if (debug.messageEnabled()) {
            debug.message("LDAPFilterCondition.setPolicyConfig():policy config expired, resetting");
        }
        if (map == null) {
            debug.error("LDAPFilterCondition.setPolicyConfig():configParams is null");
            throw new PolicyException("amPolicy", "ldapfiltercondition_setpolicyconfig_null_policy_config", null, null);
        }
        String string = (String)map.get("iplanet-am-policy-config-ldap-server");
        if (string == null) {
            debug.error("LDAPFilterCondition.initialize(): failed to get LDAP server name. If you enter more than one server name in the policy config service's Primary LDAP Server field, please make sure the ldap server name is preceded with the local server name.");
            throw new PolicyException("amPolicy", "invalid_ldap_server_host", null, null);
        }
        this.ldapServer = string.toLowerCase();
        this.localDS = PolicyUtils.isLocalDS(this.ldapServer);
        this.aliasEnabled = Boolean.valueOf((String)map.get("iplanet-am-policy-config-user-alias-enabled"));
        this.authid = (String)map.get("iplanet-am-policy-config-ldap-bind-dn");
        this.authpw = (String)map.get("iplanet-am-policy-config-ldap-bind-password");
        this.baseDN = (String)map.get("iplanet-am-policy-config-ldap-users-base-dn");
        this.userSearchFilter = (String)map.get("iplanet-am-policy-config-ldap-users-search-filter");
        String string2 = (String)map.get("iplanet-am-policy-config-ldap-users-search-scope");
        this.userSearchScope = string2.equalsIgnoreCase(LDAP_SCOPE_BASE) ? 0 : (string2.equalsIgnoreCase(LDAP_SCOPE_ONE) ? 1 : 2);
        this.userRDNAttrName = (String)map.get("iplanet-am-policy-config-ldap-users-search-attribute");
        try {
            this.timeLimit = Integer.parseInt((String)map.get("iplanet-am-policy-config-search-timeout"));
            this.maxResults = Integer.parseInt((String)map.get("iplanet-am-policy-config-search-limit"));
            this.minPoolSize = Integer.parseInt((String)map.get("iplanet-am-policy-config-connection_pool_min_size"));
            this.maxPoolSize = Integer.parseInt((String)map.get("iplanet-am-policy-config-connection_pool_max_size"));
        }
        catch (NumberFormatException numberFormatException) {
            throw new PolicyException(numberFormatException);
        }
        String string3 = (String)map.get("iplanet-am-policy-config-ldap-ssl-enabled");
        this.sslEnabled = string3.equalsIgnoreCase("true");
        Set set = (Set)map.get("OrganizationName");
        if (set != null && set.size() != 0) {
            Iterator iterator = set.iterator();
            this.orgName = (String)iterator.next();
        }
        if (debug.messageEnabled()) {
            debug.message("LDAPFilterCondition.setPolicyConfig(): getting params\nldapServer: " + this.ldapServer + "\nauthid: " + this.authid + "\nbaseDN: " + this.baseDN + "\nuserSearchFilter: " + this.userSearchFilter + "\nuserRDNAttrName: " + this.userRDNAttrName + "\ntimeLimit: " + this.timeLimit + "\nmaxResults: " + this.maxResults + "\nminPoolSize: " + this.minPoolSize + "\nmaxPoolSize: " + this.maxPoolSize + "\nSSLEnabled: " + this.sslEnabled + "\nOrgName: " + this.orgName);
        }
        LDAPConnectionPools.initConnectionPool(this.ldapServer, this.authid, this.authpw, this.sslEnabled, this.minPoolSize, this.maxPoolSize);
        this.connPool = LDAPConnectionPools.getConnectionPool(this.ldapServer);
        this.policyConfigExpiresAt = System.currentTimeMillis() + PolicyConfig.getSubjectsResultTtl(map);
    }

    private boolean validateProperties(Map map) throws PolicyException {
        Object object;
        if (map == null || map.keySet() == null) {
            throw new PolicyException("amPolicy", "properties_can_not_be_null_or_empty", null, null);
        }
        Set set = map.keySet();
        if (!set.contains(LDAP_FILTER)) {
            Object[] objectArray = new String[]{LDAP_FILTER};
            throw new PolicyException("amPolicy", "property_value_not_defined", objectArray, null);
        }
        Iterator iterator = set.iterator();
        while (iterator.hasNext()) {
            object = (String)iterator.next();
            if (LDAP_FILTER.equals(object)) continue;
            Object[] objectArray = new String[]{object};
            throw new PolicyException("amPolicy", "attempt_to_set_invalid_property", objectArray, null);
        }
        object = (Set)map.get(LDAP_FILTER);
        if (object != null) {
            this.validateLdapFilterSet((Set)object);
        }
        return true;
    }

    private boolean validateLdapFilterSet(Set set) throws PolicyException {
        if (set.isEmpty()) {
            Object[] objectArray = new String[]{LDAP_FILTER};
            throw new PolicyException("amPolicy", "property_does_not_allow_empty_values", objectArray, null);
        }
        if (set.size() > 1) {
            Object[] objectArray = new String[]{LDAP_FILTER};
            throw new PolicyException("amPolicy", "property_does_not_allow_multiple_values", objectArray, null);
        }
        try {
            this.ldapConditionFilter = (String)set.iterator().next();
        }
        catch (ClassCastException classCastException) {
            Object[] objectArray = new String[]{LDAP_FILTER};
            throw new PolicyException("amPolicy", "property_is_not_a_String", objectArray, null);
        }
        return true;
    }

    private String trimAndParenthesise(String string) {
        String string2 = string;
        if (string != null) {
            if (!(string = string.trim()).startsWith(OPEN_PARENTHESIS)) {
                string2 = OPEN_PARENTHESIS + string + CLOSE_PARENTHESIS;
            }
        } else {
            string2 = "()";
        }
        return string2;
    }

    public Object clone() {
        LDAPFilterCondition lDAPFilterCondition = null;
        try {
            lDAPFilterCondition = (LDAPFilterCondition)super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new InternalError();
        }
        if (this.properties != null) {
            lDAPFilterCondition.properties = new HashMap();
            Iterator iterator = this.properties.keySet().iterator();
            while (iterator.hasNext()) {
                Object k = iterator.next();
                HashSet hashSet = new HashSet();
                hashSet.addAll((Set)this.properties.get(k));
                lDAPFilterCondition.properties.put(k, hashSet);
            }
        }
        return lDAPFilterCondition;
    }

    static {
        propertyNames.add(LDAP_FILTER);
    }
}

