/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.policy.plugins;

import com.iplanet.am.util.Debug;
import com.iplanet.am.util.SSLSocketFactoryManager;
import com.sun.identity.policy.PolicyException;
import java.util.HashMap;
import netscape.ldap.LDAPConnection;
import netscape.ldap.util.ConnectionPool;

public class LDAPConnectionPools {
    private static HashMap connectionPools = new HashMap();
    private static final int MIN_CONNECTION_POOL_SIZE = 1;
    private static final int MAX_CONNECTION_POOL_SIZE = 10;
    private static final int DEFAULT_PORT = 389;
    private static Debug debug = Debug.getInstance((String)"amPolicy");

    private LDAPConnectionPools() {
    }

    static void initConnectionPool(String string, String string2, String string3, boolean bl, int n, int n2) throws PolicyException {
        if (string.length() < 1) {
            debug.message("Invalid host name");
            throw new PolicyException("amPolicy", "invalid_ldap_server_host", null, null);
        }
        ConnectionPool connectionPool = null;
        try {
            HashMap hashMap = connectionPools;
            synchronized (hashMap) {
                connectionPool = (ConnectionPool)connectionPools.get(string);
                if (connectionPool == null) {
                    if (debug.messageEnabled()) {
                        debug.message("Create ConnectionPool: " + string);
                    }
                    LDAPConnection lDAPConnection = bl ? new LDAPConnection(SSLSocketFactoryManager.getSSLSocketFactory()) : new LDAPConnection();
                    lDAPConnection.setOption(17, (Object)new Integer(3));
                    lDAPConnection.connect(string, 389, string2, string3);
                    if (n < 1) {
                        n = 1;
                    }
                    if (n2 < 1) {
                        n2 = 10;
                    }
                    if (debug.messageEnabled()) {
                        debug.message("LDAPConnectionPools.initConnectionPool(): minPoolSize=" + n + ", maxPoolSize=" + n2);
                    }
                    connectionPool = new ConnectionPool(n, n2, lDAPConnection);
                    if (debug.messageEnabled()) {
                        debug.message("LDAPConnectionPools.initConnectionPool(): host: " + string);
                    }
                    connectionPools.put(string, connectionPool);
                }
            }
        }
        catch (Exception exception) {
            if (debug.messageEnabled()) {
                debug.message("Unable to create ConnectionPool", (Throwable)exception);
            }
            throw new PolicyException(exception.getMessage(), exception);
        }
    }

    static ConnectionPool getConnectionPool(String string) {
        if (debug.messageEnabled()) {
            debug.message("LDAPConnectionPools.getConnectionPool(): host: " + string);
        }
        HashMap hashMap = connectionPools;
        synchronized (hashMap) {
            ConnectionPool connectionPool = (ConnectionPool)connectionPools.get(string);
            return connectionPool;
        }
    }
}

