/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.policy.jaas;

import com.iplanet.am.util.Debug;
import com.sun.identity.policy.jaas.ISPermission;
import java.security.CodeSource;
import java.security.Permission;
import java.security.PermissionCollection;
import java.util.Enumeration;
import javax.security.auth.Policy;
import javax.security.auth.Subject;

public class ISPolicy
extends Policy {
    private static Policy defaultPolicyJDK131 = null;
    private static java.security.Policy defaultPolicyJDK141 = null;
    static Debug debug = Debug.getInstance((String)"amPolicy");

    public ISPolicy() {
        defaultPolicyJDK131 = Policy.getPolicy();
        defaultPolicyJDK141 = java.security.Policy.getPolicy();
        debug.message("ISPolicy:: ISPolicy() called");
    }

    public PermissionCollection getPermissions(Subject subject, CodeSource codeSource) {
        PermissionCollection permissionCollection;
        debug.message("ISPolicy:: Calling getPermissions");
        if (debug.messageEnabled()) {
            debug.message("ISPolicy:: codesource's URL=" + codeSource.getLocation().toString());
            debug.message("ISPolicy:: subject=" + subject.toString());
        }
        if (System.getProperty("java.version").startsWith("1.4")) {
            debug.message("JDK version 1.4.x detected");
            permissionCollection = defaultPolicyJDK141.getPermissions(codeSource);
        } else {
            debug.message("JDK version 1.3.1 detected");
            if (debug.messageEnabled()) {
                debug.message("ISPolicy:: Getting PermissionCollection from defaultPolicyJDK131");
            }
            permissionCollection = defaultPolicyJDK131.getPermissions(subject, codeSource);
        }
        permissionCollection.add(new ISPermission(subject, codeSource));
        if (debug.messageEnabled()) {
            debug.message("ISPolicy:getPermissions::pc.elements()");
            Enumeration<Permission> enumeration = permissionCollection.elements();
            while (enumeration.hasMoreElements()) {
                debug.message(((Object)enumeration.nextElement()).toString() + "\n");
            }
        }
        return permissionCollection;
    }

    public void refresh() {
        defaultPolicyJDK131.refresh();
        defaultPolicyJDK141.refresh();
        debug.message("ISPolicy:: Calling refresh");
    }
}

