/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.policy;

import com.iplanet.services.util.Base64;
import com.iplanet.sso.SSOException;
import com.iplanet.sso.SSOToken;
import com.iplanet.sso.SSOTokenManager;
import com.sun.identity.policy.NameNotFoundException;
import com.sun.identity.policy.NoPermissionException;
import com.sun.identity.policy.PolicyException;
import com.sun.identity.policy.PolicyManager;
import com.sun.identity.policy.ServiceType;
import com.sun.identity.security.AdminTokenAction;
import com.sun.identity.sm.SMSException;
import com.sun.identity.sm.ServiceManager;
import com.sun.identity.sm.ServiceSchema;
import com.sun.identity.sm.ServiceSchemaManager;
import java.security.AccessController;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Random;
import java.util.Set;

public class ServiceTypeManager {
    private static ServiceTypeManager svtm = null;
    private SSOToken token;
    private Map serviceTypes = Collections.synchronizedMap(new HashMap());
    private static Random random = new Random();

    static ServiceTypeManager getServiceTypeManager() throws SSOException {
        if (svtm == null) {
            svtm = new ServiceTypeManager();
        }
        return svtm;
    }

    private ServiceTypeManager() throws SSOException {
        this.token = ServiceTypeManager.getSSOToken();
    }

    private ServiceTypeManager(PolicyManager policyManager) {
        this.token = policyManager.token;
    }

    public ServiceTypeManager(SSOToken sSOToken) throws SSOException {
        SSOTokenManager.getInstance().validateToken(sSOToken);
        this.token = sSOToken;
    }

    public Set getServiceTypeNames() throws SSOException, NoPermissionException {
        SSOTokenManager.getInstance().validateToken(this.token);
        try {
            ServiceManager serviceManager = new ServiceManager(this.token);
            Iterator iterator = serviceManager.getServiceNames().iterator();
            HashSet<String> hashSet = new HashSet<String>();
            while (iterator.hasNext()) {
                String string = (String)iterator.next();
                try {
                    ServiceSchemaManager serviceSchemaManager = new ServiceSchemaManager(string, this.token);
                    if (serviceSchemaManager.getPolicySchema() == null) continue;
                    hashSet.add(string);
                }
                catch (Exception exception) {
                    PolicyManager.debug.error("ServiceTypeManager.getServiceTypeNames:", (Throwable)exception);
                }
            }
            return hashSet;
        }
        catch (SMSException sMSException) {
            throw new NoPermissionException(sMSException);
        }
    }

    public ServiceType getServiceType(String string) throws SSOException, NameNotFoundException {
        ServiceType serviceType = (ServiceType)this.serviceTypes.get(string);
        if (serviceType == null) {
            try {
                ServiceSchema serviceSchema = null;
                ServiceSchemaManager serviceSchemaManager = new ServiceSchemaManager(string, this.token);
                if (serviceSchemaManager == null || (serviceSchema = serviceSchemaManager.getPolicySchema()) == null) {
                    if (PolicyManager.debug.messageEnabled()) {
                        PolicyManager.debug.message("ServiceTypeManager::getServiceType " + string + " not found with policy privileges");
                    }
                    Object[] objectArray = new String[]{string};
                    throw new NameNotFoundException("amPolicy", "service_name_not_found", objectArray, string, 3);
                }
                serviceType = new ServiceType(string, serviceSchemaManager, serviceSchema);
                this.serviceTypes.put(string, serviceType);
            }
            catch (SMSException sMSException) {
                PolicyManager.debug.error("In ServiceTypeManager::getServiceType " + string + " got SMS exception: ", (Throwable)sMSException);
                throw new NameNotFoundException(sMSException, string, 3);
            }
        }
        return serviceType;
    }

    static SSOToken getSSOToken() throws SSOException {
        SSOToken sSOToken = (SSOToken)AccessController.doPrivileged(AdminTokenAction.getInstance());
        if (sSOToken == null) {
            throw new SSOException((Throwable)new PolicyException("amPolicy", "invalid_admin", null, null));
        }
        return sSOToken;
    }

    static String generateRandomName() {
        StringBuffer stringBuffer = new StringBuffer(30);
        byte[] byArray = new byte[5];
        random.nextBytes(byArray);
        stringBuffer.append(System.currentTimeMillis()).toString();
        return stringBuffer.append(Base64.encode((byte[])byArray)).toString();
    }

    public static int getPolicyServiceRevisionNumber() throws PolicyException, SSOException, SMSException {
        if (PolicyManager.debug.messageEnabled()) {
            PolicyManager.debug.message("ServiceTypeManager.getPolicyServiceRevisionNumber:entering");
        }
        SSOToken sSOToken = ServiceTypeManager.getSSOToken();
        ServiceSchemaManager serviceSchemaManager = new ServiceSchemaManager("iPlanetAMPolicyService", sSOToken);
        int n = serviceSchemaManager.getRevisionNumber();
        if (PolicyManager.debug.messageEnabled()) {
            PolicyManager.debug.message("ServiceTypeManager.getPolicyServiceRevisionNumber:returning revision=" + n);
        }
        return n;
    }
}

