/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.policy;

import com.iplanet.am.util.Debug;
import com.iplanet.sso.SSOTokenEvent;
import com.iplanet.sso.SSOTokenID;
import com.iplanet.sso.SSOTokenListener;
import com.sun.identity.policy.PolicyEvaluator;
import com.sun.identity.policy.PolicyManager;
import com.sun.identity.policy.SubjectEvaluationCache;
import com.sun.identity.policy.plugins.LDAPRoles;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

public class PolicySSOTokenListener
implements SSOTokenListener {
    private static Map resultsCache = PolicyEvaluator.policyResultsCache;
    private static Debug debug = PolicyManager.debug;

    public void ssoTokenChanged(SSOTokenEvent sSOTokenEvent) {
        try {
            SSOTokenID sSOTokenID = sSOTokenEvent.getToken().getTokenID();
            String string = sSOTokenID.toString();
            if (string == null) {
                debug.error("PolicySSOTokenListener: token id string is null");
                return;
            }
            Map map = PolicyEvaluator.policyResultsCache;
            synchronized (map) {
                if (!resultsCache.isEmpty()) {
                    Set set = resultsCache.keySet();
                    Iterator iterator = set.iterator();
                    while (iterator.hasNext()) {
                        String string2 = (String)iterator.next();
                        Map map2 = (Map)resultsCache.get(string2);
                        if (map2 == null || map2.isEmpty()) continue;
                        Set set2 = map2.keySet();
                        Iterator iterator2 = set2.iterator();
                        while (iterator2.hasNext()) {
                            String string3 = (String)iterator2.next();
                            Map map3 = (Map)map2.get(string3);
                            if (map3 == null || map3.isEmpty() || map3.remove(string) == null || !debug.messageEnabled()) continue;
                            debug.message("cleaned up the policy results for an expired token " + string);
                        }
                    }
                }
            }
            PolicyEvaluator.userNSRoleCache.remove(string);
            if (debug.messageEnabled()) {
                debug.message("PolicySSOTokenListener.ssoTokenChanged():cleaned up user nsRole cache for an expired token " + string);
            }
            SubjectEvaluationCache.subjectEvaluationCache.remove(string);
            if (debug.messageEnabled()) {
                debug.message("PolicySSOTokenListener.ssoTokenChanged():cleaned up subject evaluation cache for an expired token " + string);
            }
            LDAPRoles.userLDAPRoleCache.remove(string);
            if (debug.messageEnabled()) {
                debug.message("PolicySSOTokenListener.ssoTokenChanged()cleaned up user role cache of LDAPRoles for an expired token " + string);
            }
            PolicyEvaluator.ssoListenerRegistry.remove(string);
        }
        catch (Exception exception) {
            debug.error("PolicySSOTokenListener.ssoTokenChanged():policy sso token listener", (Throwable)exception);
        }
    }
}

