/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.policy;

import com.iplanet.am.util.Misc;
import com.iplanet.sso.SSOException;
import com.sun.identity.policy.PolicyCache;
import com.sun.identity.policy.PolicyException;
import com.sun.identity.policy.PolicyManager;
import com.sun.identity.policy.PolicyUtils;
import com.sun.identity.policy.ServiceTypeManager;
import com.sun.identity.sm.SMSException;
import com.sun.identity.sm.ServiceConfig;
import com.sun.identity.sm.ServiceConfigManager;
import com.sun.identity.sm.ServiceListener;
import com.sun.identity.sm.ServiceSchema;
import com.sun.identity.sm.ServiceSchemaManager;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import netscape.ldap.util.DN;

public class PolicyConfig
implements ServiceListener {
    public static final String LDAP_SERVER = "iplanet-am-policy-config-ldap-server";
    public static final String LDAP_BASE_DN = "iplanet-am-policy-config-ldap-base-dn";
    public static final String LDAP_USERS_BASE_DN = "iplanet-am-policy-config-ldap-users-base-dn";
    public static final String LDAP_BIND_DN = "iplanet-am-policy-config-ldap-bind-dn";
    public static final String LDAP_BIND_PASSWORD = "iplanet-am-policy-config-ldap-bind-password";
    public static final String LDAP_ORG_SEARCH_FILTER = "iplanet-am-policy-config-ldap-organizations-search-filter";
    public static final String LDAP_ORG_SEARCH_SCOPE = "iplanet-am-policy-config-ldap-organizations-search-scope";
    public static final String LDAP_GROUP_SEARCH_FILTER = "iplanet-am-policy-config-ldap-groups-search-filter";
    public static final String LDAP_GROUP_SEARCH_SCOPE = "iplanet-am-policy-config-ldap-groups-search-scope";
    public static final String LDAP_USERS_SEARCH_FILTER = "iplanet-am-policy-config-ldap-users-search-filter";
    public static final String LDAP_USERS_SEARCH_SCOPE = "iplanet-am-policy-config-ldap-users-search-scope";
    public static final String LDAP_ROLES_SEARCH_FILTER = "iplanet-am-policy-config-ldap-roles-search-filter";
    public static final String LDAP_ROLES_SEARCH_SCOPE = "iplanet-am-policy-config-ldap-roles-search-scope";
    public static final String LDAP_ORG_SEARCH_ATTRIBUTE = "iplanet-am-policy-config-ldap-organizations-search-attribute";
    public static final String LDAP_GROUP_SEARCH_ATTRIBUTE = "iplanet-am-policy-config-ldap-groups-search-attribute";
    public static final String LDAP_USER_SEARCH_ATTRIBUTE = "iplanet-am-policy-config-ldap-users-search-attribute";
    public static final String LDAP_ROLES_SEARCH_ATTRIBUTE = "iplanet-am-policy-config-ldap-roles-search-attribute";
    public static final String LDAP_SEARCH_TIME_OUT = "iplanet-am-policy-config-search-timeout";
    public static final String LDAP_SEARCH_LIMIT = "iplanet-am-policy-config-search-limit";
    public static final String LDAP_CONNECTION_POOL_MIN_SIZE = "iplanet-am-policy-config-connection_pool_min_size";
    public static final String LDAP_CONNECTION_POOL_MAX_SIZE = "iplanet-am-policy-config-connection_pool_max_size";
    public static final String LDAP_SSL_ENABLED = "iplanet-am-policy-config-ldap-ssl-enabled";
    public static final String IS_ROLES_BASE_DN = "iplanet-am-policy-config-is-roles-base-dn";
    public static final String IS_ROLES_SEARCH_SCOPE = "iplanet-am-policy-config-is-roles-search-scope";
    public static final String SELECTED_SUBJECTS = "iplanet-am-policy-selected-subjects";
    public static final String SELECTED_REFERRALS = "iplanet-am-policy-selected-referrals";
    public static final String SELECTED_CONDITIONS = "iplanet-am-policy-selected-conditions";
    public static final String SELECTED_RESPONSE_PROVIDERS = "sun-am-policy-selected-responseproviders";
    public static final String SELECTED_DYNAMIC_ATTRIBUTES = "sun-am-policy-dynamic-response-attributes";
    public static final String USER_ALIAS_ENABLED = "iplanet-am-policy-config-user-alias-enabled";
    public static final String RESOURCE_COMPARATOR = "iplanet-am-policy-config-resource-comparator";
    public static final String RESOURCE_COMPARATOR_TYPE = "serviceType";
    public static final String RESOURCE_COMPARATOR_CLASS = "class";
    public static final String RESOURCE_COMPARATOR_DELIMITER = "delimiter";
    public static final String RESOURCE_COMPARATOR_WILDCARD = "wildcard";
    public static final String RESOURCE_COMPARATOR_CASE_SENSITIVE = "caseSensitive";
    public static final String CONTINUE_EVALUATION_ON_DENY_DECISION = "iplanet-am-policy-config-continue-evaluation-on-deny-decision";
    public static final String ADVICES_HANDLEABLE_BY_AM = "sun-am-policy-config-advices-handleable-by-am";
    public static final String ORG_DN = "orgDN";
    public static final String SUBJECTS_RESULT_TTL = "iplanet-am-policy-config-subjects-result-ttl";
    public static final String POLICY_CONFIG_SERVICE = "iPlanetAMPolicyConfigService";
    public static final String ISDS_HOST = PolicyUtils.getISDSHostName();
    private static ServiceConfigManager scm = null;
    private static ServiceSchemaManager ssm = null;
    private static Map attrMap = new HashMap();
    private static Map resourceCompMap = new HashMap();
    private static PolicyCache policyCache;
    static boolean continueEvaluationOnDenyDecisionFlag;
    static Set advicesHandleableByAM;

    private PolicyConfig() {
    }

    public static Map getResourceCompareConfig(String string) throws PolicyException {
        Map map;
        Object object;
        Map map2 = null;
        if (scm == null || ssm == null) {
            try {
                scm = new ServiceConfigManager(POLICY_CONFIG_SERVICE, ServiceTypeManager.getSSOToken());
                ssm = new ServiceSchemaManager(POLICY_CONFIG_SERVICE, ServiceTypeManager.getSSOToken());
                object = new PolicyConfig();
                scm.addListener((ServiceListener)object);
                ssm.addListener((ServiceListener)object);
            }
            catch (SMSException sMSException) {
                PolicyManager.debug.error("getResourceCompareConfig: Unable to create ServiceConfigManager", (Throwable)sMSException);
                throw new PolicyException(sMSException);
            }
            catch (SSOException sSOException) {
                PolicyManager.debug.error("getResourceCompareConfig: Unale to create ServiceConfigManager", (Throwable)sSOException);
                throw new PolicyException(sSOException);
            }
        }
        object = null;
        if (string == null || !resourceCompMap.containsKey(string)) {
            try {
                object = ssm.getGlobalSchema();
            }
            catch (SMSException sMSException) {
                PolicyManager.debug.error("getResourceCompConfig: Unable to get ServiceConfig", (Throwable)sMSException);
                throw new PolicyException(sMSException);
            }
            map = null;
            if (object != null) {
                Map map3 = ((ServiceSchema)object).getAttributeDefaults();
                PolicyConfig.setContinueEvaluationOnDenyDecision(map3);
                PolicyConfig.setAdvicesHandleableByAM(map3);
                PolicyConfig.processResourceMap(map3);
            }
        }
        if (string != null) {
            map = resourceCompMap;
            synchronized (map) {
                map2 = (Map)resourceCompMap.get(string);
            }
        }
        return map2;
    }

    public static Map getPolicyConfig(String string) throws PolicyException {
        Map map;
        Object object;
        string = new DN(string).toRFCString().toLowerCase();
        if (policyCache == null) {
            policyCache = PolicyCache.getInstance();
        }
        if (scm == null) {
            try {
                scm = new ServiceConfigManager(POLICY_CONFIG_SERVICE, ServiceTypeManager.getSSOToken());
                ssm = new ServiceSchemaManager(POLICY_CONFIG_SERVICE, ServiceTypeManager.getSSOToken());
                object = new PolicyConfig();
                scm.addListener((ServiceListener)object);
                ssm.addListener((ServiceListener)object);
            }
            catch (SMSException sMSException) {
                PolicyManager.debug.error("getPolicyConfig: Unable to create ServiceConfigManager", (Throwable)sMSException);
                throw new PolicyException(sMSException);
            }
            catch (SSOException sSOException) {
                PolicyManager.debug.error("getPolicyConfig Unable to create ServiceConfigManager", (Throwable)sSOException);
                throw new PolicyException(sSOException);
            }
        }
        if (!attrMap.containsKey(string)) {
            object = null;
            try {
                object = scm.getOrganizationConfig(string, null);
            }
            catch (SMSException sMSException) {
                PolicyManager.debug.error("getPolicyConfig: Unable to get ServiceConfig", (Throwable)sMSException);
                throw new PolicyException(sMSException);
            }
            catch (SSOException sSOException) {
                PolicyManager.debug.error("getPolicyConfig: Unable to get ServiceConfig", (Throwable)sSOException);
                throw new PolicyException(sSOException);
            }
            if (object != null) {
                map = PolicyConfig.processOrgAttrMap(((ServiceConfig)object).getAttributes());
                map.put(ORG_DN, string);
                Map map2 = attrMap;
                synchronized (map2) {
                    attrMap.put(string, map);
                }
            }
        }
        object = attrMap;
        synchronized (object) {
            map = (Map)attrMap.get(string);
            return map;
        }
    }

    public void schemaChanged(String string, String string2) {
        ServiceSchema serviceSchema = null;
        try {
            serviceSchema = ssm.getGlobalSchema();
        }
        catch (SMSException sMSException) {
            PolicyManager.debug.error("globalConfigChanged: Unable to get global config ", (Throwable)sMSException);
            return;
        }
        if (serviceSchema != null) {
            Map map = serviceSchema.getAttributeDefaults();
            PolicyConfig.setContinueEvaluationOnDenyDecision(map);
            PolicyConfig.setAdvicesHandleableByAM(map);
            PolicyConfig.processResourceMap(map);
        }
    }

    public void globalConfigChanged(String string, String string2, String string3, String string4, int n) {
    }

    public void organizationConfigChanged(String string, String string2, String string3, String string4, String string5, int n) {
        Map map = null;
        ServiceConfig serviceConfig = null;
        try {
            serviceConfig = scm.getOrganizationConfig(string3, null);
        }
        catch (SMSException sMSException) {
            PolicyManager.debug.error("orgConfigChanged: Unable to get org config: " + string3, (Throwable)sMSException);
            return;
        }
        catch (SSOException sSOException) {
            PolicyManager.debug.error("orgConfigChanged: Unable to get org config: " + string3, (Throwable)sSOException);
            return;
        }
        if (serviceConfig != null) {
            map = PolicyConfig.processOrgAttrMap(serviceConfig.getAttributes());
        }
        Map map2 = attrMap;
        synchronized (map2) {
            attrMap.put(string3, map);
        }
        if (policyCache != null) {
            policyCache.policyConfigChanged(string3);
        }
    }

    private static Map processOrgAttrMap(Map map) {
        Set set = map.keySet();
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        if (set != null && !set.isEmpty()) {
            Iterator iterator = set.iterator();
            while (iterator.hasNext()) {
                String string = (String)iterator.next();
                Set set2 = (Set)map.get(string);
                if (set2 == null || set2.isEmpty()) continue;
                if (string.equals(SELECTED_SUBJECTS) || string.equals(SELECTED_REFERRALS) || string.equals(SELECTED_RESPONSE_PROVIDERS) || string.equals(SELECTED_DYNAMIC_ATTRIBUTES) || string.equals(SELECTED_CONDITIONS)) {
                    hashMap.put(string, set2);
                    continue;
                }
                if (string.equals(LDAP_SERVER)) {
                    hashMap.put(string, Misc.getServerMapAttr((Map)map, (String)LDAP_SERVER));
                    continue;
                }
                Iterator iterator2 = set2.iterator();
                while (iterator2.hasNext()) {
                    String string2 = (String)iterator2.next();
                    if (string == null || string2 == null) continue;
                    hashMap.put(string, string2);
                    if (!PolicyManager.debug.messageEnabled()) continue;
                    if (string.equals(LDAP_BIND_PASSWORD)) {
                        PolicyManager.debug.message("Attr Name = " + string + ";  Attr Value = ********");
                        continue;
                    }
                    PolicyManager.debug.message("Attr Name = " + string + ";  Attr Value = " + string2);
                }
            }
        }
        return hashMap;
    }

    private static void processResourceMap(Map map) {
        Set set = (Set)map.get(RESOURCE_COMPARATOR);
        if (set != null && !set.isEmpty()) {
            Iterator iterator = set.iterator();
            while (iterator.hasNext()) {
                String string = (String)iterator.next();
                if (string == null) continue;
                StringTokenizer stringTokenizer = new StringTokenizer(string, "|");
                String[] stringArray = new String[5];
                int n = 0;
                while (stringTokenizer.hasMoreTokens()) {
                    stringArray[n++] = stringTokenizer.nextToken();
                    if (n > 4) break;
                }
                HashMap<String, String> hashMap = new HashMap<String, String>();
                String string2 = null;
                int n2 = 0;
                while (n2 < n) {
                    int n3 = stringArray[n2].indexOf("=");
                    String string3 = stringArray[n2].substring(0, n3);
                    String string4 = stringArray[n2].substring(n3 + 1);
                    if (string3 == null) {
                        PolicyManager.debug.error("Resource comapartaor:  name is null");
                    } else if (string4 == null) {
                        PolicyManager.debug.error("Resource comapartaor:  value is null");
                    } else {
                        if (PolicyManager.debug.messageEnabled()) {
                            PolicyManager.debug.message("Attr Name = " + string3 + " Attr Value = " + string4);
                        }
                        if (string3.equalsIgnoreCase(RESOURCE_COMPARATOR_TYPE)) {
                            string2 = string4;
                        } else if (string3.equalsIgnoreCase(RESOURCE_COMPARATOR_CLASS)) {
                            hashMap.put(RESOURCE_COMPARATOR_CLASS, string4);
                        } else if (string3.equalsIgnoreCase(RESOURCE_COMPARATOR_DELIMITER)) {
                            hashMap.put(RESOURCE_COMPARATOR_DELIMITER, string4);
                        } else if (string3.equalsIgnoreCase(RESOURCE_COMPARATOR_WILDCARD)) {
                            hashMap.put(RESOURCE_COMPARATOR_WILDCARD, string4);
                        } else if (string3.equalsIgnoreCase(RESOURCE_COMPARATOR_CASE_SENSITIVE)) {
                            hashMap.put(RESOURCE_COMPARATOR_CASE_SENSITIVE, string4);
                        }
                    }
                    ++n2;
                }
                Map map2 = resourceCompMap;
                synchronized (map2) {
                    resourceCompMap.put(string2, hashMap);
                }
            }
        }
    }

    public static long getSubjectsResultTtl(Map map) {
        long l;
        block4: {
            String string = null;
            if (map != null) {
                string = (String)map.get(SUBJECTS_RESULT_TTL);
            }
            l = 0L;
            if (string != null) {
                try {
                    l = Integer.parseInt(string) * 60 * 1000;
                }
                catch (NumberFormatException numberFormatException) {
                    if (!PolicyManager.debug.warningEnabled()) break block4;
                    PolicyManager.debug.warning("NumberFormatException while parsing  subjectsResultTtl defined in policyConfig  service  using default 600000");
                }
            }
        }
        return l;
    }

    static void setContinueEvaluationOnDenyDecision(Map map) {
        Set set;
        if (map != null && (set = (Set)map.get(CONTINUE_EVALUATION_ON_DENY_DECISION)) != null && !set.isEmpty()) {
            String string = (String)set.iterator().next();
            if (string != null) {
                continueEvaluationOnDenyDecisionFlag = Boolean.valueOf(string);
            }
            if (PolicyManager.debug.messageEnabled()) {
                PolicyManager.debug.message("PolicyConfig.setContinueEvaluationOnDenyDecision():global attribute continueEvaluationOnDenyDecision=" + string);
            }
        }
        PolicyManager.debug.message("PolicyConfig.setContinueEvaluationOnDenyDecision():continueEvaluationOnDenyDecision=" + continueEvaluationOnDenyDecisionFlag);
    }

    static boolean continueEvaluationOnDenyDecision() {
        return continueEvaluationOnDenyDecisionFlag;
    }

    private static void setAdvicesHandleableByAM(Map map) {
        Set set;
        if (map != null && (set = (Set)map.get(ADVICES_HANDLEABLE_BY_AM)) != null) {
            advicesHandleableByAM = set;
        }
        if (PolicyManager.debug.messageEnabled()) {
            PolicyManager.debug.message("PolicyConfig.setAdvicesHandleableByAM():global attribute advicesHandleableByAM=" + advicesHandleableByAM);
        }
        if (advicesHandleableByAM == null) {
            advicesHandleableByAM = Collections.EMPTY_SET;
        }
    }

    public static Set getAdvicesHandleableByAM() throws PolicyException {
        if (advicesHandleableByAM == null) {
            PolicyConfig.getResourceCompareConfig(null);
        }
        if (PolicyManager.debug.messageEnabled()) {
            PolicyManager.debug.message("PolicyConfig.getAdvicesHandleableByAM():returning global attribute advicesHandleableByAM=" + advicesHandleableByAM);
        }
        return advicesHandleableByAM;
    }

    static {
        continueEvaluationOnDenyDecisionFlag = false;
        advicesHandleableByAM = null;
    }
}

