/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.policy;

import com.iplanet.am.util.Debug;
import com.iplanet.am.util.XMLUtils;
import com.iplanet.sso.SSOException;
import com.iplanet.sso.SSOToken;
import com.sun.identity.policy.ConditionDecision;
import com.sun.identity.policy.ConditionTypeManager;
import com.sun.identity.policy.InvalidFormatException;
import com.sun.identity.policy.InvalidNameException;
import com.sun.identity.policy.NameAlreadyExistsException;
import com.sun.identity.policy.NameNotFoundException;
import com.sun.identity.policy.PolicyException;
import com.sun.identity.policy.PolicyManager;
import com.sun.identity.policy.PolicyUtils;
import com.sun.identity.policy.ServiceTypeManager;
import com.sun.identity.policy.interfaces.Condition;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class Conditions {
    private static final Debug DEBUG = Debug.getInstance((String)"amPolicy");
    private String name;
    private String description;
    private Map conditions = new HashMap();
    private static String CONDITIONS_ELEMENT_BEGIN = "<Conditions name=\"";
    private static String CONDITIONS_DESCRIPTION = "\" description=\"";
    private static String CONDITIONS_ELEMENT_END = "</Conditions>";
    private static String CONDITION_ELEMENT = "<Condition name=\"";
    private static String CONDITION_TYPE = "\" type=\"";
    private static String CONDITION_ELEMENT_END = "</Condition>";
    private static String VALUE_BEGIN = "<Value>";
    private static String VALUE_END = "</Value>";
    private static String ATTR_VALUE_PAIR_BEGIN = "<AttributeValuePair>";
    private static String ATTR_NAME_BEGIN = "<Attribute name=";
    private static String ATTR_NAME_END = "/>";
    private static String ATTR_VALUE_PAIR_END = "</AttributeValuePair>";

    Conditions() {
    }

    protected Conditions(ConditionTypeManager conditionTypeManager, Node node) throws InvalidFormatException, InvalidNameException, NameNotFoundException, PolicyException {
        if (!node.getNodeName().equalsIgnoreCase("Conditions")) {
            if (PolicyManager.debug.warningEnabled()) {
                PolicyManager.debug.warning("invalid conditions xml blob given to construct conditions");
            }
            throw new InvalidFormatException("amPolicy", "invalid_xml_conditions_root_node", null, "", 6);
        }
        this.name = XMLUtils.getNodeAttributeValue((Node)node, (String)"name");
        if (this.name == null) {
            this.name = "Conditions:" + ServiceTypeManager.generateRandomName();
        }
        if ((this.description = XMLUtils.getNodeAttributeValue((Node)node, (String)"description")) == null) {
            this.description = "";
        }
        Iterator iterator = XMLUtils.getChildNodes((Node)node, (String)"Condition").iterator();
        while (iterator.hasNext()) {
            Object object;
            Node node2 = (Node)iterator.next();
            String string = XMLUtils.getNodeAttributeValue((Node)node2, (String)"type");
            if (string == null) {
                if (PolicyManager.debug.warningEnabled()) {
                    PolicyManager.debug.warning("condition type is null");
                }
                throw new InvalidFormatException("amPolicy", "invalid_xml_conditions_root_node", null, "", 6);
            }
            Condition condition = conditionTypeManager.getCondition(string);
            HashMap<String, Set> hashMap = new HashMap<String, Set>();
            NodeList nodeList = node2.getChildNodes();
            int n = nodeList.getLength();
            int n2 = 0;
            while (n2 < n) {
                object = nodeList.item(n2);
                Node node3 = XMLUtils.getChildNode((Node)object, (String)"Attribute");
                if (node3 != null) {
                    String string2 = XMLUtils.getNodeAttributeValue((Node)node3, (String)"name");
                    Set set = XMLUtils.getAttributeValuePair((Node)object);
                    if (string2 != null && set != null) {
                        hashMap.put(string2, set);
                    }
                }
                ++n2;
            }
            condition.setProperties(hashMap);
            object = XMLUtils.getNodeAttributeValue((Node)node2, (String)"name");
            this.addCondition((String)object, condition);
        }
    }

    public Conditions(String string, String string2) {
        this.name = string == null ? "Conditions:" + ServiceTypeManager.generateRandomName() : string;
        this.description = string2 == null ? "" : string2;
    }

    public String getName() {
        return this.name;
    }

    public String getDescription() {
        return this.description;
    }

    public void setName(String string) {
        this.name = string == null ? "Conditions:" + ServiceTypeManager.generateRandomName() : string;
    }

    public void setDescription(String string) {
        this.description = string == null ? "" : string;
    }

    public Set getConditionNames() {
        return this.conditions.keySet();
    }

    public Condition getCondition(String string) throws NameNotFoundException {
        Condition condition = (Condition)this.conditions.get(string);
        if (condition == null) {
            Object[] objectArray = new String[]{string};
            throw new NameNotFoundException("amPolicy", "name_not_present", objectArray, string, 6);
        }
        return condition;
    }

    public void addCondition(Condition condition) throws NameAlreadyExistsException {
        this.addCondition(null, condition);
    }

    public void addCondition(String string, Condition condition) throws NameAlreadyExistsException {
        if (string == null) {
            string = "Condition:" + ServiceTypeManager.generateRandomName();
        }
        if (this.conditions.containsKey(string)) {
            Object[] objectArray = new String[]{string};
            throw new NameAlreadyExistsException("amPolicy", "name_already_present", objectArray, string, 6);
        }
        this.conditions.put(string, condition);
    }

    public void replaceCondition(String string, Condition condition) throws NameNotFoundException {
        if (!this.conditions.containsKey(string)) {
            Object[] objectArray = new String[]{string};
            throw new NameNotFoundException("amPolicy", "name_not_present", objectArray, string, 6);
        }
        this.conditions.put(string, condition);
    }

    public Condition removeCondition(String string) {
        return (Condition)this.conditions.remove(string);
    }

    public Condition removeCondition(Condition condition) {
        String string = this.getConditionName(condition);
        if (string != null) {
            return this.removeCondition(string);
        }
        return null;
    }

    public String getConditionName(Condition condition) {
        String string = null;
        Iterator iterator = this.conditions.keySet().iterator();
        while (iterator.hasNext()) {
            String string2 = (String)iterator.next();
            if (!condition.equals(this.conditions.get(string2))) continue;
            string = string2;
            break;
        }
        return string;
    }

    public boolean equals(Object object) {
        if (object instanceof Conditions) {
            Conditions conditions = (Conditions)object;
            Iterator iterator = this.conditions.entrySet().iterator();
            while (iterator.hasNext()) {
                Object v = iterator.next().getValue();
                if (conditions.conditions.containsValue(v)) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public Object clone() {
        Conditions conditions = null;
        try {
            conditions = (Conditions)super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            conditions = new Conditions();
        }
        conditions.name = this.name;
        conditions.description = this.description;
        conditions.conditions = new HashMap();
        Iterator iterator = this.conditions.keySet().iterator();
        while (iterator.hasNext()) {
            Object k = iterator.next();
            Condition condition = (Condition)this.conditions.get(k);
            conditions.conditions.put(k, condition.clone());
        }
        return conditions;
    }

    public boolean isAllowed(SSOToken sSOToken, Map map) throws PolicyException, SSOException {
        return this.getConditionDecision(sSOToken, map).isAllowed();
    }

    ConditionDecision getConditionDecision(SSOToken sSOToken, Map map) throws PolicyException, SSOException {
        Boolean bl;
        Object object;
        Cloneable cloneable;
        boolean bl2 = false;
        HashMap<Object, Boolean> hashMap = new HashMap<Object, Boolean>();
        HashMap hashMap2 = new HashMap();
        long l = Long.MAX_VALUE;
        Iterator iterator = this.conditions.entrySet().iterator();
        while (iterator.hasNext()) {
            long l2;
            ConditionDecision conditionDecision;
            boolean bl3;
            cloneable = (Condition)iterator.next().getValue();
            object = ConditionTypeManager.conditionTypeName(cloneable);
            boolean bl4 = false;
            bl = (Boolean)hashMap.get(object);
            if (bl != null) {
                bl4 = bl;
            }
            bl3 = (bl3 = (conditionDecision = cloneable.getConditionDecision(sSOToken, map)).isAllowed()) || bl4;
            hashMap.put(object, new Boolean(bl3));
            Map map2 = conditionDecision.getAdvices();
            if (map2 != null && !map2.isEmpty()) {
                HashMap hashMap3 = (HashMap)hashMap2.get(object);
                if (hashMap3 == null) {
                    hashMap3 = new HashMap();
                    hashMap2.put(object, hashMap3);
                }
                PolicyUtils.appendMapToMap(map2, (Map)hashMap2.get(object));
            }
            if ((l2 = conditionDecision.getTimeToLive()) >= l) continue;
            l = l2;
        }
        cloneable = new HashMap();
        if (!hashMap.containsValue(Boolean.FALSE)) {
            bl2 = true;
        } else {
            object = hashMap2.keySet().iterator();
            while (object.hasNext()) {
                String string = (String)object.next();
                bl = (Boolean)hashMap.get(string);
                if (!bl.equals(Boolean.FALSE)) continue;
                PolicyUtils.appendMapToMap((Map)hashMap2.get(string), (Map)((Object)cloneable));
            }
        }
        if (DEBUG.messageEnabled()) {
            DEBUG.message("At Conditions.getConditionDecision():allowed,timeToLive,  advices=" + bl2 + "," + l + "," + cloneable);
        }
        return new ConditionDecision(bl2, l, (Map)((Object)cloneable));
    }

    public String toString() {
        return this.toXML();
    }

    protected String toXML() {
        StringBuffer stringBuffer = new StringBuffer(100);
        stringBuffer.append("\n").append(CONDITIONS_ELEMENT_BEGIN).append(XMLUtils.escapeSpecialCharacters((String)this.name)).append(CONDITIONS_DESCRIPTION).append(XMLUtils.escapeSpecialCharacters((String)this.description)).append("\">");
        Iterator iterator = this.conditions.keySet().iterator();
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            Condition condition = (Condition)this.conditions.get(string);
            stringBuffer.append("\n").append(CONDITION_ELEMENT).append(XMLUtils.escapeSpecialCharacters((String)string)).append(CONDITION_TYPE).append(XMLUtils.escapeSpecialCharacters((String)ConditionTypeManager.conditionTypeName(condition))).append("\">");
            Map map = condition.getProperties();
            if (map != null) {
                Set set = map.keySet();
                Iterator iterator2 = set.iterator();
                while (iterator2.hasNext()) {
                    stringBuffer.append("\n").append(ATTR_VALUE_PAIR_BEGIN);
                    String string2 = (String)iterator2.next();
                    stringBuffer.append(ATTR_NAME_BEGIN);
                    stringBuffer.append(this.quote(XMLUtils.escapeSpecialCharacters((String)string2)));
                    stringBuffer.append(ATTR_NAME_END);
                    Set set2 = (Set)map.get(string2);
                    if (set2 != null && !set2.isEmpty()) {
                        Iterator iterator3 = set2.iterator();
                        while (iterator3.hasNext()) {
                            String string3 = (String)iterator3.next();
                            stringBuffer.append(VALUE_BEGIN);
                            stringBuffer.append(XMLUtils.escapeSpecialCharacters((String)string3));
                            stringBuffer.append(VALUE_END);
                        }
                    }
                    stringBuffer.append("\n").append(ATTR_VALUE_PAIR_END);
                }
            }
            stringBuffer.append("\n").append(CONDITION_ELEMENT_END);
        }
        stringBuffer.append("\n").append(CONDITIONS_ELEMENT_END);
        return stringBuffer.toString();
    }

    private String quote(String string) {
        String string2 = null;
        string2 = string == null ? "\"\"" : "\"" + string + "\"";
        return string2;
    }

    int size() {
        return this.conditions.size();
    }
}

