/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.liberty.ws.soapbinding;

import com.iplanet.am.util.Cache;
import com.iplanet.am.util.Debug;
import com.iplanet.am.util.Misc;
import com.iplanet.am.util.SystemProperties;
import com.iplanet.dpro.session.service.SessionService;
import com.iplanet.sso.SSOToken;
import com.iplanet.sso.SSOTokenManager;
import com.sun.identity.common.DateUtils;
import com.sun.identity.liberty.ws.soapbinding.Message;
import com.sun.identity.liberty.ws.soapbinding.Utils;
import com.sun.identity.liberty.ws.soapbinding.WebServiceAuthenticator;
import com.sun.identity.security.AdminTokenAction;
import com.sun.identity.sm.ServiceSchema;
import com.sun.identity.sm.ServiceSchemaManager;
import java.security.AccessController;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;

class WebServiceAuthenticatorImpl
implements WebServiceAuthenticator {
    private static final String PRINCIPAL_PROP = "Principal";
    private static final String PRINCIPALS_PROP = "Principals";
    private static final String AUTH_TYPE_PROP = "AuthType";
    private static final String AUTH_INSTANT_PROP = "authInstant";
    private static final String ANONYMOUS_PRINCIPAL = "anonymous";
    private static final String SESSION_SERVICE_NAME = "iPlanetAMSessionService";
    private static final String MAX_SESSION_TIME = "iplanet-am-session-max-session-time";
    private static final String IDLE_TIME = "iplanet-am-session-max-idle-time";
    private static final String CACHE_TIME = "iplanet-am-session-max-caching-time";
    private static final int DEFAULT_MAX_SESSION_TIME = 120;
    private static final int DEFAULT_IDLE_TIME = 30;
    private static final int DEFAULT_CACHE_TIME = 3;
    private static Cache ssoTokenCache = new Cache(1000);
    private static SSOTokenManager ssoTokenManager = null;
    private static ServiceSchema sessionSchema = null;
    private static String rootSuffix = SystemProperties.get((String)"com.iplanet.am.rootsuffix");

    WebServiceAuthenticatorImpl() {
    }

    public Object authenticate(Message message, HttpServletRequest httpServletRequest) {
        String string;
        String string2;
        Object object;
        Object object2;
        Object object3;
        X509Certificate x509Certificate;
        ArrayList<X509Certificate> arrayList = null;
        X509Certificate x509Certificate2 = message.getPeerCertificate();
        if (x509Certificate2 != null) {
            arrayList = new ArrayList<X509Certificate>(2);
            arrayList.add(x509Certificate2);
        }
        if ((x509Certificate = message.getMessageCertificate()) != null) {
            if (arrayList == null) {
                arrayList = new ArrayList(1);
            }
            arrayList.add(x509Certificate);
        }
        String string3 = null;
        StringBuffer stringBuffer = null;
        if (arrayList == null) {
            string3 = ANONYMOUS_PRINCIPAL;
        } else {
            object3 = new HashSet(6);
            object2 = arrayList.iterator();
            while (object2.hasNext()) {
                object = (X509Certificate)object2.next();
                if (Utils.debug.messageEnabled()) {
                    Utils.debug.message("WebServiceAuthenticatorImpl.authenticate: cert = " + object);
                }
                string2 = ((X509Certificate)object).getSubjectDN().getName();
                if (string3 == null) {
                    string3 = string2;
                } else if (!string3.equals(string2)) {
                    object3.add(string2);
                }
                string = ((X509Certificate)object).getIssuerDN().getName();
                object3.add(string);
            }
            stringBuffer = new StringBuffer(50);
            object = object3.iterator();
            while (object.hasNext()) {
                string2 = (String)object.next();
                if (stringBuffer.length() == 0) {
                    stringBuffer.append(string2);
                    continue;
                }
                stringBuffer.append("|").append(string2);
            }
        }
        if (Utils.debug.messageEnabled()) {
            Utils.debug.message("WebServiceAuthenticatorImpl.authenticate: principal = " + string3 + ", principals = " + stringBuffer);
        }
        object3 = message.getAuthenticationMechanism();
        object2 = (String)object3 + " " + string3;
        if (Utils.debug.messageEnabled()) {
            Utils.debug.message("WebServiceAuthenticatorImpl.authenticate: cacheKey = " + (String)object2);
        }
        object = null;
        object = (SSOToken)ssoTokenCache.get(object2);
        if (object != null) {
            if (ssoTokenManager.isValidToken((SSOToken)object)) {
                if (Utils.debug.messageEnabled()) {
                    Utils.debug.message("WebServiceAuthenticatorImpl.authenticate: found ssoToken in cache");
                }
                return object;
            }
            if (Utils.debug.messageEnabled()) {
                Utils.debug.message("WebServiceAuthenticatorImpl.authenticate: ssoToken in cache expired");
            }
            string2 = ssoTokenCache;
            synchronized (string2) {
                ssoTokenCache.remove(object2);
            }
            object = null;
        }
        string2 = null;
        try {
            string = SessionService.getSessionService().newInternalSession(null, null);
            string.activate("");
            Map map = sessionSchema.getAttributeDefaults();
            string.setMaxSessionTime((long)Misc.getIntMapAttr((Map)map, (String)MAX_SESSION_TIME, (int)120, (Debug)Utils.debug));
            string.setMaxIdleTime((long)Misc.getIntMapAttr((Map)map, (String)IDLE_TIME, (int)30, (Debug)Utils.debug));
            string.setMaxCachingTime((long)Misc.getIntMapAttr((Map)map, (String)CACHE_TIME, (int)3, (Debug)Utils.debug));
            string.putProperty(AUTH_TYPE_PROP, message.getAuthenticationMechanism());
            string2 = DateUtils.toUTCDateFormat((Date)new Date());
            string.putProperty(AUTH_INSTANT_PROP, string2);
            object = SSOTokenManager.getInstance().createSSOToken(string.getID().toString());
        }
        catch (Exception exception) {
            Utils.debug.error("WebServiceAuthenticatorImpl.authenticate: Unable to get SSOToken", (Throwable)exception);
        }
        if (object == null) {
            return null;
        }
        try {
            object.setProperty(PRINCIPAL_PROP, string3);
            if (stringBuffer != null) {
                object.setProperty(PRINCIPALS_PROP, stringBuffer.toString());
            }
            if (string2 != null) {
                object.setProperty(AUTH_INSTANT_PROP, string2);
            }
            object.setProperty(AUTH_TYPE_PROP, message.getAuthenticationMechanism());
            SSOTokenManager.getInstance().refreshSession((SSOToken)object);
            ssoTokenCache.put(object2, object);
        }
        catch (Exception exception) {
            Utils.debug.error("WebServiceAuthenticatorImpl.authenticate: Unable to set SSOToken property", (Throwable)exception);
            return null;
        }
        return object;
    }

    static {
        try {
            ssoTokenManager = SSOTokenManager.getInstance();
        }
        catch (Exception exception) {
            Utils.debug.error("WebServiceAuthenticatorImpl.static: unable to get SSOTokenManager", (Throwable)exception);
        }
        try {
            SSOToken sSOToken = (SSOToken)AccessController.doPrivileged(AdminTokenAction.getInstance());
            ServiceSchemaManager serviceSchemaManager = new ServiceSchemaManager(SESSION_SERVICE_NAME, sSOToken);
            sessionSchema = serviceSchemaManager.getDynamicSchema();
        }
        catch (Exception exception) {
            Utils.debug.error("WebServiceAuthenticatorImpl.static: unable to get session schema", (Throwable)exception);
        }
    }
}

