/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.liberty.ws.soapbinding;

import com.sun.identity.liberty.ws.common.LogUtil;
import com.sun.identity.liberty.ws.security.SecurityUtils;
import com.sun.identity.liberty.ws.soapbinding.CorrelationHeader;
import com.sun.identity.liberty.ws.soapbinding.Message;
import com.sun.identity.liberty.ws.soapbinding.RequestHandler;
import com.sun.identity.liberty.ws.soapbinding.SOAPBindingService;
import com.sun.identity.liberty.ws.soapbinding.SOAPFault;
import com.sun.identity.liberty.ws.soapbinding.SOAPFaultException;
import com.sun.identity.liberty.ws.soapbinding.Utils;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.cert.X509Certificate;
import java.util.List;
import java.util.logging.Level;
import javax.servlet.ServletException;
import javax.servlet.ServletInputStream;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.xml.messaging.JAXMServlet;
import javax.xml.namespace.QName;
import javax.xml.soap.MimeHeaders;
import javax.xml.soap.SOAPException;
import javax.xml.soap.SOAPMessage;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class SOAPReceiver
extends JAXMServlet {
    public void doPost(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws IOException, ServletException {
        try {
            MimeHeaders mimeHeaders = JAXMServlet.getHeaders((HttpServletRequest)httpServletRequest);
            ServletInputStream servletInputStream = httpServletRequest.getInputStream();
            SOAPMessage sOAPMessage = this.msgFactory.createMessage(mimeHeaders, (InputStream)servletInputStream);
            SOAPMessage sOAPMessage2 = this.onMessage(sOAPMessage, httpServletRequest);
            if (sOAPMessage2 != null) {
                JAXMServlet.putHeaders((MimeHeaders)sOAPMessage2.getMimeHeaders(), (HttpServletResponse)httpServletResponse);
                ServletOutputStream servletOutputStream = httpServletResponse.getOutputStream();
                sOAPMessage2.writeTo((OutputStream)servletOutputStream);
                servletOutputStream.flush();
            } else {
                httpServletResponse.setStatus(500);
            }
        }
        catch (SOAPException sOAPException) {
            throw new ServletException((Throwable)sOAPException);
        }
    }

    public SOAPMessage onMessage(SOAPMessage sOAPMessage, HttpServletRequest httpServletRequest) {
        String string;
        String string2;
        if (Utils.debug.messageEnabled()) {
            Utils.debug.message("SOAPReceiver.onMessage:");
        }
        if ((string2 = httpServletRequest.getHeader("SOAPAction")) != null && string2.length() == 0) {
            string2 = httpServletRequest.getRequestURI();
        }
        String string3 = httpServletRequest.getRemoteAddr();
        X509Certificate[] x509CertificateArray = (X509Certificate[])httpServletRequest.getAttribute("javax.servlet.request.X509Certificate");
        X509Certificate x509Certificate = null;
        if (x509CertificateArray != null && x509CertificateArray.length > 0) {
            x509Certificate = x509CertificateArray[0];
        }
        if ((string = httpServletRequest.getPathInfo()) != null) {
            RequestHandler requestHandler;
            string = string.substring(1);
            if (Utils.debug.messageEnabled()) {
                Utils.debug.message("SOAPReceiver.doPost: key = " + string + "\nSOAPAction = " + string2 + "\nremoteAttr = " + string3);
            }
            if ((requestHandler = (RequestHandler)SOAPBindingService.handlers.get(string)) != null) {
                Object object;
                if (string2 != null && (object = (List)SOAPBindingService.supportedSOAPActionsMap.get(string)) != null && !object.isEmpty() && !object.contains(string2)) {
                    return this.FormSOAPError("Client", "unsupportedSOAPAction", null);
                }
                object = null;
                try {
                    object = new Message(sOAPMessage);
                    Utils.enforceProcessingRules((Message)object, null, true);
                    ((Message)object).setIPAddress(string3);
                    ((Message)object).setPeerCertificate(x509Certificate);
                    ((Message)object).setProtocol(httpServletRequest.getScheme());
                    if (((Message)object).getSecurityProfileType() != 0 && !SecurityUtils.verifyMessage((Message)object)) {
                        return this.FormSOAPError("Client", "cannotVerifySignature", (Message)object);
                    }
                    String string4 = ((Message)object).getAuthenticationMechanism();
                    if (Utils.debug.messageEnabled()) {
                        Utils.debug.message("SOAPReceiver.onMessage: authMech = " + string4 + ", isClientAuthentication = " + ((Message)object).isClientAuthentication());
                    }
                    if (string4 == null || !SOAPBindingService.getSupportedAuthenticationMechanisms().contains(string4)) {
                        return this.FormSOAPError("Server", "unsupportedAuthMech", (Message)object);
                    }
                    Object object2 = SOAPBindingService.getWebServiceAuthenticator().authenticate((Message)object, httpServletRequest);
                    ((Message)object).setToken(object2);
                    String[] stringArray = new String[]{((Message)object).getCorrelationHeader().getMessageID(), string};
                    LogUtil.access(Level.INFO, "WS_Success", stringArray);
                    Message message = requestHandler.processRequest((Message)object);
                    message.getCorrelationHeader().setRefToMessageID(((Message)object).getCorrelationHeader().getMessageID());
                    int n = message.getSecurityProfileType();
                    if (n == 0 || n == 3) {
                        return message.toSOAPMessage();
                    }
                    Element element = SecurityUtils.signMessage(message);
                    if (element == null) {
                        Utils.debug.error("SOAPReceiver.onMessage: Unable to sign response");
                        return this.FormSOAPError("Server", "cannotSignResponse", (Message)object);
                    }
                    Document document = element.getOwnerDocument();
                    return Utils.DocumentToSOAPMessage(document);
                }
                catch (SOAPFaultException sOAPFaultException) {
                    Message message = sOAPFaultException.getSOAPFaultMessage();
                    if (message == null) {
                        return this.FormSOAPError("Server", "unknownError", (Message)object);
                    }
                    if (Utils.debug.messageEnabled()) {
                        Utils.debug.message("SOAPReceiver.onMessage: got SOAPFaultException");
                    }
                    try {
                        CorrelationHeader correlationHeader;
                        if (object != null && (correlationHeader = message.getCorrelationHeader()) != null) {
                            correlationHeader.setRefToMessageID(((Message)object).getCorrelationHeader().getMessageID());
                        }
                        return message.toSOAPMessage();
                    }
                    catch (Exception exception) {
                        Utils.debug.message("SOAPReceiver.onMessage: ", (Throwable)exception);
                        return this.FormSOAPError("Server", exception, (Message)object);
                    }
                }
                catch (Throwable throwable) {
                    Utils.debug.message("SOAPReceiver.onMessage: ", throwable);
                    return this.FormSOAPError("Server", throwable, (Message)object);
                }
            }
            return this.FormSOAPError("Server", "missingRequestHandler", null);
        }
        return this.FormSOAPError("Server", "missingKey", null);
    }

    private SOAPMessage FormSOAPError(String string, Throwable throwable, Message message) {
        String string2 = throwable.getMessage();
        if (string2 == null || string2.length() == 0) {
            string2 = Utils.bundle.getString("unknownError");
        }
        return this.FormSOAPError(message, string, string2);
    }

    private SOAPMessage FormSOAPError(String string, String string2, Message message) {
        String string3 = Utils.bundle.getString(string2);
        return this.FormSOAPError(message, string, string3);
    }

    private SOAPMessage FormSOAPError(Message message, String string, String string2) {
        String string3 = message == null ? string2 : Utils.bundle.getString("messageID") + "=" + message.getCorrelationHeader().getMessageID() + ". " + string2;
        String[] stringArray = new String[]{string3};
        LogUtil.error(Level.INFO, "WS_Failure", stringArray);
        try {
            SOAPFault sOAPFault = new SOAPFault(new QName("http://schemas.xmlsoap.org/soap/envelope/", string), string2);
            Message message2 = new Message(sOAPFault);
            return message2.toSOAPMessage();
        }
        catch (Exception exception) {
            Utils.debug.error("SOAPReceiver.FormSOAPError: ", (Throwable)exception);
            return null;
        }
    }
}

