/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.liberty.ws.security;

import com.iplanet.am.util.Debug;
import com.iplanet.am.util.Locale;
import com.iplanet.am.util.SystemProperties;
import com.iplanet.am.util.XMLUtils;
import com.iplanet.services.naming.WebtopNaming;
import com.iplanet.services.util.Base64;
import com.iplanet.sso.SSOToken;
import com.sun.identity.liberty.ws.common.wsse.BinarySecurityToken;
import com.sun.identity.liberty.ws.disco.EncryptedResourceID;
import com.sun.identity.liberty.ws.security.SecurityAssertion;
import com.sun.identity.liberty.ws.security.SecurityTokenException;
import com.sun.identity.liberty.ws.security.SecurityTokenManager;
import com.sun.identity.liberty.ws.security.SecurityTokenManagerIF;
import com.sun.identity.liberty.ws.security.SecurityTokenManagerImpl;
import com.sun.identity.liberty.ws.security.SecurityTokenManagerService_Impl;
import com.sun.identity.liberty.ws.security.SessionContext;
import com.sun.identity.saml.assertion.NameIdentifier;
import com.sun.identity.saml.common.SAMLException;
import java.net.URL;
import java.rmi.RemoteException;
import java.security.cert.X509Certificate;
import java.util.Enumeration;
import java.util.ResourceBundle;
import javax.xml.rpc.Stub;

public final class SecurityTokenManagerClient {
    private static String SERVICE_NAME = "securitytokenmanager";
    private static boolean checkedForLocal;
    private static boolean isLocal;
    private boolean useLocal;
    private static SecurityTokenManagerIF remoteStub;
    private SecurityTokenManager securityTokenManager;
    private SSOToken ssoToken;
    private boolean isCertificateSet = false;
    private SecurityTokenManagerIF stub;
    static ResourceBundle bundle;

    public SecurityTokenManagerClient(SSOToken sSOToken) throws SecurityTokenException {
        if (!checkedForLocal) {
            try {
                remoteStub = SecurityTokenManagerClient.getServiceEndPoint(SystemProperties.get((String)"com.iplanet.am.server.protocol"), SystemProperties.get((String)"com.iplanet.am.server.host"), SystemProperties.get((String)"com.iplanet.am.server.port"));
                remoteStub.checkForLocal();
                if (SecurityTokenManagerImpl.isLocal) {
                    isLocal = true;
                    SecurityTokenManager.debug.warning("STMC(): Using local service");
                    this.securityTokenManager = new SecurityTokenManager(sSOToken);
                }
                checkedForLocal = true;
            }
            catch (Exception exception) {
                checkedForLocal = true;
                if (SecurityTokenManager.debug.warningEnabled()) {
                    SecurityTokenManager.debug.warning("SecurityTokenManagerClient()Exception", (Throwable)exception);
                }
                throw new SecurityTokenException(exception.getMessage());
            }
        }
        if (isLocal) {
            this.useLocal = true;
        } else {
            this.stub = remoteStub;
            try {
                this.stub.initialization(sSOToken.getTokenID().toString());
            }
            catch (Exception exception) {
                if (SecurityTokenManager.debug.warningEnabled()) {
                    SecurityTokenManager.debug.warning("SecurityTokenManagerClient()Exception", (Throwable)exception);
                }
                throw new SecurityTokenException(exception.getMessage());
            }
        }
    }

    public SecurityTokenManagerClient(String string, SSOToken sSOToken) throws SecurityTokenException {
        try {
            Stub stub = (Stub)new SecurityTokenManagerService_Impl().getSecurityTokenManagerIFPort();
            stub._setProperty("javax.xml.rpc.service.endpoint.address", (Object)string);
            this.stub = (SecurityTokenManagerIF)stub;
            this.stub.initialization(sSOToken.getTokenID().toString());
            this.useLocal = false;
        }
        catch (Exception exception) {
            if (SecurityTokenManager.debug.warningEnabled()) {
                SecurityTokenManager.debug.warning("STMC() Exception", (Throwable)exception);
            }
            throw new SecurityTokenException(exception.getMessage());
        }
    }

    private static SecurityTokenManagerIF getServiceEndPoint(String string, String string2, String string3) throws Exception {
        URL uRL = WebtopNaming.getServiceURL((String)SERVICE_NAME, (String)string, (String)string2, (String)string3);
        String string4 = uRL.toString();
        if (SecurityTokenManager.debug.messageEnabled()) {
            SecurityTokenManager.debug.message("SecurityTokenManagerClient with URL: " + string4);
        }
        Stub stub = (Stub)new SecurityTokenManagerService_Impl().getSecurityTokenManagerIFPort();
        stub._setProperty("javax.xml.rpc.service.endpoint.address", (Object)string4);
        return (SecurityTokenManagerIF)stub;
    }

    private static SecurityTokenManagerIF getRemoteStub() throws SecurityTokenException {
        SecurityTokenManagerIF securityTokenManagerIF;
        Exception exception;
        boolean bl;
        block8: {
            bl = false;
            exception = null;
            securityTokenManagerIF = null;
            try {
                Enumeration enumeration = WebtopNaming.getPlatformServerList().elements();
                while (enumeration.hasMoreElements() && !bl) {
                    URL uRL = new URL((String)enumeration.nextElement());
                    securityTokenManagerIF = SecurityTokenManagerClient.getServiceEndPoint(uRL.getProtocol(), uRL.getHost(), Integer.toString(uRL.getPort()));
                    try {
                        securityTokenManagerIF.checkForLocal();
                        if (SecurityTokenManager.debug.messageEnabled()) {
                            SecurityTokenManager.debug.message("STMC(): Using the remote URL: " + uRL.toString());
                        }
                        bl = true;
                        if (!SecurityTokenManager.debug.warningEnabled()) continue;
                        SecurityTokenManager.debug.warning("STMC:getRemoteStub: remote server being used: " + uRL.toString());
                    }
                    catch (Exception exception2) {
                        exception = exception2;
                        if (!SecurityTokenManager.debug.warningEnabled()) continue;
                        SecurityTokenManager.debug.warning("STMC:getRemoteStub: server (" + uRL.toString() + ") error: ", (Throwable)exception2);
                    }
                }
            }
            catch (Exception exception3) {
                exception = exception3;
                if (!SecurityTokenManager.debug.warningEnabled()) break block8;
                SecurityTokenManager.debug.warning("STMC:getRemoteStub: generic error: ", (Throwable)exception3);
            }
        }
        if (!bl) {
            if (exception != null) {
                throw new SecurityTokenException(exception.getMessage());
            }
            throw new SecurityTokenException(bundle.getString("serverNotFound"));
        }
        return securityTokenManagerIF;
    }

    public void setCertAlias(String string) throws SecurityTokenException {
        if (this.useLocal) {
            this.securityTokenManager.setCertAlias(string);
        } else {
            try {
                this.stub.setCertificate(string, true);
                this.isCertificateSet = true;
            }
            catch (Exception exception) {
                if (SecurityTokenManager.debug.warningEnabled()) {
                    SecurityTokenManager.debug.warning("STMC:setCertAlias()", (Throwable)exception);
                }
                throw new SecurityTokenException(exception.getMessage());
            }
        }
    }

    public void setCertificate(X509Certificate x509Certificate) throws SecurityTokenException {
        if (this.useLocal) {
            this.securityTokenManager.setCertificate(x509Certificate);
        } else {
            try {
                String string = Base64.encode((byte[])x509Certificate.getEncoded());
                this.stub.setCertificate(string, false);
                this.isCertificateSet = true;
            }
            catch (Exception exception) {
                if (SecurityTokenManager.debug.warningEnabled()) {
                    SecurityTokenManager.debug.warning("STMC:setCertificate()", (Throwable)exception);
                }
                throw new SecurityTokenException(exception.getMessage());
            }
        }
    }

    public BinarySecurityToken getX509CertificateToken() throws SecurityTokenException {
        if (this.useLocal) {
            return this.securityTokenManager.getX509CertificateToken();
        }
        if (!this.isCertificateSet) {
            throw new SecurityTokenException(bundle.getString("nullCertificate"));
        }
        String string = null;
        try {
            string = this.stub.getX509CertificateToken();
            return new BinarySecurityToken(XMLUtils.toDOMDocument((String)string, (Debug)SecurityTokenManager.debug).getDocumentElement());
        }
        catch (Exception exception) {
            if (SecurityTokenManager.debug.warningEnabled()) {
                SecurityTokenManager.debug.warning("STMC:getX509CertificateToken()", (Throwable)exception);
            }
            throw new SecurityTokenException(exception.getMessage());
        }
    }

    public SecurityAssertion getSAMLAuthenticationToken(NameIdentifier nameIdentifier) throws SecurityTokenException, SAMLException {
        if (this.useLocal) {
            return this.securityTokenManager.getSAMLAuthenticationToken(nameIdentifier);
        }
        if (!this.isCertificateSet) {
            throw new SecurityTokenException(bundle.getString("nullCertificate"));
        }
        try {
            String string = nameIdentifier.toString(true, true);
            String string2 = this.stub.getSAMLAuthenticationToken(string);
            return new SecurityAssertion(XMLUtils.toDOMDocument((String)string2, (Debug)SecurityTokenManager.debug).getDocumentElement());
        }
        catch (RemoteException remoteException) {
            if (SecurityTokenManager.debug.warningEnabled()) {
                SecurityTokenManager.debug.warning("STMC:getSAMLAuthenticationToken()", (Throwable)remoteException);
            }
            throw new SAMLException(remoteException.getMessage());
        }
    }

    public SecurityAssertion getSAMLAuthorizationToken(NameIdentifier nameIdentifier, SessionContext sessionContext, String string, boolean bl, boolean bl2) throws SecurityTokenException, SAMLException {
        if (this.useLocal) {
            return this.securityTokenManager.getSAMLAuthorizationToken(nameIdentifier, sessionContext, string, bl, bl2);
        }
        if (!this.isCertificateSet) {
            throw new SecurityTokenException(bundle.getString("nullCertificate"));
        }
        try {
            String string2 = nameIdentifier.toString(true, true);
            String string3 = sessionContext.toXMLString(true, true);
            String string4 = this.stub.getSAMLAuthorizationToken(string2, string3, string, false, bl, bl2);
            return new SecurityAssertion(XMLUtils.toDOMDocument((String)string4, (Debug)SecurityTokenManager.debug).getDocumentElement());
        }
        catch (RemoteException remoteException) {
            if (SecurityTokenManager.debug.warningEnabled()) {
                SecurityTokenManager.debug.warning("STMC:createAssertionArtifact:", (Throwable)remoteException);
            }
            throw new SAMLException(remoteException.getMessage());
        }
        catch (Exception exception) {
            throw new SecurityTokenException(exception.getMessage());
        }
    }

    public SecurityAssertion getSAMLAuthorizationToken(NameIdentifier nameIdentifier, SessionContext sessionContext, EncryptedResourceID encryptedResourceID, boolean bl, boolean bl2) throws SecurityTokenException, SAMLException {
        if (this.useLocal) {
            return this.securityTokenManager.getSAMLAuthorizationToken(nameIdentifier, sessionContext, encryptedResourceID, bl, bl2);
        }
        String string = null;
        if (!this.isCertificateSet) {
            throw new SecurityTokenException(bundle.getString("nullCertificate"));
        }
        try {
            String string2 = nameIdentifier.toString(true, true);
            String string3 = sessionContext.toXMLString(true, true);
            String string4 = encryptedResourceID.toString();
            string = this.stub.getSAMLAuthorizationToken(string2, string3, string4, true, bl, bl2);
            return new SecurityAssertion(XMLUtils.toDOMDocument((String)string, (Debug)SecurityTokenManager.debug).getDocumentElement());
        }
        catch (RemoteException remoteException) {
            if (SecurityTokenManager.debug.warningEnabled()) {
                SecurityTokenManager.debug.warning("STMC:getSAMLAuthorizationToken() ", (Throwable)remoteException);
            }
            throw new SAMLException(remoteException.getMessage());
        }
        catch (Exception exception) {
            throw new SecurityTokenException(exception.getMessage());
        }
    }

    static {
        bundle = Locale.getInstallResourceBundle((String)"amLibertySecurity");
    }
}

