/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.liberty.ws.security;

import com.iplanet.am.util.Debug;
import com.iplanet.am.util.Locale;
import com.iplanet.am.util.SystemProperties;
import com.sun.identity.liberty.ws.common.wsse.BinarySecurityToken;
import com.sun.identity.liberty.ws.disco.EncryptedResourceID;
import com.sun.identity.liberty.ws.security.SecurityAssertion;
import com.sun.identity.liberty.ws.security.SecurityTokenException;
import com.sun.identity.liberty.ws.security.SecurityTokenProvider;
import com.sun.identity.liberty.ws.security.SessionContext;
import com.sun.identity.saml.assertion.NameIdentifier;
import com.sun.identity.saml.common.SAMLException;
import com.sun.identity.saml.xmlsig.XMLSignatureManager;
import java.security.cert.X509Certificate;
import java.util.ResourceBundle;

public final class SecurityTokenManager {
    private static String TOKEN_PROVIDER = "com.sun.identity.liberty.ws.security.TokenProviderImpl";
    private static String providerClass = SystemProperties.get((String)TOKEN_PROVIDER);
    static ResourceBundle bundle = Locale.getInstallResourceBundle((String)"amLibertySecurity");
    static Debug debug = Debug.getInstance((String)"amLibertySecurity");
    private SecurityTokenProvider provider = null;

    private SecurityTokenManager() {
    }

    public SecurityTokenManager(Object object) throws SecurityTokenException {
        if (providerClass == null || providerClass.trim().equals("")) {
            debug.error("Con: Security Token Provider class is not defined");
            throw new SecurityTokenException(bundle.getString("noProvider"));
        }
        try {
            this.provider = (SecurityTokenProvider)Class.forName(providerClass).newInstance();
        }
        catch (Exception exception) {
            debug.message("Con: Unable to get instance of Token Provider", (Throwable)exception);
            throw new SecurityTokenException(bundle.getString("noProviderInstance"));
        }
        XMLSignatureManager xMLSignatureManager = null;
        try {
            xMLSignatureManager = XMLSignatureManager.getInstance();
        }
        catch (Exception exception) {
            debug.message("Con: Unable to get instance of XMLSigManager", (Throwable)exception);
        }
        this.provider.initialize(object, xMLSignatureManager);
    }

    public SecurityTokenManager(Object object, XMLSignatureManager xMLSignatureManager) throws SecurityTokenException {
        if (providerClass == null || providerClass.trim().equals("")) {
            debug.error("Con2: Security Token Provider class is not defined");
            throw new SecurityTokenException(bundle.getString("noProvider"));
        }
        try {
            this.provider = (SecurityTokenProvider)Class.forName(providerClass).newInstance();
        }
        catch (Exception exception) {
            debug.message("Con2: Unable to get instance of Token Provider", (Throwable)exception);
            throw new SecurityTokenException(bundle.getString("noProviderInstance"));
        }
        this.provider.initialize(object, xMLSignatureManager);
    }

    public void setCertAlias(String string) throws SecurityTokenException {
        this.provider.setCertAlias(string);
    }

    public void setCertificate(X509Certificate x509Certificate) throws SecurityTokenException {
        this.provider.setCertificate(x509Certificate);
    }

    public BinarySecurityToken getX509CertificateToken() throws SecurityTokenException {
        return this.provider.getX509CertificateToken();
    }

    public SecurityAssertion getSAMLAuthenticationToken(NameIdentifier nameIdentifier) throws SecurityTokenException, SAMLException {
        return this.provider.getSAMLAuthenticationToken(nameIdentifier);
    }

    public SecurityAssertion getSAMLAuthorizationToken(NameIdentifier nameIdentifier, SessionContext sessionContext, String string, boolean bl, boolean bl2) throws SecurityTokenException, SAMLException {
        return this.provider.getSAMLAuthorizationToken(nameIdentifier, sessionContext, string, bl, bl2);
    }

    public SecurityAssertion getSAMLAuthorizationToken(NameIdentifier nameIdentifier, SessionContext sessionContext, EncryptedResourceID encryptedResourceID, boolean bl, boolean bl2) throws SecurityTokenException {
        return this.provider.getSAMLAuthorizationToken(nameIdentifier, sessionContext, encryptedResourceID, bl, bl2);
    }

    public SecurityAssertion getSAMLBearerToken(NameIdentifier nameIdentifier, SessionContext sessionContext, String string, boolean bl, boolean bl2) throws SecurityTokenException, SAMLException {
        return this.provider.getSAMLBearerToken(nameIdentifier, sessionContext, string, bl, bl2);
    }

    public SecurityAssertion getSAMLBearerToken(NameIdentifier nameIdentifier, SessionContext sessionContext, EncryptedResourceID encryptedResourceID, boolean bl, boolean bl2) throws SecurityTokenException {
        return this.provider.getSAMLBearerToken(nameIdentifier, sessionContext, encryptedResourceID, bl, bl2);
    }
}

