/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.liberty.ws.security;

import com.sun.identity.common.DateUtils;
import com.sun.identity.liberty.ws.security.ResourceAccessStatement;
import com.sun.identity.liberty.ws.security.SessionContextStatement;
import com.sun.identity.saml.assertion.Advice;
import com.sun.identity.saml.assertion.Assertion;
import com.sun.identity.saml.assertion.Conditions;
import com.sun.identity.saml.assertion.Statement;
import com.sun.identity.saml.assertion.Subject;
import com.sun.identity.saml.assertion.SubjectConfirmation;
import com.sun.identity.saml.assertion.SubjectStatement;
import com.sun.identity.saml.common.SAMLConstants;
import com.sun.identity.saml.common.SAMLException;
import com.sun.identity.saml.common.SAMLUtilsCommon;
import com.sun.identity.saml.xmlsig.XMLSignatureManager;
import java.util.Date;
import java.util.Iterator;
import java.util.Set;
import org.w3c.dom.Element;

public class SecurityAssertion
extends Assertion {
    private String verifyingCertAlias = null;

    public SecurityAssertion(Element element) throws SAMLException {
        this.parseAssertionElement(element);
    }

    public SecurityAssertion(String string, String string2, Date date, Set set) throws SAMLException {
        super(string, string2, date, set);
    }

    public SecurityAssertion(String string, String string2, Date date, Conditions conditions, Set set) throws SAMLException {
        super(string, string2, date, conditions, set);
    }

    public SecurityAssertion(String string, String string2, Date date, Conditions conditions, Advice advice, Set set) throws SAMLException {
        super(string, string2, date, conditions, advice, set);
    }

    public void setVerifyingCertAlias(String string) {
        this.verifyingCertAlias = string;
    }

    public boolean isSignatureValid() {
        if (this.signed & !this.validationDone) {
            try {
                XMLSignatureManager xMLSignatureManager = XMLSignatureManager.getInstance();
                this.valid = xMLSignatureManager.verifyXMLSignature(this.xmlString, "AssertionID", this.verifyingCertAlias);
            }
            catch (Exception exception) {
                if (SAMLUtilsCommon.debug.warningEnabled()) {
                    SAMLUtilsCommon.debug.warning("SecurityAssertion.isSignatureValid:  signature validation exception", (Throwable)exception);
                }
                this.valid = false;
            }
            if (SAMLUtilsCommon.debug.messageEnabled()) {
                SAMLUtilsCommon.debug.message("SAMLUtils.checkSignatureValid: valid = " + this.valid);
            }
            this.validationDone = true;
        }
        return this.valid;
    }

    public boolean isBearer() {
        if (this._statements == null || this._statements.isEmpty()) {
            return false;
        }
        Iterator iterator = this._statements.iterator();
        while (iterator.hasNext()) {
            Set set;
            SubjectConfirmation subjectConfirmation;
            Subject subject;
            Object e = iterator.next();
            if (!(e instanceof SubjectStatement) || (subject = ((SubjectStatement)e).getSubject()) == null || (subjectConfirmation = subject.getSubjectConfirmation()) == null || (set = subjectConfirmation.getConfirmationMethod()) == null || set.isEmpty() || !set.contains("urn:oasis:names:tc:SAML:1.0:cm:bearer")) continue;
            return true;
        }
        return false;
    }

    public Subject getBearerSubject() {
        if (this._statements == null || this._statements.isEmpty()) {
            return null;
        }
        Iterator iterator = this._statements.iterator();
        while (iterator.hasNext()) {
            Set set;
            SubjectConfirmation subjectConfirmation;
            Subject subject;
            Object e = iterator.next();
            if (!(e instanceof SubjectStatement) || (subject = ((SubjectStatement)e).getSubject()) == null || (subjectConfirmation = subject.getSubjectConfirmation()) == null || (set = subjectConfirmation.getConfirmationMethod()) == null || set.isEmpty() || !set.contains("urn:oasis:names:tc:SAML:1.0:cm:bearer")) continue;
            return subject;
        }
        return null;
    }

    public String toString() {
        String string = this.toString(true, false);
        return string;
    }

    public String toString(boolean bl, boolean bl2) {
        Object object;
        if (this.signed && this.xmlString != null) {
            return this.xmlString;
        }
        StringBuffer stringBuffer = new StringBuffer(3000);
        String string = "";
        String string2 = "";
        if (bl2) {
            string = " xmlns:saml=\"urn:oasis:names:tc:SAML:1.0:assertion\"";
        }
        if (bl) {
            string2 = "saml:";
        }
        String string3 = null;
        if (this._issueInstant != null) {
            string3 = DateUtils.toUTCDateFormat((Date)this._issueInstant);
        }
        stringBuffer.append("<").append(string2).append("Assertion").append(" ").append(string).append(" ").append("MajorVersion").append("=\"").append(this._majorVersion).append("\"").append(" ").append("MinorVersion").append("=\"").append(this._minorVersion).append("\"").append(" ").append("AssertionID=\"").append(this._assertionID.getAssertionIDReference()).append("\"").append(" ").append("Issuer").append("=\"").append(this._issuer).append("\"").append(" ").append("IssueInstant").append("=\"").append(string3).append("\"").append(" ").append(">").append("\n");
        if (this._conditions != null) {
            stringBuffer.append(this._conditions.toString(bl, false));
        }
        if (this._advice != null) {
            stringBuffer.append(this._advice.toString(bl, false));
        }
        Iterator iterator = this.getStatement().iterator();
        while (iterator.hasNext()) {
            object = (Statement)iterator.next();
            stringBuffer.append(((Statement)object).toString(bl, bl2));
        }
        if (this.signed && this.signatureString != null) {
            stringBuffer.append(this.signatureString);
        }
        object = SAMLUtilsCommon.makeEndElementTagXML("Assertion", bl);
        stringBuffer.append((String)object);
        return stringBuffer.toString();
    }

    protected boolean processUnknownElement(Element element) throws SAMLException {
        String string;
        if (super.processUnknownElement(element)) {
            if (SAMLUtilsCommon.debug.messageEnabled()) {
                SAMLUtilsCommon.debug.message("SecurityAssertion.processUnknownElement: super returns true");
            }
            return true;
        }
        if (SAMLUtilsCommon.debug.messageEnabled()) {
            SAMLUtilsCommon.debug.message("SecurityAssertion.processUnknownElement: super returns false");
        }
        if ((string = element.getLocalName()).equals("ResourceAccessStatement")) {
            this._statements.add(new ResourceAccessStatement(element));
            return true;
        }
        if (string.equals("SessionContextStatement")) {
            this._statements.add(new SessionContextStatement(element));
            return true;
        }
        return false;
    }

    protected int getMinAssertionMinorVersion() {
        return SAMLConstants.ASSERTION_MINOR_VERSION;
    }

    protected int getMaxAssertionMinorVersion() {
        return SAMLConstants.ASSERTION_MINOR_VERSION;
    }
}

