/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.liberty.ws.security;

import com.sun.identity.liberty.ws.disco.EncryptedResourceID;
import com.sun.identity.liberty.ws.disco.ResourceID;
import com.sun.identity.liberty.ws.security.ProxySubject;
import com.sun.identity.liberty.ws.security.SessionContext;
import com.sun.identity.saml.assertion.Subject;
import com.sun.identity.saml.assertion.SubjectStatement;
import com.sun.identity.saml.common.SAMLException;
import com.sun.identity.saml.common.SAMLRequesterException;
import com.sun.identity.saml.common.SAMLUtilsCommon;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class ResourceAccessStatement
extends SubjectStatement {
    public static final int RESOURCEACCESS_STATEMENT = 4;
    private ResourceID _resourceID = null;
    private EncryptedResourceID _encryptedResourceID = null;
    protected ProxySubject _proxySubject = null;
    protected SessionContext _sessionContext = null;

    public ResourceAccessStatement(Element element) throws SAMLException {
        if (element == null) {
            SAMLUtilsCommon.debug.message("ResourceAccessStatement: null input.");
            throw new SAMLRequesterException(SAMLUtilsCommon.bundle.getString("nullInput"));
        }
        boolean bl = SAMLUtilsCommon.checkStatement(element, "ResourceAccessStatement");
        if (!bl) {
            SAMLUtilsCommon.debug.message("ResourceAccessStatement: Wrong input.");
            throw new SAMLRequesterException(SAMLUtilsCommon.bundle.getString("wrongInput"));
        }
        NodeList nodeList = element.getChildNodes();
        int n = nodeList.getLength();
        if (n > 0) {
            int n2 = 0;
            while (n2 < n) {
                Node node = nodeList.item(n2);
                if (node.getNodeType() == 1) {
                    String string = node.getLocalName();
                    String string2 = node.getNamespaceURI();
                    if (string == null || string.equals("") || string2 == null || string2.equals("")) {
                        if (SAMLUtilsCommon.debug.messageEnabled()) {
                            SAMLUtilsCommon.debug.message("ResourceAccessStatement: The tag name or tag namespace of child element is either null or empty.");
                        }
                        throw new SAMLRequesterException(SAMLUtilsCommon.bundle.getString("nullInput"));
                    }
                    if (string.equals("Subject") && string2.equals("urn:oasis:names:tc:SAML:1.0:assertion")) {
                        if (this._subject != null) {
                            if (SAMLUtilsCommon.debug.messageEnabled()) {
                                SAMLUtilsCommon.debug.message("ResourceAccessStatement:should only contain one subject");
                            }
                            throw new SAMLRequesterException(SAMLUtilsCommon.bundle.getString("oneElement"));
                        }
                        this._subject = new Subject((Element)node);
                    } else if (string.equals("ResourceID") && string2.equals("urn:liberty:disco:2003-08")) {
                        if (this._resourceID != null || this._encryptedResourceID != null) {
                            if (SAMLUtilsCommon.debug.messageEnabled()) {
                                SAMLUtilsCommon.debug.message("ResourceAccessStatement: should at most contain one ResourceIDGroup.");
                            }
                            throw new SAMLRequesterException(SAMLUtilsCommon.bundle.getString("oneElement"));
                        }
                        try {
                            this._resourceID = new ResourceID((Element)node);
                        }
                        catch (Exception exception) {
                            throw new SAMLRequesterException(exception.getMessage());
                        }
                    } else if (string.equals("EncryptedResourceID") && string2.equals("urn:liberty:disco:2003-08")) {
                        if (this._resourceID != null || this._encryptedResourceID != null) {
                            if (SAMLUtilsCommon.debug.messageEnabled()) {
                                SAMLUtilsCommon.debug.message("ResourceAccessStatement: should at most contain one ResourceIDGroup.");
                            }
                            throw new SAMLRequesterException(SAMLUtilsCommon.bundle.getString("oneElement"));
                        }
                        try {
                            this._encryptedResourceID = new EncryptedResourceID((Element)node);
                        }
                        catch (Exception exception) {
                            throw new SAMLRequesterException(exception.getMessage());
                        }
                    } else if (string.equals("ProxySubject") && string2.equals("urn:liberty:sec:2003-08")) {
                        if (this._proxySubject != null) {
                            if (SAMLUtilsCommon.debug.messageEnabled()) {
                                SAMLUtilsCommon.debug.message("ResourceAccessStatement: should at most contain one ProxySubject.");
                            }
                            throw new SAMLRequesterException(SAMLUtilsCommon.bundle.getString("oneElement"));
                        }
                        this._proxySubject = new ProxySubject((Element)node);
                    } else if (string.equals("SessionContext") && string2.equals("urn:liberty:sec:2003-08")) {
                        if (this._sessionContext != null) {
                            if (SAMLUtilsCommon.debug.messageEnabled()) {
                                SAMLUtilsCommon.debug.message("ResourceAccessStatement: should at most contain one SessionContext.");
                            }
                            throw new SAMLRequesterException(SAMLUtilsCommon.bundle.getString("oneElement"));
                        }
                        this._sessionContext = new SessionContext((Element)node);
                    } else {
                        if (SAMLUtilsCommon.debug.messageEnabled()) {
                            SAMLUtilsCommon.debug.message("ResourceAccessStatement:Wrong element " + string + "included.");
                        }
                        throw new SAMLRequesterException(SAMLUtilsCommon.bundle.getString("wrongInput"));
                    }
                }
                ++n2;
            }
        }
        if (this._subject == null) {
            if (SAMLUtilsCommon.debug.messageEnabled()) {
                SAMLUtilsCommon.debug.message("ResourceAccessStatement should contain one subject.");
            }
            throw new SAMLRequesterException(SAMLUtilsCommon.bundle.getString("missingElement"));
        }
    }

    public ResourceAccessStatement(String string, Subject subject) throws SAMLException {
        if (subject == null) {
            if (SAMLUtilsCommon.debug.messageEnabled()) {
                SAMLUtilsCommon.debug.message("ResourceAccessStatement: should contain one subject.");
            }
            throw new SAMLRequesterException(SAMLUtilsCommon.bundle.getString("oneElement"));
        }
        this._subject = subject;
        this._resourceID = new ResourceID(string);
    }

    public ResourceAccessStatement(String string, ProxySubject proxySubject, Subject subject) throws SAMLException {
        if (subject == null) {
            if (SAMLUtilsCommon.debug.messageEnabled()) {
                SAMLUtilsCommon.debug.message("ResourceAccessStatement: should contain one subject.");
            }
            throw new SAMLRequesterException(SAMLUtilsCommon.bundle.getString("oneElement"));
        }
        this._subject = subject;
        this._resourceID = new ResourceID(string);
        this._proxySubject = proxySubject;
    }

    public ResourceAccessStatement(String string, ProxySubject proxySubject, SessionContext sessionContext, Subject subject) throws SAMLException {
        if (subject == null) {
            if (SAMLUtilsCommon.debug.messageEnabled()) {
                SAMLUtilsCommon.debug.message("ResourceAccessStatement: should contain one subject.");
            }
            throw new SAMLRequesterException(SAMLUtilsCommon.bundle.getString("oneElement"));
        }
        this._subject = subject;
        this._resourceID = new ResourceID(string);
        this._proxySubject = proxySubject;
        this._sessionContext = sessionContext;
    }

    public ResourceAccessStatement(ResourceID resourceID, ProxySubject proxySubject, SessionContext sessionContext, Subject subject) throws SAMLException {
        if (subject == null) {
            if (SAMLUtilsCommon.debug.messageEnabled()) {
                SAMLUtilsCommon.debug.message("ResourceAccessStatement: should contain one subject.");
            }
            throw new SAMLRequesterException(SAMLUtilsCommon.bundle.getString("oneElement"));
        }
        this._subject = subject;
        this._resourceID = resourceID;
        this._proxySubject = proxySubject;
        this._sessionContext = sessionContext;
    }

    public ResourceAccessStatement(EncryptedResourceID encryptedResourceID, ProxySubject proxySubject, SessionContext sessionContext, Subject subject) throws SAMLException {
        if (subject == null) {
            if (SAMLUtilsCommon.debug.messageEnabled()) {
                SAMLUtilsCommon.debug.message("ResourceAccessStatement: should contain one subject.");
            }
            throw new SAMLRequesterException(SAMLUtilsCommon.bundle.getString("oneElement"));
        }
        this._subject = subject;
        this._encryptedResourceID = encryptedResourceID;
        this._proxySubject = proxySubject;
        this._sessionContext = sessionContext;
    }

    public String getResourceID() {
        return this._resourceID == null ? null : this._resourceID.getResourceID();
    }

    public ResourceID getResourceIDObject() {
        return this._resourceID;
    }

    public EncryptedResourceID getEncryptedResourceID() {
        return this._encryptedResourceID;
    }

    public boolean setResourceID(String string) {
        if (string == null) {
            if (SAMLUtilsCommon.debug.messageEnabled()) {
                SAMLUtilsCommon.debug.message("ResourceAccessStatement: setResourceID:Input is null.");
            }
            return false;
        }
        this._resourceID = new ResourceID(string);
        return true;
    }

    public void setResourceID(ResourceID resourceID) {
        this._resourceID = resourceID;
    }

    public void setEncryptedResourceID(EncryptedResourceID encryptedResourceID) {
        this._encryptedResourceID = encryptedResourceID;
    }

    public int getStatementType() {
        return 4;
    }

    public boolean setSessionContext(SessionContext sessionContext) {
        if (sessionContext == null) {
            if (SAMLUtilsCommon.debug.messageEnabled()) {
                SAMLUtilsCommon.debug.message("ResourceAccessStatement: setSessionContext: Input is null.");
            }
            return false;
        }
        this._sessionContext = sessionContext;
        return true;
    }

    public SessionContext getSessionContext() {
        return this._sessionContext;
    }

    public String toString() {
        return this.toString(true, false);
    }

    public String toString(boolean bl, boolean bl2) {
        StringBuffer stringBuffer = new StringBuffer(1000);
        stringBuffer.append("<").append("sec:").append("ResourceAccessStatement").append(" ").append("xmlns:sec").append("=").append("\"").append("urn:liberty:sec:2003-08").append("\"");
        stringBuffer.append(">\n").append(this._subject.toString(bl, true));
        if (this._resourceID != null) {
            stringBuffer.append(this._resourceID);
        } else if (this._encryptedResourceID != null) {
            stringBuffer.append(this._encryptedResourceID);
        }
        if (this._proxySubject != null) {
            stringBuffer.append(this._proxySubject.toString(bl, true));
            if (this._sessionContext != null) {
                try {
                    stringBuffer.append(this._sessionContext.toXMLString(bl, true));
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
        stringBuffer.append("</").append("sec:").append("ResourceAccessStatement").append(">\n");
        return stringBuffer.toString();
    }
}

