/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.liberty.ws.security;

import com.iplanet.am.util.SystemProperties;
import com.iplanet.am.util.XMLUtils;
import com.iplanet.services.util.Base64;
import com.iplanet.sso.SSOException;
import com.iplanet.sso.SSOToken;
import com.iplanet.sso.SSOTokenManager;
import com.sun.identity.common.DateUtils;
import com.sun.identity.liberty.ws.common.wsse.BinarySecurityToken;
import com.sun.identity.liberty.ws.disco.EncryptedResourceID;
import com.sun.identity.liberty.ws.disco.common.DiscoServiceManager;
import com.sun.identity.liberty.ws.security.ProxySubject;
import com.sun.identity.liberty.ws.security.ResourceAccessStatement;
import com.sun.identity.liberty.ws.security.SecurityAssertion;
import com.sun.identity.liberty.ws.security.SecurityTokenException;
import com.sun.identity.liberty.ws.security.SecurityTokenManager;
import com.sun.identity.liberty.ws.security.SecurityTokenProvider;
import com.sun.identity.liberty.ws.security.SessionContext;
import com.sun.identity.liberty.ws.security.SessionContextStatement;
import com.sun.identity.saml.assertion.AuthenticationStatement;
import com.sun.identity.saml.assertion.NameIdentifier;
import com.sun.identity.saml.assertion.Subject;
import com.sun.identity.saml.assertion.SubjectConfirmation;
import com.sun.identity.saml.common.SAMLException;
import com.sun.identity.saml.common.SAMLServiceManager;
import com.sun.identity.saml.xmlsig.KeyProvider;
import com.sun.identity.saml.xmlsig.XMLSignatureManager;
import java.math.BigInteger;
import java.security.PublicKey;
import java.security.cert.X509Certificate;
import java.security.interfaces.DSAParams;
import java.security.interfaces.DSAPublicKey;
import java.security.interfaces.RSAPublicKey;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Text;

public class AMSecurityTokenProvider
implements SecurityTokenProvider {
    private XMLSignatureManager sigManager = null;
    private KeyProvider keystore = null;
    private SSOToken ssoToken = null;
    private String certAlias = null;
    private X509Certificate wssCert = null;
    private static String DEFAULT_CERT_ALIAS_KEY = "com.sun.identity.liberty.ws.wsc.certalias";
    private static String DEFAULT_CERT_ALIAS_VALUE = SystemProperties.get((String)DEFAULT_CERT_ALIAS_KEY);
    private static String DEFAULT_TA_CERT_ALIAS_KEY = "com.sun.identity.liberty.ws.ta.certalias";
    private static String DEFAULT_TA_CERT_ALIAS_VALUE = SystemProperties.get((String)DEFAULT_TA_CERT_ALIAS_KEY);
    private static String KEYINFO_TYPE = "com.sun.identity.liberty.ws.security.keyinfotype";
    private static String keyInfoType = SystemProperties.get((String)KEYINFO_TYPE);
    protected String authTime = "";
    protected String authType = "";

    public void initialize(Object object, XMLSignatureManager xMLSignatureManager) throws SecurityTokenException {
        if (xMLSignatureManager == null) {
            SecurityTokenManager.debug.error("AMP: nulll signature manager");
            throw new SecurityTokenException(SecurityTokenManager.bundle.getString("nullXMLSigManager"));
        }
        this.keystore = xMLSignatureManager.getKeyProvider();
        try {
            this.ssoToken = (SSOToken)object;
            SSOTokenManager.getInstance().validateToken(this.ssoToken);
            this.authType = this.ssoToken.getAuthType();
            this.authTime = this.ssoToken.getProperty("authInstant");
        }
        catch (SSOException sSOException) {
            SecurityTokenManager.debug.error("AMP: invalid SSO Token", (Throwable)sSOException);
            throw new SecurityTokenException(sSOException.getMessage());
        }
        this.sigManager = xMLSignatureManager;
    }

    public void setCertAlias(String string) throws SecurityTokenException {
        if (SecurityTokenManager.debug.messageEnabled()) {
            SecurityTokenManager.debug.message("AMP : certalias=" + string);
        }
        this.certAlias = string;
        this.wssCert = this.getX509Certificate();
    }

    public void setCertificate(X509Certificate x509Certificate) throws SecurityTokenException {
        this.certAlias = this.keystore.getCertificateAlias(x509Certificate);
        if (SecurityTokenManager.debug.messageEnabled()) {
            SecurityTokenManager.debug.message("AMP : certalias=" + this.certAlias);
        }
        if (this.certAlias == null) {
            SecurityTokenManager.debug.error("AMP: no cert found");
            throw new SecurityTokenException(SecurityTokenManager.bundle.getString("noCertAlias"));
        }
        this.wssCert = x509Certificate;
    }

    private X509Certificate getX509Certificate() throws SecurityTokenException {
        X509Certificate x509Certificate;
        if (this.certAlias == null) {
            if (DEFAULT_CERT_ALIAS_VALUE == null || DEFAULT_CERT_ALIAS_VALUE.trim().equals("")) {
                SecurityTokenManager.debug.error("AMP: no cert found");
                throw new SecurityTokenException(SecurityTokenManager.bundle.getString("noCertAlias"));
            }
            this.certAlias = DEFAULT_CERT_ALIAS_VALUE;
        }
        if ((x509Certificate = this.keystore.getX509Certificate(this.certAlias)) == null) {
            SecurityTokenManager.debug.error("AMP : no cert found in store");
            throw new SecurityTokenException(SecurityTokenManager.bundle.getString("noMatchingCert"));
        }
        return x509Certificate;
    }

    public BinarySecurityToken getX509CertificateToken() throws SecurityTokenException {
        if (this.wssCert == null) {
            this.wssCert = this.getX509Certificate();
        }
        String string = null;
        try {
            string = Base64.encode((byte[])this.wssCert.getEncoded());
            return new BinarySecurityToken(string, BinarySecurityToken.X509V3, BinarySecurityToken.BASE64BINARY);
        }
        catch (Exception exception) {
            SecurityTokenManager.debug.error("getX509Token", (Throwable)exception);
            throw new SecurityTokenException(exception.getMessage());
        }
    }

    public SecurityAssertion getSAMLAuthenticationToken(NameIdentifier nameIdentifier) throws SecurityTokenException {
        return this.getSAMLToken(nameIdentifier, null, null, true, false, false);
    }

    public SecurityAssertion getSAMLAuthorizationToken(NameIdentifier nameIdentifier, SessionContext sessionContext, String string, boolean bl, boolean bl2) throws SecurityTokenException {
        return this.getSAMLToken(nameIdentifier, sessionContext, string, bl, bl2, false);
    }

    public SecurityAssertion getSAMLAuthorizationToken(NameIdentifier nameIdentifier, SessionContext sessionContext, EncryptedResourceID encryptedResourceID, boolean bl, boolean bl2) throws SecurityTokenException {
        return this.getSAMLToken(nameIdentifier, sessionContext, encryptedResourceID, bl, bl2, false);
    }

    public SecurityAssertion getSAMLBearerToken(NameIdentifier nameIdentifier, SessionContext sessionContext, String string, boolean bl, boolean bl2) throws SecurityTokenException {
        return this.getSAMLToken(nameIdentifier, sessionContext, string, bl, bl2, true);
    }

    public SecurityAssertion getSAMLBearerToken(NameIdentifier nameIdentifier, SessionContext sessionContext, EncryptedResourceID encryptedResourceID, boolean bl, boolean bl2) throws SecurityTokenException {
        return this.getSAMLToken(nameIdentifier, sessionContext, encryptedResourceID, bl, bl2, true);
    }

    private SecurityAssertion getSAMLToken(NameIdentifier nameIdentifier, SessionContext sessionContext, Object object, boolean bl, boolean bl2, boolean bl3) throws SecurityTokenException {
        Object object2;
        if (SecurityTokenManager.debug.messageEnabled()) {
            SecurityTokenManager.debug.message("getSAMLToken: isBear = " + bl3);
        }
        if (nameIdentifier == null) {
            SecurityTokenManager.debug.error("AMSecurityTokenProvider.getSAMLToken:senderIdentity is null");
            throw new SecurityTokenException(SecurityTokenManager.bundle.getString("nullSenderIdentity"));
        }
        boolean bl4 = true;
        SecurityAssertion securityAssertion = null;
        HashSet<Object> hashSet = new HashSet<Object>();
        if (bl) {
            object2 = this.createAuthenticationStatement(nameIdentifier, bl3);
            hashSet.add(object2);
            bl4 = false;
        }
        if (bl2) {
            object2 = this.createResourceAccessStatement(nameIdentifier, sessionContext, object, bl3);
            hashSet.add(object2);
            bl4 = false;
        } else if (sessionContext != null) {
            object2 = this.createSessionContextStatement(nameIdentifier, sessionContext, bl3);
            hashSet.add(object2);
            bl4 = false;
        }
        if (bl4) {
            SecurityTokenManager.debug.error("getSAMLAuthorizationToken: SAML statement should not be null.");
            throw new SecurityTokenException(SecurityTokenManager.bundle.getString("nullStatement"));
        }
        object2 = new Date();
        String string = DiscoServiceManager.getDiscoProviderID();
        try {
            securityAssertion = new SecurityAssertion("", string, (Date)object2, hashSet);
            securityAssertion.signXML(DEFAULT_TA_CERT_ALIAS_VALUE);
        }
        catch (Exception exception) {
            throw new SecurityTokenException(SecurityTokenManager.bundle.getString("nullAssertion"));
        }
        return securityAssertion;
    }

    private AuthenticationStatement createAuthenticationStatement(NameIdentifier nameIdentifier, boolean bl) throws SecurityTokenException {
        AuthenticationStatement authenticationStatement = null;
        try {
            String string = SAMLServiceManager.getAuthMethodURI(this.authType);
            Date date = DateUtils.stringToDate((String)this.authTime);
            Subject subject = null;
            SubjectConfirmation subjectConfirmation = null;
            if (bl) {
                subjectConfirmation = new SubjectConfirmation("urn:oasis:names:tc:SAML:1.0:cm:bearer");
            } else {
                subjectConfirmation = new SubjectConfirmation("urn:oasis:names:tc:SAML:1.0:cm:holder-of-key");
                subjectConfirmation.setKeyInfo(this.createKeyInfo());
            }
            subject = new Subject(nameIdentifier, subjectConfirmation);
            authenticationStatement = new AuthenticationStatement(string, date, subject);
        }
        catch (Exception exception) {
            SecurityTokenManager.debug.error("createAuthenticationStatement: ", (Throwable)exception);
            throw new SecurityTokenException(exception.getMessage());
        }
        return authenticationStatement;
    }

    private ResourceAccessStatement createResourceAccessStatement(NameIdentifier nameIdentifier, SessionContext sessionContext, Object object, boolean bl) throws SecurityTokenException {
        if (SecurityTokenManager.debug.messageEnabled()) {
            SecurityTokenManager.debug.message("AMSecurityTokenProvider.createResourceAccessStatement: resourceID class = " + object.getClass() + ", value = " + object);
        }
        ResourceAccessStatement resourceAccessStatement = null;
        try {
            ProxySubject proxySubject = null;
            Subject subject = null;
            List list = this.createSubjectAndProxySubject(nameIdentifier, sessionContext, bl);
            subject = (Subject)list.get(0);
            if (list.size() == 2) {
                proxySubject = (ProxySubject)list.get(1);
            }
            resourceAccessStatement = object instanceof String ? new ResourceAccessStatement((String)object, proxySubject, sessionContext, subject) : new ResourceAccessStatement((EncryptedResourceID)object, proxySubject, sessionContext, subject);
            if (SecurityTokenManager.debug.messageEnabled()) {
                SecurityTokenManager.debug.message("AMSecurityTokenProvider.createResourceAccessStatement: ras = " + resourceAccessStatement);
            }
        }
        catch (Exception exception) {
            SecurityTokenManager.debug.error("createResourceAccessStatement: ", (Throwable)exception);
            throw new SecurityTokenException(exception.getMessage());
        }
        return resourceAccessStatement;
    }

    private List createSubjectAndProxySubject(NameIdentifier nameIdentifier, SessionContext sessionContext, boolean bl) throws Exception {
        ArrayList<Subject> arrayList = new ArrayList<Subject>();
        Subject subject = null;
        SubjectConfirmation subjectConfirmation = null;
        ProxySubject proxySubject = null;
        NameIdentifier nameIdentifier2 = null;
        if (sessionContext != null && !(nameIdentifier2 = sessionContext.getSessionSubject().getNameIdentifier()).equals(nameIdentifier)) {
            subjectConfirmation = new SubjectConfirmation("urn:oasis:names:tc:SAML:1.0:cm:sendervouches");
            subject = new Subject(nameIdentifier2, subjectConfirmation);
            proxySubject = this.createProxySubject(nameIdentifier, bl);
            arrayList.add(subject);
            arrayList.add(proxySubject);
        } else {
            if (bl) {
                subjectConfirmation = new SubjectConfirmation("urn:oasis:names:tc:SAML:1.0:cm:bearer");
            } else {
                subjectConfirmation = new SubjectConfirmation("urn:oasis:names:tc:SAML:1.0:cm:holder-of-key");
                subjectConfirmation.setKeyInfo(this.createKeyInfo());
            }
            subject = new Subject(nameIdentifier, subjectConfirmation);
            arrayList.add(subject);
        }
        return arrayList;
    }

    private SessionContextStatement createSessionContextStatement(NameIdentifier nameIdentifier, SessionContext sessionContext, boolean bl) throws SecurityTokenException {
        try {
            ProxySubject proxySubject = null;
            Subject subject = null;
            List list = this.createSubjectAndProxySubject(nameIdentifier, sessionContext, bl);
            subject = (Subject)list.get(0);
            if (list.size() == 2) {
                proxySubject = (ProxySubject)list.get(1);
            }
            return new SessionContextStatement(sessionContext, proxySubject, subject);
        }
        catch (Exception exception) {
            SecurityTokenManager.debug.error("createSessionContextStatement: ", (Throwable)exception);
            throw new SecurityTokenException(exception.getMessage());
        }
    }

    private ProxySubject createProxySubject(NameIdentifier nameIdentifier, boolean bl) throws SecurityTokenException, SAMLException {
        SubjectConfirmation subjectConfirmation = null;
        if (bl) {
            subjectConfirmation = new SubjectConfirmation("urn:oasis:names:tc:SAML:1.0:cm:bearer");
        } else {
            subjectConfirmation = new SubjectConfirmation("urn:oasis:names:tc:SAML:1.0:cm:holder-of-key");
            subjectConfirmation.setKeyInfo(this.createKeyInfo());
        }
        return new ProxySubject(nameIdentifier, subjectConfirmation);
    }

    private Element createKeyInfo() throws SecurityTokenException {
        X509Certificate x509Certificate = this.getX509Certificate();
        Document document = null;
        try {
            document = XMLUtils.newDocument();
        }
        catch (Exception exception) {
            SecurityTokenManager.debug.error("createKeyInfo: ", (Throwable)exception);
            throw new SecurityTokenException(exception.getMessage());
        }
        String string = null;
        String string2 = null;
        PublicKey publicKey = null;
        try {
            publicKey = x509Certificate.getPublicKey();
            string = x509Certificate.getSubjectDN().getName();
            string2 = Base64.encode((byte[])x509Certificate.getEncoded());
        }
        catch (Exception exception) {
            SecurityTokenManager.debug.error("createKeyInfo: ", (Throwable)exception);
            throw new SecurityTokenException(exception.getMessage());
        }
        Element element = document.createElementNS("http://www.w3.org/2000/09/xmldsig#", "KeyInfo");
        element.setAttribute("xmlns", "http://www.w3.org/2000/09/xmldsig#");
        if (keyInfoType != null && keyInfoType.equalsIgnoreCase("certificate")) {
            Element element2 = document.createElementNS("http://www.w3.org/2000/09/xmldsig#", "X509Data");
            Element element3 = document.createElementNS("http://www.w3.org/2000/09/xmldsig#", "X509Certificate");
            Text text = document.createTextNode(string2);
            element3.appendChild(text);
            element.appendChild(element2).appendChild(element3);
        } else {
            Element element4 = document.createElementNS("http://www.w3.org/2000/09/xmldsig#", "KeyName");
            Text text = document.createTextNode(string);
            Element element5 = document.createElementNS("http://www.w3.org/2000/09/xmldsig#", "KeyValue");
            if (publicKey.getAlgorithm().equals("DSA")) {
                DSAPublicKey dSAPublicKey = (DSAPublicKey)publicKey;
                DSAParams dSAParams = dSAPublicKey.getParams();
                BigInteger bigInteger = dSAParams.getP();
                BigInteger bigInteger2 = dSAParams.getQ();
                BigInteger bigInteger3 = dSAParams.getG();
                BigInteger bigInteger4 = dSAPublicKey.getY();
                Element element6 = document.createElementNS("http://www.w3.org/2000/09/xmldsig#", "DSAKeyValue");
                Element element7 = document.createElementNS("http://www.w3.org/2000/09/xmldsig#", "P");
                Text text2 = document.createTextNode(Base64.encode((byte[])bigInteger.toByteArray()));
                element7.appendChild(text2);
                element6.appendChild(element7);
                Element element8 = document.createElementNS("http://www.w3.org/2000/09/xmldsig#", "Q");
                Text text3 = document.createTextNode(Base64.encode((byte[])bigInteger2.toByteArray()));
                element8.appendChild(text3);
                element6.appendChild(element8);
                Element element9 = document.createElementNS("http://www.w3.org/2000/09/xmldsig#", "G");
                Text text4 = document.createTextNode(Base64.encode((byte[])bigInteger3.toByteArray()));
                element9.appendChild(text4);
                element6.appendChild(element9);
                Element element10 = document.createElementNS("http://www.w3.org/2000/09/xmldsig#", "Y");
                Text text5 = document.createTextNode(Base64.encode((byte[])bigInteger4.toByteArray()));
                element10.appendChild(text5);
                element6.appendChild(element10);
                element5.appendChild(element6);
            } else {
                RSAPublicKey rSAPublicKey = (RSAPublicKey)publicKey;
                BigInteger bigInteger = rSAPublicKey.getPublicExponent();
                BigInteger bigInteger5 = rSAPublicKey.getModulus();
                Element element11 = document.createElementNS("http://www.w3.org/2000/09/xmldsig#", "RSAKeyValue");
                Element element12 = document.createElementNS("http://www.w3.org/2000/09/xmldsig#", "Modulus");
                Element element13 = document.createElementNS("http://www.w3.org/2000/09/xmldsig#", "Exponent");
                element11.appendChild(element12);
                element11.appendChild(element13);
                Text text6 = document.createTextNode(Base64.encode((byte[])bigInteger5.toByteArray()));
                element12.appendChild(text6);
                Text text7 = document.createTextNode(Base64.encode((byte[])bigInteger.toByteArray()));
                element13.appendChild(text7);
                element5.appendChild(element11);
            }
            element.appendChild(element4).appendChild(text);
            element.appendChild(element5);
        }
        return element;
    }
}

