/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.liberty.ws.paos;

import com.iplanet.am.util.Debug;
import com.sun.identity.liberty.ws.idpp.common.IDPPUtils;
import com.sun.identity.liberty.ws.idpp.jaxb.QueryElement;
import com.sun.identity.liberty.ws.paos.PAOSException;
import com.sun.identity.liberty.ws.paos.jaxb.ObjectFactory;
import com.sun.identity.liberty.ws.paos.jaxb.RequestElement;
import com.sun.identity.liberty.ws.soapbinding.Message;
import com.sun.identity.liberty.ws.soapbinding.ProviderHeader;
import com.sun.identity.liberty.ws.soapbinding.SOAPBindingException;
import com.sun.identity.liberty.ws.soapbinding.Utils;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletResponse;
import javax.xml.bind.JAXBException;

public class PAOSRequest {
    static final String ACTOR = "http://schemas.xmlsoap.org/soap/actor/next";
    static final String PAOS_CONTENT_TYPE = "application/vnd.paos+xml";
    static final String RESOURCE_ID = "urn:liberty:isf:implied-resource";
    static Hashtable reqTable = new Hashtable();
    static Debug debug = null;
    private String origURL = null;
    private String[] qItems = null;
    private List qBodies = null;
    private String messageID = null;
    private String msgStr = null;

    public PAOSRequest(String string, String string2, String string3, List list) throws PAOSException {
        try {
            this.compose(string, string2, string3, list);
        }
        catch (JAXBException jAXBException) {
            throw new PAOSException("Unable to compose PAOS request message. More details: " + jAXBException.getMessage());
        }
    }

    public PAOSRequest(String string, String string2, String string3, String[] stringArray) throws PAOSException {
        this.qItems = stringArray;
        int n = stringArray.length;
        ArrayList<String> arrayList = new ArrayList<String>(n);
        int n2 = 0;
        while (n2 < n) {
            arrayList.add(stringArray[n2]);
            ++n2;
        }
        this.qBodies = new ArrayList(1);
        QueryElement queryElement = null;
        try {
            queryElement = IDPPUtils.createQueryElement(arrayList, RESOURCE_ID, false);
        }
        catch (Exception exception) {
            debug.error("PAOSRequest.PAOSRequest: Unable to create QueryElement.", (Throwable)exception);
            throw new PAOSException("Unable to compose PAOS request message. More details: " + exception.getMessage());
        }
        try {
            this.qBodies.add(Utils.convertJAXBToElement(queryElement));
            this.compose(string, string2, string3, null);
        }
        catch (JAXBException jAXBException) {
            throw new PAOSException("Unable to compose PAOS request message. More details: " + jAXBException.getMessage());
        }
    }

    private void compose(String string, String string2, String string3, List list) throws JAXBException {
        Object object;
        this.origURL = string;
        if (list != null) {
            this.qBodies = list;
        }
        ObjectFactory objectFactory = new ObjectFactory();
        RequestElement requestElement = null;
        try {
            requestElement = objectFactory.createRequestElement();
        }
        catch (JAXBException jAXBException) {
            debug.error("PAOSRequest:compose: Unable to create RequestElement.", (Throwable)jAXBException);
            throw jAXBException;
        }
        requestElement.setService(string2);
        requestElement.setMustUnderstand(true);
        requestElement.setResponseConsumerURL(string3);
        requestElement.setActor(ACTOR);
        Message message = null;
        try {
            object = "tmp";
            message = new Message(new ProviderHeader((String)object));
        }
        catch (SOAPBindingException sOAPBindingException) {
            // empty catch block
        }
        object = new ArrayList(1);
        object.add(requestElement);
        object = Utils.convertJAXBToElement((List)object);
        message.setOtherSOAPHeaders((List)object, null);
        message.setSOAPBodies(this.qBodies);
        this.msgStr = message.toString();
        this.messageID = message.getCorrelationHeader().getMessageID();
    }

    public void send(HttpServletResponse httpServletResponse, boolean bl) throws IOException {
        httpServletResponse.setContentType(PAOS_CONTENT_TYPE);
        httpServletResponse.setContentLength(1 + this.msgStr.length());
        ServletOutputStream servletOutputStream = null;
        try {
            servletOutputStream = httpServletResponse.getOutputStream();
        }
        catch (IOException iOException) {
            debug.error("PAOSRequest:send: Unable to get output stream from HttpServletResponse.", (Throwable)iOException);
            throw iOException;
        }
        PrintWriter printWriter = new PrintWriter((OutputStream)servletOutputStream);
        printWriter.println(this.msgStr);
        if (bl) {
            printWriter.close();
        }
        reqTable.put(this.messageID, this);
    }

    public String getMessageID() {
        return this.messageID;
    }

    public String[] getQueryItems() {
        return this.qItems;
    }

    public List getQueryObjects() {
        return this.qBodies;
    }

    public String getOriginalURL() {
        return this.origURL;
    }

    public String toString() {
        return this.msgStr;
    }

    static {
        debug = Debug.getInstance((String)"amPAOS");
    }
}

