/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.liberty.ws.meta;

import com.sun.identity.federation.alliance.FSAllianceManagementException;
import com.sun.identity.federation.alliance.FSOrganization;
import com.sun.identity.liberty.ws.meta.MetaException;
import com.sun.identity.liberty.ws.meta.MetaUtils;
import com.sun.identity.liberty.ws.meta.jaxb.LocalizedURIType;
import com.sun.identity.liberty.ws.meta.jaxb.OrganizationDisplayNameType;
import com.sun.identity.liberty.ws.meta.jaxb.OrganizationNameType;
import com.sun.identity.liberty.ws.meta.jaxb.OrganizationType;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.StringTokenizer;
import javax.xml.bind.JAXBException;

public class OrganizationManager {
    private static OrganizationManager instance = new OrganizationManager();
    int orgCount = 0;

    private OrganizationManager() {
    }

    public static OrganizationManager getInstance() throws MetaException {
        if (instance == null) {
            throw new MetaException(MetaUtils.bundle.getString("failGetInstance"));
        }
        return instance;
    }

    public FSOrganization mapToFSOrganization(OrganizationType organizationType) throws MetaException {
        Object object;
        FSOrganization fSOrganization = null;
        try {
            fSOrganization = new FSOrganization("Organization");
        }
        catch (FSAllianceManagementException fSAllianceManagementException) {
            MetaUtils.debug.message("OrganizationManager.mapToFSOrganization", (Throwable)((Object)fSAllianceManagementException));
            throw new MetaException(fSAllianceManagementException.getMessage());
        }
        HashSet<String> hashSet = null;
        List list = organizationType.getOrganizationName();
        if (list == null || list.isEmpty()) {
            throw new MetaException(MetaUtils.bundle.getString("nullOrgName"));
        }
        hashSet = new HashSet<String>();
        int n = 0;
        while (n < list.size()) {
            object = (OrganizationNameType)list.get(n);
            hashSet.add(object.getLang() + "|" + object.getValue());
            ++n;
        }
        try {
            fSOrganization.setOrgName(hashSet);
        }
        catch (FSAllianceManagementException fSAllianceManagementException) {
            throw new MetaException(fSAllianceManagementException.getMessage());
        }
        list = organizationType.getOrganizationDisplayName();
        if (list == null || list.isEmpty()) {
            throw new MetaException(MetaUtils.bundle.getString("nullDisplayName"));
        }
        hashSet = new HashSet();
        n = 0;
        while (n < list.size()) {
            object = (OrganizationDisplayNameType)list.get(n);
            hashSet.add(object.getLang() + "|" + object.getValue());
            ++n;
        }
        try {
            fSOrganization.setOrgDisplayName(hashSet);
        }
        catch (FSAllianceManagementException fSAllianceManagementException) {
            throw new MetaException(fSAllianceManagementException.getMessage());
        }
        list = organizationType.getOrganizationURL();
        if (list == null || list.isEmpty()) {
            throw new MetaException(MetaUtils.bundle.getString("nullOrgUrl"));
        }
        hashSet = new HashSet();
        n = 0;
        while (n < list.size()) {
            object = (LocalizedURIType)list.get(n);
            hashSet.add(object.getLang() + "|" + object.getValue());
            ++n;
        }
        try {
            fSOrganization.setOrgURL(hashSet);
        }
        catch (FSAllianceManagementException fSAllianceManagementException) {
            throw new MetaException(fSAllianceManagementException.getMessage());
        }
        return fSOrganization;
    }

    public OrganizationType mapToOrganization(FSOrganization fSOrganization) throws MetaException {
        OrganizationType organizationType = null;
        try {
            Object object;
            organizationType = MetaUtils.objF.createOrganizationType();
            Set set = new HashSet();
            StringTokenizer stringTokenizer = null;
            set = fSOrganization.getOrgName();
            Iterator iterator = null;
            String string = null;
            if (set == null || set.isEmpty()) {
                throw new MetaException("Organization: OrgName: empty set");
            }
            iterator = set.iterator();
            while (iterator.hasNext()) {
                stringTokenizer = new StringTokenizer((String)iterator.next(), "|");
                object = MetaUtils.objF.createOrganizationNameType();
                string = stringTokenizer.nextToken().trim();
                if (string != null) {
                    object.setLang(string);
                }
                if ((string = stringTokenizer.nextToken().trim()) != null) {
                    object.setValue(string);
                }
                organizationType.getOrganizationName().add(object);
            }
            set = fSOrganization.getOrgDisplayName();
            if (set == null || set.isEmpty()) {
                throw new MetaException("Organization:OrgDisplayName empty set");
            }
            iterator = set.iterator();
            while (iterator.hasNext()) {
                stringTokenizer = new StringTokenizer((String)iterator.next(), "|");
                object = MetaUtils.objF.createOrganizationDisplayNameType();
                string = stringTokenizer.nextToken().trim();
                if (string != null) {
                    object.setLang(string);
                }
                if ((string = stringTokenizer.nextToken().trim()) != null) {
                    object.setValue(string);
                }
                organizationType.getOrganizationDisplayName().add(object);
            }
            set = fSOrganization.getOrgURL();
            if (set == null || set.isEmpty()) {
                throw new MetaException("Organization: OrgURL empty set");
            }
            iterator = set.iterator();
            while (iterator.hasNext()) {
                stringTokenizer = new StringTokenizer((String)iterator.next(), "|");
                object = MetaUtils.objF.createLocalizedURIType();
                string = stringTokenizer.nextToken().trim();
                if (string != null) {
                    object.setLang(string);
                }
                if ((string = stringTokenizer.nextToken().trim()) != null) {
                    object.setValue(string);
                }
                organizationType.getOrganizationURL().add(object);
            }
        }
        catch (JAXBException jAXBException) {
            new MetaException(jAXBException.getMessage());
        }
        return organizationType;
    }
}

